/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.runtime;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.runtime.FlowContentObserver;
import com.raizlabs.android.dbflow.runtime.ModelNotifier;
import com.raizlabs.android.dbflow.runtime.OnTableChangedListener;
import com.raizlabs.android.dbflow.runtime.TableNotifierRegister;
import com.raizlabs.android.dbflow.sql.SqlUtils;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.structure.BaseModel;
import com.raizlabs.android.dbflow.structure.ModelAdapter;

public class ContentResolverNotifier
implements ModelNotifier {
    @NonNull
    private final String contentAuthority;

    public ContentResolverNotifier(@NonNull String contentAuthority) {
        this.contentAuthority = contentAuthority;
    }

    @Override
    public <T> void notifyModelChanged(@NonNull T model, @NonNull ModelAdapter<T> adapter, @NonNull BaseModel.Action action) {
        if (FlowContentObserver.shouldNotify()) {
            FlowManager.getContext().getContentResolver().notifyChange(SqlUtils.getNotificationUri(this.contentAuthority, adapter.getModelClass(), action, adapter.getPrimaryConditionClause(model).getConditions()), null, true);
        }
    }

    @Override
    public <T> void notifyTableChanged(@NonNull Class<T> table, @NonNull BaseModel.Action action) {
        if (FlowContentObserver.shouldNotify()) {
            FlowManager.getContext().getContentResolver().notifyChange(SqlUtils.getNotificationUri(this.contentAuthority, table, action, (SQLOperator[])null), null, true);
        }
    }

    @Override
    public TableNotifierRegister newRegister() {
        return new FlowContentTableNotifierRegister(this.contentAuthority);
    }

    public static class FlowContentTableNotifierRegister
    implements TableNotifierRegister {
        private final FlowContentObserver flowContentObserver;
        @Nullable
        private OnTableChangedListener tableChangedListener;
        private final OnTableChangedListener internalContentChangeListener = new OnTableChangedListener(){

            @Override
            public void onTableChanged(@Nullable Class<?> tableChanged, @NonNull BaseModel.Action action) {
                if (FlowContentTableNotifierRegister.this.tableChangedListener != null) {
                    FlowContentTableNotifierRegister.this.tableChangedListener.onTableChanged(tableChanged, action);
                }
            }
        };

        public FlowContentTableNotifierRegister(@NonNull String contentAuthority) {
            this.flowContentObserver = new FlowContentObserver(contentAuthority);
            this.flowContentObserver.addOnTableChangedListener(this.internalContentChangeListener);
        }

        @Override
        public <T> void register(@NonNull Class<T> tClass) {
            this.flowContentObserver.registerForContentChanges(FlowManager.getContext(), tClass);
        }

        @Override
        public <T> void unregister(@NonNull Class<T> tClass) {
            this.flowContentObserver.unregisterForContentChanges(FlowManager.getContext());
        }

        @Override
        public void unregisterAll() {
            this.flowContentObserver.removeTableChangedListener(this.internalContentChangeListener);
            this.tableChangedListener = null;
        }

        @Override
        public void setListener(@Nullable OnTableChangedListener contentChangeListener) {
            this.tableChangedListener = contentChangeListener;
        }

        @Override
        public boolean isSubscribed() {
            return !this.flowContentObserver.isSubscribed();
        }
    }
}

