/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.jni;

import io.agora.rtm.jni.AgoraRtmServiceJNI;
import io.agora.rtm.jni.IMessage;
import io.agora.rtm.jni.ISendMessageOptions;

public class IChannel {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected IChannel(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(IChannel obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                throw new UnsupportedOperationException("C++ destructor does not have public access");
            }
            this.swigCPtr = 0L;
        }
    }

    public int join() {
        return AgoraRtmServiceJNI.IChannel_join(this.swigCPtr, this);
    }

    public int leave() {
        return AgoraRtmServiceJNI.IChannel_leave(this.swigCPtr, this);
    }

    public int sendMessage(IMessage message) {
        return AgoraRtmServiceJNI.IChannel_sendMessage__SWIG_0(this.swigCPtr, this, IMessage.getCPtr(message), message);
    }

    public int sendMessage(IMessage message, ISendMessageOptions options) {
        return AgoraRtmServiceJNI.IChannel_sendMessage__SWIG_1(this.swigCPtr, this, IMessage.getCPtr(message), message, ISendMessageOptions.getCPtr(options), options);
    }

    public String getId() {
        return AgoraRtmServiceJNI.IChannel_getId(this.swigCPtr, this);
    }

    public int getMembers() {
        return AgoraRtmServiceJNI.IChannel_getMembers(this.swigCPtr, this);
    }

    public void release() {
        AgoraRtmServiceJNI.IChannel_release(this.swigCPtr, this);
    }
}

