/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import io.agora.rtm.internal.Marshallable;
import java.util.ArrayList;

public class RtmClientMessage
extends Marshallable {

    public static class PAndroidContextInfo
    extends Marshallable {
        public String device;
        public String deviceInfo;
        public String systemInfo;
        public String configDir;
        public String dataDir;
        public String pluginDir;
        public String androidID;

        @Override
        public byte[] marshall() {
            this.pushBytes(this.device.getBytes());
            this.pushBytes(this.deviceInfo.getBytes());
            this.pushBytes(this.systemInfo.getBytes());
            this.pushBytes(this.configDir.getBytes());
            this.pushBytes(this.dataDir.getBytes());
            this.pushBytes(this.pluginDir.getBytes());
            this.pushBytes(this.androidID.getBytes());
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.device = this.popString16UTF8();
            this.deviceInfo = this.popString16UTF8();
            this.systemInfo = this.popString16UTF8();
            this.configDir = this.popString16UTF8();
            this.dataDir = this.popString16UTF8();
            this.pluginDir = this.popString16UTF8();
            this.androidID = this.popString16UTF8();
        }
    }

    public static class MediaNetworkInfo
    extends Marshallable {
        String localIp4 = "";
        String gatewayIp4 = "";
        String localIp6 = "";
        String gatewayIp6 = "";
        int networkType;
        int networkSubtype;
        int signalLevel;
        int rssi;
        int asu;
        int frequency;
        int linkspeed;
        String ssid = "";
        String bssid = "";
        ArrayList<String> dnsList = null;

        public void marshall(Marshallable m) {
            m.pushBytes(this.localIp4.getBytes());
            m.pushBytes(this.gatewayIp4.getBytes());
            m.pushBytes(this.localIp6.getBytes());
            m.pushBytes(this.gatewayIp6.getBytes());
            m.pushInt(this.networkType);
            m.pushInt(this.networkSubtype);
            m.pushInt(this.signalLevel);
            m.pushInt(this.rssi);
            m.pushInt(this.asu);
            m.pushInt(this.frequency);
            m.pushInt(this.linkspeed);
            if (this.ssid != null && this.ssid instanceof String) {
                m.pushBytes(this.ssid.getBytes());
            } else {
                m.pushBytes("".getBytes());
            }
            if (this.bssid != null) {
                m.pushBytes(this.bssid.getBytes());
            } else {
                m.pushBytes("".getBytes());
            }
            if (this.dnsList != null) {
                m.pushStringArray(this.dnsList);
            } else {
                m.pushStringArray(new ArrayList<String>());
            }
        }

        @Override
        public byte[] marshall() {
            this.marshall(this);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
        }
    }
}

