/*
 * Decompiled with CFR 0.152.
 */
package io.agora.common;

import io.agora.common.Logging;
import io.agora.rtm.internal.RtmSdkContext;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;

public class AgoraServiceJNI {
    private static final String TAG = AgoraServiceJNI.class.getSimpleName();
    private static boolean isNativeInitialized = false;

    public static boolean ensureNativeInitialized() {
        if (!isNativeInitialized) {
            System.loadLibrary(RtmSdkContext.getLibraryName());
            isNativeInitialized = AgoraServiceJNI.nativeClassInit() == 0;
        }
        return isNativeInitialized;
    }

    private static native int nativeClassInit();

    private static native int nativeClassDestroy();

    public static native long createRtmService(String var0, String var1, String var2, String var3, String var4, String var5, String var6);

    public static native void deleteRtmService(long var0);

    public static native int nativeLog(int var0, String var1);

    public static native String nativeGetSdkVersion();

    public static native long newPointerArray(int var0);

    public static native void deletePointerArray(long var0);

    public static native void setPointerArrayElement(long var0, int var2, long var3);

    public static native long getPointerArrayElement(long var0, int var2);

    public static native long newCharArray(int var0);

    public static native void deleteCharArray(long var0);

    public static native void setCharArrayElement(long var0, int var2, byte var3);

    public static native Byte getCharArrayElement(long var0, int var2);

    public static final native long newLongLongPointer();

    public static final native void deleteLongLongPointer(long var0);

    public static final native long dereferenceLongLongPointer(long var0);

    protected static String getRandomUUID() {
        return UUID.randomUUID().toString().replace("-", "").toUpperCase();
    }

    protected static String getLocalHost() {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface intf : interfaces) {
                if (intf.getName().startsWith("usb")) continue;
                ArrayList<InetAddress> addrs = Collections.list(intf.getInetAddresses());
                for (InetAddress addr : addrs) {
                    String ip = AgoraServiceJNI.inetAddressToIpAddress(addr);
                    if (ip == null || ip.isEmpty()) continue;
                    return ip;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected static String[] getLocalHostList() {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            ArrayList<String> ips = new ArrayList<String>();
            for (NetworkInterface intf : interfaces) {
                if (intf.getName().startsWith("usb")) continue;
                ArrayList<InetAddress> addrs = Collections.list(intf.getInetAddresses());
                for (InetAddress addr : addrs) {
                    String ip = AgoraServiceJNI.inetAddressToIpAddress(addr);
                    if (ip == null) continue;
                    ips.add(ip);
                }
            }
            if (!ips.isEmpty()) {
                String[] addresses = new String[ips.size()];
                int i = 0;
                Iterator iterator = ips.iterator();
                while (iterator.hasNext()) {
                    String ip;
                    addresses[i] = ip = (String)iterator.next();
                    ++i;
                }
                return addresses;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected static byte[] stringToUtf8(String str) {
        if (str != null) {
            try {
                return str.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Logging.e(TAG, "failed to encode string to UTF-8: " + e.getMessage());
            }
        }
        return null;
    }

    protected static String utf8ToString(byte[] utfBytes) {
        if (utfBytes != null) {
            try {
                return new String(utfBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Logging.e(TAG, "failed to construct a string from UTF-8: " + e.getMessage());
            }
        }
        return null;
    }

    private static String inetAddressToIpAddress(InetAddress address) {
        if (!address.isLoopbackAddress()) {
            if (address instanceof Inet4Address) {
                Inet4Address address4 = (Inet4Address)address;
                return address4.getHostAddress();
            }
            if (address instanceof Inet6Address) {
                // empty if block
            }
        }
        return null;
    }

    static {
        AgoraServiceJNI.ensureNativeInitialized();
    }
}

