/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import io.agora.common.Logging;
import java.lang.reflect.Method;

public abstract class RtmSdkContext {
    private static String libraryName = "agora-rtm-sdk-jni";

    public static String getLibraryName() {
        return libraryName;
    }

    public static void setLibraryName(String name) {
        libraryName = name;
    }

    public abstract String getConfigDir();

    public abstract String getDataDir();

    public abstract String getPluginDir();

    public abstract String getDeviceId();

    public abstract String getDeviceInfo();

    public abstract String getSystemInfo();

    public static String swigValueToStringSafe(int value, Class<?> type) {
        try {
            Object swigEnum = RtmSdkContext.swigValueToEnumSafe(value, type);
            if (swigEnum != null) {
                return swigEnum.toString();
            }
        }
        catch (Exception e) {
            Logging.e("RTM_EXCEPTION", e.getMessage());
        }
        return "";
    }

    public static <T> T swigValueToEnumSafe(int value, Class<T> type) {
        try {
            Method m_swigToEnum = type.getMethod("swigToEnum", Integer.TYPE);
            return (T)m_swigToEnum.invoke(null, value);
        }
        catch (Exception e) {
            Logging.e("RTM_EXCEPTION", e.getMessage());
            return null;
        }
    }
}

