/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import io.agora.common.AgoraServiceJNI;
import io.agora.common.Logging;
import io.agora.common.LruCache;
import io.agora.common.annotation.NonNull;
import io.agora.rtm.ChannelAttributeOptions;
import io.agora.rtm.ErrorInfo;
import io.agora.rtm.ResultCallback;
import io.agora.rtm.RtmAttribute;
import io.agora.rtm.RtmCallManager;
import io.agora.rtm.RtmChannel;
import io.agora.rtm.RtmChannelAttribute;
import io.agora.rtm.RtmChannelListener;
import io.agora.rtm.RtmChannelMemberCount;
import io.agora.rtm.RtmClient;
import io.agora.rtm.RtmClientListener;
import io.agora.rtm.RtmFileMessage;
import io.agora.rtm.RtmImageMessage;
import io.agora.rtm.RtmMediaOperationProgress;
import io.agora.rtm.RtmMessage;
import io.agora.rtm.RtmRequestId;
import io.agora.rtm.SendMessageOptions;
import io.agora.rtm.internal.RtmCallManagerImpl;
import io.agora.rtm.internal.RtmChannelImpl;
import io.agora.rtm.internal.RtmFileMessageImpl;
import io.agora.rtm.internal.RtmImageMessageImpl;
import io.agora.rtm.internal.RtmMessageImpl;
import io.agora.rtm.internal.RtmSdkContext;
import io.agora.rtm.jni.ATTRIBUTE_OPERATION_ERR;
import io.agora.rtm.jni.CANCEL_MEDIA_ERR_CODE;
import io.agora.rtm.jni.CONNECTION_CHANGE_REASON;
import io.agora.rtm.jni.CONNECTION_STATE;
import io.agora.rtm.jni.DOWNLOAD_MEDIA_ERR_CODE;
import io.agora.rtm.jni.GET_CHANNEL_MEMBER_COUNT_ERR;
import io.agora.rtm.jni.IChannelAttributeOptions;
import io.agora.rtm.jni.IFileMessage;
import io.agora.rtm.jni.IImageMessage;
import io.agora.rtm.jni.IMessage;
import io.agora.rtm.jni.IRtmAttribute;
import io.agora.rtm.jni.IRtmChannelAttribute;
import io.agora.rtm.jni.IRtmChannelMemberCount;
import io.agora.rtm.jni.IRtmService;
import io.agora.rtm.jni.IRtmServiceEventHandler;
import io.agora.rtm.jni.ISendMessageOptions;
import io.agora.rtm.jni.LOGIN_ERR_CODE;
import io.agora.rtm.jni.LOGOUT_ERR_CODE;
import io.agora.rtm.jni.MESSAGE_TYPE;
import io.agora.rtm.jni.MediaOperationProgress;
import io.agora.rtm.jni.PEER_MESSAGE_ERR_CODE;
import io.agora.rtm.jni.PEER_ONLINE_STATE;
import io.agora.rtm.jni.PEER_SUBSCRIPTION_OPTION;
import io.agora.rtm.jni.PEER_SUBSCRIPTION_STATUS_ERR;
import io.agora.rtm.jni.PeerOnlineStatus;
import io.agora.rtm.jni.QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR;
import io.agora.rtm.jni.QUERY_PEERS_ONLINE_STATUS_ERR;
import io.agora.rtm.jni.RENEW_TOKEN_ERR_CODE;
import io.agora.rtm.jni.SWIGTYPE_p_long_long;
import io.agora.rtm.jni.UPLOAD_MEDIA_ERR_CODE;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

class RtmClientImpl
extends RtmClient {
    private static final String TAG = RtmClientImpl.class.getSimpleName();
    private RtmClientListener mClientListener;
    IRtmService mRtmServiceNative;
    private long mRtmServiceNativeHandle;
    private RtmServiceEventHandlerNative mRtmEventHandlerNative;
    private HashSet<RtmChannelImpl> mRefChannels = new HashSet();
    private final byte[] mRtmLock = new byte[0];
    private final byte[] mRtmCallbackLock = new byte[0];
    private boolean mIsInitialized = false;
    private ResultCallback<Void> mLoginCallback;
    private ResultCallback<Void> mLogoutCallback;
    private final LruCache<String, ResultCallback<Void>> mRenewTokenCallbacks = new LruCache(50);
    private final LruCache<Long, ResultCallback<Void>> mSendPeerMessageCallbacks = new LruCache(10000);
    private final LruCache<Long, ResultCallback<Map<String, Boolean>>> mQueryOnlineStatusCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Void>> mSubscribePeersOnlineStatusCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Set<String>>> mQueryPeersBySubscriptionOptionCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Void>> mSetLocalUserAttrCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Void>> mAddOrUpdateLocalUserAttrCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Void>> mDeleteLocalUserAttrCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Void>> mClearLocalUserAttrCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<List<RtmAttribute>>> mGetUserAttrCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Void>> mSetChannelAttrCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Void>> mAddOrUpdateChannelAttrCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Void>> mDeleteChannelAttrCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Void>> mClearChannelAttrCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<List<RtmChannelAttribute>>> mGetChannelAttrCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<List<RtmChannelMemberCount>>> mGetChannelMemberCountCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<RtmFileMessage>> mUploadFileMediaCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<RtmImageMessage>> mUploadImageMediaCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<byte[]>> mDownloadMediaToMemoryCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Void>> mDownloadMediaToFileCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Void>> mCancelMediaCallbacks = new LruCache(100);
    private RtmCallManagerImpl rtmCallManager;

    RtmClientImpl(@NonNull RtmSdkContext context, @NonNull String appId, @NonNull RtmClientListener clientListener) throws IllegalArgumentException {
        this.mClientListener = clientListener;
        this.initRtmService(context, appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRtmService(RtmSdkContext context, String appId) throws IllegalArgumentException {
        if (context == null || appId == null || appId.isEmpty()) {
            Logging.e(TAG, "empty context or appId!");
            throw new IllegalArgumentException();
        }
        String configDir = context.getConfigDir();
        String dataDir = context.getDataDir();
        String pluginDir = context.getPluginDir();
        String device = context.getDeviceId();
        String deviceInfo = context.getDeviceInfo();
        String systemInfo = context.getSystemInfo();
        Logging.i(TAG, "Initialize Agora RTM service deviceId '" + device + "' deviceInfo '" + deviceInfo + "' systemInfo '" + systemInfo + "' dir '" + configDir);
        byte[] byArray = this.mRtmLock;
        synchronized (this.mRtmLock) {
            this.mRtmServiceNativeHandle = AgoraServiceJNI.createRtmService(appId, device, deviceInfo, systemInfo, configDir, dataDir, pluginDir);
            this.mRtmServiceNative = new IRtmService(this.mRtmServiceNativeHandle, true);
            this.mRtmEventHandlerNative = new RtmServiceEventHandlerNative();
            int err = this.mRtmServiceNative.initialize(appId, this.mRtmEventHandlerNative);
            if (err != 0) {
                throw new IllegalArgumentException("cannot initialize Agora RTM Service, error: " + err);
            }
            this.mIsInitialized = true;
            Logging.d(TAG, "init done. appId: " + Logging.desensetize(appId) + " this: " + this);
            // ** MonitorExit[var9_9] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void release() {
        Logging.i(TAG, "release " + this);
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.mIsInitialized) {
            this.mIsInitialized = false;
            if (this.rtmCallManager != null) {
                Object object = this.rtmCallManager.lock;
                // MONITORENTER : this.rtmCallManager.lock
                if (this.rtmCallManager.isNativeAttached) {
                    this.rtmCallManager.detach();
                }
                // MONITOREXIT : object
            }
            for (RtmChannelImpl channel : this.mRefChannels) {
                if (channel == null) continue;
                Logging.i(TAG, "force leave channel " + Logging.desensetize(channel.getId()));
                channel.release();
            }
            if (this.mRtmServiceNative != null) {
                this.mRtmServiceNative.release(true);
                this.mRtmServiceNative = null;
            }
            if (this.mRtmEventHandlerNative != null) {
                this.mRtmEventHandlerNative.delete();
                this.mRtmEventHandlerNative = null;
            }
        }
        // MONITOREXIT : byArray
    }

    protected void finalize() {
        Logging.i(TAG, "rtm client is destroyed");
        this.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void login(String token, String userId, ResultCallback<Void> resultCallback) {
        Logging.i(TAG, "login token: " + (token == null || token.length() < 8 ? "invalid!" : token.substring(0, 4) + "****" + token.substring(token.length() - 4)) + " uid: " + Logging.desensetize(userId) + " cb: " + resultCallback);
        LOGIN_ERR_CODE apiErr = null;
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            int ret = this.mRtmServiceNative.login(token, userId);
            Logging.i(TAG, "login ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, LOGIN_ERR_CODE.class);
            if (apiErr == LOGIN_ERR_CODE.LOGIN_ERR_OK) {
                this.mLoginCallback = resultCallback;
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        if (apiErr == LOGIN_ERR_CODE.LOGIN_ERR_OK) return;
        if (resultCallback == null) return;
        if (apiErr == null) {
            apiErr = LOGIN_ERR_CODE.LOGIN_ERR_UNKNOWN;
        }
        resultCallback.onFailure(new ErrorInfo(apiErr.swigValue(), apiErr.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void logout(ResultCallback<Void> resultCallback) {
        Logging.i(TAG, "logout");
        LOGOUT_ERR_CODE apiErr = null;
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        Logging.i(TAG, "clean up channels while logging out");
        HashSet channels = (HashSet)this.mRefChannels.clone();
        for (RtmChannelImpl channel : channels) {
            if (channel == null) continue;
            Logging.i(TAG, "force leave channel " + Logging.desensetize(channel.getId()));
            channel.leave(null);
            channel.detach();
        }
        this.mRefChannels.clear();
        if (this.isNativeReady()) {
            Object object = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            int ret = this.mRtmServiceNative.logout();
            Logging.i(TAG, "logout ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, LOGOUT_ERR_CODE.class);
            if (apiErr == LOGOUT_ERR_CODE.LOGOUT_ERR_OK) {
                this.mLogoutCallback = resultCallback;
            }
            // MONITOREXIT : object
        }
        // MONITOREXIT : byArray
        if (apiErr == LOGOUT_ERR_CODE.LOGOUT_ERR_OK) return;
        if (resultCallback == null) return;
        if (apiErr == null) {
            apiErr = LOGOUT_ERR_CODE.LOGOUT_ERR_REJECTED;
        }
        resultCallback.onFailure(new ErrorInfo(apiErr.swigValue(), apiErr.toString()));
    }

    @Override
    public RtmMessage createMessage() {
        return new RtmMessageImpl("");
    }

    @Override
    public RtmMessage createMessage(String text) {
        return new RtmMessageImpl(text);
    }

    @Override
    public RtmMessage createMessage(byte[] data) {
        return new RtmMessageImpl(data);
    }

    @Override
    public RtmMessage createMessage(byte[] data, String description) {
        return new RtmMessageImpl(data, description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtmFileMessage createFileMessageByMediaId(@NonNull String mediaId) {
        Logging.i(TAG, "createFileMessageByMediaId mediaId: " + mediaId);
        byte[] byArray = this.mRtmLock;
        synchronized (this.mRtmLock) {
            if (this.isNativeReady() && mediaId != null) {
                IFileMessage nativeMessage = this.mRtmServiceNative.createFileMessageByMediaId(mediaId);
                if (nativeMessage == null) {
                    Logging.e(TAG, "createFileMessageByMediaId failed, mediaId maybe invalid");
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
                RtmFileMessageImpl fileMessage = new RtmFileMessageImpl();
                fileMessage.setText(nativeMessage.getText());
                fileMessage.setSize(nativeMessage.getSize());
                fileMessage.setFileName(nativeMessage.getFileName());
                fileMessage.setMediaId(nativeMessage.getMediaId());
                fileMessage.setThumbnail(nativeMessage.getThumbnailData());
                nativeMessage.release();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return fileMessage;
            }
            if (!this.isNativeReady()) {
                throw new RuntimeException("RtmClient instance is released!");
            }
            Logging.e(TAG, "createFileMessageByMediaId failed, mediaId is null");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtmImageMessage createImageMessageByMediaId(@NonNull String mediaId) {
        Logging.i(TAG, "createImageMessageByMediaId mediaId: " + mediaId);
        byte[] byArray = this.mRtmLock;
        synchronized (this.mRtmLock) {
            if (this.isNativeReady() && mediaId != null) {
                IImageMessage nativeMessage = this.mRtmServiceNative.createImageMessageByMediaId(mediaId);
                if (nativeMessage == null) {
                    Logging.e(TAG, "createImageMessageByMediaId failed, mediaId maybe invalid");
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
                RtmImageMessageImpl imageMessage = new RtmImageMessageImpl();
                imageMessage.setText(nativeMessage.getText());
                imageMessage.setSize(nativeMessage.getSize());
                imageMessage.setFileName(nativeMessage.getFileName());
                imageMessage.setMediaId(nativeMessage.getMediaId());
                imageMessage.setThumbnail(nativeMessage.getThumbnailData());
                imageMessage.setHeight(nativeMessage.getHeight());
                imageMessage.setWidth(nativeMessage.getWidth());
                imageMessage.setThumbnailHeight(nativeMessage.getThumbnailHeight());
                imageMessage.setThumbnailWidth(nativeMessage.getThumbnailWidth());
                nativeMessage.release();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return imageMessage;
            }
            if (!this.isNativeReady()) {
                throw new RuntimeException("RtmClient instance is released!");
            }
            Logging.e(TAG, "createImageMessageByMediaId failed, mediaId is null");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void createFileMessageByUploading(@NonNull String filePath, RtmRequestId requestId, ResultCallback<RtmFileMessage> resultCallback) {
        Logging.i(TAG, "createFileMessageByUploading filePath:" + Logging.desensetize(filePath));
        UPLOAD_MEDIA_ERR_CODE apiErr = null;
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            SWIGTYPE_p_long_long reqId = new SWIGTYPE_p_long_long();
            int ret = this.mRtmServiceNative.createFileMessageByUploading(filePath, reqId);
            requestId.setRequestId(SWIGTYPE_p_long_long.dereference(reqId));
            Logging.i(TAG, "createFileMessageByUploading, ret: " + ret + ", requestId: " + SWIGTYPE_p_long_long.dereference(reqId));
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, UPLOAD_MEDIA_ERR_CODE.class);
            if (apiErr == UPLOAD_MEDIA_ERR_CODE.UPLOAD_MEDIA_ERR_OK && resultCallback != null) {
                this.mUploadFileMediaCallbacks.put(SWIGTYPE_p_long_long.dereference(reqId), resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        if (apiErr == UPLOAD_MEDIA_ERR_CODE.UPLOAD_MEDIA_ERR_OK) return;
        if (resultCallback == null) return;
        if (apiErr == null) {
            apiErr = UPLOAD_MEDIA_ERR_CODE.UPLOAD_MEDIA_ERR_FAILURE;
        }
        resultCallback.onFailure(new ErrorInfo(apiErr.swigValue(), apiErr.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void createImageMessageByUploading(@NonNull String filePath, RtmRequestId requestId, ResultCallback<RtmImageMessage> resultCallback) {
        Logging.i(TAG, "createImageMessageByUploading, filePath:" + Logging.desensetize(filePath));
        UPLOAD_MEDIA_ERR_CODE apiErr = null;
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            SWIGTYPE_p_long_long reqId = new SWIGTYPE_p_long_long();
            int ret = this.mRtmServiceNative.createImageMessageByUploading(filePath, reqId);
            requestId.setRequestId(SWIGTYPE_p_long_long.dereference(reqId));
            Logging.i(TAG, "createImageMessageByUploading, ret: " + ret + ", requestId: " + SWIGTYPE_p_long_long.dereference(reqId));
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, UPLOAD_MEDIA_ERR_CODE.class);
            if (apiErr == UPLOAD_MEDIA_ERR_CODE.UPLOAD_MEDIA_ERR_OK && resultCallback != null) {
                this.mUploadImageMediaCallbacks.put(SWIGTYPE_p_long_long.dereference(reqId), resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        if (apiErr == UPLOAD_MEDIA_ERR_CODE.UPLOAD_MEDIA_ERR_OK) return;
        if (resultCallback == null) return;
        if (apiErr == null) {
            apiErr = UPLOAD_MEDIA_ERR_CODE.UPLOAD_MEDIA_ERR_FAILURE;
        }
        resultCallback.onFailure(new ErrorInfo(apiErr.swigValue(), apiErr.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void downloadMediaToMemory(@NonNull String mediaId, RtmRequestId requestId, ResultCallback<byte[]> resultCallback) {
        Logging.i(TAG, "downloadMediaToMemory requestId: " + requestId);
        DOWNLOAD_MEDIA_ERR_CODE apiErr = null;
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            SWIGTYPE_p_long_long reqId = new SWIGTYPE_p_long_long();
            int ret = this.mRtmServiceNative.downloadMediaToMemory(mediaId, reqId);
            requestId.setRequestId(SWIGTYPE_p_long_long.dereference(reqId));
            Logging.i(TAG, "downloadMediaToMemory, ret: " + ret + ", requestId: " + SWIGTYPE_p_long_long.dereference(reqId));
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, DOWNLOAD_MEDIA_ERR_CODE.class);
            if (apiErr == DOWNLOAD_MEDIA_ERR_CODE.DOWNLOAD_MEDIA_ERR_OK && resultCallback != null) {
                this.mDownloadMediaToMemoryCallbacks.put(SWIGTYPE_p_long_long.dereference(reqId), resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        if (apiErr == DOWNLOAD_MEDIA_ERR_CODE.DOWNLOAD_MEDIA_ERR_OK) return;
        if (resultCallback == null) return;
        if (apiErr == null) {
            apiErr = DOWNLOAD_MEDIA_ERR_CODE.DOWNLOAD_MEDIA_ERR_FAILURE;
        }
        resultCallback.onFailure(new ErrorInfo(apiErr.swigValue(), apiErr.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void downloadMediaToFile(@NonNull String mediaId, @NonNull String filePath, RtmRequestId requestId, ResultCallback<Void> resultCallback) {
        Logging.i(TAG, "downloadMediaToFile mediaId: " + mediaId + ", filePath: " + Logging.desensetize(filePath));
        DOWNLOAD_MEDIA_ERR_CODE apiErr = null;
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            SWIGTYPE_p_long_long reqId = new SWIGTYPE_p_long_long();
            int ret = this.mRtmServiceNative.downloadMediaToFile(mediaId, filePath, reqId);
            requestId.setRequestId(SWIGTYPE_p_long_long.dereference(reqId));
            Logging.i(TAG, "downloadMediaToFile, ret: " + ret + ", requestId: " + SWIGTYPE_p_long_long.dereference(reqId));
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, DOWNLOAD_MEDIA_ERR_CODE.class);
            if (apiErr == DOWNLOAD_MEDIA_ERR_CODE.DOWNLOAD_MEDIA_ERR_OK && resultCallback != null) {
                this.mDownloadMediaToFileCallbacks.put(SWIGTYPE_p_long_long.dereference(reqId), resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        if (apiErr == DOWNLOAD_MEDIA_ERR_CODE.DOWNLOAD_MEDIA_ERR_OK) return;
        if (resultCallback == null) return;
        if (apiErr == null) {
            apiErr = DOWNLOAD_MEDIA_ERR_CODE.DOWNLOAD_MEDIA_ERR_FAILURE;
        }
        resultCallback.onFailure(new ErrorInfo(apiErr.swigValue(), apiErr.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void cancelMediaUpload(RtmRequestId requestId, ResultCallback<Void> resultCallback) {
        Logging.i(TAG, "cancelMediaUpload requestId: " + requestId.getRequestId());
        CANCEL_MEDIA_ERR_CODE apiErr = null;
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            int ret = this.mRtmServiceNative.cancelMediaUpload(requestId.getRequestId());
            Logging.i(TAG, "cancelMediaUpload, ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, CANCEL_MEDIA_ERR_CODE.class);
            if (apiErr == CANCEL_MEDIA_ERR_CODE.CANCEL_MEDIA_ERR_OK && resultCallback != null) {
                this.mCancelMediaCallbacks.put(requestId.getRequestId(), resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        if (apiErr == CANCEL_MEDIA_ERR_CODE.CANCEL_MEDIA_ERR_OK) return;
        if (resultCallback == null) return;
        if (apiErr == null) {
            apiErr = CANCEL_MEDIA_ERR_CODE.CANCEL_MEDIA_ERR_FAILURE;
        }
        resultCallback.onFailure(new ErrorInfo(apiErr.swigValue(), apiErr.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void cancelMediaDownload(RtmRequestId requestId, ResultCallback<Void> resultCallback) {
        Logging.i(TAG, "cancelMediaDownload requestId: " + requestId.getRequestId());
        CANCEL_MEDIA_ERR_CODE apiErr = null;
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            int ret = this.mRtmServiceNative.cancelMediaDownload(requestId.getRequestId());
            Logging.i(TAG, "cancelMediaDownload, ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, CANCEL_MEDIA_ERR_CODE.class);
            if (apiErr == CANCEL_MEDIA_ERR_CODE.CANCEL_MEDIA_ERR_OK && resultCallback != null) {
                this.mCancelMediaCallbacks.put(requestId.getRequestId(), resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        if (apiErr == CANCEL_MEDIA_ERR_CODE.CANCEL_MEDIA_ERR_OK) return;
        if (resultCallback == null) return;
        if (apiErr == null) {
            apiErr = CANCEL_MEDIA_ERR_CODE.CANCEL_MEDIA_ERR_FAILURE;
        }
        resultCallback.onFailure(new ErrorInfo(apiErr.swigValue(), apiErr.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMediaUploadingPercentage(RtmRequestId requestId) {
        Logging.i(TAG, "getMediaUploadingPercentage requestId: " + requestId.getRequestId());
        byte[] byArray = this.mRtmLock;
        synchronized (this.mRtmLock) {
            if (this.isNativeReady() && requestId != null) {
                double percentage = this.mRtmServiceNative.getMediaUploadingPercentage(requestId.getRequestId());
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return percentage;
            }
            if (!this.isNativeReady()) {
                throw new RuntimeException("RtmClient instance is released!");
            }
            Logging.e(TAG, "getMediaUploadingPercentage failed, mediaId is null");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMediaDownloadingPercentage(RtmRequestId requestId) {
        Logging.i(TAG, "getMediaDownloadingPercentage requestId: " + requestId.getRequestId());
        byte[] byArray = this.mRtmLock;
        synchronized (this.mRtmLock) {
            if (this.isNativeReady() && requestId != null) {
                double percentage = this.mRtmServiceNative.getMediaDownloadingPercentage(requestId.getRequestId());
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return percentage;
            }
            if (!this.isNativeReady()) {
                throw new RuntimeException("RtmClient instance is released!");
            }
            Logging.e(TAG, "getMediaDownloadingPercentage failed, mediaId is null");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return 0.0;
        }
    }

    @Override
    public void sendMessageToPeer(String peerId, RtmMessage message, ResultCallback<Void> resultCallback) {
        this.sendMessageToPeer(peerId, message, null, resultCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void sendMessageToPeer(String peerId, RtmMessage message, SendMessageOptions options, ResultCallback<Void> resultCallback) {
        Logging.i(TAG, "sendMessageToPeer peerId: " + Logging.desensetize(peerId) + " options: " + options);
        PEER_MESSAGE_ERR_CODE apiErr = null;
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady() && peerId != null && message != null) {
            IMessage nativeMessage = null;
            if (message.getMessageType() == 1) {
                nativeMessage = this.mRtmServiceNative.createMessage(message.getText());
            } else if (message.getMessageType() == 2) {
                byte[] data = message.getRawMessage();
                nativeMessage = message.getText().isEmpty() ? this.mRtmServiceNative.createMessage(data, data.length) : this.mRtmServiceNative.createMessage(data, data.length, message.getText());
            } else if (message.getMessageType() == 3) {
                RtmFileMessage fileMessage = (RtmFileMessage)message;
                IFileMessage nativeFileMessage = this.mRtmServiceNative.createFileMessageByMediaId(fileMessage.getMediaId());
                nativeFileMessage.setText(fileMessage.getText());
                nativeFileMessage.setFileName(fileMessage.getFileName());
                nativeFileMessage.setThumbnail(fileMessage.getThumbnail(), fileMessage.getThumbnail().length);
                nativeMessage = nativeFileMessage;
            } else if (message.getMessageType() == 4) {
                RtmImageMessage imageMessage = (RtmImageMessage)message;
                IImageMessage nativeImageMessage = this.mRtmServiceNative.createImageMessageByMediaId(imageMessage.getMediaId());
                nativeImageMessage.setText(imageMessage.getText());
                nativeImageMessage.setFileName(imageMessage.getFileName());
                nativeImageMessage.setThumbnail(imageMessage.getThumbnail(), imageMessage.getThumbnail().length);
                nativeImageMessage.setWidth(imageMessage.getWidth());
                nativeImageMessage.setHeight(imageMessage.getHeight());
                nativeImageMessage.setThumbnailWidth(imageMessage.getThumbnailWidth());
                nativeImageMessage.setThumbnailHeight(imageMessage.getThumbnailHeight());
                nativeMessage = nativeImageMessage;
            }
            if (nativeMessage != null) {
                int ret;
                nativeMessage.setText(message.getText());
                byte[] byArray2 = this.mRtmCallbackLock;
                // MONITORENTER : this.mRtmCallbackLock
                if (options == null) {
                    ret = this.mRtmServiceNative.sendMessageToPeer(peerId, nativeMessage);
                } else {
                    ISendMessageOptions internalOptions = new ISendMessageOptions();
                    internalOptions.setEnableOfflineMessaging(options.enableOfflineMessaging);
                    internalOptions.setEnableHistoricalMessaging(options.enableHistoricalMessaging);
                    ret = this.mRtmServiceNative.sendMessageToPeer(peerId, nativeMessage, internalOptions);
                }
                Logging.d(TAG, "sendMessageToPeer peerId: " + Logging.desensetize(peerId) + " ret: " + ret);
                apiErr = RtmSdkContext.swigValueToEnumSafe(ret, PEER_MESSAGE_ERR_CODE.class);
                if (apiErr == PEER_MESSAGE_ERR_CODE.PEER_MESSAGE_ERR_OK && resultCallback != null) {
                    this.mSendPeerMessageCallbacks.put(nativeMessage.getMessageId(), resultCallback);
                }
                // MONITOREXIT : byArray2
                nativeMessage.release();
            }
        }
        // MONITOREXIT : byArray
        if (apiErr == PEER_MESSAGE_ERR_CODE.PEER_MESSAGE_ERR_OK) return;
        if (resultCallback == null) return;
        if (apiErr == null) {
            apiErr = PEER_MESSAGE_ERR_CODE.PEER_MESSAGE_ERR_FAILURE;
        }
        resultCallback.onFailure(new ErrorInfo(apiErr.swigValue(), apiErr.toString()));
    }

    public void removeChannel(RtmChannelImpl channel) {
        if (channel != null) {
            Logging.i(TAG, "remove channel " + Logging.desensetize(channel.getId()) + " from rtm client");
            this.mRefChannels.remove(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtmChannel createChannel(String channelId, RtmChannelListener channelListener) throws RuntimeException {
        byte[] byArray = this.mRtmLock;
        synchronized (this.mRtmLock) {
            RtmChannelImpl channelRemove = null;
            for (RtmChannelImpl channel : this.mRefChannels) {
                if (!channel.getId().equals(channelId)) continue;
                if (channel.isChannelNativeReady()) {
                    Logging.w(TAG, "channel " + Logging.desensetize(channelId) + " created already");
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return channel;
                }
                channelRemove = channel;
                break;
            }
            if (channelRemove != null) {
                this.mRefChannels.remove(channelRemove);
            }
            Logging.i(TAG, "createChannel " + Logging.desensetize(channelId));
            RtmChannelImpl rtmChannel = new RtmChannelImpl(channelId, channelListener);
            if (!this.isNativeReady()) {
                throw new RuntimeException("RtmClient instance is released!");
            }
            boolean success = rtmChannel.attach(this);
            if (!success) {
                throw new RuntimeException("not allowed to create the channel or size over limit!");
            }
            this.mRefChannels.add(rtmChannel);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return rtmChannel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public RtmCallManager getRtmCallManager() {
        boolean success;
        Logging.i(TAG, "getRtmCallManager");
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.rtmCallManager != null) {
            byte[] byArray2 = this.rtmCallManager.lock;
            // MONITORENTER : this.rtmCallManager.lock
            if (this.rtmCallManager.isNativeAttached) {
                // MONITOREXIT : byArray2
                // MONITOREXIT : byArray
                return this.rtmCallManager;
            }
            // MONITOREXIT : byArray2
        }
        this.rtmCallManager = new RtmCallManagerImpl();
        boolean bl = success = this.isNativeReady() && this.rtmCallManager.attach(this);
        if (success) {
            // MONITOREXIT : byArray
            return this.rtmCallManager;
        }
        // MONITOREXIT : byArray
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void queryPeersOnlineStatus(Set<String> peerIds, ResultCallback<Map<String, Boolean>> resultCallback) {
        Logging.i(TAG, "queryPeersOnlineStatus");
        QUERY_PEERS_ONLINE_STATUS_ERR apiErr = null;
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            String[] peerIdsArray = new String[]{};
            if (peerIds != null && !peerIds.isEmpty()) {
                peerIdsArray = peerIds.toArray(peerIdsArray);
            }
            SWIGTYPE_p_long_long requestId = new SWIGTYPE_p_long_long();
            int ret = this.mRtmServiceNative.queryPeersOnlineStatus(peerIdsArray, peerIdsArray.length, requestId);
            Logging.i(TAG, "queryPeersOnlineStatus, ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, QUERY_PEERS_ONLINE_STATUS_ERR.class);
            if (apiErr == QUERY_PEERS_ONLINE_STATUS_ERR.QUERY_PEERS_ONLINE_STATUS_ERR_OK && resultCallback != null) {
                this.mQueryOnlineStatusCallbacks.put(SWIGTYPE_p_long_long.dereference(requestId), resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        if (apiErr == QUERY_PEERS_ONLINE_STATUS_ERR.QUERY_PEERS_ONLINE_STATUS_ERR_OK) return;
        if (resultCallback == null) return;
        if (apiErr == null) {
            apiErr = QUERY_PEERS_ONLINE_STATUS_ERR.QUERY_PEERS_ONLINE_STATUS_ERR_FAILURE;
        }
        resultCallback.onFailure(new ErrorInfo(apiErr.swigValue(), apiErr.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void subscribePeersOnlineStatus(Set<String> peerIds, ResultCallback<Void> resultCallback) {
        Logging.i(TAG, "subscribePeersOnlineStatus");
        PEER_SUBSCRIPTION_STATUS_ERR apiErr = null;
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            String[] peerIdsArray = new String[]{};
            if (peerIds != null && !peerIds.isEmpty()) {
                peerIdsArray = peerIds.toArray(peerIdsArray);
            }
            SWIGTYPE_p_long_long requestId = new SWIGTYPE_p_long_long();
            int ret = this.mRtmServiceNative.subscribePeersOnlineStatus(peerIdsArray, peerIdsArray.length, requestId);
            Logging.i(TAG, "subscribePeersOnlineStatus, ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, PEER_SUBSCRIPTION_STATUS_ERR.class);
            if (apiErr == PEER_SUBSCRIPTION_STATUS_ERR.PEER_SUBSCRIPTION_STATUS_ERR_OK && resultCallback != null) {
                this.mSubscribePeersOnlineStatusCallbacks.put(SWIGTYPE_p_long_long.dereference(requestId), resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        if (apiErr == PEER_SUBSCRIPTION_STATUS_ERR.PEER_SUBSCRIPTION_STATUS_ERR_OK) return;
        if (resultCallback == null) return;
        if (apiErr == null) {
            apiErr = PEER_SUBSCRIPTION_STATUS_ERR.PEER_SUBSCRIPTION_STATUS_ERR_FAILURE;
        }
        resultCallback.onFailure(new ErrorInfo(apiErr.swigValue(), apiErr.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void unsubscribePeersOnlineStatus(Set<String> peerIds, ResultCallback<Void> resultCallback) {
        Logging.i(TAG, "subscribePeersOnlineStatus");
        PEER_SUBSCRIPTION_STATUS_ERR apiErr = null;
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            String[] peerIdsArray = new String[]{};
            if (peerIds != null && !peerIds.isEmpty()) {
                peerIdsArray = peerIds.toArray(peerIdsArray);
            }
            SWIGTYPE_p_long_long requestId = new SWIGTYPE_p_long_long();
            int ret = this.mRtmServiceNative.unsubscribePeersOnlineStatus(peerIdsArray, peerIdsArray.length, requestId);
            Logging.i(TAG, "unsubscribePeersOnlineStatus, ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, PEER_SUBSCRIPTION_STATUS_ERR.class);
            if (apiErr == PEER_SUBSCRIPTION_STATUS_ERR.PEER_SUBSCRIPTION_STATUS_ERR_OK && resultCallback != null) {
                this.mSubscribePeersOnlineStatusCallbacks.put(SWIGTYPE_p_long_long.dereference(requestId), resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        if (apiErr == PEER_SUBSCRIPTION_STATUS_ERR.PEER_SUBSCRIPTION_STATUS_ERR_OK) return;
        if (resultCallback == null) return;
        if (apiErr == null) {
            apiErr = PEER_SUBSCRIPTION_STATUS_ERR.PEER_SUBSCRIPTION_STATUS_ERR_FAILURE;
        }
        resultCallback.onFailure(new ErrorInfo(apiErr.swigValue(), apiErr.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void queryPeersBySubscriptionOption(Integer option, ResultCallback<Set<String>> resultCallback) {
        Logging.i(TAG, "queryPeersBySubscriptionOption");
        PEER_SUBSCRIPTION_OPTION nativeOption = null;
        if (option != 0) {
            Logging.e(TAG, "invalid subscription option");
            return;
        }
        nativeOption = PEER_SUBSCRIPTION_OPTION.PEER_SUBSCRIPTION_OPTION_ONLINE_STATUS;
        QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR apiErr = null;
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            SWIGTYPE_p_long_long requestId = new SWIGTYPE_p_long_long();
            int ret = this.mRtmServiceNative.queryPeersBySubscriptionOption(nativeOption, requestId);
            Logging.i(TAG, "queryPeersBySubscriptionOption, ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR.class);
            if (apiErr == QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR.QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR_OK && resultCallback != null) {
                this.mQueryPeersBySubscriptionOptionCallbacks.put(SWIGTYPE_p_long_long.dereference(requestId), resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        if (apiErr == QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR.QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR_OK) return;
        if (resultCallback == null) return;
        if (apiErr == null) {
            apiErr = QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR.QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR_FAILURE;
        }
        resultCallback.onFailure(new ErrorInfo(apiErr.swigValue(), apiErr.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void renewToken(String token, ResultCallback<Void> resultCallback) {
        Logging.i(TAG, "renewToken: " + (token == null || token.length() < 8 ? "invalid!" : token.substring(0, 4) + "****" + token.substring(token.length() - 4)));
        RENEW_TOKEN_ERR_CODE apiErr = null;
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            int ret = this.mRtmServiceNative.renewToken(token);
            Logging.i(TAG, "renewToken ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, RENEW_TOKEN_ERR_CODE.class);
            if (apiErr == RENEW_TOKEN_ERR_CODE.RENEW_TOKEN_ERR_OK && resultCallback != null) {
                this.mRenewTokenCallbacks.put(token, resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        if (apiErr == RENEW_TOKEN_ERR_CODE.RENEW_TOKEN_ERR_OK) return;
        if (resultCallback == null) return;
        if (apiErr == null) {
            apiErr = RENEW_TOKEN_ERR_CODE.RENEW_TOKEN_ERR_FAILURE;
        }
        resultCallback.onFailure(new ErrorInfo(apiErr.swigValue(), apiErr.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void setLocalUserAttributes(List<RtmAttribute> attributes, ResultCallback<Void> resultCallback) {
        Logging.i(TAG, "setLocalUserAttributes");
        ATTRIBUTE_OPERATION_ERR apiErr = null;
        if (attributes == null || attributes.isEmpty()) {
            Logging.e(TAG, "attribute list is null or empty!");
            this.processAttrApiError(ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_INVALID_ARGUMENT, resultCallback);
            return;
        }
        IRtmAttribute[] internalAttrArray = this.convertAttrListToInternal(attributes);
        SWIGTYPE_p_long_long requestId = new SWIGTYPE_p_long_long();
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            int ret = this.mRtmServiceNative.setLocalUserAttributes(internalAttrArray, requestId);
            Logging.i(TAG, "setLocalUserAttributes ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, ATTRIBUTE_OPERATION_ERR.class);
            if (apiErr == ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK && resultCallback != null) {
                this.mSetLocalUserAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(requestId), resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        this.processAttrApiError(apiErr, resultCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void addOrUpdateLocalUserAttributes(List<RtmAttribute> attributes, ResultCallback<Void> resultCallback) {
        Logging.i(TAG, "addOrUpdateLocalUserAttributes");
        ATTRIBUTE_OPERATION_ERR apiErr = null;
        if (attributes == null || attributes.isEmpty()) {
            Logging.e(TAG, "attribute list is null or empty!");
            this.processAttrApiError(ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_INVALID_ARGUMENT, resultCallback);
            return;
        }
        IRtmAttribute[] internalAttrArray = this.convertAttrListToInternal(attributes);
        SWIGTYPE_p_long_long requestId = new SWIGTYPE_p_long_long();
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            int ret = this.mRtmServiceNative.addOrUpdateLocalUserAttributes(internalAttrArray, requestId);
            Logging.i(TAG, "addOrUpdateLocalUserAttributes ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, ATTRIBUTE_OPERATION_ERR.class);
            if (apiErr == ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK && resultCallback != null) {
                this.mAddOrUpdateLocalUserAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(requestId), resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        this.processAttrApiError(apiErr, resultCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void deleteLocalUserAttributesByKeys(List<String> attributeKeys, ResultCallback<Void> resultCallback) {
        Logging.i(TAG, "deleteLocalUserAttributesByKeys");
        ATTRIBUTE_OPERATION_ERR apiErr = null;
        if (attributeKeys == null || attributeKeys.isEmpty()) {
            Logging.e(TAG, "attribute keys is null or empty!");
            this.processAttrApiError(ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_INVALID_ARGUMENT, resultCallback);
            return;
        }
        SWIGTYPE_p_long_long requestId = new SWIGTYPE_p_long_long();
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            int ret = this.mRtmServiceNative.deleteLocalUserAttributesByKeys(attributeKeys.toArray(new String[0]), requestId);
            Logging.i(TAG, "deleteLocalUserAttributesByKeys ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, ATTRIBUTE_OPERATION_ERR.class);
            if (apiErr == ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK && resultCallback != null) {
                this.mDeleteLocalUserAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(requestId), resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        this.processAttrApiError(apiErr, resultCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void clearLocalUserAttributes(ResultCallback<Void> resultCallback) {
        Logging.i(TAG, "clearLocalUserAttributes");
        ATTRIBUTE_OPERATION_ERR apiErr = null;
        SWIGTYPE_p_long_long requestId = new SWIGTYPE_p_long_long();
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            int ret = this.mRtmServiceNative.clearLocalUserAttributes(requestId);
            Logging.i(TAG, "clearLocalUserAttributes ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, ATTRIBUTE_OPERATION_ERR.class);
            if (apiErr == ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK && resultCallback != null) {
                this.mClearLocalUserAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(requestId), resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        this.processAttrApiError(apiErr, resultCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void getUserAttributes(String userId, ResultCallback<List<RtmAttribute>> resultCallback) {
        Logging.i(TAG, "getUserAttributes");
        ATTRIBUTE_OPERATION_ERR apiErr = null;
        SWIGTYPE_p_long_long requestId = new SWIGTYPE_p_long_long();
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            int ret = this.mRtmServiceNative.getUserAttributes(userId, requestId);
            Logging.i(TAG, "getUserAttributes ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, ATTRIBUTE_OPERATION_ERR.class);
            if (apiErr == ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK && resultCallback != null) {
                this.mGetUserAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(requestId), resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        this.processAttrApiError(apiErr, resultCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void getUserAttributesByKeys(String userId, List<String> attributeKeys, ResultCallback<List<RtmAttribute>> resultCallback) {
        Logging.i(TAG, "getUserAttributesByKeys");
        ATTRIBUTE_OPERATION_ERR apiErr = null;
        if (attributeKeys == null || attributeKeys.isEmpty()) {
            Logging.e(TAG, "attribute keys is null or empty!");
            this.processAttrApiError(ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_INVALID_ARGUMENT, resultCallback);
            return;
        }
        SWIGTYPE_p_long_long requestId = new SWIGTYPE_p_long_long();
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            int ret = this.mRtmServiceNative.getUserAttributesByKeys(userId, attributeKeys.toArray(new String[0]), requestId);
            Logging.i(TAG, "getUserAttributesByKeys ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, ATTRIBUTE_OPERATION_ERR.class);
            if (apiErr == ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK && resultCallback != null) {
                this.mGetUserAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(requestId), resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        this.processAttrApiError(apiErr, resultCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void setChannelAttributes(String channelId, List<RtmChannelAttribute> attributes, ChannelAttributeOptions option, ResultCallback<Void> resultCallback) {
        Logging.i(TAG, "setChannelAttributes");
        ATTRIBUTE_OPERATION_ERR apiErr = null;
        if (attributes == null || attributes.isEmpty()) {
            Logging.e(TAG, "attribute list is null or empty!");
            this.processAttrApiError(ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_INVALID_ARGUMENT, resultCallback);
            return;
        }
        IRtmChannelAttribute[] internalAttrArray = this.convertChannelAttrListToInternal(attributes);
        IChannelAttributeOptions internalOption = this.convertChannelAttrOptToInternal(option);
        SWIGTYPE_p_long_long requestId = new SWIGTYPE_p_long_long();
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            int ret = this.mRtmServiceNative.setChannelAttributes(channelId, internalAttrArray, internalOption, requestId);
            Logging.i(TAG, "setChannelAttributes ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, ATTRIBUTE_OPERATION_ERR.class);
            if (apiErr == ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK && resultCallback != null) {
                this.mSetChannelAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(requestId), resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        this.processAttrApiError(apiErr, resultCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void addOrUpdateChannelAttributes(String channelId, List<RtmChannelAttribute> attributes, ChannelAttributeOptions option, ResultCallback<Void> resultCallback) {
        Logging.i(TAG, "addOrUpdateChannelAttributes");
        ATTRIBUTE_OPERATION_ERR apiErr = null;
        if (attributes == null || attributes.isEmpty()) {
            Logging.e(TAG, "attribute list is null or empty!");
            this.processAttrApiError(ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_INVALID_ARGUMENT, resultCallback);
            return;
        }
        IRtmChannelAttribute[] internalAttrArray = this.convertChannelAttrListToInternal(attributes);
        IChannelAttributeOptions internalOption = this.convertChannelAttrOptToInternal(option);
        SWIGTYPE_p_long_long requestId = new SWIGTYPE_p_long_long();
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            int ret = this.mRtmServiceNative.addOrUpdateChannelAttributes(channelId, internalAttrArray, internalOption, requestId);
            Logging.i(TAG, "addOrUpdateChannelAttributes ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, ATTRIBUTE_OPERATION_ERR.class);
            if (apiErr == ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK && resultCallback != null) {
                this.mAddOrUpdateChannelAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(requestId), resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        this.processAttrApiError(apiErr, resultCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void deleteChannelAttributesByKeys(String channelId, List<String> attributeKeys, ChannelAttributeOptions option, ResultCallback<Void> resultCallback) {
        Logging.i(TAG, "deleteChannelAttributesByKeys");
        ATTRIBUTE_OPERATION_ERR apiErr = null;
        if (attributeKeys == null || attributeKeys.isEmpty()) {
            Logging.e(TAG, "attribute keys is null or empty!");
            this.processAttrApiError(ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_INVALID_ARGUMENT, resultCallback);
            return;
        }
        IChannelAttributeOptions internalOption = this.convertChannelAttrOptToInternal(option);
        SWIGTYPE_p_long_long requestId = new SWIGTYPE_p_long_long();
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            int ret = this.mRtmServiceNative.deleteChannelAttributesByKeys(channelId, attributeKeys.toArray(new String[0]), internalOption, requestId);
            Logging.i(TAG, "deleteChannelAttributesByKeys ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, ATTRIBUTE_OPERATION_ERR.class);
            if (apiErr == ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK && resultCallback != null) {
                this.mDeleteChannelAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(requestId), resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        this.processAttrApiError(apiErr, resultCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void clearChannelAttributes(String channelId, ChannelAttributeOptions option, ResultCallback<Void> resultCallback) {
        Logging.i(TAG, "clearChannelAttributes");
        ATTRIBUTE_OPERATION_ERR apiErr = null;
        IChannelAttributeOptions internalOption = this.convertChannelAttrOptToInternal(option);
        SWIGTYPE_p_long_long requestId = new SWIGTYPE_p_long_long();
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            int ret = this.mRtmServiceNative.clearChannelAttributes(channelId, internalOption, requestId);
            Logging.i(TAG, "clearChannelAttributes ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, ATTRIBUTE_OPERATION_ERR.class);
            if (apiErr == ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK && resultCallback != null) {
                this.mClearChannelAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(requestId), resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        this.processAttrApiError(apiErr, resultCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void getChannelAttributes(String channelId, ResultCallback<List<RtmChannelAttribute>> resultCallback) {
        Logging.i(TAG, "getChannelAttributes");
        ATTRIBUTE_OPERATION_ERR apiErr = null;
        SWIGTYPE_p_long_long requestId = new SWIGTYPE_p_long_long();
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            int ret = this.mRtmServiceNative.getChannelAttributes(channelId, requestId);
            Logging.i(TAG, "getChannelAttributes ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, ATTRIBUTE_OPERATION_ERR.class);
            if (apiErr == ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK && resultCallback != null) {
                this.mGetChannelAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(requestId), resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        this.processAttrApiError(apiErr, resultCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void getChannelAttributesByKeys(String channelId, List<String> attributeKeys, ResultCallback<List<RtmChannelAttribute>> resultCallback) {
        Logging.i(TAG, "getChannelAttributesByKeys");
        ATTRIBUTE_OPERATION_ERR apiErr = null;
        if (attributeKeys == null || attributeKeys.isEmpty()) {
            Logging.e(TAG, "attribute keys is null or empty!");
            this.processAttrApiError(ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_INVALID_ARGUMENT, resultCallback);
            return;
        }
        SWIGTYPE_p_long_long requestId = new SWIGTYPE_p_long_long();
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            int ret = this.mRtmServiceNative.getChannelAttributesByKeys(channelId, attributeKeys.toArray(new String[0]), requestId);
            Logging.i(TAG, "getChannelAttributesByKeys ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, ATTRIBUTE_OPERATION_ERR.class);
            if (apiErr == ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK && resultCallback != null) {
                this.mGetChannelAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(requestId), resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        this.processAttrApiError(apiErr, resultCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void getChannelMemberCount(List<String> channelIds, ResultCallback<List<RtmChannelMemberCount>> resultCallback) {
        Logging.i(TAG, "getChannelMemberCount");
        GET_CHANNEL_MEMBER_COUNT_ERR apiErr = null;
        if (channelIds == null || channelIds.isEmpty()) {
            Logging.e(TAG, "channel Ids is null or empty!");
            this.processGetChannelMemberCountApiError(GET_CHANNEL_MEMBER_COUNT_ERR.GET_CHANNEL_MEMBER_COUNT_ERR_INVALID_ARGUMENT, resultCallback);
            return;
        }
        SWIGTYPE_p_long_long requestId = new SWIGTYPE_p_long_long();
        byte[] byArray = this.mRtmLock;
        // MONITORENTER : this.mRtmLock
        if (this.isNativeReady()) {
            byte[] byArray2 = this.mRtmCallbackLock;
            // MONITORENTER : this.mRtmCallbackLock
            int ret = this.mRtmServiceNative.getChannelMemberCount(channelIds.toArray(new String[0]), requestId);
            Logging.i(TAG, "getChannelMemberCount ret: " + ret);
            apiErr = RtmSdkContext.swigValueToEnumSafe(ret, GET_CHANNEL_MEMBER_COUNT_ERR.class);
            if (apiErr == GET_CHANNEL_MEMBER_COUNT_ERR.GET_CHANNEL_MEMBER_COUNT_ERR_OK && resultCallback != null) {
                this.mGetChannelMemberCountCallbacks.put(SWIGTYPE_p_long_long.dereference(requestId), resultCallback);
            }
            // MONITOREXIT : byArray2
        }
        // MONITOREXIT : byArray
        this.processGetChannelMemberCountApiError(apiErr, resultCallback);
    }

    private IRtmAttribute[] convertAttrListToInternal(@NonNull List<RtmAttribute> attributes) {
        IRtmAttribute[] internalAttrArray = new IRtmAttribute[attributes.size()];
        for (int index = 0; index < attributes.size(); ++index) {
            RtmAttribute attr = attributes.get(index);
            IRtmAttribute internalAttr = new IRtmAttribute();
            internalAttr.setKey(attr.getKey());
            internalAttr.setValue(attr.getValue());
            internalAttrArray[index] = internalAttr;
        }
        return internalAttrArray;
    }

    private IRtmChannelAttribute[] convertChannelAttrListToInternal(@NonNull List<RtmChannelAttribute> attributes) {
        IRtmChannelAttribute[] internalAttrArray = new IRtmChannelAttribute[attributes.size()];
        for (int index = 0; index < attributes.size(); ++index) {
            RtmChannelAttribute attr = attributes.get(index);
            IRtmChannelAttribute internalAttr = new IRtmChannelAttribute(this.mRtmServiceNativeHandle);
            internalAttr.setKey(attr.getKey());
            internalAttr.setValue(attr.getValue());
            internalAttrArray[index] = internalAttr;
        }
        return internalAttrArray;
    }

    private IChannelAttributeOptions convertChannelAttrOptToInternal(@NonNull ChannelAttributeOptions option) {
        IChannelAttributeOptions internalAttrArray = new IChannelAttributeOptions();
        internalAttrArray.setEnableNotificationToChannelMembers(option.getEnableNotificationToChannelMembers());
        return internalAttrArray;
    }

    private void processAttrApiError(ATTRIBUTE_OPERATION_ERR apiErr, ResultCallback<?> resultCallback) {
        if (apiErr == ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK || resultCallback == null) {
            return;
        }
        if (apiErr == null) {
            apiErr = ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_FAILURE;
        }
        resultCallback.onFailure(new ErrorInfo(apiErr.swigValue(), apiErr.toString()));
    }

    private void processGetChannelMemberCountApiError(GET_CHANNEL_MEMBER_COUNT_ERR apiErr, ResultCallback<?> resultCallback) {
        if (apiErr == GET_CHANNEL_MEMBER_COUNT_ERR.GET_CHANNEL_MEMBER_COUNT_ERR_OK || resultCallback == null) {
            return;
        }
        if (apiErr == null) {
            apiErr = GET_CHANNEL_MEMBER_COUNT_ERR.GET_CHANNEL_MEMBER_COUNT_ERR_FAILURE;
        }
        resultCallback.onFailure(new ErrorInfo(apiErr.swigValue(), apiErr.toString()));
    }

    @Override
    public int setParameters(String parameters) {
        return this.mRtmServiceNative.setParameters(parameters);
    }

    @Override
    public int setLogFile(String filePath) {
        return this.mRtmServiceNative.setLogFile(filePath);
    }

    @Override
    public int setLogFilter(int filter) {
        return this.mRtmServiceNative.setLogFilter(filter);
    }

    @Override
    public int setLogFileSize(int fileSizeInKBytes) {
        return this.mRtmServiceNative.setLogFileSize(fileSizeInKBytes);
    }

    private boolean isNativeReady() {
        if (this.mRtmServiceNative == null) {
            Logging.w(TAG, "rtm native is not ready");
            return false;
        }
        return true;
    }

    private int setParameter(String key, boolean value) {
        return this.setParameters(RtmClientImpl.formatString("{\"%s\":%b}", key, value));
    }

    private int setParameter(String key, int value) {
        return this.setParameters(RtmClientImpl.formatString("{\"%s\":%d}", key, value));
    }

    private int setParameter(String key, long value) {
        return this.setParameters(RtmClientImpl.formatString("{\"%s\":%d}", key, value));
    }

    private int setParameter(String key, double value) {
        return this.setParameters(RtmClientImpl.formatString("{\"%s\":%f}", key, value));
    }

    private int setParameter(String key, String value) {
        return this.setParameters(RtmClientImpl.formatString("{\"%s\":\"%s\"}", key, value));
    }

    private int setParameterObject(String key, String value) {
        return this.setParameters(RtmClientImpl.formatString("{\"%s\":%s}", key, value));
    }

    private static String formatString(String format, Object ... args) {
        return String.format(Locale.US, format, args);
    }

    private int covertPeerOnlineState(PEER_ONLINE_STATE state) {
        if (state == PEER_ONLINE_STATE.PEER_ONLINE_STATE_ONLINE) {
            return 0;
        }
        if (state == PEER_ONLINE_STATE.PEER_ONLINE_STATE_UNREACHABLE) {
            return 1;
        }
        if (state == PEER_ONLINE_STATE.PEER_ONLINE_STATE_OFFLINE) {
            return 2;
        }
        return -1;
    }

    private class RtmServiceEventHandlerNative
    extends IRtmServiceEventHandler {
        private RtmServiceEventHandlerNative() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLoginSuccess() {
            Logging.i(TAG, "onLoginSuccess");
            ResultCallback pendingCallback = null;
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (byArray) {
                if (RtmClientImpl.this.mLoginCallback != null) {
                    pendingCallback = RtmClientImpl.this.mLoginCallback;
                    RtmClientImpl.this.mLoginCallback = null;
                }
            }
            if (pendingCallback != null) {
                pendingCallback.onSuccess(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLoginFailure(LOGIN_ERR_CODE errorCode) {
            Logging.e(TAG, "onLoginFailure, err: " + errorCode);
            if (errorCode == null) {
                return;
            }
            ResultCallback pendingCallback = null;
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (byArray) {
                if (RtmClientImpl.this.mLoginCallback != null) {
                    pendingCallback = RtmClientImpl.this.mLoginCallback;
                    RtmClientImpl.this.mLoginCallback = null;
                }
            }
            if (pendingCallback != null) {
                pendingCallback.onFailure(new ErrorInfo(errorCode.swigValue(), errorCode.toString()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLogout(LOGOUT_ERR_CODE errorCode) {
            Logging.i(TAG, "onLogout, err: " + errorCode);
            if (errorCode == null) {
                return;
            }
            ResultCallback pendingCallback = null;
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (byArray) {
                if (RtmClientImpl.this.mLogoutCallback != null) {
                    pendingCallback = RtmClientImpl.this.mLogoutCallback;
                    RtmClientImpl.this.mLogoutCallback = null;
                }
            }
            if (pendingCallback != null) {
                if (errorCode == LOGOUT_ERR_CODE.LOGOUT_ERR_OK) {
                    pendingCallback.onSuccess(null);
                } else {
                    pendingCallback.onFailure(new ErrorInfo(errorCode.swigValue(), errorCode.toString()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSendMessageResult(long messageId, PEER_MESSAGE_ERR_CODE errorCode) {
            ResultCallback callback;
            Logging.i(TAG, "onSendMessageResult, messageId: " + messageId + " err: " + errorCode);
            if (errorCode == null) {
                return;
            }
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (byArray) {
                callback = (ResultCallback)RtmClientImpl.this.mSendPeerMessageCallbacks.remove(messageId);
            }
            if (callback != null) {
                if (errorCode == PEER_MESSAGE_ERR_CODE.PEER_MESSAGE_ERR_OK) {
                    callback.onSuccess(null);
                } else {
                    callback.onFailure(new ErrorInfo(errorCode.swigValue(), errorCode.toString()));
                }
            }
        }

        @Override
        public void onConnectionStateChanged(CONNECTION_STATE state, CONNECTION_CHANGE_REASON reason) {
            Logging.i(TAG, "onConnectionStateChanged, state: " + state + " reason: " + reason);
            if (state == null || reason == null) {
                return;
            }
            if (RtmClientImpl.this.mClientListener == null) {
                Logging.w(TAG, "empty client listener!");
                return;
            }
            RtmClientImpl.this.mClientListener.onConnectionStateChanged(state.swigValue(), reason.swigValue());
        }

        @Override
        public void onMessageReceivedFromPeer(String peerId, IMessage message) {
            if (peerId == null || peerId.isEmpty() || message == null || RtmClientImpl.this.mClientListener == null) {
                Logging.w(TAG, "empty listener or invalid message received!");
                return;
            }
            RtmMessageImpl rtmMessage = null;
            if (message.getMessageType() == MESSAGE_TYPE.MESSAGE_TYPE_TEXT) {
                rtmMessage = new RtmMessageImpl(message.getText(), message.getServerReceivedTs(), message.isOfflineMessage());
            } else if (message.getMessageType() == MESSAGE_TYPE.MESSAGE_TYPE_RAW) {
                rtmMessage = new RtmMessageImpl(message.getRawMessageData(), message.getText(), message.getServerReceivedTs(), message.isOfflineMessage());
            }
            Logging.i(TAG, "onMessageReceivedFromPeer, peerId: " + Logging.desensetize(peerId));
            RtmClientImpl.this.mClientListener.onMessageReceived(rtmMessage, peerId);
        }

        @Override
        public void onImageMessageReceivedFromPeer(String peerId, IImageMessage message) {
            if (peerId == null || peerId.isEmpty() || message == null || RtmClientImpl.this.mClientListener == null) {
                Logging.w(TAG, "empty listener or invalid message received!");
                return;
            }
            RtmImageMessageImpl imageMessage = new RtmImageMessageImpl();
            imageMessage.setText(message.getText());
            imageMessage.setSize(message.getSize());
            imageMessage.setFileName(message.getFileName());
            imageMessage.setMediaId(message.getMediaId());
            imageMessage.setThumbnail(message.getThumbnailData());
            imageMessage.setHeight(message.getHeight());
            imageMessage.setWidth(message.getWidth());
            imageMessage.setThumbnailHeight(message.getThumbnailHeight());
            imageMessage.setThumbnailWidth(message.getThumbnailWidth());
            imageMessage.setServerReceivedTs(message.getServerReceivedTs());
            imageMessage.setIsOfflineMessage(message.isOfflineMessage());
            Logging.i(TAG, "onImageMessageReceivedFromPeer, peerId: " + Logging.desensetize(peerId));
            RtmClientImpl.this.mClientListener.onImageMessageReceivedFromPeer(imageMessage, peerId);
        }

        @Override
        public void onFileMessageReceivedFromPeer(String peerId, IFileMessage message) {
            if (peerId == null || peerId.isEmpty() || message == null || RtmClientImpl.this.mClientListener == null) {
                Logging.w(TAG, "empty listener or invalid message received!");
                return;
            }
            RtmFileMessageImpl fileMessage = new RtmFileMessageImpl();
            fileMessage.setText(message.getText());
            fileMessage.setSize(message.getSize());
            fileMessage.setFileName(message.getFileName());
            fileMessage.setMediaId(message.getMediaId());
            fileMessage.setThumbnail(message.getThumbnailData());
            fileMessage.setServerReceivedTs(message.getServerReceivedTs());
            fileMessage.setIsOfflineMessage(message.isOfflineMessage());
            Logging.i(TAG, "onFileMessageReceivedFromPeer, peerId: " + Logging.desensetize(peerId));
            RtmClientImpl.this.mClientListener.onFileMessageReceivedFromPeer(fileMessage, peerId);
        }

        @Override
        public void onMediaUploadingProgress(long requestId, MediaOperationProgress progress) {
            Logging.i(TAG, "onMediaUploadingProgress, requestId: " + requestId + ", totalSize: " + progress.getTotalSize() + ", currentSize: " + progress.getCurrentSize());
            RtmMediaOperationProgress rat = new RtmMediaOperationProgress();
            rat.totalSize = progress.getTotalSize();
            rat.currentSize = progress.getCurrentSize();
            RtmClientImpl.this.mClientListener.onMediaUploadingProgress(rat, requestId);
        }

        @Override
        public void onMediaDownloadingProgress(long requestId, MediaOperationProgress progress) {
            Logging.i(TAG, "onMediaDownloadingProgress, requestId: " + requestId + ", totalSize: " + progress.getTotalSize() + ", currentSize: " + progress.getCurrentSize());
            RtmMediaOperationProgress rat = new RtmMediaOperationProgress();
            rat.totalSize = progress.getTotalSize();
            rat.currentSize = progress.getCurrentSize();
            RtmClientImpl.this.mClientListener.onMediaDownloadingProgress(rat, requestId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFileMediaUploadResult(long requestId, IFileMessage mediaMessage, UPLOAD_MEDIA_ERR_CODE code) {
            ResultCallback callback;
            Logging.i(TAG, "onFileMediaUploadResult, requestId: " + requestId + ", err: " + code);
            if (code == null) {
                return;
            }
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (byArray) {
                callback = (ResultCallback)RtmClientImpl.this.mUploadFileMediaCallbacks.remove(requestId);
            }
            if (callback != null) {
                if (code == UPLOAD_MEDIA_ERR_CODE.UPLOAD_MEDIA_ERR_OK) {
                    RtmFileMessageImpl fileMessage = new RtmFileMessageImpl();
                    fileMessage.setText(mediaMessage.getText());
                    fileMessage.setSize(mediaMessage.getSize());
                    fileMessage.setFileName(mediaMessage.getFileName());
                    fileMessage.setMediaId(mediaMessage.getMediaId());
                    fileMessage.setThumbnail(mediaMessage.getThumbnailData());
                    callback.onSuccess(fileMessage);
                } else {
                    callback.onFailure(new ErrorInfo(code.swigValue(), code.toString()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onImageMediaUploadResult(long requestId, IImageMessage mediaMessage, UPLOAD_MEDIA_ERR_CODE code) {
            ResultCallback callback;
            Logging.i(TAG, "onImageMediaUploadResult, requestId: " + requestId + ", err: " + code);
            if (code == null) {
                return;
            }
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (byArray) {
                callback = (ResultCallback)RtmClientImpl.this.mUploadImageMediaCallbacks.remove(requestId);
            }
            if (callback != null) {
                if (code == UPLOAD_MEDIA_ERR_CODE.UPLOAD_MEDIA_ERR_OK) {
                    RtmImageMessageImpl imageMessage = new RtmImageMessageImpl();
                    imageMessage.setText(mediaMessage.getText());
                    imageMessage.setSize(mediaMessage.getSize());
                    imageMessage.setFileName(mediaMessage.getFileName());
                    imageMessage.setMediaId(mediaMessage.getMediaId());
                    imageMessage.setThumbnail(mediaMessage.getThumbnailData());
                    imageMessage.setHeight(mediaMessage.getHeight());
                    imageMessage.setWidth(mediaMessage.getWidth());
                    imageMessage.setThumbnailHeight(mediaMessage.getThumbnailHeight());
                    imageMessage.setThumbnailWidth(mediaMessage.getThumbnailWidth());
                    callback.onSuccess(imageMessage);
                } else {
                    callback.onFailure(new ErrorInfo(code.swigValue(), code.toString()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMediaDownloadToFileResult(long requestId, DOWNLOAD_MEDIA_ERR_CODE code) {
            ResultCallback callback;
            Logging.i(TAG, "onMediaDownloadToFileResult, requestId: " + requestId + ", err: " + code);
            if (code == null) {
                return;
            }
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (byArray) {
                callback = (ResultCallback)RtmClientImpl.this.mDownloadMediaToFileCallbacks.remove(requestId);
            }
            if (callback != null) {
                if (code == DOWNLOAD_MEDIA_ERR_CODE.DOWNLOAD_MEDIA_ERR_OK) {
                    callback.onSuccess(null);
                } else {
                    callback.onFailure(new ErrorInfo(code.swigValue(), code.toString()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMediaDownloadToMemoryResult(long requestId, byte[] memory, DOWNLOAD_MEDIA_ERR_CODE code) {
            ResultCallback callback;
            Logging.i(TAG, "onMediaDownloadToMemoryResult, requestId: " + requestId + ", err: " + code);
            if (code == null) {
                return;
            }
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (byArray) {
                callback = (ResultCallback)RtmClientImpl.this.mDownloadMediaToMemoryCallbacks.remove(requestId);
            }
            if (callback != null) {
                if (code == DOWNLOAD_MEDIA_ERR_CODE.DOWNLOAD_MEDIA_ERR_OK) {
                    callback.onSuccess(memory);
                } else {
                    callback.onFailure(new ErrorInfo(code.swigValue(), code.toString()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMediaCancelResult(long requestId, CANCEL_MEDIA_ERR_CODE code) {
            ResultCallback callback;
            Logging.i(TAG, "onMediaCancelResult, requestId: " + requestId + ", err: " + code);
            if (code == null) {
                return;
            }
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (byArray) {
                callback = (ResultCallback)RtmClientImpl.this.mCancelMediaCallbacks.remove(requestId);
            }
            if (callback != null) {
                if (code == CANCEL_MEDIA_ERR_CODE.CANCEL_MEDIA_ERR_OK) {
                    callback.onSuccess(null);
                } else {
                    callback.onFailure(new ErrorInfo(code.swigValue(), code.toString()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onQueryPeersOnlineStatusResult(long requestId, PeerOnlineStatus[] peersStatus, int peerCount, QUERY_PEERS_ONLINE_STATUS_ERR errorCode) {
            ResultCallback callback;
            Logging.i(TAG, "onQueryPeersOnlineStatusResult, err: " + errorCode);
            if (errorCode == null) {
                return;
            }
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (byArray) {
                callback = (ResultCallback)RtmClientImpl.this.mQueryOnlineStatusCallbacks.remove(requestId);
            }
            if (callback != null) {
                if (errorCode == QUERY_PEERS_ONLINE_STATUS_ERR.QUERY_PEERS_ONLINE_STATUS_ERR_OK) {
                    LinkedHashMap<String, Boolean> statusMap = new LinkedHashMap<String, Boolean>(peerCount);
                    if (peersStatus != null) {
                        for (PeerOnlineStatus status : peersStatus) {
                            statusMap.put(status.getPeerId(), status.getIsOnline());
                        }
                    }
                    callback.onSuccess(statusMap);
                } else {
                    callback.onFailure(new ErrorInfo(errorCode.swigValue(), errorCode.toString()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSubscriptionRequestResult(long requestId, PEER_SUBSCRIPTION_STATUS_ERR errorCode) {
            ResultCallback callback;
            Logging.i(TAG, "onSubscriptionRequestResult, err: " + errorCode);
            if (errorCode == null) {
                return;
            }
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (byArray) {
                callback = (ResultCallback)RtmClientImpl.this.mSubscribePeersOnlineStatusCallbacks.remove(requestId);
            }
            if (callback != null) {
                if (errorCode == PEER_SUBSCRIPTION_STATUS_ERR.PEER_SUBSCRIPTION_STATUS_ERR_OK) {
                    callback.onSuccess(null);
                } else {
                    callback.onFailure(new ErrorInfo(errorCode.swigValue(), errorCode.toString()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onQueryPeersBySubscriptionOptionResult(long requestId, String[] peerIds, int peerCount, QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR errorCode) {
            ResultCallback callback;
            Logging.i(TAG, "onQueryPeersBySubscriptionOptionResult, err: " + errorCode);
            if (errorCode == null) {
                return;
            }
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (byArray) {
                callback = (ResultCallback)RtmClientImpl.this.mQueryPeersBySubscriptionOptionCallbacks.remove(requestId);
            }
            if (callback != null) {
                if (errorCode == QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR.QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR_OK) {
                    HashSet<String> peerIdsSet = new HashSet<String>(peerCount);
                    if (peerIdsSet != null) {
                        for (String peerId : peerIds) {
                            peerIdsSet.add(peerId);
                        }
                    }
                    callback.onSuccess(peerIdsSet);
                } else {
                    callback.onFailure(new ErrorInfo(errorCode.swigValue(), errorCode.toString()));
                }
            }
        }

        @Override
        public void onPeersOnlineStatusChanged(PeerOnlineStatus[] peersStatus, int peerCount) {
            Logging.i(TAG, "onPeersOnlineStatusChanged");
            if (peersStatus == null || peerCount <= 0) {
                return;
            }
            if (RtmClientImpl.this.mClientListener == null) {
                Logging.w(TAG, "empty client listener!");
                return;
            }
            HashMap<String, Integer> status = new HashMap<String, Integer>();
            for (PeerOnlineStatus peerStatus : peersStatus) {
                status.put(peerStatus.getPeerId(), RtmClientImpl.this.covertPeerOnlineState(peerStatus.getOnlineState()));
            }
            RtmClientImpl.this.mClientListener.onPeersOnlineStatusChanged(status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRenewTokenResult(String token, RENEW_TOKEN_ERR_CODE errorCode) {
            ResultCallback callback;
            Logging.i(TAG, "onRenewTokenResult, err: " + errorCode);
            if (errorCode == null) {
                return;
            }
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (byArray) {
                callback = (ResultCallback)RtmClientImpl.this.mRenewTokenCallbacks.remove(token);
            }
            if (callback != null) {
                if (errorCode == RENEW_TOKEN_ERR_CODE.RENEW_TOKEN_ERR_OK) {
                    callback.onSuccess(null);
                } else {
                    callback.onFailure(new ErrorInfo(errorCode.swigValue(), errorCode.toString()));
                }
            }
        }

        @Override
        public void onTokenExpired() {
            if (RtmClientImpl.this.mClientListener == null) {
                Logging.w(TAG, "no listener for token expiration!");
                return;
            }
            Logging.i(TAG, "token expired");
            RtmClientImpl.this.mClientListener.onTokenExpired();
        }

        @Override
        public void onSetLocalUserAttributesResult(long requestId, ATTRIBUTE_OPERATION_ERR errorCode) {
            Logging.i(TAG, "onSetLocalUserAttributesResult: " + errorCode);
            this.processAttrResultCallbackSimple(requestId, errorCode, RtmClientImpl.this.mSetLocalUserAttrCallbacks);
        }

        @Override
        public void onAddOrUpdateLocalUserAttributesResult(long requestId, ATTRIBUTE_OPERATION_ERR errorCode) {
            Logging.i(TAG, "onAddOrUpdateLocalUserAttributesResult: " + errorCode);
            this.processAttrResultCallbackSimple(requestId, errorCode, RtmClientImpl.this.mAddOrUpdateLocalUserAttrCallbacks);
        }

        @Override
        public void onDeleteLocalUserAttributesResult(long requestId, ATTRIBUTE_OPERATION_ERR errorCode) {
            Logging.i(TAG, "onDeleteLocalUserAttributesResult: " + errorCode);
            this.processAttrResultCallbackSimple(requestId, errorCode, RtmClientImpl.this.mDeleteLocalUserAttrCallbacks);
        }

        @Override
        public void onClearLocalUserAttributesResult(long requestId, ATTRIBUTE_OPERATION_ERR errorCode) {
            Logging.i(TAG, "onClearLocalUserAttributesResult: " + errorCode);
            this.processAttrResultCallbackSimple(requestId, errorCode, RtmClientImpl.this.mClearLocalUserAttrCallbacks);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onGetUserAttributesResult(long requestId, String userId, IRtmAttribute[] attributes, int numberOfAttributes, ATTRIBUTE_OPERATION_ERR errorCode) {
            ResultCallback callback;
            Logging.i(TAG, "onGetUserAttributesResult: " + errorCode);
            if (errorCode == null) {
                Logging.e(TAG, "onGetUserAttributesResult: null error code!");
                return;
            }
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (byArray) {
                callback = (ResultCallback)RtmClientImpl.this.mGetUserAttrCallbacks.remove(requestId);
            }
            if (callback == null) {
                Logging.e(TAG, "onGetUserAttributesResult: callback target lost!");
                return;
            }
            if (errorCode == ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK) {
                ArrayList<RtmAttribute> attributeList = new ArrayList<RtmAttribute>();
                for (int index = 0; index < attributes.length; ++index) {
                    IRtmAttribute internalAttr = attributes[index];
                    attributeList.add(new RtmAttribute(internalAttr.getKey(), internalAttr.getValue()));
                }
                callback.onSuccess(attributeList);
            } else {
                callback.onFailure(new ErrorInfo(errorCode.swigValue(), errorCode.toString()));
            }
        }

        @Override
        public void onSetChannelAttributesResult(long requestId, ATTRIBUTE_OPERATION_ERR errorCode) {
            Logging.i(TAG, "onSetChannelAttributesResult: " + errorCode);
            this.processAttrResultCallbackSimple(requestId, errorCode, RtmClientImpl.this.mSetChannelAttrCallbacks);
        }

        @Override
        public void onAddOrUpdateChannelAttributesResult(long requestId, ATTRIBUTE_OPERATION_ERR errorCode) {
            Logging.i(TAG, "onAddOrUpdateChannelAttributesResult: " + errorCode);
            this.processAttrResultCallbackSimple(requestId, errorCode, RtmClientImpl.this.mAddOrUpdateChannelAttrCallbacks);
        }

        @Override
        public void onDeleteChannelAttributesResult(long requestId, ATTRIBUTE_OPERATION_ERR errorCode) {
            Logging.i(TAG, "onDeleteChannelAttributesResult: " + errorCode);
            this.processAttrResultCallbackSimple(requestId, errorCode, RtmClientImpl.this.mDeleteChannelAttrCallbacks);
        }

        @Override
        public void onClearChannelAttributesResult(long requestId, ATTRIBUTE_OPERATION_ERR errorCode) {
            Logging.i(TAG, "onClearChannelAttributesResult: " + errorCode);
            this.processAttrResultCallbackSimple(requestId, errorCode, RtmClientImpl.this.mClearChannelAttrCallbacks);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onGetChannelAttributesResult(long requestId, IRtmChannelAttribute[] attributes, int numberOfChannelAttributes, ATTRIBUTE_OPERATION_ERR errorCode) {
            ResultCallback callback;
            Logging.i(TAG, "onGetChannelAttributesResult: " + errorCode);
            if (errorCode == null) {
                Logging.e(TAG, "onGetChannelAttributesResult: null error code!");
                return;
            }
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (byArray) {
                callback = (ResultCallback)RtmClientImpl.this.mGetChannelAttrCallbacks.remove(requestId);
            }
            if (callback == null) {
                Logging.e(TAG, "onGetChannelAttributesResult: callback target lost!");
                return;
            }
            if (errorCode == ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK) {
                ArrayList<RtmChannelAttribute> attributeList = new ArrayList<RtmChannelAttribute>();
                for (int index = 0; index < attributes.length; ++index) {
                    IRtmChannelAttribute internalAttr = attributes[index];
                    attributeList.add(new RtmChannelAttribute(internalAttr.getKey(), internalAttr.getValue(), internalAttr.getLastUpdateUserId(), internalAttr.getLastUpdateTs()));
                }
                callback.onSuccess(attributeList);
            } else {
                callback.onFailure(new ErrorInfo(errorCode.swigValue(), errorCode.toString()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onGetChannelMemberCountResult(long requestId, IRtmChannelMemberCount[] channelMemberCounts, int numberOfCounts, GET_CHANNEL_MEMBER_COUNT_ERR errorCode) {
            ResultCallback callback;
            Logging.i(TAG, "onGetChannelMemberCountResult: " + errorCode);
            if (errorCode == null) {
                Logging.e(TAG, "onGetChannelMemberCountResult: null error code!");
                return;
            }
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (byArray) {
                callback = (ResultCallback)RtmClientImpl.this.mGetChannelMemberCountCallbacks.remove(requestId);
            }
            if (callback == null) {
                Logging.e(TAG, "onGetChannelMemberCountResult: callback target lost!");
                return;
            }
            if (errorCode == GET_CHANNEL_MEMBER_COUNT_ERR.GET_CHANNEL_MEMBER_COUNT_ERR_OK) {
                ArrayList<RtmChannelMemberCount> countList = new ArrayList<RtmChannelMemberCount>();
                for (int index = 0; index < channelMemberCounts.length; ++index) {
                    IRtmChannelMemberCount internalMemberCount = channelMemberCounts[index];
                    countList.add(new RtmChannelMemberCount(internalMemberCount.getChannelID(), internalMemberCount.getMemberCount()));
                }
                callback.onSuccess(countList);
            } else {
                callback.onFailure(new ErrorInfo(errorCode.swigValue(), errorCode.toString()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processAttrResultCallbackSimple(long requestId, ATTRIBUTE_OPERATION_ERR errorCode, LruCache<Long, ResultCallback<Void>> callbackLruCache) {
            ResultCallback callback;
            if (errorCode == null) {
                Logging.e(TAG, "attr result callback with null error code!");
                return;
            }
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (byArray) {
                callback = (ResultCallback)callbackLruCache.remove(requestId);
            }
            if (callback == null) {
                Logging.e(TAG, "attr result callback target lost!");
                return;
            }
            if (errorCode == ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK) {
                callback.onSuccess(null);
            } else {
                callback.onFailure(new ErrorInfo(errorCode.swigValue(), errorCode.toString()));
            }
        }
    }
}

