/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import io.agora.common.Logging;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AgoraSysUtils {
    private static final String TAG = AgoraSysUtils.class.getSimpleName();

    public static String getAppStorageDir(Context context) {
        if (context == null) {
            return null;
        }
        int res = context.checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE");
        if (res == 0) {
            File appDir = new File(Environment.getExternalStorageDirectory().getAbsolutePath(), context.getApplicationInfo().packageName);
            appDir.mkdirs();
            return appDir.getAbsolutePath();
        }
        Logging.w(TAG, "write external storage is not granted");
        return null;
    }

    public static String getCacheDir(Context context) {
        return context.getCacheDir().getAbsolutePath();
    }

    public static String getNativeLibraryDir(Context context) {
        return context.getApplicationInfo().nativeLibraryDir;
    }

    public static String getDeviceId() {
        String deviceId = Build.MANUFACTURER + "/" + Build.MODEL + "/" + Build.PRODUCT + "/" + Build.DEVICE + "/" + Build.VERSION.SDK_INT + "/" + System.getProperty("os.version");
        if (deviceId != null) {
            deviceId = deviceId.toLowerCase();
        }
        String bid = Build.ID;
        Pattern pattern = Pattern.compile(".*[A-Z][A-M][0-9]$");
        Matcher matcher = pattern.matcher(bid);
        if (Build.BRAND.toLowerCase().equals("samsung") && Build.DEVICE.toLowerCase().startsWith("cs02") && !matcher.find() && Build.VERSION.SDK_INT == 19) {
            deviceId = "yeshen/simulator/" + Build.MODEL + "/" + Build.PRODUCT + "/" + Build.DEVICE + "/" + Build.VERSION.SDK_INT + "/" + System.getProperty("os.version");
        }
        return deviceId;
    }

    public static String getDeviceInfo() {
        String deviceInfo = Build.MANUFACTURER + "/" + Build.MODEL;
        if (deviceInfo != null) {
            deviceInfo = deviceInfo.toLowerCase();
        }
        return deviceInfo;
    }

    public static String getSystemInfo() {
        String systemInfo = "Android/" + Build.VERSION.RELEASE;
        return systemInfo;
    }
}

