/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.content.Context;
import io.agora.rtc.IMetadataObserver;
import io.agora.rtc.RtcChannel;
import io.agora.rtc.internal.EncryptionConfig;
import io.agora.rtc.internal.RtcEngineImpl;
import io.agora.rtc.internal.RtcEngineMessage;
import io.agora.rtc.live.LiveInjectStreamConfig;
import io.agora.rtc.live.LiveTranscoding;
import io.agora.rtc.mediaio.AgoraDefaultRender;
import io.agora.rtc.mediaio.IVideoSink;
import io.agora.rtc.models.ChannelMediaOptions;
import io.agora.rtc.models.ClientRoleOptions;
import io.agora.rtc.models.DataStreamConfig;
import io.agora.rtc.video.ChannelMediaInfo;
import io.agora.rtc.video.ChannelMediaRelayConfiguration;
import java.util.Map;

public class RtcChannelImpl
extends RtcChannel {
    private long mNativeHandle = 0L;
    private boolean mInitialized = false;
    private RtcEngineImpl mRtcEngineImpl = null;
    private boolean mJoined = false;

    public boolean isInitialized() {
        return this.mInitialized;
    }

    public boolean hasJoined() {
        return this.mJoined;
    }

    public long getNativeHandle() {
        return this.mNativeHandle;
    }

    public void onEngineDestroy() {
        this.mNativeHandle = 0L;
        this.mInitialized = false;
    }

    public int initialize(RtcEngineImpl rtcEngineImpl, long l2) {
        this.mRtcEngineImpl = rtcEngineImpl;
        this.mNativeHandle = l2;
        this.mInitialized = true;
        return 0;
    }

    @Override
    public String channelId() {
        if (!this.mInitialized) {
            return "";
        }
        return this.nativeRtcChannelChannelId(this.mNativeHandle);
    }

    @Override
    public String getCallId() {
        if (!this.mInitialized) {
            return "";
        }
        return this.nativeRtcChannelGetCallId(this.mNativeHandle);
    }

    @Override
    public int destroy() {
        if (this.mInitialized) {
            int n2 = this.mRtcEngineImpl.destroyRtcChannel(this.channelId());
            this.mInitialized = false;
            return n2;
        }
        return -7;
    }

    @Override
    public int getConnectionState() {
        if (!this.mInitialized) {
            return 1;
        }
        return this.nativeRtcChannelGetConncetionState(this.mNativeHandle);
    }

    @Override
    public int enableRemoteSuperResolution(int n2, boolean bl) {
        if (!this.mInitialized) {
            return 1;
        }
        return this.nativeRtcChannelEnableRemoteSuperResolutionDepercated(this.mNativeHandle, n2, bl);
    }

    @Override
    public int enableRemoteSuperResolution(boolean bl, int n2, int n3) {
        if (!this.mInitialized) {
            return 1;
        }
        return this.nativeRtcChannelEnableRemoteSuperResolution(this.mNativeHandle, bl, n2, n3);
    }

    @Override
    public int joinChannel(String string, String string2, int n2, ChannelMediaOptions channelMediaOptions) {
        if (!this.mInitialized) {
            return -7;
        }
        Context context = this.mRtcEngineImpl.getContext();
        if (context == null) {
            return -7;
        }
        if (channelMediaOptions == null) {
            return -2;
        }
        this.mRtcEngineImpl.onRtcChannelJoinChannel();
        this.mJoined = true;
        return this.nativeRtcChannelJoinChannel(this.mNativeHandle, string, string2, n2, channelMediaOptions);
    }

    @Override
    public int joinChannelWithUserAccount(String string, String string2, ChannelMediaOptions channelMediaOptions) {
        if (!this.mInitialized) {
            return -7;
        }
        Context context = this.mRtcEngineImpl.getContext();
        if (context == null) {
            return -7;
        }
        if (channelMediaOptions == null) {
            return -2;
        }
        this.mRtcEngineImpl.onRtcChannelJoinChannel();
        this.mJoined = true;
        return this.nativeRtcChannelJoinChannelWithUserAccount(this.mNativeHandle, string, string2, channelMediaOptions);
    }

    @Override
    public int leaveChannel() {
        if (!this.mInitialized) {
            return -7;
        }
        this.mJoined = false;
        this.mRtcEngineImpl.onRtcChannelLeaveChannel();
        return this.nativeRtcChannelLeaveChannel(this.mNativeHandle);
    }

    @Override
    public int setAVSyncSource(String string, int n2) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelSetAVSyncSource(this.mNativeHandle, string, n2);
    }

    @Override
    public int muteLocalAudioStream(boolean bl) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelMuteLocalAudioStream(this.mNativeHandle, bl);
    }

    @Override
    public int muteLocalVideoStream(boolean bl) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelMuteLocalVideoStream(this.mNativeHandle, bl);
    }

    @Override
    public int publish() {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelPublish(this.mNativeHandle);
    }

    @Override
    public int unpublish() {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelUnpublish(this.mNativeHandle);
    }

    @Override
    public int renewToken(String string) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelRenewToken(this.mNativeHandle, string);
    }

    @Override
    public int setEncryptionSecret(String string) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelSetEncryptionSecret(this.mNativeHandle, string);
    }

    @Override
    public int setEncryptionMode(String string) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelSetEncryptionMode(this.mNativeHandle, string);
    }

    @Override
    public int enableEncryption(boolean bl, EncryptionConfig encryptionConfig) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelEnableEncryption(this.mNativeHandle, bl, encryptionConfig.encryptionMode.getValue(), encryptionConfig.encryptionKey, encryptionConfig.encryptionKdfSalt);
    }

    @Override
    public int registerMediaMetadataObserver(IMetadataObserver iMetadataObserver, int n2) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelRegisterMediaMetadataObserver(this.mNativeHandle, iMetadataObserver, n2);
    }

    @Override
    public int setClientRole(int n2) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelSetClientRole(this.mNativeHandle, n2);
    }

    @Override
    public int setClientRole(int n2, ClientRoleOptions clientRoleOptions) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelSetClientRoleOptions(this.mNativeHandle, n2, clientRoleOptions);
    }

    @Override
    public int setRemoteUserPriority(int n2, int n3) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelSetRemoteUserPriority(this.mNativeHandle, n2, n3);
    }

    @Override
    public int setRemoteVoicePosition(int n2, double d2, double d3) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelSetRemoteVoicePosition(this.mNativeHandle, n2, d2, d3);
    }

    @Override
    public int setRemoteRenderMode(int n2, int n3, int n4) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelSetRemoteRenderModeWithMirrorMode(this.mNativeHandle, n2, n3, n4);
    }

    @Override
    public int setDefaultMuteAllRemoteAudioStreams(boolean bl) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelSetDefaultMuteAllRemoteAudioStreams(this.mNativeHandle, bl);
    }

    @Override
    public int setDefaultMuteAllRemoteVideoStreams(boolean bl) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelSetDefaultMuteAllRemoteVideoStreams(this.mNativeHandle, bl);
    }

    @Override
    public int muteAllRemoteAudioStreams(boolean bl) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelMuteAllRemoteAudioStreams(this.mNativeHandle, bl);
    }

    @Override
    public int muteRemoteAudioStream(int n2, boolean bl) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelMuteRemoteAudioStream(this.mNativeHandle, n2, bl);
    }

    @Override
    public int adjustUserPlaybackSignalVolume(int n2, int n3) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelAdjustUserPlaybackSignalVolume(this.mNativeHandle, n2, n3);
    }

    @Override
    public int muteAllRemoteVideoStreams(boolean bl) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelMuteAllRemoteVideoStreams(this.mNativeHandle, bl);
    }

    @Override
    public int muteRemoteVideoStream(int n2, boolean bl) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelMuteRemoteVideoStream(this.mNativeHandle, n2, bl);
    }

    @Override
    public int setRemoteVideoStreamType(int n2, int n3) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelSetRemoteVideoStreamType(this.mNativeHandle, n2, n3);
    }

    @Override
    public int setRemoteDefaultVideoStreamType(int n2) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelSetRemoteDefaultVideoStreamType(this.mNativeHandle, n2);
    }

    @Override
    public int createDataStream(boolean bl, boolean bl2) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelCreateDataStream(this.mNativeHandle, bl, bl2);
    }

    @Override
    public int createDataStream(DataStreamConfig dataStreamConfig) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelCreateDataStream2(this.mNativeHandle, dataStreamConfig.ordered, dataStreamConfig.syncWithAudio);
    }

    @Override
    public int sendStreamMessage(int n2, byte[] byArray) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelSendStreamMessage(this.mNativeHandle, n2, byArray);
    }

    @Override
    public int addPublishStreamUrl(String string, boolean bl) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelAddPublishStreamUrl(this.mNativeHandle, string, bl);
    }

    @Override
    public int removePublishStreamUrl(String string) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelRemovePublishStreamUrl(this.mNativeHandle, string);
    }

    @Override
    public int setLiveTranscoding(LiveTranscoding liveTranscoding) {
        Object object;
        Object object2;
        if (!this.mInitialized) {
            return -7;
        }
        if (liveTranscoding == null) {
            return -2;
        }
        if (liveTranscoding.getUsers() != null) {
            object2 = liveTranscoding.getUsers().iterator();
            while (object2.hasNext()) {
                object = (LiveTranscoding.TranscodingUser)object2.next();
                if (object.width > 0 && object.height > 0) continue;
                throw new IllegalArgumentException("transcoding user's width and height must be >0");
            }
        }
        object2 = new RtcEngineMessage.PLiveTranscoding();
        object = ((RtcEngineMessage.PLiveTranscoding)object2).marshall(liveTranscoding);
        return this.nativeRtcChannelSetLiveTranscoding(this.mNativeHandle, (byte[])object);
    }

    @Override
    public int startRtmpStreamWithoutTranscoding(String string) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelStartRtmpStreamWithoutTranscoding(this.mNativeHandle, string);
    }

    @Override
    public int startRtmpStreamWithTranscoding(String string, LiveTranscoding liveTranscoding) {
        Object object;
        Object object2;
        if (!this.mInitialized) {
            return -7;
        }
        if (liveTranscoding == null) {
            return -2;
        }
        if (liveTranscoding.getUsers() != null) {
            object2 = liveTranscoding.getUsers().iterator();
            while (object2.hasNext()) {
                object = (LiveTranscoding.TranscodingUser)object2.next();
                if (object.width > 0 && object.height > 0) continue;
                throw new IllegalArgumentException("transcoding user's width and height must be >0");
            }
        }
        object2 = new RtcEngineMessage.PLiveTranscoding();
        object = ((RtcEngineMessage.PLiveTranscoding)object2).marshall(liveTranscoding);
        return this.nativeRtcChannelStartRtmpStreamWithTranscoding(this.mNativeHandle, string, (byte[])object);
    }

    @Override
    public int updateRtmpTranscoding(LiveTranscoding liveTranscoding) {
        Object object;
        Object object2;
        if (!this.mInitialized) {
            return -7;
        }
        if (liveTranscoding == null) {
            return -2;
        }
        if (liveTranscoding.getUsers() != null) {
            object2 = liveTranscoding.getUsers().iterator();
            while (object2.hasNext()) {
                object = (LiveTranscoding.TranscodingUser)object2.next();
                if (object.width > 0 && object.height > 0) continue;
                throw new IllegalArgumentException("transcoding user's width and height must be >0");
            }
        }
        object2 = new RtcEngineMessage.PLiveTranscoding();
        object = ((RtcEngineMessage.PLiveTranscoding)object2).marshall(liveTranscoding);
        return this.nativeRtcChannelUpdateRtmpTranscoding(this.mNativeHandle, (byte[])object);
    }

    @Override
    public int stopRtmpStream(String string) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelStopRtmpStream(this.mNativeHandle, string);
    }

    @Override
    public int addInjectStreamUrl(String string, LiveInjectStreamConfig liveInjectStreamConfig) {
        if (!this.mInitialized) {
            return -7;
        }
        if (string == null || liveInjectStreamConfig == null) {
            return -2;
        }
        RtcEngineMessage.PInjectStreamConfig pInjectStreamConfig = new RtcEngineMessage.PInjectStreamConfig();
        byte[] byArray = pInjectStreamConfig.marshall(liveInjectStreamConfig);
        return this.nativeRtcChannelAddInjectStreamUrl(this.mNativeHandle, string, byArray);
    }

    @Override
    public int removeInjectStreamUrl(String string) {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelRemoveInjectStreamUrl(this.mNativeHandle, string);
    }

    @Override
    public int startChannelMediaRelay(ChannelMediaRelayConfiguration channelMediaRelayConfiguration) {
        if (!this.mInitialized) {
            return -7;
        }
        if (channelMediaRelayConfiguration == null || channelMediaRelayConfiguration.getDestChannelMediaInfos().size() == 0 || channelMediaRelayConfiguration.getSrcChannelMediaInfo() == null) {
            return -2;
        }
        for (Map.Entry<String, ChannelMediaInfo> object2 : channelMediaRelayConfiguration.getDestChannelMediaInfos().entrySet()) {
            if (object2.getValue().channelName != null && object2.getValue().channelName.length() != 0) continue;
            return -2;
        }
        RtcEngineMessage.PChannelMediaRelayConfiguration pChannelMediaRelayConfiguration = new RtcEngineMessage.PChannelMediaRelayConfiguration();
        byte[] byArray = pChannelMediaRelayConfiguration.marshall(channelMediaRelayConfiguration);
        return this.nativeRtcChannelStartChannelMediaRelay(this.mNativeHandle, byArray);
    }

    @Override
    public int updateChannelMediaRelay(ChannelMediaRelayConfiguration channelMediaRelayConfiguration) {
        if (!this.mInitialized) {
            return -7;
        }
        if (channelMediaRelayConfiguration == null || channelMediaRelayConfiguration.getDestChannelMediaInfos().size() == 0 || channelMediaRelayConfiguration.getSrcChannelMediaInfo() == null) {
            return -2;
        }
        for (Map.Entry<String, ChannelMediaInfo> object2 : channelMediaRelayConfiguration.getDestChannelMediaInfos().entrySet()) {
            if (object2.getValue().channelName != null && object2.getValue().channelName.length() != 0) continue;
            return -2;
        }
        RtcEngineMessage.PChannelMediaRelayConfiguration pChannelMediaRelayConfiguration = new RtcEngineMessage.PChannelMediaRelayConfiguration();
        byte[] byArray = pChannelMediaRelayConfiguration.marshall(channelMediaRelayConfiguration);
        return this.nativeRtcChannelUpdateChannelMediaRelay(this.mNativeHandle, byArray);
    }

    @Override
    public int stopChannelMediaRelay() {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelStopChannelMediaRelay(this.mNativeHandle);
    }

    @Override
    public int pauseAllChannelMediaRelay() {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelPauseAllChannelMediaRelay(this.mNativeHandle);
    }

    @Override
    public int resumeAllChannelMediaRelay() {
        if (!this.mInitialized) {
            return -7;
        }
        return this.nativeRtcChannelResumeAllChannelMediaRelay(this.mNativeHandle);
    }

    @Override
    public int setRemoteVideoRenderer(int n2, IVideoSink iVideoSink) {
        if (!this.mInitialized) {
            return -7;
        }
        int n3 = iVideoSink == null ? 0 : (iVideoSink instanceof AgoraDefaultRender ? 1 : 2);
        return this.nativeRtcChannelAddRemoteVideoRender(this.mNativeHandle, n2, iVideoSink, n3);
    }

    private native String nativeRtcChannelChannelId(long var1);

    private native String nativeRtcChannelGetCallId(long var1);

    private native int nativeRtcChannelJoinChannel(long var1, String var3, String var4, int var5, Object var6);

    private native int nativeRtcChannelLeaveChannel(long var1);

    private native int nativeRtcChannelSetAVSyncSource(long var1, String var3, int var4);

    private native int nativeRtcChannelMuteLocalAudioStream(long var1, boolean var3);

    private native int nativeRtcChannelMuteLocalVideoStream(long var1, boolean var3);

    private native int nativeRtcChannelJoinChannelWithUserAccount(long var1, String var3, String var4, Object var5);

    private native int nativeRtcChannelPublish(long var1);

    private native int nativeRtcChannelUnpublish(long var1);

    private native int nativeRtcChannelRenewToken(long var1, String var3);

    private native int nativeRtcChannelSetEncryptionSecret(long var1, String var3);

    private native int nativeRtcChannelSetEncryptionMode(long var1, String var3);

    private native int nativeRtcChannelEnableEncryption(long var1, boolean var3, int var4, String var5, byte[] var6);

    private native int nativeRtcChannelRegisterMediaMetadataObserver(long var1, Object var3, int var4);

    private native int nativeRtcChannelSetClientRole(long var1, int var3);

    private native int nativeRtcChannelSetClientRoleOptions(long var1, int var3, Object var4);

    private native int nativeRtcChannelSetRemoteUserPriority(long var1, int var3, int var4);

    private native int nativeRtcChannelSetRemoteVoicePosition(long var1, int var3, double var4, double var6);

    private native int nativeRtcChannelSetRemoteRenderMode(long var1, int var3, int var4);

    private native int nativeRtcChannelSetRemoteRenderModeWithMirrorMode(long var1, int var3, int var4, int var5);

    private native int nativeRtcChannelSetDefaultMuteAllRemoteAudioStreams(long var1, boolean var3);

    private native int nativeRtcChannelSetDefaultMuteAllRemoteVideoStreams(long var1, boolean var3);

    private native int nativeRtcChannelMuteAllRemoteAudioStreams(long var1, boolean var3);

    private native int nativeRtcChannelMuteRemoteAudioStream(long var1, int var3, boolean var4);

    private native int nativeRtcChannelAdjustUserPlaybackSignalVolume(long var1, int var3, int var4);

    private native int nativeRtcChannelMuteAllRemoteVideoStreams(long var1, boolean var3);

    private native int nativeRtcChannelMuteRemoteVideoStream(long var1, int var3, boolean var4);

    private native int nativeRtcChannelSetRemoteVideoStreamType(long var1, int var3, int var4);

    private native int nativeRtcChannelSetRemoteDefaultVideoStreamType(long var1, int var3);

    private native int nativeRtcChannelCreateDataStream(long var1, boolean var3, boolean var4);

    private native int nativeRtcChannelCreateDataStream2(long var1, boolean var3, boolean var4);

    private native int nativeRtcChannelSendStreamMessage(long var1, int var3, byte[] var4);

    private native int nativeRtcChannelAddPublishStreamUrl(long var1, String var3, boolean var4);

    private native int nativeRtcChannelRemovePublishStreamUrl(long var1, String var3);

    private native int nativeRtcChannelSetLiveTranscoding(long var1, byte[] var3);

    private native int nativeRtcChannelStartRtmpStreamWithoutTranscoding(long var1, String var3);

    private native int nativeRtcChannelStartRtmpStreamWithTranscoding(long var1, String var3, byte[] var4);

    private native int nativeRtcChannelUpdateRtmpTranscoding(long var1, byte[] var3);

    private native int nativeRtcChannelStopRtmpStream(long var1, String var3);

    private native int nativeRtcChannelAddInjectStreamUrl(long var1, String var3, byte[] var4);

    private native int nativeRtcChannelRemoveInjectStreamUrl(long var1, String var3);

    private native int nativeRtcChannelStartChannelMediaRelay(long var1, byte[] var3);

    private native int nativeRtcChannelUpdateChannelMediaRelay(long var1, byte[] var3);

    private native int nativeRtcChannelStopChannelMediaRelay(long var1);

    private native int nativeRtcChannelPauseAllChannelMediaRelay(long var1);

    private native int nativeRtcChannelResumeAllChannelMediaRelay(long var1);

    private native int nativeRtcChannelGetConncetionState(long var1);

    private native int nativeRtcChannelAddRemoteVideoRender(long var1, int var3, IVideoSink var4, int var5);

    private native int nativeRtcChannelEnableRemoteSuperResolutionDepercated(long var1, int var3, boolean var4);

    private native int nativeRtcChannelEnableRemoteSuperResolution(long var1, boolean var3, int var4, int var5);
}

