/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.opengl.GLES20;
import android.opengl.Matrix;
import android.util.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class TextureRenderer {
    private static final String LOG_TAG = "TextureRenderer";
    private final String mVertexShader = "attribute vec4 position;\nattribute vec2 inputTextureCoordinate;\nuniform mat4 uMVPMatrix;\nuniform mat4 uSTMatrix;\nvarying vec2 textureCoordinate;\nvoid main()\n{\ngl_Position = uMVPMatrix * position;\nvec4 tex4 = vec4(inputTextureCoordinate.xy, 1.0, 1.0);\ntextureCoordinate = (uSTMatrix * tex4).xy;\n}";
    private final String mFragmentShaderOes = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 textureCoordinate;\nuniform samplerExternalOES s_texture;\nvoid main() {\ngl_FragColor = texture2D(s_texture, textureCoordinate);\n}";
    private final String mFragmentShaderRgba = "precision mediump float;\nvarying vec2 textureCoordinate;\nuniform sampler2D s_texture;\nvoid main() {\ngl_FragColor = texture2D(s_texture, textureCoordinate);\n}";
    private FloatBuffer vertexBuffer;
    private FloatBuffer textureVerticesBuffer;
    private ShortBuffer drawListBuffer;
    private final int mProgram;
    private boolean mOesTexture = true;
    static final int COORDS_PER_VERTEX = 2;
    static float[] squareVertices = new float[]{-1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f};
    float[] textureVertices = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f};
    private short[] drawOrder = new short[]{0, 1, 2, 0, 2, 3};
    private final int vertexStride = 8;
    private int muMVPMatrixHandle;
    private int muSTMatrixHandle;
    private float[] mMVPMatrix = new float[16];
    private float[] mSTMatrix = new float[16];

    public TextureRenderer(boolean bl) {
        this.mOesTexture = bl;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(squareVertices.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.vertexBuffer = byteBuffer.asFloatBuffer();
        this.vertexBuffer.put(squareVertices);
        this.vertexBuffer.position(0);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(this.drawOrder.length * 2);
        byteBuffer2.order(ByteOrder.nativeOrder());
        this.drawListBuffer = byteBuffer2.asShortBuffer();
        this.drawListBuffer.put(this.drawOrder);
        this.drawListBuffer.position(0);
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(this.textureVertices.length * 4);
        byteBuffer3.order(ByteOrder.nativeOrder());
        this.textureVerticesBuffer = byteBuffer3.asFloatBuffer();
        this.textureVerticesBuffer.put(this.textureVertices);
        this.textureVerticesBuffer.position(0);
        int n2 = this.loadShader(35633, "attribute vec4 position;\nattribute vec2 inputTextureCoordinate;\nuniform mat4 uMVPMatrix;\nuniform mat4 uSTMatrix;\nvarying vec2 textureCoordinate;\nvoid main()\n{\ngl_Position = uMVPMatrix * position;\nvec4 tex4 = vec4(inputTextureCoordinate.xy, 1.0, 1.0);\ntextureCoordinate = (uSTMatrix * tex4).xy;\n}");
        int n3 = this.mOesTexture ? this.loadShader(35632, "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 textureCoordinate;\nuniform samplerExternalOES s_texture;\nvoid main() {\ngl_FragColor = texture2D(s_texture, textureCoordinate);\n}") : this.loadShader(35632, "precision mediump float;\nvarying vec2 textureCoordinate;\nuniform sampler2D s_texture;\nvoid main() {\ngl_FragColor = texture2D(s_texture, textureCoordinate);\n}");
        this.mProgram = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)this.mProgram, (int)n2);
        GLES20.glAttachShader((int)this.mProgram, (int)n3);
        GLES20.glLinkProgram((int)this.mProgram);
        this.muMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uMVPMatrix");
        this.muSTMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uSTMatrix");
        Matrix.setIdentityM((float[])this.mMVPMatrix, (int)0);
        Matrix.setIdentityM((float[])this.mSTMatrix, (int)0);
    }

    public void rotate(int n2) {
        double d2 = (double)n2 / 180.0 * Math.PI;
        this.mMVPMatrix[0] = (float)Math.cos(d2);
        this.mMVPMatrix[1] = -((float)Math.sin(d2));
        this.mMVPMatrix[4] = (float)Math.sin(d2);
        this.mMVPMatrix[5] = (float)Math.cos(d2);
    }

    public void flip(boolean bl, boolean bl2) {
        if (bl || bl2) {
            Matrix.scaleM((float[])this.mMVPMatrix, (int)0, (float)(bl ? -1.0f : 1.0f), (float)(bl2 ? -1.0f : 1.0f), (float)1.0f);
        }
    }

    public void draw(int n2) {
        GLES20.glUseProgram((int)this.mProgram);
        GLES20.glActiveTexture((int)33984);
        if (this.mOesTexture) {
            GLES20.glBindTexture((int)36197, (int)n2);
        } else {
            GLES20.glBindTexture((int)3553, (int)n2);
        }
        int n3 = GLES20.glGetAttribLocation((int)this.mProgram, (String)"position");
        GLES20.glEnableVertexAttribArray((int)n3);
        GLES20.glVertexAttribPointer((int)n3, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexBuffer);
        int n4 = GLES20.glGetAttribLocation((int)this.mProgram, (String)"inputTextureCoordinate");
        GLES20.glEnableVertexAttribArray((int)n4);
        GLES20.glVertexAttribPointer((int)n4, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVerticesBuffer);
        GLES20.glUniformMatrix4fv((int)this.muMVPMatrixHandle, (int)1, (boolean)false, (float[])this.mMVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.muSTMatrixHandle, (int)1, (boolean)false, (float[])this.mSTMatrix, (int)0);
        GLES20.glDrawElements((int)4, (int)this.drawOrder.length, (int)5123, (Buffer)this.drawListBuffer);
        GLES20.glDisableVertexAttribArray((int)n3);
        GLES20.glDisableVertexAttribArray((int)n4);
        GLES20.glUseProgram((int)0);
    }

    private void printMatrix(float[] fArray) {
        for (int i2 = 0; i2 < 4; ++i2) {
            Log.d((String)LOG_TAG, (String)(fArray[i2 * 4 + 0] + " " + fArray[i2 * 4 + 1] + " " + fArray[i2 * 4 + 2] + " " + fArray[i2 * 4 + 3]));
        }
    }

    public void draw(int n2, float[] fArray) {
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            this.mSTMatrix[i2] = fArray[i2];
        }
        this.draw(n2);
    }

    private int loadShader(int n2, String string) {
        int n3 = GLES20.glCreateShader((int)n2);
        GLES20.glShaderSource((int)n3, (String)string);
        GLES20.glCompileShader((int)n3);
        return n3;
    }
}

