/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.view.Surface;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.SurfaceTextureHelper;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.internal.DeviceUtils;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.utils.ThreadUtils;
import io.agora.rtc.video.AgoraVideoDebugger;
import io.agora.rtc.video.CoordinatesTransform;
import io.agora.rtc.video.VideoCapture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class VideoCaptureCamera
extends VideoCapture
implements Camera.PreviewCallback,
SurfaceTextureHelper.OnTextureFrameAvailableListener {
    private static final String TAG = "CAMERA1";
    private static final boolean VERBOSE = false;
    private static final int CAMERA_ALLOCATE_TIMEOUT_MS = 6000;
    protected Camera mCamera;
    protected ReentrantLock mPreviewBufferLock = new ReentrantLock();
    private ReentrantLock mCaptureLock = new ReentrantLock();
    private boolean isCaptureStarted = false;
    private boolean isCaptureRunning = false;
    private boolean isSurfaceReady = false;
    private boolean isFaceDetectionStarted = false;
    private int mCaptureWidth = -1;
    private int mCaptureHeight = -1;
    private int mCaptureFps = -1;
    private int mCaptureFormat = 17;
    private static final long CAMERA_OPEN_REQUEST_INTERVAL = 2000L;
    private HandlerThread mCameraRecoverHandlerThread = null;
    private Handler mHandler = null;
    private Object mRecoverThreadObjectLock = new Object();
    private HandlerThread mCameraPreviewHandlerThread = null;
    private Handler mPreviewHandler = null;
    private volatile int mAllocated;
    private Object mObjectLock = new Object();
    private boolean mIsAutoFaceFocusEnabled = false;
    private RectF[] rectArray = null;
    private int[] distanceArray = null;
    private boolean faceDetectEnabled = false;
    private String mAntiBandingMode = "auto";
    private final boolean mIsCameraFacingFront;
    private static final int NUM_OF_CAPTURE_BUFFERS = 3;
    private SurfaceTexture mDummySurfaceTexture = null;

    VideoCaptureCamera(Context context, int n2, int n3, EglBase.Context context2, long l2) {
        super(context, n2, n3, context2, l2);
        this.mIsCameraFacingFront = VideoCaptureCamera.isCameraFacingFront(n2);
    }

    static boolean isCameraFacingFront(int n2) {
        Camera.CameraInfo cameraInfo = VideoCaptureCamera.getCameraInfo(n2);
        if (cameraInfo != null) {
            return cameraInfo.facing == 1;
        }
        return true;
    }

    protected static Camera.CameraInfo getCameraInfo(int n2) {
        if (n2 < 0 || n2 > Camera.getNumberOfCameras() - 1) {
            return null;
        }
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        try {
            Camera.getCameraInfo((int)n2, (Camera.CameraInfo)cameraInfo);
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "getCameraInfo: Camera.getCameraInfo: ", runtimeException);
            return null;
        }
        return cameraInfo;
    }

    public static int getFrontCameraIndex() {
        int n2 = 0;
        try {
            n2 = Camera.getNumberOfCameras() > 1 ? 1 : 0;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)exception.toString());
        }
        return n2;
    }

    static int getNumberOfCameras() {
        int n2 = Camera.getNumberOfCameras();
        Logging.e(TAG, "camera1 listCount:" + n2);
        return n2;
    }

    static String getName(int n2) {
        Camera.CameraInfo cameraInfo = VideoCaptureCamera.getCameraInfo(n2);
        if (cameraInfo == null) {
            return null;
        }
        return "camera " + n2 + ", facing " + (cameraInfo.facing == 1 ? "front" : "back");
    }

    static String getCaptureName() {
        return "camera1";
    }

    static int getSensorOrientation(int n2) {
        Camera.CameraInfo cameraInfo = VideoCaptureCamera.getCameraInfo(n2);
        if (cameraInfo == null) {
            return -1;
        }
        return cameraInfo.orientation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int UnRegisterNativeHandle() {
        Logging.d(TAG, "UnRegisterNativeHandle called");
        Object object = this.mRecoverThreadObjectLock;
        synchronized (object) {
            this.mNativeVideoCaptureDeviceAndroid = 0L;
        }
        return 0;
    }

    @Override
    public int allocate() {
        if (this.mCameraPreviewHandlerThread == null) {
            this.mCameraPreviewHandlerThread = new HandlerThread("camera-preview-thread");
            this.mCameraPreviewHandlerThread.start();
            if (this.mCameraPreviewHandlerThread != null) {
                this.mPreviewHandler = new Handler(this.mCameraPreviewHandlerThread.getLooper());
            }
        }
        this.mAllocated = -1;
        if (this.mPreviewHandler != null) {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            this.mPreviewHandler.postAtFrontOfQueue(new Runnable(){

                @Override
                public void run() {
                    VideoCaptureCamera.this.mAllocated = VideoCaptureCamera.this.allocate_l();
                    countDownLatch.countDown();
                }
            });
            try {
                countDownLatch.await(6000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return this.mAllocated;
    }

    private int allocate_l() {
        try {
            this.mCamera = Camera.open((int)this.mId);
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "allocate: Camera.open: ", runtimeException);
            return -1;
        }
        Camera.CameraInfo cameraInfo = VideoCaptureCamera.getCameraInfo(this.mId);
        if (cameraInfo == null) {
            this.mCamera.release();
            this.mCamera = null;
            return -2;
        }
        if (VideoCapture.fetchCapability(this.mId, this.mContext, VideoCaptureCamera.getCaptureName()) == null) {
            this.createCapabilities();
        }
        this.mCameraNativeOrientation = cameraInfo.orientation;
        if (this.mNativeVideoCaptureDeviceAndroid != 0L) {
            this.mIsAutoFaceFocusEnabled = this.isAutoFaceFocusEnabled(this.mNativeVideoCaptureDeviceAndroid);
        }
        this.faceDetectEnabled = this.isFaceDetectionEnabled(this.mNativeVideoCaptureDeviceAndroid);
        return 0;
    }

    @Override
    public int setCaptureFormat(int n2, int n3, boolean bl) {
        Logging.i(TAG, "setCaptureFormat: " + n2 + " type: " + n3 + " force texture oes: " + bl);
        VideoCapture.FORCE_TEXTURE_OES = bl;
        this.mCaptureOutputDataType = VideoCaptureCamera.translateToCaptureOutputDataType(n3);
        this.mCaptureFormat = VideoCaptureCamera.translateToAndroidFormat(n2);
        if (this.mCaptureFormat == 0) {
            Logging.e(TAG, "setCaptureFormat failed, unkonwn format: " + n2);
            return -1;
        }
        return 0;
    }

    private int tryStartCapture(int n2, int n3, int n4) {
        if (this.mCamera == null) {
            Logging.e(TAG, "Camera not initialized %d" + this.mId);
            return -1;
        }
        Logging.i(TAG, "tryStartCapture: " + n2 + "*" + n3 + ", frameRate: " + n4 + ", isCaptureRunning: " + this.isCaptureRunning + ", isSurfaceReady: " + this.isSurfaceReady + ", isCaptureStarted: " + this.isCaptureStarted + ", outputDataType: " + this.mCaptureOutputDataType);
        if (this.isCaptureRunning || !this.isCaptureStarted) {
            Logging.w(TAG, "tryStartCapture return");
            return 0;
        }
        Camera.Parameters parameters = this.mCamera.getParameters();
        parameters.setPreviewSize(n2, n3);
        parameters.setPreviewFormat(this.mCaptureFormat);
        if (this.mPQFirst < 1) {
            Logging.i(TAG, "camera1::fps first");
            List list = parameters.getSupportedPreviewFpsRange();
            if (list.size() <= 0) {
                parameters.setPreviewFrameRate(n4);
            } else {
                int n5;
                for (n5 = 0; n5 < list.size(); ++n5) {
                    if (((int[])list.get(n5))[0] < n4 * 1000) continue;
                    parameters.setPreviewFpsRange(((int[])list.get(n5))[0], ((int[])list.get(n5))[1]);
                    break;
                }
                if (n5 == list.size()) {
                    parameters.setPreviewFpsRange(((int[])list.get(n5 - 1))[0], ((int[])list.get(n5 - 1))[1]);
                }
            }
        } else {
            Logging.i(TAG, "camera1::PQ first");
            parameters.setPreviewFrameRate(n4);
        }
        this.setAdvancedCameraParameters(parameters);
        this.setDeviceSpecificParameters(parameters);
        this.mCamera.setParameters(parameters);
        int n6 = 0;
        if (this.mCaptureOutputDataType == 0 || this.mCaptureOutputDataType == 2) {
            n6 = n2 * n3 * ImageFormat.getBitsPerPixel((int)this.mCaptureFormat) / 8;
            n6 += 4096;
            byte[] byArray = null;
            for (int i2 = 0; i2 < 3; ++i2) {
                byArray = new byte[n6];
                this.mCamera.addCallbackBuffer(byArray);
            }
            this.mCamera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
        }
        this.mCamera.setErrorCallback(new Camera.ErrorCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(int n2, Camera camera) {
                Logging.e(VideoCaptureCamera.TAG, "onError: error code" + n2);
                if (n2 == 2 || n2 == 100 || n2 == 1) {
                    if (VideoCaptureCamera.this.mCamera != null) {
                        VideoCaptureCamera.this.stopCapture();
                        VideoCaptureCamera.this.mCaptureLock.lock();
                        try {
                            if (VideoCaptureCamera.this.mCamera != null) {
                                VideoCaptureCamera.this.mCamera.release();
                                VideoCaptureCamera.this.mCamera = null;
                            }
                        }
                        catch (Exception exception) {
                            Logging.e(VideoCaptureCamera.TAG, "Camera release failed, " + exception);
                        }
                        finally {
                            VideoCaptureCamera.this.mCaptureLock.unlock();
                        }
                    }
                    Object object = VideoCaptureCamera.this.mRecoverThreadObjectLock;
                    synchronized (object) {
                        if (VideoCaptureCamera.this.mCameraRecoverHandlerThread == null) {
                            VideoCaptureCamera.this.mCameraRecoverHandlerThread = new HandlerThread("camera-recover-thread");
                            VideoCaptureCamera.this.mCameraRecoverHandlerThread.start();
                            if (VideoCaptureCamera.this.mCameraRecoverHandlerThread != null) {
                                VideoCaptureCamera.this.mHandler = new Handler(VideoCaptureCamera.this.mCameraRecoverHandlerThread.getLooper());
                            }
                        }
                        if (VideoCaptureCamera.this.mHandler != null) {
                            VideoCaptureCamera.this.mHandler.postDelayed(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    Object object = VideoCaptureCamera.this.mRecoverThreadObjectLock;
                                    synchronized (object) {
                                        Logging.i(VideoCaptureCamera.TAG, "native handle = " + VideoCaptureCamera.this.mNativeVideoCaptureDeviceAndroid);
                                        if (VideoCaptureCamera.this.isForeground() && null == VideoCaptureCamera.this.mCamera && VideoCaptureCamera.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                                            VideoCaptureCamera.this.allocate();
                                            VideoCaptureCamera.this.startCapture(VideoCaptureCamera.this.mCaptureWidth, VideoCaptureCamera.this.mCaptureHeight, VideoCaptureCamera.this.mCaptureFps);
                                            return;
                                        }
                                        if (VideoCaptureCamera.this.mHandler != null) {
                                            VideoCaptureCamera.this.mHandler.postDelayed((Runnable)this, 2000L);
                                        }
                                    }
                                }
                            }, 2000L);
                        }
                    }
                }
            }
        });
        this.mCamera.startPreview();
        if (this.isAutoFaceFocusSupported()) {
            this.mCamera.setFaceDetectionListener(new Camera.FaceDetectionListener(){
                private long mLastFocusedTs;

                public void onFaceDetection(Camera.Face[] faceArray, Camera camera) {
                    if (VideoCaptureCamera.this.faceDetectEnabled) {
                        VideoCaptureCamera.this.notifyFaceDetection(faceArray);
                    }
                    if (faceArray == null || faceArray.length == 0 || camera == null || !VideoCaptureCamera.this.mIsAutoFaceFocusEnabled) {
                        return;
                    }
                    if (System.currentTimeMillis() - this.mLastFocusedTs < 3000L) {
                        if (faceArray[0].score > 20) {
                            VideoCaptureCamera.this.notifyCameraFocusAreaChanged(faceArray[0].rect);
                        }
                        return;
                    }
                    if (faceArray[0].score <= 50) {
                        Logging.i(VideoCaptureCamera.TAG, "face score = " + faceArray[0].score);
                        return;
                    }
                    try {
                        ArrayList<Camera.Area> arrayList = new ArrayList<Camera.Area>();
                        Camera.Area area = new Camera.Area(faceArray[0].rect, 1000);
                        arrayList.add(area);
                        if (camera.getParameters().getMaxNumFocusAreas() > 0) {
                            camera.getParameters().setFocusAreas(arrayList);
                        }
                        if (camera.getParameters().getMaxNumMeteringAreas() > 0) {
                            camera.getParameters().setMeteringAreas(arrayList);
                        }
                        VideoCaptureCamera.this.notifyCameraFocusAreaChanged(faceArray[0].rect);
                        camera.autoFocus(new Camera.AutoFocusCallback(){

                            public void onAutoFocus(boolean bl, Camera camera) {
                                Logging.d(VideoCaptureCamera.TAG, "auto face focus called api1 every 3 seconds");
                                try {
                                    if (camera != null) {
                                        camera.cancelAutoFocus();
                                    }
                                }
                                catch (RuntimeException runtimeException) {
                                    Logging.w(VideoCaptureCamera.TAG, "Exception in cancelAutoFocus: " + Log.getStackTraceString((Throwable)runtimeException));
                                }
                            }
                        });
                        this.mLastFocusedTs = System.currentTimeMillis();
                    }
                    catch (RuntimeException runtimeException) {
                        Logging.w(VideoCaptureCamera.TAG, "Exception in onFaceDetection callback: " + Log.getStackTraceString((Throwable)runtimeException));
                    }
                }
            });
            if (this.mIsAutoFaceFocusEnabled || this.faceDetectEnabled) {
                this.startFaceDetection();
            }
        } else if (this.isFaceDetectedSupported()) {
            this.mCamera.setFaceDetectionListener(new Camera.FaceDetectionListener(){

                public void onFaceDetection(Camera.Face[] faceArray, Camera camera) {
                    if (VideoCaptureCamera.this.faceDetectEnabled) {
                        VideoCaptureCamera.this.notifyFaceDetection(faceArray);
                    }
                }
            });
            if (this.faceDetectEnabled) {
                this.startFaceDetection();
            }
        }
        this.mPreviewBufferLock.lock();
        this.mExpectedRawBufferSize = n6;
        this.isCaptureRunning = true;
        this.mPreviewBufferLock.unlock();
        parameters = this.mCamera.getParameters();
        Logging.i(TAG, "Params: " + parameters.flatten());
        return 0;
    }

    private void startFaceDetection() {
        if (this.mPreviewHandler != null) {
            ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Runnable(){

                @Override
                public void run() {
                    VideoCaptureCamera.this.startFaceDetection_l();
                }
            });
        }
    }

    private void startFaceDetection_l() {
        if (this.mCamera == null) {
            return;
        }
        try {
            Logging.i(TAG, "enable face detection");
            this.mCamera.startFaceDetection();
            this.isFaceDetectionStarted = true;
        }
        catch (Exception exception) {
            Logging.e(TAG, "start face detection failed:" + exception);
            this.mCamera.stopFaceDetection();
            this.isFaceDetectionStarted = false;
        }
    }

    private void stopFaceDetection() {
        if (this.mPreviewHandler != null) {
            ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Runnable(){

                @Override
                public void run() {
                    VideoCaptureCamera.this.stopFaceDetection_l();
                }
            });
        }
    }

    private void stopFaceDetection_l() {
        if (this.mCamera == null) {
            return;
        }
        Logging.i(TAG, "disable face detection");
        this.mCamera.stopFaceDetection();
        this.isFaceDetectionStarted = false;
    }

    private void notifyCameraFocusAreaChanged(Rect rect) {
        boolean bl = false;
        if (this.mId == 1) {
            bl = true;
        }
        RectF rectF = CoordinatesTransform.normalizedFaceRect(rect, 0, bl);
        float f2 = rectF.left;
        float f3 = rectF.top;
        float f4 = rectF.width();
        float f5 = rectF.height();
        Logging.d(TAG, "auto face focus left =" + rectF.left + " top = " + rectF.top + " right = " + rectF.right + " bottom = " + rectF.bottom);
        this.NotifyCameraFocusAreaChanged(f2, f3, f4, f5, this.mNativeVideoCaptureDeviceAndroid);
    }

    private void notifyFaceDetection(Camera.Face[] faceArray) {
        this.rectArray = null;
        int n2 = 0;
        boolean bl = false;
        if (this.mId == 1) {
            bl = true;
        }
        if (faceArray != null && faceArray.length > 0) {
            n2 = faceArray.length;
            this.rectArray = new RectF[n2];
            this.distanceArray = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.rectArray[i2] = CoordinatesTransform.normalizedFaceRect(faceArray[i2].rect, 0, bl);
                this.distanceArray[i2] = 5;
            }
        } else {
            this.rectArray = new RectF[0];
        }
        this.NotifyFaceDetection(this.mCaptureWidth, this.mCaptureHeight, this.rectArray, n2, this.mNativeVideoCaptureDeviceAndroid);
    }

    @Override
    public int setZoom(float f2) {
        final float f3 = f2;
        if (this.mPreviewHandler != null) {
            Integer n2 = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    int n2 = VideoCaptureCamera.this.setZoom_l(f3);
                    return n2;
                }
            });
            return n2;
        }
        return -1;
    }

    private int setZoom_l(float f2) {
        Camera.Parameters parameters;
        int n2;
        if (f2 < 0.0f) {
            return -1;
        }
        int n3 = (int)(f2 * 100.0f + 0.5f);
        List<Integer> list = this.getZoomRatios();
        if (list == null) {
            return -1;
        }
        int n4 = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            n2 = list.get(i2);
            if (n3 > n2) continue;
            n4 = i2;
            break;
        }
        if (this.mCamera != null && this.isZoomSupported(parameters = this.getCameraParameters())) {
            n2 = parameters.getMaxZoom();
            if (n4 > n2) {
                Logging.w(TAG, "zoom value is larger than maxZoom value");
                return -1;
            }
            parameters.setZoom(n4);
            try {
                this.mCamera.setParameters(parameters);
            }
            catch (Exception exception) {
                Logging.w(TAG, "setParameters failed, zoomLevel: " + n4 + ", " + exception);
            }
        }
        return 0;
    }

    @Override
    public float getMaxZoom() {
        if (this.mPreviewHandler != null) {
            Float f2 = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Float>(){

                @Override
                public Float call() {
                    float f2 = VideoCaptureCamera.this.getMaxZoom_l();
                    return Float.valueOf(f2);
                }
            });
            return f2.floatValue();
        }
        return -1.0f;
    }

    private float getMaxZoom_l() {
        if (this.mCamera != null) {
            List<Integer> list;
            Camera.Parameters parameters = this.getCameraParameters();
            int n2 = 0;
            if (this.isZoomSupported(parameters)) {
                n2 = parameters.getMaxZoom();
            }
            if ((list = this.getZoomRatios()) != null && list.size() > n2) {
                return (float)list.get(n2).intValue() / 100.0f;
            }
        }
        return -1.0f;
    }

    @Override
    public int setTorchMode(boolean bl) {
        final boolean bl2 = bl;
        if (this.mPreviewHandler != null) {
            Integer n2 = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    int n2 = VideoCaptureCamera.this.setTorchMode_l(bl2);
                    return n2;
                }
            });
            return n2;
        }
        return -1;
    }

    private int setTorchMode_l(boolean bl) {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            List list = parameters.getSupportedFlashModes();
            if (list != null && list.contains("torch")) {
                if (bl) {
                    parameters.setFlashMode("torch");
                } else {
                    parameters.setFlashMode("off");
                }
                this.mCamera.setParameters(parameters);
                return 0;
            }
            return -1;
        }
        return -2;
    }

    @Override
    public int setFocus(float f2, float f3, boolean bl) {
        final float f4 = f2;
        final float f5 = f3;
        final boolean bl2 = bl;
        if (this.mPreviewHandler != null) {
            Integer n2 = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    int n2 = VideoCaptureCamera.this.setFocus_l(f4, f5, bl2);
                    return n2;
                }
            });
            return n2;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setFocus_l(float f2, float f3, boolean bl) {
        Object object;
        Logging.d(TAG, "setFocus called camera api1");
        if (this.mCamera == null) {
            return -1;
        }
        if (f2 < 0.0f || f2 > 1.0f || f3 < 0.0f || f3 > 1.0f) {
            Logging.e(TAG, "set focus unreasonable inputs");
            return -1;
        }
        Rect rect = VideoCaptureCamera.calculateTapArea(f2, f3, 1.0f);
        Rect rect2 = VideoCaptureCamera.calculateTapArea(f2, f3, 1.5f);
        try {
            this.mCamera.cancelAutoFocus();
        }
        catch (RuntimeException runtimeException) {
            Logging.w(TAG, "Failed to cancle AutoFocus" + runtimeException);
        }
        Camera.Parameters parameters = this.getCameraParameters();
        if (parameters == null) {
            return -1;
        }
        if (parameters.getMaxNumFocusAreas() > 0) {
            object = new ArrayList<Camera.Area>();
            object.add(new Camera.Area(rect, 800));
            parameters.setFocusAreas((List)object);
        } else {
            Logging.i(TAG, "focus areas not supported");
        }
        if (parameters.getMaxNumMeteringAreas() > 0) {
            object = new ArrayList();
            object.add(new Camera.Area(rect2, 800));
            parameters.setMeteringAreas((List)object);
        } else {
            Logging.i(TAG, "metering areas not supported");
        }
        object = parameters.getFocusMode();
        if (VideoCaptureCamera.isSupported("macro", parameters.getSupportedFocusModes())) {
            parameters.setFocusMode("macro");
            Object object2 = this.mObjectLock;
            synchronized (object2) {
                this.mCamera.setParameters(parameters);
            }
        } else {
            Logging.i("focus", "FOCUS_MODE_MACRO is not supported");
        }
        try {
            this.mCamera.autoFocus(new Camera.AutoFocusCallback((String)object){
                final /* synthetic */ String val$currentFocusMode;
                {
                    this.val$currentFocusMode = string;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onAutoFocus(boolean bl, Camera camera) {
                    if (VideoCaptureCamera.this.mCamera == null) {
                        return;
                    }
                    Camera.Parameters parameters = camera.getParameters();
                    parameters.setFocusMode(this.val$currentFocusMode);
                    Object object = VideoCaptureCamera.this.mObjectLock;
                    synchronized (object) {
                        camera.setParameters(parameters);
                    }
                }
            });
        }
        catch (Exception exception) {
            Logging.w(TAG, "mCamera.autoFocus Exception: " + exception);
            return -1;
        }
        if (this.mNativeVideoCaptureDeviceAndroid != 0L) {
            this.NotifyCameraFocusAreaChanged(f2, f3, 0.0f, 0.0f, this.mNativeVideoCaptureDeviceAndroid);
        }
        return 0;
    }

    @Override
    public int setExposure(float f2, float f3, boolean bl) {
        final float f4 = f2;
        final float f5 = f3;
        final boolean bl2 = bl;
        if (this.mPreviewHandler != null) {
            Integer n2 = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    int n2 = VideoCaptureCamera.this.setExposure_l(f4, f5, bl2);
                    return n2;
                }
            });
            return n2;
        }
        return -1;
    }

    private int setExposure_l(float f2, float f3, boolean bl) {
        Logging.d(TAG, "setExposure called camera api1 x = " + f2 + " y = " + f3);
        if (this.mCamera == null) {
            return -1;
        }
        if (f2 < 0.0f || f2 > 1.0f || f3 < 0.0f || f3 > 1.0f) {
            Logging.e(TAG, "set exposure unreasonable inputs");
            return -1;
        }
        Rect rect = VideoCaptureCamera.calculateTapArea(f2, f3, 1.5f);
        if (this.mCamera != null) {
            Camera.Parameters parameters = this.getCameraParameters();
            if (parameters == null) {
                return -1;
            }
            if (parameters.getMaxNumMeteringAreas() > 0) {
                ArrayList<Camera.Area> arrayList = new ArrayList<Camera.Area>();
                arrayList.add(new Camera.Area(rect, 800));
                parameters.setMeteringAreas(arrayList);
            } else {
                Logging.i(TAG, "metering areas not supported");
            }
            try {
                this.mCamera.setParameters(parameters);
                this.mCamera.startPreview();
            }
            catch (Exception exception) {
                Logging.e(TAG, "setExposure failed, " + exception);
                return -1;
            }
        }
        if (this.mNativeVideoCaptureDeviceAndroid != 0L) {
            this.NotifyCameraExposureAreaChanged(f2, f3, 0.0f, 0.0f, this.mNativeVideoCaptureDeviceAndroid);
        }
        return 0;
    }

    @Override
    public int setAutoFaceFocus(boolean bl) {
        Logging.d(TAG, "setAutoFaceFocus: " + bl);
        boolean bl2 = this.mIsAutoFaceFocusEnabled != bl;
        this.mIsAutoFaceFocusEnabled = bl;
        if (this.isAutoFaceFocusSupported() && bl2) {
            if (this.mIsAutoFaceFocusEnabled && !this.isFaceDetectionStarted) {
                this.startFaceDetection();
            } else if (!this.mIsAutoFaceFocusEnabled && this.isFaceDetectionStarted && !this.faceDetectEnabled) {
                this.stopFaceDetection();
            }
        }
        return 0;
    }

    @Override
    public int setFaceDetection(boolean bl) {
        Logging.d(TAG, "setFaceDetection: " + bl);
        boolean bl2 = this.faceDetectEnabled != bl;
        this.faceDetectEnabled = bl;
        if (this.isFaceDetectedSupported() && bl2) {
            if (this.faceDetectEnabled && !this.isFaceDetectionStarted) {
                this.startFaceDetection();
            } else if (!this.faceDetectEnabled && this.isFaceDetectionStarted && !this.mIsAutoFaceFocusEnabled) {
                this.stopFaceDetection();
            }
        }
        return 0;
    }

    @Override
    public int startCapture(int n2, int n3, int n4) {
        final int n5 = n2;
        final int n6 = n3;
        final int n7 = n4;
        if (this.mPreviewHandler != null) {
            Integer n8 = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    int n2 = VideoCaptureCamera.this.startCapture_l(n5, n6, n7);
                    return n2;
                }
            });
            return n8;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int startCapture_l(int n2, int n3, int n4) {
        Logging.i(TAG, "startCapture, w=" + n2 + ", h=" + n3 + ", fps=" + n4);
        if (this.mCamera == null) {
            Logging.e(TAG, "startCapture: camera is null!!");
            return -1;
        }
        SurfaceTexture surfaceTexture = null;
        if (this.mCaptureOutputDataType == 1 || this.mCaptureOutputDataType == 2) {
            this.mSurfaceTextureHelper = SurfaceTextureHelper.create("Camera1Tex-" + this.mId, this.mShareContext, 8);
            if (this.mSurfaceTextureHelper == null) {
                Logging.e(TAG, "Failed to create SurfaceTextureHelper, force fallback to raw data type");
                this.mCaptureOutputDataType = 0;
            } else {
                this.mSurfaceTextureHelper.getSurfaceTexture().setDefaultBufferSize(n2, n3);
                this.mSurfaceTextureHelper.startListening(this);
                this.mEglContext = this.mSurfaceTextureHelper.getEglContext();
                surfaceTexture = this.mSurfaceTextureHelper.getSurfaceTexture();
                if (this.mCaptureOutputDataType == 2 && this.mTextureAndRawBufferSynchronizer == null) {
                    this.mTextureAndRawBufferSynchronizer = new VideoCapture.TextureAndRawBufferSynchronizer(this);
                }
            }
        }
        int n5 = 0;
        if (this.mCaptureOutputDataType == 0) {
            if (this.mDummySurfaceTexture == null) {
                try {
                    this.mDummySurfaceTexture = new SurfaceTexture(42);
                }
                catch (Surface.OutOfResourcesException outOfResourcesException) {
                    Logging.e(TAG, "failed to create dummy SurfaceTexture!");
                }
            }
            surfaceTexture = this.mDummySurfaceTexture;
        }
        if (surfaceTexture == null) {
            n5 = -1;
        } else {
            this.mCaptureLock.lock();
            try {
                this.mCamera.setPreviewTexture(surfaceTexture);
            }
            catch (Exception exception) {
                Logging.e(TAG, "failed to set preview texture, invalid surfaceTexture!");
                this.mDummySurfaceTexture = null;
                n5 = -1;
            }
            finally {
                this.mCaptureLock.unlock();
            }
        }
        if (n5 != 0) {
            return n5;
        }
        this.mCaptureLock.lock();
        this.isCaptureStarted = true;
        this.mCaptureWidth = n2;
        this.mCaptureHeight = n3;
        this.mCaptureFps = n4;
        try {
            n5 = this.tryStartCapture(n2, n3, n4);
        }
        catch (Throwable throwable) {
            Logging.e(TAG, "try start capture failed " + throwable);
            n5 = -1;
        }
        finally {
            this.mCaptureLock.unlock();
        }
        return n5;
    }

    @Override
    public int stopCapture() {
        if (this.mPreviewHandler != null) {
            Integer n2 = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    int n2 = VideoCaptureCamera.this.stopCapture_l();
                    return n2;
                }
            });
            return n2;
        }
        return -1;
    }

    private int stopCapture_l() {
        if (!this.isCaptureStarted) {
            Logging.w(TAG, "already stop capture");
            return 0;
        }
        try {
            if (this.isFaceDetectionStarted) {
                this.stopFaceDetection();
                this.mCamera.setFaceDetectionListener(null);
            }
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "Failed to stop face detection", runtimeException);
        }
        int n2 = 0;
        try {
            this.mCamera.cancelAutoFocus();
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "Failed to cancle AutoFocus", runtimeException);
        }
        try {
            this.mPreviewBufferLock.lock();
            this.isCaptureRunning = false;
            this.mCamera.stopPreview();
            this.mCamera.setErrorCallback(null);
            AgoraVideoDebugger.reset();
            this.mDroppedTextureBufferCount = 0;
            if (this.mTextureAndRawBufferSynchronizer != null) {
                this.mTextureAndRawBufferSynchronizer.reset();
            }
            if (this.mSurfaceTextureHelper != null) {
                this.mSurfaceTextureHelper.stopListening();
                this.mSurfaceTextureHelper.dispose();
                this.mSurfaceTextureHelper = null;
            }
            this.mEglContext = null;
            if (this.mCaptureOutputDataType == 0 || this.mCaptureOutputDataType == 2) {
                this.mCamera.setPreviewCallbackWithBuffer(null);
            }
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "Failed to stop camera", runtimeException);
            n2 = -1;
        }
        this.mPreviewBufferLock.unlock();
        if (n2 == 0) {
            this.isCaptureStarted = false;
        }
        return n2;
    }

    @Override
    public boolean isTorchSupported() {
        if (this.mPreviewHandler != null) {
            Boolean bl = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    boolean bl = VideoCaptureCamera.this.isTorchSupported_l();
                    return bl;
                }
            });
            return bl;
        }
        return false;
    }

    private boolean isTorchSupported_l() {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            return VideoCaptureCamera.isSupported("torch", parameters.getSupportedFlashModes());
        }
        return false;
    }

    @Override
    public boolean isFocusSupported() {
        if (this.mPreviewHandler != null) {
            Boolean bl = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    boolean bl = VideoCaptureCamera.this.isFocusSupported_l();
                    return bl;
                }
            });
            return bl;
        }
        return false;
    }

    private boolean isFocusSupported_l() {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            boolean bl = parameters.getMaxNumFocusAreas() > 0 && VideoCaptureCamera.isSupported("auto", parameters.getSupportedFocusModes());
            return bl;
        }
        return false;
    }

    @Override
    public boolean isExposureSupported() {
        if (this.mPreviewHandler != null) {
            Boolean bl = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    boolean bl = VideoCaptureCamera.this.isExposureSupported_l();
                    return bl;
                }
            });
            return bl;
        }
        return false;
    }

    private boolean isExposureSupported_l() {
        Camera.Parameters parameters;
        boolean bl = false;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            bl = parameters.getMaxNumMeteringAreas() > 0;
        }
        return bl;
    }

    @Override
    public boolean isZoomSupported() {
        if (this.mPreviewHandler != null) {
            Boolean bl = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    boolean bl = VideoCaptureCamera.this.isZoomSupported_l();
                    return bl;
                }
            });
            return bl;
        }
        return false;
    }

    private boolean isZoomSupported_l() {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            return parameters.isZoomSupported();
        }
        return false;
    }

    @Override
    public boolean isAutoFaceFocusSupported() {
        if (this.mPreviewHandler != null) {
            Boolean bl = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    boolean bl = VideoCaptureCamera.this.isAutoFaceFocusSupported_l();
                    return bl;
                }
            });
            return bl;
        }
        return false;
    }

    private boolean isAutoFaceFocusSupported_l() {
        Camera.Parameters parameters;
        return this.mCamera != null && (parameters = this.getCameraParameters()) != null && parameters.getMaxNumDetectedFaces() > 0 && parameters.getMaxNumFocusAreas() > 0 && VideoCaptureCamera.isSupported("auto", parameters.getSupportedFocusModes());
    }

    private boolean isFaceDetectedSupported() {
        Camera.Parameters parameters;
        return this.mCamera != null && (parameters = this.getCameraParameters()) != null && parameters.getMaxNumDetectedFaces() > 0;
    }

    @Override
    public void deallocate() {
        if (this.mPreviewHandler != null) {
            ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Runnable(){

                @Override
                public void run() {
                    VideoCaptureCamera.this.deallocate_l();
                }
            });
        }
        if (this.mPreviewHandler != null) {
            this.mPreviewHandler.removeCallbacksAndMessages(null);
        }
        if (this.mCameraPreviewHandlerThread != null) {
            this.mCameraPreviewHandlerThread.quit();
            this.mCameraPreviewHandlerThread = null;
            this.mPreviewHandler = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deallocate_l() {
        Object object = this.mRecoverThreadObjectLock;
        synchronized (object) {
            this.mNativeVideoCaptureDeviceAndroid = 0L;
            this.stopCapture();
            this.mCaptureLock.lock();
            if (this.mCamera != null) {
                this.mCamera.release();
                this.mCamera = null;
            }
            this.mCaptureLock.unlock();
            if (this.mHandler != null) {
                this.mHandler.removeCallbacksAndMessages(null);
            }
            if (this.mCameraRecoverHandlerThread != null) {
                this.mCameraRecoverHandlerThread.quit();
                this.mCameraRecoverHandlerThread = null;
                this.mHandler = null;
            }
        }
    }

    public void onPreviewFrame(byte[] byArray, Camera camera) {
        try {
            this.mPreviewBufferLock.lock();
            if (byArray == null || !this.isCaptureRunning) {
                return;
            }
            if (byArray.length == this.mExpectedRawBufferSize && this.mNativeVideoCaptureDeviceAndroid != 0L) {
                this.onRawBufferAvailable(byArray, this.mExpectedRawBufferSize, this.mCaptureWidth, this.mCaptureHeight, this.mCaptureFormat);
            } else if (this.mNativeVideoCaptureDeviceAndroid == 0L) {
                Logging.w(TAG, "warning mNativeVideoCaptureDeviceAndroid = 0, error");
            }
        }
        finally {
            if (camera != null && this.isCaptureRunning) {
                camera.addCallbackBuffer(byArray);
            }
            this.mPreviewBufferLock.unlock();
        }
    }

    @Override
    public void onTextureFrameAvailable(int n2, float[] fArray, long l2) {
        int n3 = this.getFrameOrientation();
        if (this.mIsCameraFacingFront) {
            fArray = RendererCommon.multiplyMatrices(fArray, RendererCommon.horizontalFlipMatrix());
        }
        VideoFrame.TextureBuffer textureBuffer = this.mSurfaceTextureHelper.createTextureBuffer(this.mCaptureWidth, this.mCaptureHeight, RendererCommon.convertMatrixToAndroidGraphicsMatrix(fArray));
        this.onTextureBufferAvailable(textureBuffer, n3, l2);
        textureBuffer.release();
    }

    private static boolean isSupported(String string, List<String> list) {
        return list == null ? false : list.indexOf(string) >= 0;
    }

    private void setAdvancedCameraParameters(Camera.Parameters parameters) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5 = "off";
        if (VideoCaptureCamera.isSupported(string5, parameters.getSupportedFlashModes())) {
            Logging.i(TAG, "AgoraVideo set flash mode = FLASH_MODE_OFF");
            parameters.setFlashMode(string5);
        }
        if (VideoCaptureCamera.isSupported(string4 = "auto", parameters.getSupportedWhiteBalance())) {
            Logging.i(TAG, "AgoraVideo set white blance = WHITE_BALANCE_AUTO");
            parameters.setWhiteBalance(string4);
        }
        if (VideoCaptureCamera.isSupported(string3 = "continuous-video", parameters.getSupportedFocusModes())) {
            Logging.i(TAG, "AgoraVideo set Focus mode = FOCUS_MODE_CONTINUOUS_VIDEO");
            parameters.setFocusMode(string3);
        }
        if (VideoCaptureCamera.isSupported(string2 = this.mAntiBandingMode, parameters.getSupportedAntibanding())) {
            Logging.i(TAG, "AgoraVideo set anti-banding = " + this.mAntiBandingMode);
            parameters.setAntibanding(string2);
        }
        if (VideoCaptureCamera.isSupported(string = "auto", parameters.getSupportedSceneModes())) {
            Logging.i(TAG, "AgoraVideo set sence mode = " + string);
            if (parameters.getSceneMode() != string) {
                parameters.setSceneMode(string);
            }
        }
    }

    private void setDeviceSpecificParameters(Camera.Parameters parameters) {
        String string = DeviceUtils.buildDeviceId();
        String string2 = DeviceUtils.getCpuName();
        String string3 = DeviceUtils.getCpuABI();
        int n2 = DeviceUtils.getNumberOfCPUCores();
        int n3 = DeviceUtils.getCPUMaxFreqKHz();
        Logging.i(TAG, "Current Device: " + string);
        Logging.i(TAG, "CPU name: " + string2 + ", with " + n2 + " cores, arch: " + string3 + ", max Freq: " + n3);
        if (string.contains("xiaomi/mi note")) {
            Logging.i(TAG, "set MiNote config");
            parameters.set("scene-detect", "on");
            parameters.set("xiaomi-still-beautify-values", "i:3");
            parameters.set("skinToneEnhancement", "enable");
            parameters.set("auto-exposure", "center-weighted");
        }
        if (string.contains("oppo/r7c/r7c")) {
            Logging.i(TAG, "set oppo r7c config");
            parameters.set("skinToneEnhancement", 1);
            parameters.set("face-beautify", 100);
            parameters.set("auto-exposure", "center-weighted");
        }
    }

    public Camera.Parameters getCameraParameters() {
        Camera.Parameters parameters;
        try {
            parameters = this.mCamera.getParameters();
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "getCameraParameters: Camera.getParameters: ", runtimeException);
            if (this.mCamera != null) {
                this.mCamera.release();
                this.mCamera = null;
            }
            return null;
        }
        return parameters;
    }

    public int createCapabilities() {
        String string = null;
        Camera.Parameters parameters = this.getCameraParameters();
        if (parameters != null) {
            String string2 = "\"id\":" + this.mId + ",";
            String string3 = "\"resolution\":";
            String string4 = "";
            List list = parameters.getSupportedPreviewSizes();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                int n2 = ((Camera.Size)list.get((int)i2)).width;
                int n3 = ((Camera.Size)list.get((int)i2)).height;
                if (n2 < 240 || n3 < 240 || n2 < 320 && n3 < 320) continue;
                String string5 = "{\"w\":" + n2 + ",\"h\":" + n3 + "}";
                string4 = !string4.isEmpty() ? string4 + "," + string5 : string5;
            }
            String string6 = "\"format\":";
            String string7 = "";
            List list2 = parameters.getSupportedPreviewFormats();
            boolean bl = false;
            if (Build.VERSION.SDK_INT >= 21 && Build.SUPPORTED_ABIS != null && Build.SUPPORTED_ABIS[0].startsWith("x86")) {
                bl = true;
            }
            if (VideoCapture.isEmulator() || bl && list2.size() > 1) {
                list2.remove((Object)842094169);
            }
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                int n4 = VideoCaptureCamera.translateToEngineFormat((Integer)list2.get(i3));
                string7 = i3 != list2.size() - 1 ? string7 + n4 + "," : string7 + n4;
            }
            String string8 = "\"fps\":";
            String string9 = "";
            List list3 = parameters.getSupportedPreviewFrameRates();
            for (int i4 = 0; i4 < list3.size(); ++i4) {
                int n5 = (Integer)list3.get(i4);
                string9 = i4 != list3.size() - 1 ? string9 + n5 + "," : string9 + n5;
            }
            string = "{" + string2 + string3 + "[" + string4 + "]," + string6 + "[" + string7 + "]," + string8 + "[" + string9 + "]}";
        }
        VideoCaptureCamera.cacheCapability(this.mId, this.mContext, string, VideoCaptureCamera.getCaptureName());
        return 0;
    }

    private List<Integer> getZoomRatios() {
        Camera.Parameters parameters;
        if (this.mCamera != null && this.isZoomSupported(parameters = this.getCameraParameters())) {
            return parameters.getZoomRatios();
        }
        return null;
    }

    private boolean isZoomSupported(Camera.Parameters parameters) {
        if (parameters != null) {
            boolean bl = parameters.isZoomSupported();
            if (bl) {
                return true;
            }
            Logging.w(TAG, "camera zoom is not supported ");
            return false;
        }
        return false;
    }

    private static Rect calculateTapArea(float f2, float f3, float f4) {
        float f5 = 300.0f;
        int n2 = Float.valueOf(f5 * f4).intValue();
        int n3 = (int)(f2 * 2000.0f - 1000.0f);
        int n4 = (int)(f3 * 2000.0f - 1000.0f);
        int n5 = n2 / 2;
        RectF rectF = new RectF((float)VideoCaptureCamera.clamp(n3 - n5, -1000, 1000), (float)VideoCaptureCamera.clamp(n4 - n5, -1000, 1000), (float)VideoCaptureCamera.clamp(n3 + n5, -1000, 1000), (float)VideoCaptureCamera.clamp(n4 + n5, -1000, 1000));
        return new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
    }

    private static int clamp(int n2, int n3, int n4) {
        return Math.max(n3, Math.min(n4, n2));
    }

    private boolean isForeground() {
        if (this.mContext != null) {
            ActivityManager activityManager = (ActivityManager)this.mContext.getSystemService("activity");
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                Logging.e(TAG, "List of RunningAppProcessInfo is null");
                return false;
            }
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)list.get(i2);
                if (runningAppProcessInfo == null) {
                    Logging.e(TAG, "ActivityManager.RunningAppProcessInfo is null");
                    continue;
                }
                if (!runningAppProcessInfo.processName.equals(this.mContext.getPackageName()) || runningAppProcessInfo.importance != 100) continue;
                return true;
            }
        }
        return false;
    }

    private int getFrameOrientation() {
        int n2 = this.checkOrientation();
        if (!this.mIsCameraFacingFront) {
            n2 = 360 - n2;
        }
        return (VideoCaptureCamera.getSensorOrientation(this.mId) + n2) % 360;
    }

    private String toCamera1ABMode(int n2) {
        switch (n2) {
            case 1: {
                return "50hz";
            }
            case 2: {
                return "60hz";
            }
            case 3: {
                return "auto";
            }
            case 0: {
                return "off";
            }
        }
        return "auto";
    }

    @Override
    public int setAntiBandingMode(int n2) {
        final int n3 = n2;
        if (this.mPreviewHandler != null) {
            Integer n4 = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    int n2 = VideoCaptureCamera.this.setAntiBandingMode_l(n3);
                    return n2;
                }
            });
            return n4;
        }
        return -1;
    }

    private int setAntiBandingMode_l(int n2) {
        this.mAntiBandingMode = this.toCamera1ABMode(n2);
        if (this.mCamera == null) {
            return -1;
        }
        Camera.Parameters parameters = this.mCamera.getParameters();
        if (parameters == null) {
            return -1;
        }
        String string = this.mAntiBandingMode;
        if (VideoCaptureCamera.isSupported(string, parameters.getSupportedAntibanding())) {
            Logging.i(TAG, "AgoraVideo set anti-banding = " + string);
            parameters.setAntibanding(string);
            try {
                this.mCamera.setParameters(parameters);
            }
            catch (Exception exception) {
                Logging.e(TAG, "anti banding got exception:" + exception);
            }
            return 0;
        }
        Logging.i(TAG, "not supported anti-banding = " + string);
        return -1;
    }

    @Override
    public int setExposureCompensation(int n2) {
        final int n3 = n2;
        if (this.mPreviewHandler != null) {
            Integer n4 = ThreadUtils.invokeAtFrontUninterruptibly(this.mPreviewHandler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    VideoCaptureCamera.this.setExposureCompensation_l(n3);
                    return 0;
                }
            });
            return n4;
        }
        return -1;
    }

    @Override
    public int setNoiseReductionMode(int n2) {
        Logging.e(TAG, "NoiseReduction not supported in camera1 ");
        return -1;
    }

    @Override
    public int setEdgeEnhanceMode(int n2) {
        Logging.e(TAG, "EdgeEnhancement not supported in camera1 ");
        return -1;
    }

    @Override
    public int setVideoStabilityMode(int n2) {
        Logging.e(TAG, "VideoStability not supported in camera1 ");
        return -1;
    }

    private void setExposureCompensation_l(int n2) {
        Camera.Parameters parameters;
        Logging.i(TAG, "setExposureCompensation:" + n2);
        if (this.mCamera != null && (parameters = this.mCamera.getParameters()) != null) {
            float f2 = parameters.getExposureCompensationStep();
            int n3 = parameters.getMinExposureCompensation();
            int n4 = parameters.getMaxExposureCompensation();
            int n5 = parameters.getExposureCompensation();
            Logging.i(TAG, "compensation step=" + f2 + ", min=" + n3 + ", max=" + n4 + ", cur index=" + n5);
            if (n2 > n4) {
                n2 = n4;
            }
            if (n2 < n3) {
                n2 = n3;
            }
            parameters.setExposureCompensation(n2);
            try {
                this.mCamera.setParameters(parameters);
            }
            catch (Exception exception) {
                Logging.e(TAG, "exposure compensation got exception:" + exception);
            }
            n5 = parameters.getExposureCompensation();
            float f3 = f2 * (float)n5;
            Logging.i(TAG, "cur index=" + n5 + ", ev=" + f3);
        }
    }
}

