/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.utils;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.media.Image;
import android.util.Log;
import io.agora.rtc.gl.JavaI420Buffer;
import io.agora.rtc.gl.VideoFrame;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

@TargetApi(value=21)
public class YuvUtils {
    private static final String TAG = YuvUtils.class.getSimpleName();
    public static final int I420 = 35;
    public static final int NV21 = 17;

    public static boolean supportedImageFormat(Image image) {
        int n2 = image.getFormat();
        switch (n2) {
            case 17: 
            case 35: 
            case 842094169: {
                return true;
            }
        }
        return false;
    }

    public static byte[] getImageData(Image image, int n2) {
        if (n2 != 35 && n2 != 17) {
            throw new IllegalArgumentException("only support COLOR_FormatI420 and COLOR_FormatNV21");
        }
        if (!YuvUtils.supportedImageFormat(image)) {
            throw new RuntimeException("can't convert Image to byte array, format " + image.getFormat());
        }
        Rect rect = image.getCropRect();
        int n3 = image.getFormat();
        int n4 = rect.width();
        int n5 = rect.height();
        Image.Plane[] planeArray = image.getPlanes();
        byte[] byArray = new byte[n4 * n5 * ImageFormat.getBitsPerPixel((int)n3) / 8];
        byte[] byArray2 = new byte[planeArray[0].getRowStride()];
        int n6 = 0;
        int n7 = 1;
        for (int i2 = 0; i2 < planeArray.length; ++i2) {
            switch (i2) {
                case 0: {
                    n6 = 0;
                    n7 = 1;
                    break;
                }
                case 1: {
                    if (n2 == 35) {
                        n6 = n4 * n5;
                        n7 = 1;
                        break;
                    }
                    if (n2 != 17) break;
                    n6 = n4 * n5 + 1;
                    n7 = 2;
                    break;
                }
                case 2: {
                    if (n2 == 35) {
                        n6 = (int)((double)(n4 * n5) * 1.25);
                        n7 = 1;
                        break;
                    }
                    if (n2 != 17) break;
                    n6 = n4 * n5;
                    n7 = 2;
                }
            }
            ByteBuffer byteBuffer = planeArray[i2].getBuffer();
            int n8 = planeArray[i2].getRowStride();
            int n9 = planeArray[i2].getPixelStride();
            int n10 = i2 == 0 ? 0 : 1;
            int n11 = n4 >> n10;
            int n12 = n5 >> n10;
            byteBuffer.position(n8 * (rect.top >> n10) + n9 * (rect.left >> n10));
            for (int i3 = 0; i3 < n12; ++i3) {
                int n13;
                if (n9 == 1 && n7 == 1) {
                    n13 = n11;
                    byteBuffer.get(byArray, n6, n13);
                    n6 += n13;
                } else {
                    n13 = (n11 - 1) * n9 + 1;
                    byteBuffer.get(byArray2, 0, n13);
                    for (int i4 = 0; i4 < n11; ++i4) {
                        byArray[n6] = byArray2[i4 * n9];
                        n6 += n7;
                    }
                }
                if (i3 >= n12 - 1) continue;
                byteBuffer.position(byteBuffer.position() + n8 - n13);
            }
        }
        return byArray;
    }

    public static boolean writeNV21ToFile(byte[] byArray, int n2, int n3, String string) {
        YuvImage yuvImage = new YuvImage(byArray, 17, n2, n3, null);
        Rect rect = new Rect(0, 0, n2, n3);
        try {
            File file = new File(string);
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            yuvImage.compressToJpeg(rect, 100, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)iOException.toString());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRawData(byte[] byArray, String string) {
        if (byArray == null || byArray.length == 0) {
            return;
        }
        try {
            File file = new File(string);
            file.createNewFile();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)iOException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write420ImageToFile(Image image, String string) {
        if (image == null) {
            return;
        }
        byte[] byArray = YuvUtils.yuv420toNV21(image);
        try {
            YuvImage yuvImage = new YuvImage(byArray, 17, image.getWidth(), image.getHeight(), null);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            yuvImage.compressToJpeg(new Rect(0, 0, image.getWidth(), image.getHeight()), 100, (OutputStream)byteArrayOutputStream);
            File file = new File(string);
            file.createNewFile();
            FileOutputStream fileOutputStream = null;
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byteArrayOutputStream.toByteArray());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)iOException.toString());
        }
    }

    public static byte[] yuv420toNV21(Image image) {
        Rect rect = image.getCropRect();
        int n2 = image.getFormat();
        int n3 = rect.width();
        int n4 = rect.height();
        Image.Plane[] planeArray = image.getPlanes();
        byte[] byArray = new byte[n3 * n4 * ImageFormat.getBitsPerPixel((int)n2) / 8];
        byte[] byArray2 = new byte[planeArray[0].getRowStride()];
        int n5 = 0;
        int n6 = 1;
        for (int i2 = 0; i2 < planeArray.length; ++i2) {
            switch (i2) {
                case 0: {
                    n5 = 0;
                    n6 = 1;
                    break;
                }
                case 1: {
                    n5 = n3 * n4 + 1;
                    n6 = 2;
                    break;
                }
                case 2: {
                    n5 = n3 * n4;
                    n6 = 2;
                }
            }
            ByteBuffer byteBuffer = planeArray[i2].getBuffer();
            int n7 = planeArray[i2].getRowStride();
            int n8 = planeArray[i2].getPixelStride();
            int n9 = i2 == 0 ? 0 : 1;
            int n10 = n3 >> n9;
            int n11 = n4 >> n9;
            byteBuffer.position(n7 * (rect.top >> n9) + n8 * (rect.left >> n9));
            for (int i3 = 0; i3 < n11; ++i3) {
                int n12;
                if (n8 == 1 && n6 == 1) {
                    n12 = n10;
                    byteBuffer.get(byArray, n5, n12);
                    n5 += n12;
                } else {
                    n12 = (n10 - 1) * n8 + 1;
                    byteBuffer.get(byArray2, 0, n12);
                    for (int i4 = 0; i4 < n10; ++i4) {
                        byArray[n5] = byArray2[i4 * n8];
                        n5 += n6;
                    }
                }
                if (i3 >= n11 - 1) continue;
                byteBuffer.position(byteBuffer.position() + n7 - n12);
            }
        }
        return byArray;
    }

    public static byte[] yuv420toNV21(byte[] byArray, int n2, int n3) {
        JavaI420Buffer javaI420Buffer = JavaI420Buffer.createYUV(byArray, n2, n3);
        byte[] byArray2 = YuvUtils.yuv420toNV21(javaI420Buffer, n2, n3);
        return byArray2;
    }

    public static byte[] yuv420toNV21(VideoFrame.I420Buffer i420Buffer, int n2, int n3) {
        Rect rect = new Rect(0, 0, n2, n3);
        int n4 = 35;
        Plane[] planeArray = new Plane[3];
        Plane plane = new Plane(i420Buffer.getDataY(), i420Buffer.getStrideY(), 1);
        Plane plane2 = new Plane(i420Buffer.getDataU(), i420Buffer.getStrideU(), 1);
        Plane plane3 = new Plane(i420Buffer.getDataV(), i420Buffer.getStrideV(), 1);
        planeArray[0] = plane;
        planeArray[1] = plane2;
        planeArray[2] = plane3;
        byte[] byArray = new byte[n2 * n3 * ImageFormat.getBitsPerPixel((int)n4) / 8];
        byte[] byArray2 = new byte[planeArray[0].getRowStride()];
        int n5 = 0;
        int n6 = 1;
        for (int i2 = 0; i2 < planeArray.length; ++i2) {
            switch (i2) {
                case 0: {
                    n5 = 0;
                    n6 = 1;
                    break;
                }
                case 1: {
                    n5 = n2 * n3 + 1;
                    n6 = 2;
                    break;
                }
                case 2: {
                    n5 = n2 * n3;
                    n6 = 2;
                }
            }
            ByteBuffer byteBuffer = planeArray[i2].getBuffer();
            int n7 = planeArray[i2].getRowStride();
            int n8 = planeArray[i2].getPixelStride();
            int n9 = i2 == 0 ? 0 : 1;
            int n10 = n2 >> n9;
            int n11 = n3 >> n9;
            byteBuffer.position(n7 * (rect.top >> n9) + n8 * (rect.left >> n9));
            for (int i3 = 0; i3 < n11; ++i3) {
                int n12;
                if (n8 == 1 && n6 == 1) {
                    n12 = n10;
                    byteBuffer.get(byArray, n5, n12);
                    n5 += n12;
                } else {
                    n12 = (n10 - 1) * n8 + 1;
                    byteBuffer.get(byArray2, 0, n12);
                    for (int i4 = 0; i4 < n10; ++i4) {
                        byArray[n5] = byArray2[i4 * n8];
                        n5 += n6;
                    }
                }
                if (i3 >= n11 - 1) continue;
                byteBuffer.position(byteBuffer.position() + n7 - n12);
            }
        }
        return byArray;
    }

    public static void writeRgbaToFile(Buffer buffer, int n2, int n3, String string) {
        try {
            File file = new File(string);
            file.createNewFile();
            FileOutputStream fileOutputStream = null;
            fileOutputStream = new FileOutputStream(file);
            Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer(buffer);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 50, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)iOException.toString());
        }
    }

    static class Plane {
        private ByteBuffer buffer;
        private int rowStride;
        private int pixelStride;

        public Plane(ByteBuffer byteBuffer, int n2, int n3) {
            this.buffer = byteBuffer;
            this.rowStride = n2;
            this.pixelStride = n3;
        }

        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        public int getRowStride() {
            return this.rowStride;
        }

        public int getPixelStride() {
            return this.pixelStride;
        }
    }
}

