/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

import android.content.Context;
import android.view.SurfaceView;
import android.view.TextureView;
import io.agora.rtc.IAudioEffectManager;
import io.agora.rtc.IAudioFrameObserver;
import io.agora.rtc.ILogWriter;
import io.agora.rtc.IMetadataObserver;
import io.agora.rtc.IRtcEngineEventHandler;
import io.agora.rtc.IVideoEncodedFrameObserver;
import io.agora.rtc.IVideoFrameObserver;
import io.agora.rtc.RtcChannel;
import io.agora.rtc.RtcEngineConfig;
import io.agora.rtc.audio.AudioRecordingConfiguration;
import io.agora.rtc.internal.DeviceUtils;
import io.agora.rtc.internal.EncryptionConfig;
import io.agora.rtc.internal.LastmileProbeConfig;
import io.agora.rtc.internal.RtcEngineImpl;
import io.agora.rtc.live.LiveInjectStreamConfig;
import io.agora.rtc.live.LiveTranscoding;
import io.agora.rtc.mediaio.IVideoSink;
import io.agora.rtc.mediaio.IVideoSource;
import io.agora.rtc.models.ChannelMediaOptions;
import io.agora.rtc.models.ClientRoleOptions;
import io.agora.rtc.models.DataStreamConfig;
import io.agora.rtc.models.UserInfo;
import io.agora.rtc.video.AgoraImage;
import io.agora.rtc.video.AgoraVideoFrame;
import io.agora.rtc.video.BeautyOptions;
import io.agora.rtc.video.CameraCapturerConfiguration;
import io.agora.rtc.video.ChannelMediaRelayConfiguration;
import io.agora.rtc.video.GLTextureView;
import io.agora.rtc.video.ViEAndroidGLES20;
import io.agora.rtc.video.ViETextureView;
import io.agora.rtc.video.VideoCanvas;
import io.agora.rtc.video.VideoEncoderConfiguration;
import io.agora.rtc.video.VirtualBackgroundSource;
import io.agora.rtc.video.WatermarkOptions;
import java.util.ArrayList;

public abstract class RtcEngine {
    private static RtcEngineImpl mInstance = null;

    public static synchronized RtcEngine create(Context context, String string, IRtcEngineEventHandler iRtcEngineEventHandler) throws Exception {
        if (context == null || !RtcEngineImpl.initializeNativeLibs()) {
            return null;
        }
        if (mInstance == null) {
            mInstance = new RtcEngineImpl(context, string, iRtcEngineEventHandler);
        } else {
            mInstance.reinitialize(context, string, iRtcEngineEventHandler);
        }
        return mInstance;
    }

    public static synchronized RtcEngine create(RtcEngineConfig rtcEngineConfig) throws Exception {
        if (rtcEngineConfig == null || rtcEngineConfig.mContext == null || !RtcEngineImpl.initializeNativeLibs()) {
            return null;
        }
        if (mInstance == null) {
            mInstance = new RtcEngineImpl(rtcEngineConfig);
        } else {
            mInstance.reinitialize(rtcEngineConfig.mContext, rtcEngineConfig.mAppId, rtcEngineConfig.mEventHandler);
        }
        return mInstance;
    }

    public static synchronized void destroy() {
        if (mInstance == null) {
            return;
        }
        mInstance.doDestroy();
        mInstance = null;
        System.gc();
    }

    public abstract int setChannelProfile(int var1);

    public abstract int setClientRole(int var1);

    public abstract int setClientRole(int var1, ClientRoleOptions var2);

    public abstract int sendCustomReportMessage(String var1, String var2, String var3, String var4, int var5);

    public abstract int joinChannel(String var1, String var2, String var3, int var4);

    public abstract int joinChannel(String var1, String var2, String var3, int var4, ChannelMediaOptions var5);

    public abstract int switchChannel(String var1, String var2);

    public abstract int switchChannel(String var1, String var2, ChannelMediaOptions var3);

    public abstract int leaveChannel();

    public abstract int renewToken(String var1);

    public abstract int registerLocalUserAccount(String var1, String var2);

    public abstract int joinChannelWithUserAccount(String var1, String var2, String var3);

    public abstract int joinChannelWithUserAccount(String var1, String var2, String var3, ChannelMediaOptions var4);

    public abstract int setCloudProxy(int var1);

    public abstract int getUserInfoByUserAccount(String var1, UserInfo var2);

    public abstract int getUserInfoByUid(int var1, UserInfo var2);

    @Deprecated
    public abstract int enableWebSdkInteroperability(boolean var1);

    public abstract int getConnectionState();

    public abstract int enableRemoteSuperResolution(int var1, boolean var2);

    public abstract int enableAudio();

    public abstract int disableAudio();

    @Deprecated
    public abstract int pauseAudio();

    @Deprecated
    public abstract int resumeAudio();

    public abstract int setAudioProfile(int var1, int var2);

    @Deprecated
    public abstract int setHighQualityAudioParameters(boolean var1, boolean var2, boolean var3);

    public abstract int adjustRecordingSignalVolume(int var1);

    public abstract int adjustPlaybackSignalVolume(int var1);

    public abstract int enableAudioVolumeIndication(int var1, int var2, boolean var3);

    @Deprecated
    public abstract int enableAudioQualityIndication(boolean var1);

    public abstract int enableLocalAudio(boolean var1);

    public abstract int muteLocalAudioStream(boolean var1);

    public abstract int muteRemoteAudioStream(int var1, boolean var2);

    public abstract int adjustUserPlaybackSignalVolume(int var1, int var2);

    public abstract int muteAllRemoteAudioStreams(boolean var1);

    public abstract int setDefaultMuteAllRemoteAudioStreams(boolean var1);

    public abstract int enableVideo();

    public abstract int disableVideo();

    @Deprecated
    public abstract int setVideoProfile(int var1, boolean var2);

    @Deprecated
    public abstract int setVideoProfile(int var1, int var2, int var3, int var4);

    public abstract int setVideoEncoderConfiguration(VideoEncoderConfiguration var1);

    public abstract int setCameraCapturerConfiguration(CameraCapturerConfiguration var1);

    public abstract int setupLocalVideo(VideoCanvas var1);

    public abstract int setupRemoteVideo(VideoCanvas var1);

    @Deprecated
    public abstract int setLocalRenderMode(int var1);

    public abstract int setLocalRenderMode(int var1, int var2);

    @Deprecated
    public abstract int setRemoteRenderMode(int var1, int var2);

    public abstract int setRemoteRenderMode(int var1, int var2, int var3);

    public static SurfaceView CreateRendererView(Context context) {
        if (context == null || !RtcEngineImpl.initializeNativeLibs()) {
            return null;
        }
        RtcEngineImpl.checkIfInUIThread("CreateRendererView");
        ViEAndroidGLES20 viEAndroidGLES20 = ViEAndroidGLES20.IsSupported(context) ? new ViEAndroidGLES20(context) : new SurfaceView(context);
        viEAndroidGLES20.setVisibility(0);
        return viEAndroidGLES20;
    }

    public static TextureView CreateTextureView(Context context) {
        if (context == null || !RtcEngineImpl.initializeNativeLibs()) {
            return null;
        }
        RtcEngineImpl.checkIfInUIThread("CreateTextureView");
        GLTextureView gLTextureView = ViETextureView.IsSupported(context) ? new ViETextureView(context) : new GLTextureView(context);
        gLTextureView.setVisibility(0);
        return gLTextureView;
    }

    public abstract int startPreview();

    public abstract int stopPreview();

    public abstract int enableLocalVideo(boolean var1);

    public abstract int muteLocalVideoStream(boolean var1);

    public abstract int muteRemoteVideoStream(int var1, boolean var2);

    public abstract int muteAllRemoteVideoStreams(boolean var1);

    public abstract int setDefaultMuteAllRemoteVideoStreams(boolean var1);

    public abstract int setBeautyEffectOptions(boolean var1, BeautyOptions var2);

    public abstract int enableVirtualBackground(boolean var1, VirtualBackgroundSource var2);

    public abstract int setDefaultAudioRoutetoSpeakerphone(boolean var1);

    public abstract int setEnableSpeakerphone(boolean var1);

    public abstract boolean isSpeakerphoneEnabled();

    public abstract int enableInEarMonitoring(boolean var1);

    public abstract int setInEarMonitoringVolume(int var1);

    @Deprecated
    public abstract int useExternalAudioDevice();

    public abstract int setLocalVoicePitch(double var1);

    public abstract int setLocalVoiceEqualization(int var1, int var2);

    public abstract int setLocalVoiceReverb(int var1, int var2);

    @Deprecated
    public abstract int setLocalVoiceChanger(int var1);

    @Deprecated
    public abstract int setLocalVoiceReverbPreset(int var1);

    public abstract int setAudioEffectPreset(int var1);

    public abstract int setVoiceBeautifierPreset(int var1);

    public abstract int setVoiceConversionPreset(int var1);

    public abstract int setAudioEffectParameters(int var1, int var2, int var3);

    public abstract int setVoiceBeautifierParameters(int var1, int var2, int var3);

    public abstract int enableDeepLearningDenoise(boolean var1);

    public abstract int enableSoundPositionIndication(boolean var1);

    public abstract int setRemoteVoicePosition(int var1, double var2, double var4);

    @Deprecated
    public abstract int startAudioMixing(String var1, boolean var2, boolean var3, int var4);

    public abstract int startAudioMixing(String var1, boolean var2, boolean var3, int var4, int var5);

    public abstract int stopAudioMixing();

    public abstract int pauseAudioMixing();

    public abstract int resumeAudioMixing();

    public abstract int adjustAudioMixingVolume(int var1);

    public abstract int adjustAudioMixingPlayoutVolume(int var1);

    public abstract int adjustAudioMixingPublishVolume(int var1);

    public abstract int getAudioMixingPlayoutVolume();

    public abstract int getAudioMixingPublishVolume();

    @Deprecated
    public abstract int getAudioMixingDuration();

    public abstract int getAudioMixingDuration(String var1);

    public abstract int getAudioMixingCurrentPosition();

    public abstract int setAudioMixingPosition(int var1);

    public abstract int setAudioMixingPitch(int var1);

    public abstract IAudioEffectManager getAudioEffectManager();

    @Deprecated
    public abstract int startAudioRecording(String var1, int var2);

    @Deprecated
    public abstract int startAudioRecording(String var1, int var2, int var3);

    public abstract int startAudioRecording(AudioRecordingConfiguration var1);

    public abstract int stopAudioRecording();

    @Deprecated
    public abstract int startEchoTest();

    public abstract int startEchoTest(int var1);

    public abstract int stopEchoTest();

    public abstract int enableLastmileTest();

    public abstract int disableLastmileTest();

    public abstract int startLastmileProbeTest(LastmileProbeConfig var1);

    public abstract int stopLastmileProbeTest();

    public abstract int setVideoSource(IVideoSource var1);

    public abstract int setLocalVideoRenderer(IVideoSink var1);

    public abstract int setRemoteVideoRenderer(int var1, IVideoSink var2);

    public abstract int setExternalAudioSink(boolean var1, int var2, int var3);

    public abstract int pullPlaybackAudioFrame(byte[] var1, int var2);

    public abstract int setExternalAudioSource(boolean var1, int var2, int var3);

    public abstract int pushExternalAudioFrame(byte[] var1, long var2);

    public abstract void setExternalVideoSource(boolean var1, boolean var2, boolean var3);

    public abstract boolean pushExternalVideoFrame(AgoraVideoFrame var1);

    public abstract boolean isTextureEncodeSupported();

    public abstract int registerAudioFrameObserver(IAudioFrameObserver var1);

    public abstract int registerVideoEncodedFrameObserver(IVideoEncodedFrameObserver var1);

    public abstract int registerVideoFrameObserver(IVideoFrameObserver var1);

    public abstract int setRecordingAudioFrameParameters(int var1, int var2, int var3, int var4);

    public abstract int setPlaybackAudioFrameParameters(int var1, int var2, int var3, int var4);

    public abstract int setMixedAudioFrameParameters(int var1, int var2);

    @Deprecated
    public abstract int addVideoWatermark(AgoraImage var1);

    public abstract int addVideoWatermark(String var1, WatermarkOptions var2);

    public abstract int clearVideoWatermarks();

    public abstract int setRemoteUserPriority(int var1, int var2);

    public abstract int setLocalPublishFallbackOption(int var1);

    public abstract int setRemoteSubscribeFallbackOption(int var1);

    public abstract int enableDualStreamMode(boolean var1);

    public abstract int setRemoteVideoStreamType(int var1, int var2);

    public abstract int setRemoteDefaultVideoStreamType(int var1);

    @Deprecated
    public abstract int setEncryptionSecret(String var1);

    @Deprecated
    public abstract int setEncryptionMode(String var1);

    public abstract int enableEncryption(boolean var1, EncryptionConfig var2);

    public abstract int addInjectStreamUrl(String var1, LiveInjectStreamConfig var2);

    public abstract int removeInjectStreamUrl(String var1);

    public abstract int addPublishStreamUrl(String var1, boolean var2);

    public abstract int removePublishStreamUrl(String var1);

    public abstract int setLiveTranscoding(LiveTranscoding var1);

    public abstract int createDataStream(boolean var1, boolean var2);

    public abstract int createDataStream(DataStreamConfig var1);

    public abstract int sendStreamMessage(int var1, byte[] var2);

    @Deprecated
    public abstract int setVideoQualityParameters(boolean var1);

    @Deprecated
    public abstract int setLocalVideoMirrorMode(int var1);

    @Deprecated
    public static int getRecommendedEncoderType() {
        return DeviceUtils.getRecommendedEncoderType();
    }

    public abstract int switchCamera();

    public abstract boolean isCameraZoomSupported();

    public abstract boolean isCameraTorchSupported();

    public abstract boolean isCameraFocusSupported();

    public abstract boolean isCameraExposurePositionSupported();

    public abstract boolean isCameraAutoFocusFaceModeSupported();

    public abstract int setCameraZoomFactor(float var1);

    public abstract float getCameraMaxZoomFactor();

    public abstract int setCameraFocusPositionInPreview(float var1, float var2);

    public abstract int setCameraExposurePosition(float var1, float var2);

    public abstract int enableFaceDetection(boolean var1);

    public abstract int setCameraTorchOn(boolean var1);

    public abstract int setCameraAutoFocusFaceModeEnabled(boolean var1);

    public abstract String getCallId();

    public abstract int rate(String var1, int var2, String var3);

    public abstract int complain(String var1, String var2);

    public static String getSdkVersion() {
        if (!RtcEngineImpl.initializeNativeLibs()) {
            return "";
        }
        return RtcEngineImpl.nativeGetSdkVersion();
    }

    @Deprecated
    public static String getMediaEngineVersion() {
        if (!RtcEngineImpl.initializeNativeLibs()) {
            return "";
        }
        return RtcEngineImpl.nativeGetChatEngineVersion();
    }

    public abstract int setLogFile(String var1);

    public abstract int setLogFilter(int var1);

    public abstract int setLogFileSize(int var1);

    public abstract String uploadLogFile();

    public abstract long getNativeHandle();

    public void addHandler(IRtcEngineEventHandler iRtcEngineEventHandler) {
        mInstance.addHandler(iRtcEngineEventHandler);
    }

    public void removeHandler(IRtcEngineEventHandler iRtcEngineEventHandler) {
        mInstance.removeHandler(iRtcEngineEventHandler);
    }

    @Deprecated
    public abstract boolean enableHighPerfWifiMode(boolean var1);

    public static String getErrorDescription(int n2) {
        if (!RtcEngineImpl.initializeNativeLibs()) {
            return "";
        }
        return RtcEngineImpl.nativeGetErrorDescription(n2);
    }

    @Deprecated
    public abstract void monitorHeadsetEvent(boolean var1);

    @Deprecated
    public abstract void monitorBluetoothHeadsetEvent(boolean var1);

    @Deprecated
    public abstract void setPreferHeadset(boolean var1);

    public abstract int setParameters(String var1);

    public abstract String getParameter(String var1, String var2);

    public abstract int registerMediaMetadataObserver(IMetadataObserver var1, int var2);

    public abstract int setLogWriter(ILogWriter var1);

    public abstract int releaseLogWriter();

    public abstract int startChannelMediaRelay(ChannelMediaRelayConfiguration var1);

    public abstract int stopChannelMediaRelay();

    public abstract int updateChannelMediaRelay(ChannelMediaRelayConfiguration var1);

    public abstract int startDumpVideoReceiveTrack(int var1, String var2);

    public abstract int stopDumpVideoReceiveTrack();

    public abstract RtcChannel createRtcChannel(String var1);

    public abstract int setLocalAccessPoint(ArrayList<String> var1, String var2);
}

