/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.audio;

import android.content.Context;
import android.os.Build;
import io.agora.rtc.audio.HuaweiHardwareEarback;
import io.agora.rtc.audio.IHardwareEarback;
import io.agora.rtc.audio.OppoHardwareEarback;

public class HardwareEarbackController {
    private final String TAG = "HardwareEarbackController Java";
    private IHardwareEarback mHardwareEarback = null;
    private static HardwareEarbackController mInstance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HardwareEarbackController getInstance(Context context) {
        if (mInstance != null) return mInstance;
        Class<HardwareEarbackController> clazz = HardwareEarbackController.class;
        synchronized (HardwareEarbackController.class) {
            if (mInstance != null) return mInstance;
            mInstance = new HardwareEarbackController(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private HardwareEarbackController(Context context) {
        String string = Build.MANUFACTURER;
        if (!string.trim().contains("vivo")) {
            if (string.trim().contains("HUAWEI") && HuaweiHardwareEarback.hasHwAudioKitClass()) {
                this.mHardwareEarback = new HuaweiHardwareEarback(context);
            } else if (string.trim().contains("OPPO") && OppoHardwareEarback.hasMediaUnitClass()) {
                this.mHardwareEarback = new OppoHardwareEarback(context);
            }
        }
    }

    public boolean isHardwareEarbackSupported() {
        return this.mHardwareEarback != null ? this.mHardwareEarback.isHardwareEarbackSupported() : false;
    }

    public int enableHardwareEarback(boolean bl) {
        if (null != this.mHardwareEarback) {
            return this.mHardwareEarback.enableEarbackFeature(bl);
        }
        return -7;
    }

    public int setHardwareEarbackVolume(int n2) {
        if (null != this.mHardwareEarback) {
            return this.mHardwareEarback.setHardwareEarbackVolume(n2);
        }
        return -7;
    }
}

