/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.media.MediaFormat;
import android.os.Build;
import android.text.TextUtils;
import io.agora.rtc.internal.Logging;
import java.util.Iterator;
import org.json.JSONObject;

public class MediaCodecBase {
    private static final String TAG = MediaCodecBase.class.getSimpleName();

    protected void applyCustomConfig(MediaFormat mediaFormat, String string) {
        if (mediaFormat == null || TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        Logging.i(TAG, "applying custom config: " + string);
        try {
            JSONObject jSONObject = new JSONObject(string);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Object object = jSONObject.get(string2);
                if (object instanceof String) {
                    mediaFormat.setString(string2, (String)object);
                    continue;
                }
                if (object instanceof Integer) {
                    mediaFormat.setInteger(string2, ((Integer)object).intValue());
                    continue;
                }
                if (object instanceof JSONObject) {
                    JSONObject jSONObject2 = (JSONObject)object;
                    String string3 = (String)jSONObject2.keys().next();
                    if ("setInteger".equals(string2)) {
                        mediaFormat.setInteger(string3, jSONObject2.getInt(string3));
                        continue;
                    }
                    if ("setLong".equals(string2)) {
                        mediaFormat.setLong(string3, jSONObject2.getLong(string3));
                        continue;
                    }
                    if ("setFloat".equals(string2)) {
                        mediaFormat.setFloat(string3, (float)jSONObject2.getDouble(string3));
                        continue;
                    }
                    if ("setString".equals(string2)) {
                        mediaFormat.setString(string3, jSONObject2.getString(string3));
                        continue;
                    }
                    if (!"setFeatureEnabled".equals(string2)) continue;
                    if (Build.VERSION.SDK_INT >= 21) {
                        mediaFormat.setFeatureEnabled(string3, jSONObject2.getBoolean(string3));
                        continue;
                    }
                    Logging.e(TAG, "setFeatureEnabled requires api level 21");
                    continue;
                }
                Logging.e(TAG, "unsupported config value type " + object.getClass());
            }
        }
        catch (Exception exception) {
            Logging.e(TAG, "abort applying custom config: " + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

