/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.simplelist;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.afollestad.materialdialogs.util.DialogUtils;

public class MaterialSimpleListItem {
    private final Builder builder;

    private MaterialSimpleListItem(Builder builder) {
        this.builder = builder;
    }

    public Drawable getIcon() {
        return this.builder.icon;
    }

    public CharSequence getContent() {
        return this.builder.content;
    }

    public int getIconPadding() {
        return this.builder.iconPadding;
    }

    @ColorInt
    public int getBackgroundColor() {
        return this.builder.backgroundColor;
    }

    public long getId() {
        return this.builder.id;
    }

    @Nullable
    public Object getTag() {
        return this.builder.tag;
    }

    public String toString() {
        if (this.getContent() != null) {
            return this.getContent().toString();
        }
        return "(no content)";
    }

    public static class Builder {
        private final Context context;
        protected Drawable icon;
        protected CharSequence content;
        protected long id;
        int iconPadding;
        int backgroundColor;
        Object tag;

        public Builder(Context context) {
            this.context = context;
            this.backgroundColor = Color.parseColor((String)"#BCBCBC");
        }

        public Builder icon(Drawable icon) {
            this.icon = icon;
            return this;
        }

        public Builder icon(@DrawableRes int iconRes) {
            return this.icon(ContextCompat.getDrawable((Context)this.context, (int)iconRes));
        }

        public Builder iconPadding(@IntRange(from=0L, to=0x7FFFFFFFL) int padding) {
            this.iconPadding = padding;
            return this;
        }

        public Builder iconPaddingDp(@IntRange(from=0L, to=0x7FFFFFFFL) int paddingDp) {
            this.iconPadding = (int)TypedValue.applyDimension((int)1, (float)paddingDp, (DisplayMetrics)this.context.getResources().getDisplayMetrics());
            return this;
        }

        public Builder iconPaddingRes(@DimenRes int paddingRes) {
            return this.iconPadding(this.context.getResources().getDimensionPixelSize(paddingRes));
        }

        public Builder content(CharSequence content) {
            this.content = content;
            return this;
        }

        public Builder content(@StringRes int contentRes) {
            return this.content(this.context.getString(contentRes));
        }

        public Builder backgroundColor(@ColorInt int color) {
            this.backgroundColor = color;
            return this;
        }

        public Builder backgroundColorRes(@ColorRes int colorRes) {
            return this.backgroundColor(DialogUtils.getColor((Context)this.context, (int)colorRes));
        }

        public Builder backgroundColorAttr(@AttrRes int colorAttr) {
            return this.backgroundColor(DialogUtils.resolveColor((Context)this.context, (int)colorAttr));
        }

        public Builder id(long id2) {
            this.id = id2;
            return this;
        }

        public Builder tag(@Nullable Object tag) {
            this.tag = tag;
            return this;
        }

        public MaterialSimpleListItem build() {
            return new MaterialSimpleListItem(this);
        }
    }
}

