/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.prefs;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.EditTextPreference;
import android.preference.Preference;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.v7.widget.AppCompatEditText;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.commons.R;
import com.afollestad.materialdialogs.internal.MDTintHelper;
import com.afollestad.materialdialogs.prefs.PrefUtil;
import com.afollestad.materialdialogs.util.DialogUtils;

public class MaterialEditTextPreference
extends EditTextPreference {
    private int color = 0;
    private MaterialDialog dialog;
    private EditText editText;

    public MaterialEditTextPreference(Context context) {
        super(context);
        this.init(context, null);
    }

    public MaterialEditTextPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public MaterialEditTextPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public MaterialEditTextPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        PrefUtil.setLayoutResource(context, (Preference)this, attrs);
        int fallback = Build.VERSION.SDK_INT >= 21 ? DialogUtils.resolveColor((Context)context, (int)16843829) : 0;
        fallback = DialogUtils.resolveColor((Context)context, (int)R.attr.colorAccent, (int)fallback);
        this.color = DialogUtils.resolveColor((Context)context, (int)R.attr.md_widget_color, (int)fallback);
        this.editText = new AppCompatEditText(context, attrs);
        this.editText.setId(16908291);
        this.editText.setEnabled(true);
    }

    protected void onAddEditTextToDialogView(@NonNull View dialogView, @NonNull EditText editText) {
        ((ViewGroup)dialogView).addView((View)editText, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
    }

    @SuppressLint(value={"MissingSuperCall"})
    protected void onBindDialogView(@NonNull View view) {
        ViewParent oldParent;
        EditText editText = this.editText;
        editText.setText((CharSequence)this.getText());
        if (editText.getText().length() > 0) {
            editText.setSelection(editText.length());
        }
        if ((oldParent = editText.getParent()) != view) {
            if (oldParent != null) {
                ((ViewGroup)oldParent).removeView((View)editText);
            }
            this.onAddEditTextToDialogView(view, editText);
        }
    }

    protected void onDialogClosed(boolean positiveResult) {
        String value;
        if (positiveResult && this.callChangeListener(value = this.editText.getText().toString())) {
            this.setText(value);
        }
    }

    public EditText getEditText() {
        return this.editText;
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    protected void showDialog(Bundle state) {
        MaterialDialog.Builder mBuilder = new MaterialDialog.Builder(this.getContext()).title(this.getDialogTitle()).icon(this.getDialogIcon()).positiveText(this.getPositiveButtonText()).negativeText(this.getNegativeButtonText()).dismissListener((DialogInterface.OnDismissListener)this).onAny(new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                switch (which) {
                    default: {
                        MaterialEditTextPreference.this.onClick((DialogInterface)dialog, -1);
                        break;
                    }
                    case NEUTRAL: {
                        MaterialEditTextPreference.this.onClick((DialogInterface)dialog, -3);
                        break;
                    }
                    case NEGATIVE: {
                        MaterialEditTextPreference.this.onClick((DialogInterface)dialog, -2);
                    }
                }
            }
        }).dismissListener((DialogInterface.OnDismissListener)this);
        View layout2 = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.md_stub_inputpref, null);
        this.onBindDialogView(layout2);
        MDTintHelper.setTint((EditText)this.editText, (int)this.color);
        TextView message = (TextView)layout2.findViewById(16908299);
        if (this.getDialogMessage() != null && this.getDialogMessage().toString().length() > 0) {
            message.setVisibility(0);
            message.setText(this.getDialogMessage());
        } else {
            message.setVisibility(8);
        }
        mBuilder.customView(layout2, false);
        PrefUtil.registerOnActivityDestroyListener((Preference)this, (PreferenceManager.OnActivityDestroyListener)this);
        this.dialog = mBuilder.build();
        if (state != null) {
            this.dialog.onRestoreInstanceState(state);
        }
        this.requestInputMethod((Dialog)this.dialog);
        this.dialog.show();
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        PrefUtil.unregisterOnActivityDestroyListener((Preference)this, (PreferenceManager.OnActivityDestroyListener)this);
    }

    private void requestInputMethod(Dialog dialog) {
        Window window = dialog.getWindow();
        if (window == null) {
            return;
        }
        window.setSoftInputMode(5);
    }

    public void onActivityDestroy() {
        super.onActivityDestroy();
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.dismiss();
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Dialog dialog = this.getDialog();
        if (dialog == null || !dialog.isShowing()) {
            return superState;
        }
        SavedState myState = new SavedState(superState);
        myState.isDialogShowing = true;
        myState.dialogBundle = dialog.onSaveInstanceState();
        return myState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state == null || !state.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState myState = (SavedState)state;
        super.onRestoreInstanceState(myState.getSuperState());
        if (myState.isDialogShowing) {
            this.showDialog(myState.dialogBundle);
        }
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        boolean isDialogShowing;
        Bundle dialogBundle;

        SavedState(Parcel source) {
            super(source);
            this.isDialogShowing = source.readInt() == 1;
            this.dialogBundle = source.readBundle();
        }

        SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.isDialogShowing ? 1 : 0);
            dest.writeBundle(this.dialogBundle);
        }
    }
}

