/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.prefs;

import android.annotation.TargetApi;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.DialogPreference;
import android.preference.Preference;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.prefs.PrefUtil;

public class MaterialDialogPreference
extends DialogPreference {
    private Context context;
    private MaterialDialog dialog;

    @TargetApi(value=21)
    public MaterialDialogPreference(Context context) {
        super(context);
        this.init(context, null);
    }

    public MaterialDialogPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MaterialDialogPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public MaterialDialogPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.context = context;
        PrefUtil.setLayoutResource(context, (Preference)this, attrs);
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    protected void showDialog(Bundle state) {
        MaterialDialog.Builder builder = new MaterialDialog.Builder(this.context).title(this.getDialogTitle()).icon(this.getDialogIcon()).dismissListener((DialogInterface.OnDismissListener)this).onAny(new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                switch (which) {
                    default: {
                        MaterialDialogPreference.this.onClick((DialogInterface)dialog, -1);
                        break;
                    }
                    case NEUTRAL: {
                        MaterialDialogPreference.this.onClick((DialogInterface)dialog, -3);
                        break;
                    }
                    case NEGATIVE: {
                        MaterialDialogPreference.this.onClick((DialogInterface)dialog, -2);
                    }
                }
            }
        }).positiveText(this.getPositiveButtonText()).negativeText(this.getNegativeButtonText()).autoDismiss(true);
        View contentView = this.onCreateDialogView();
        if (contentView != null) {
            this.onBindDialogView(contentView);
            builder.customView(contentView, false);
        } else {
            builder.content(this.getDialogMessage());
        }
        PrefUtil.registerOnActivityDestroyListener((Preference)this, (PreferenceManager.OnActivityDestroyListener)this);
        this.dialog = builder.build();
        if (state != null) {
            this.dialog.onRestoreInstanceState(state);
        }
        this.dialog.show();
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        PrefUtil.unregisterOnActivityDestroyListener((Preference)this, (PreferenceManager.OnActivityDestroyListener)this);
    }

    public void onActivityDestroy() {
        super.onActivityDestroy();
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.dismiss();
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Dialog dialog = this.getDialog();
        if (dialog == null || !dialog.isShowing()) {
            return superState;
        }
        SavedState myState = new SavedState(superState);
        myState.isDialogShowing = true;
        myState.dialogBundle = dialog.onSaveInstanceState();
        return myState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state == null || !state.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState myState = (SavedState)state;
        super.onRestoreInstanceState(myState.getSuperState());
        if (myState.isDialogShowing) {
            this.showDialog(myState.dialogBundle);
        }
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        boolean isDialogShowing;
        Bundle dialogBundle;

        SavedState(Parcel source) {
            super(source);
            this.isDialogShowing = source.readInt() == 1;
            this.dialogBundle = source.readBundle();
        }

        SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.isDialogShowing ? 1 : 0);
            dest.writeBundle(this.dialogBundle);
        }
    }
}

