/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.color;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.ArrayRes;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.content.res.ResourcesCompat;
import android.support.v7.app.AppCompatActivity;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.SeekBar;
import android.widget.TextView;
import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.color.CircleView;
import com.afollestad.materialdialogs.color.ColorPalette;
import com.afollestad.materialdialogs.commons.R;
import com.afollestad.materialdialogs.internal.MDTintHelper;
import com.afollestad.materialdialogs.util.DialogUtils;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ColorChooserDialog
extends DialogFragment
implements View.OnClickListener,
View.OnLongClickListener {
    public static final String TAG_PRIMARY = "[MD_COLOR_CHOOSER]";
    public static final String TAG_ACCENT = "[MD_COLOR_CHOOSER]";
    public static final String TAG_CUSTOM = "[MD_COLOR_CHOOSER]";
    @NonNull
    private int[] mColorsTop;
    @Nullable
    private int[][] mColorsSub;
    private int mCircleSize;
    private ColorCallback mCallback;
    private GridView mGrid;
    private View mColorChooserCustomFrame;
    private EditText mCustomColorHex;
    private View mCustomColorIndicator;
    private TextWatcher mCustomColorTextWatcher;
    private SeekBar mCustomSeekA;
    private TextView mCustomSeekAValue;
    private SeekBar mCustomSeekR;
    private TextView mCustomSeekRValue;
    private SeekBar mCustomSeekG;
    private TextView mCustomSeekGValue;
    private SeekBar mCustomSeekB;
    private TextView mCustomSeekBValue;
    private SeekBar.OnSeekBarChangeListener mCustomColorRgbListener;
    private int mSelectedCustomColor;

    private void generateColors() {
        Builder builder = this.getBuilder();
        if (builder.mColorsTop != null) {
            this.mColorsTop = builder.mColorsTop;
            this.mColorsSub = builder.mColorsSub;
            return;
        }
        if (builder.mAccentMode) {
            this.mColorsTop = ColorPalette.ACCENT_COLORS;
            this.mColorsSub = ColorPalette.ACCENT_COLORS_SUB;
        } else {
            this.mColorsTop = ColorPalette.PRIMARY_COLORS;
            this.mColorsSub = ColorPalette.PRIMARY_COLORS_SUB;
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("top_index", this.topIndex());
        outState.putBoolean("in_sub", this.isInSub());
        outState.putInt("sub_index", this.subIndex());
        outState.putBoolean("in_custom", this.mColorChooserCustomFrame != null && this.mColorChooserCustomFrame.getVisibility() == 0);
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (!(activity instanceof ColorCallback)) {
            throw new IllegalStateException("ColorChooserDialog needs to be shown from an Activity implementing ColorCallback.");
        }
        this.mCallback = (ColorCallback)activity;
    }

    private boolean isInSub() {
        return this.getArguments().getBoolean("in_sub", false);
    }

    private void isInSub(boolean value) {
        this.getArguments().putBoolean("in_sub", value);
    }

    private int topIndex() {
        return this.getArguments().getInt("top_index", -1);
    }

    private void topIndex(int value) {
        if (this.topIndex() != value && value > -1) {
            this.findSubIndexForColor(value, this.mColorsTop[value]);
        }
        this.getArguments().putInt("top_index", value);
    }

    private int subIndex() {
        if (this.mColorsSub == null) {
            return -1;
        }
        return this.getArguments().getInt("sub_index", -1);
    }

    private void subIndex(int value) {
        if (this.mColorsSub == null) {
            return;
        }
        this.getArguments().putInt("sub_index", value);
    }

    @StringRes
    public int getTitle() {
        Builder builder = this.getBuilder();
        int title = this.isInSub() ? builder.mTitleSub : builder.mTitle;
        if (title == 0) {
            title = builder.mTitle;
        }
        return title;
    }

    public boolean isAccentMode() {
        return this.getBuilder().mAccentMode;
    }

    public void onClick(View v) {
        if (v.getTag() != null) {
            String[] tag = ((String)v.getTag()).split(":");
            int index = Integer.parseInt(tag[0]);
            MaterialDialog dialog = (MaterialDialog)this.getDialog();
            Builder builder = this.getBuilder();
            if (this.isInSub()) {
                this.subIndex(index);
            } else {
                this.topIndex(index);
                if (this.mColorsSub != null && index < this.mColorsSub.length) {
                    dialog.setActionButton(DialogAction.NEGATIVE, builder.mBackBtn);
                    this.isInSub(true);
                }
            }
            if (builder.mAllowUserCustom) {
                this.mSelectedCustomColor = this.getSelectedColor();
            }
            this.invalidateDynamicButtonColors();
            this.invalidate();
        }
    }

    public boolean onLongClick(View v) {
        if (v.getTag() != null) {
            String[] tag = ((String)v.getTag()).split(":");
            int color = Integer.parseInt(tag[1]);
            ((CircleView)v).showHint(color);
            return true;
        }
        return false;
    }

    private void invalidateDynamicButtonColors() {
        MaterialDialog dialog = (MaterialDialog)this.getDialog();
        if (dialog == null) {
            return;
        }
        Builder builder = this.getBuilder();
        if (builder.mDynamicButtonColor) {
            int selectedColor = this.getSelectedColor();
            if (Color.alpha((int)selectedColor) < 64 || Color.red((int)selectedColor) > 247 && Color.green((int)selectedColor) > 247 && Color.blue((int)selectedColor) > 247) {
                selectedColor = Color.parseColor((String)"#DEDEDE");
            }
            if (this.getBuilder().mDynamicButtonColor) {
                dialog.getActionButton(DialogAction.POSITIVE).setTextColor(selectedColor);
                dialog.getActionButton(DialogAction.NEGATIVE).setTextColor(selectedColor);
                dialog.getActionButton(DialogAction.NEUTRAL).setTextColor(selectedColor);
            }
            if (this.mCustomSeekR != null) {
                if (this.mCustomSeekA.getVisibility() == 0) {
                    MDTintHelper.setTint((SeekBar)this.mCustomSeekA, (int)selectedColor);
                }
                MDTintHelper.setTint((SeekBar)this.mCustomSeekR, (int)selectedColor);
                MDTintHelper.setTint((SeekBar)this.mCustomSeekG, (int)selectedColor);
                MDTintHelper.setTint((SeekBar)this.mCustomSeekB, (int)selectedColor);
            }
        }
    }

    @ColorInt
    private int getSelectedColor() {
        if (this.mColorChooserCustomFrame != null && this.mColorChooserCustomFrame.getVisibility() == 0) {
            return this.mSelectedCustomColor;
        }
        int color = 0;
        if (this.subIndex() > -1) {
            color = this.mColorsSub[this.topIndex()][this.subIndex()];
        } else if (this.topIndex() > -1) {
            color = this.mColorsTop[this.topIndex()];
        }
        if (color == 0) {
            int fallback = 0;
            if (Build.VERSION.SDK_INT >= 21) {
                fallback = DialogUtils.resolveColor((Context)this.getActivity(), (int)16843829);
            }
            color = DialogUtils.resolveColor((Context)this.getActivity(), (int)R.attr.colorAccent, (int)fallback);
        }
        return color;
    }

    private void findSubIndexForColor(int topIndex, int color) {
        if (this.mColorsSub == null || this.mColorsSub.length - 1 < topIndex) {
            return;
        }
        int[] subColors = this.mColorsSub[topIndex];
        for (int subIndex = 0; subIndex < subColors.length; ++subIndex) {
            if (subColors[subIndex] != color) continue;
            this.subIndex(subIndex);
            break;
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        int preselectColor;
        if (this.getArguments() == null || !this.getArguments().containsKey("builder")) {
            throw new IllegalStateException("ColorChooserDialog should be created using its Builder interface.");
        }
        this.generateColors();
        boolean foundPreselectColor = false;
        if (savedInstanceState != null) {
            foundPreselectColor = !savedInstanceState.getBoolean("in_custom", false);
            preselectColor = this.getSelectedColor();
        } else if (this.getBuilder().mSetPreselectionColor) {
            preselectColor = this.getBuilder().mPreselect;
            if (preselectColor != 0) {
                for (int topIndex = 0; topIndex < this.mColorsTop.length; ++topIndex) {
                    if (this.mColorsTop[topIndex] == preselectColor) {
                        foundPreselectColor = true;
                        this.topIndex(topIndex);
                        if (this.getBuilder().mAccentMode) {
                            this.subIndex(2);
                        } else if (this.mColorsSub != null) {
                            this.findSubIndexForColor(topIndex, preselectColor);
                        } else {
                            this.subIndex(5);
                        }
                    } else {
                        if (this.mColorsSub == null) continue;
                        for (int subIndex = 0; subIndex < this.mColorsSub[topIndex].length; ++subIndex) {
                            if (this.mColorsSub[topIndex][subIndex] != preselectColor) continue;
                            foundPreselectColor = true;
                            this.topIndex(topIndex);
                            this.subIndex(subIndex);
                            break;
                        }
                        if (!foundPreselectColor) {
                            continue;
                        }
                    }
                    break;
                }
            }
        } else {
            preselectColor = -16777216;
            foundPreselectColor = true;
        }
        this.mCircleSize = this.getResources().getDimensionPixelSize(R.dimen.md_colorchooser_circlesize);
        Builder builder = this.getBuilder();
        MaterialDialog dialog = new MaterialDialog.Builder((Context)this.getActivity()).title(this.getTitle()).autoDismiss(false).customView(R.layout.md_dialog_colorchooser, false).negativeText(builder.mCancelBtn).positiveText(builder.mDoneBtn).neutralText(builder.mAllowUserCustom ? builder.mCustomBtn : 0).onPositive(new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                ColorChooserDialog.this.mCallback.onColorSelection(ColorChooserDialog.this, ColorChooserDialog.this.getSelectedColor());
                ColorChooserDialog.this.dismiss();
            }
        }).onNegative(new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                if (ColorChooserDialog.this.isInSub()) {
                    dialog.setActionButton(DialogAction.NEGATIVE, ((ColorChooserDialog)ColorChooserDialog.this).getBuilder().mCancelBtn);
                    ColorChooserDialog.this.isInSub(false);
                    ColorChooserDialog.this.invalidate();
                } else {
                    dialog.cancel();
                }
            }
        }).onNeutral(new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                ColorChooserDialog.this.toggleCustom(dialog);
            }
        }).showListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialog) {
                ColorChooserDialog.this.invalidateDynamicButtonColors();
            }
        }).build();
        View v = dialog.getCustomView();
        this.mGrid = (GridView)v.findViewById(R.id.grid);
        if (builder.mAllowUserCustom) {
            this.mSelectedCustomColor = preselectColor;
            this.mColorChooserCustomFrame = v.findViewById(R.id.colorChooserCustomFrame);
            this.mCustomColorHex = (EditText)v.findViewById(R.id.hexInput);
            this.mCustomColorIndicator = v.findViewById(R.id.colorIndicator);
            this.mCustomSeekA = (SeekBar)v.findViewById(R.id.colorA);
            this.mCustomSeekAValue = (TextView)v.findViewById(R.id.colorAValue);
            this.mCustomSeekR = (SeekBar)v.findViewById(R.id.colorR);
            this.mCustomSeekRValue = (TextView)v.findViewById(R.id.colorRValue);
            this.mCustomSeekG = (SeekBar)v.findViewById(R.id.colorG);
            this.mCustomSeekGValue = (TextView)v.findViewById(R.id.colorGValue);
            this.mCustomSeekB = (SeekBar)v.findViewById(R.id.colorB);
            this.mCustomSeekBValue = (TextView)v.findViewById(R.id.colorBValue);
            if (!builder.mAllowUserCustomAlpha) {
                v.findViewById(R.id.colorALabel).setVisibility(8);
                this.mCustomSeekA.setVisibility(8);
                this.mCustomSeekAValue.setVisibility(8);
                this.mCustomColorHex.setHint((CharSequence)"2196F3");
                this.mCustomColorHex.setFilters(new InputFilter[]{new InputFilter.LengthFilter(6)});
            } else {
                this.mCustomColorHex.setHint((CharSequence)"FF2196F3");
                this.mCustomColorHex.setFilters(new InputFilter[]{new InputFilter.LengthFilter(8)});
            }
            if (!foundPreselectColor) {
                this.toggleCustom(dialog);
            }
        }
        this.invalidate();
        return dialog;
    }

    private void toggleCustom(MaterialDialog dialog) {
        if (dialog == null) {
            dialog = (MaterialDialog)this.getDialog();
        }
        if (this.mGrid.getVisibility() == 0) {
            dialog.setTitle(this.getBuilder().mCustomBtn);
            dialog.setActionButton(DialogAction.NEUTRAL, this.getBuilder().mPresetsBtn);
            dialog.setActionButton(DialogAction.NEGATIVE, this.getBuilder().mCancelBtn);
            this.mGrid.setVisibility(4);
            this.mColorChooserCustomFrame.setVisibility(0);
            this.mCustomColorTextWatcher = new TextWatcher(){

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                    try {
                        ColorChooserDialog.this.mSelectedCustomColor = Color.parseColor((String)("#" + s.toString()));
                    }
                    catch (IllegalArgumentException e) {
                        ColorChooserDialog.this.mSelectedCustomColor = -16777216;
                    }
                    ColorChooserDialog.this.mCustomColorIndicator.setBackgroundColor(ColorChooserDialog.this.mSelectedCustomColor);
                    if (ColorChooserDialog.this.mCustomSeekA.getVisibility() == 0) {
                        int alpha = Color.alpha((int)ColorChooserDialog.this.mSelectedCustomColor);
                        ColorChooserDialog.this.mCustomSeekA.setProgress(alpha);
                        ColorChooserDialog.this.mCustomSeekAValue.setText((CharSequence)String.format("%d", alpha));
                    }
                    if (ColorChooserDialog.this.mCustomSeekA.getVisibility() == 0) {
                        int alpha = Color.alpha((int)ColorChooserDialog.this.mSelectedCustomColor);
                        ColorChooserDialog.this.mCustomSeekA.setProgress(alpha);
                    }
                    int red = Color.red((int)ColorChooserDialog.this.mSelectedCustomColor);
                    ColorChooserDialog.this.mCustomSeekR.setProgress(red);
                    int green = Color.green((int)ColorChooserDialog.this.mSelectedCustomColor);
                    ColorChooserDialog.this.mCustomSeekG.setProgress(green);
                    int blue = Color.blue((int)ColorChooserDialog.this.mSelectedCustomColor);
                    ColorChooserDialog.this.mCustomSeekB.setProgress(blue);
                    ColorChooserDialog.this.isInSub(false);
                    ColorChooserDialog.this.topIndex(-1);
                    ColorChooserDialog.this.subIndex(-1);
                    ColorChooserDialog.this.invalidateDynamicButtonColors();
                }

                public void afterTextChanged(Editable s) {
                }
            };
            this.mCustomColorHex.addTextChangedListener(this.mCustomColorTextWatcher);
            this.mCustomColorRgbListener = new SeekBar.OnSeekBarChangeListener(){

                public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                    if (fromUser) {
                        if (((ColorChooserDialog)ColorChooserDialog.this).getBuilder().mAllowUserCustomAlpha) {
                            int color = Color.argb((int)ColorChooserDialog.this.mCustomSeekA.getProgress(), (int)ColorChooserDialog.this.mCustomSeekR.getProgress(), (int)ColorChooserDialog.this.mCustomSeekG.getProgress(), (int)ColorChooserDialog.this.mCustomSeekB.getProgress());
                            ColorChooserDialog.this.mCustomColorHex.setText((CharSequence)String.format("%08X", color));
                        } else {
                            int color = Color.rgb((int)ColorChooserDialog.this.mCustomSeekR.getProgress(), (int)ColorChooserDialog.this.mCustomSeekG.getProgress(), (int)ColorChooserDialog.this.mCustomSeekB.getProgress());
                            ColorChooserDialog.this.mCustomColorHex.setText((CharSequence)String.format("%06X", 0xFFFFFF & color));
                        }
                    }
                    ColorChooserDialog.this.mCustomSeekAValue.setText((CharSequence)String.format("%d", ColorChooserDialog.this.mCustomSeekA.getProgress()));
                    ColorChooserDialog.this.mCustomSeekRValue.setText((CharSequence)String.format("%d", ColorChooserDialog.this.mCustomSeekR.getProgress()));
                    ColorChooserDialog.this.mCustomSeekGValue.setText((CharSequence)String.format("%d", ColorChooserDialog.this.mCustomSeekG.getProgress()));
                    ColorChooserDialog.this.mCustomSeekBValue.setText((CharSequence)String.format("%d", ColorChooserDialog.this.mCustomSeekB.getProgress()));
                }

                public void onStartTrackingTouch(SeekBar seekBar) {
                }

                public void onStopTrackingTouch(SeekBar seekBar) {
                }
            };
            this.mCustomSeekR.setOnSeekBarChangeListener(this.mCustomColorRgbListener);
            this.mCustomSeekG.setOnSeekBarChangeListener(this.mCustomColorRgbListener);
            this.mCustomSeekB.setOnSeekBarChangeListener(this.mCustomColorRgbListener);
            if (this.mCustomSeekA.getVisibility() == 0) {
                this.mCustomSeekA.setOnSeekBarChangeListener(this.mCustomColorRgbListener);
                this.mCustomColorHex.setText((CharSequence)String.format("%08X", this.mSelectedCustomColor));
            } else {
                this.mCustomColorHex.setText((CharSequence)String.format("%06X", 0xFFFFFF & this.mSelectedCustomColor));
            }
        } else {
            dialog.setTitle(this.getBuilder().mTitle);
            dialog.setActionButton(DialogAction.NEUTRAL, this.getBuilder().mCustomBtn);
            if (this.isInSub()) {
                dialog.setActionButton(DialogAction.NEGATIVE, this.getBuilder().mBackBtn);
            } else {
                dialog.setActionButton(DialogAction.NEGATIVE, this.getBuilder().mCancelBtn);
            }
            this.mGrid.setVisibility(0);
            this.mColorChooserCustomFrame.setVisibility(8);
            this.mCustomColorHex.removeTextChangedListener(this.mCustomColorTextWatcher);
            this.mCustomColorTextWatcher = null;
            this.mCustomSeekR.setOnSeekBarChangeListener(null);
            this.mCustomSeekG.setOnSeekBarChangeListener(null);
            this.mCustomSeekB.setOnSeekBarChangeListener(null);
            this.mCustomColorRgbListener = null;
        }
    }

    private void invalidate() {
        if (this.mGrid.getAdapter() == null) {
            this.mGrid.setAdapter((ListAdapter)new ColorGridAdapter());
            this.mGrid.setSelector(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.md_transparent, null));
        } else {
            ((BaseAdapter)this.mGrid.getAdapter()).notifyDataSetChanged();
        }
        if (this.getDialog() != null) {
            this.getDialog().setTitle(this.getTitle());
        }
    }

    private Builder getBuilder() {
        if (this.getArguments() == null || !this.getArguments().containsKey("builder")) {
            return null;
        }
        return (Builder)this.getArguments().getSerializable("builder");
    }

    private void dismissIfNecessary(AppCompatActivity context, String tag) {
        Fragment frag = context.getSupportFragmentManager().findFragmentByTag(tag);
        if (frag != null) {
            ((DialogFragment)frag).dismiss();
            context.getSupportFragmentManager().beginTransaction().remove(frag).commit();
        }
    }

    @Nullable
    public static ColorChooserDialog findVisible(@NonNull AppCompatActivity context, String tag) {
        Fragment frag = context.getSupportFragmentManager().findFragmentByTag(tag);
        if (frag != null && frag instanceof ColorChooserDialog) {
            return (ColorChooserDialog)frag;
        }
        return null;
    }

    @NonNull
    public ColorChooserDialog show(AppCompatActivity context) {
        Builder builder = this.getBuilder();
        String tag = builder.mColorsTop != null ? "[MD_COLOR_CHOOSER]" : (builder.mAccentMode ? "[MD_COLOR_CHOOSER]" : "[MD_COLOR_CHOOSER]");
        this.dismissIfNecessary(context, tag);
        this.show(context.getSupportFragmentManager(), tag);
        return this;
    }

    public static class Builder
    implements Serializable {
        @NonNull
        protected final transient AppCompatActivity mContext;
        @StringRes
        protected final int mTitle;
        @StringRes
        protected int mTitleSub;
        @ColorInt
        protected int mPreselect;
        @StringRes
        protected int mDoneBtn = R.string.md_done_label;
        @StringRes
        protected int mBackBtn = R.string.md_back_label;
        @StringRes
        protected int mCancelBtn = R.string.md_cancel_label;
        @StringRes
        protected int mCustomBtn = R.string.md_custom_label;
        @StringRes
        protected int mPresetsBtn = R.string.md_presets_label;
        @Nullable
        protected int[] mColorsTop;
        @Nullable
        protected int[][] mColorsSub;
        protected boolean mAccentMode = false;
        protected boolean mDynamicButtonColor = true;
        protected boolean mAllowUserCustom = true;
        protected boolean mAllowUserCustomAlpha = true;
        protected boolean mSetPreselectionColor = false;

        public <ActivityType extends AppCompatActivity> Builder(@NonNull ActivityType context, @StringRes int title) {
            this.mContext = context;
            this.mTitle = title;
        }

        @NonNull
        public Builder titleSub(@StringRes int titleSub) {
            this.mTitleSub = titleSub;
            return this;
        }

        @NonNull
        public Builder preselect(@ColorInt int preselect) {
            this.mPreselect = preselect;
            this.mSetPreselectionColor = true;
            return this;
        }

        @NonNull
        public Builder accentMode(boolean accentMode) {
            this.mAccentMode = accentMode;
            return this;
        }

        @NonNull
        public Builder doneButton(@StringRes int text) {
            this.mDoneBtn = text;
            return this;
        }

        @NonNull
        public Builder backButton(@StringRes int text) {
            this.mBackBtn = text;
            return this;
        }

        @NonNull
        public Builder cancelButton(@StringRes int text) {
            this.mCancelBtn = text;
            return this;
        }

        @NonNull
        public Builder customButton(@StringRes int text) {
            this.mCustomBtn = text;
            return this;
        }

        @NonNull
        public Builder presetsButton(@StringRes int text) {
            this.mPresetsBtn = text;
            return this;
        }

        @NonNull
        public Builder dynamicButtonColor(boolean enabled) {
            this.mDynamicButtonColor = enabled;
            return this;
        }

        @NonNull
        public Builder customColors(@NonNull int[] topLevel, @Nullable int[][] subLevel) {
            this.mColorsTop = topLevel;
            this.mColorsSub = subLevel;
            return this;
        }

        @NonNull
        public Builder customColors(@ArrayRes int topLevel, @Nullable int[][] subLevel) {
            this.mColorsTop = DialogUtils.getColorArray((Context)this.mContext, (int)topLevel);
            this.mColorsSub = subLevel;
            return this;
        }

        @NonNull
        public Builder allowUserColorInput(boolean allow) {
            this.mAllowUserCustom = allow;
            return this;
        }

        @NonNull
        public Builder allowUserColorInputAlpha(boolean allow) {
            this.mAllowUserCustomAlpha = allow;
            return this;
        }

        @NonNull
        public ColorChooserDialog build() {
            ColorChooserDialog dialog = new ColorChooserDialog();
            Bundle args = new Bundle();
            args.putSerializable("builder", (Serializable)this);
            dialog.setArguments(args);
            return dialog;
        }

        @NonNull
        public ColorChooserDialog show() {
            ColorChooserDialog dialog = this.build();
            dialog.show(this.mContext);
            return dialog;
        }
    }

    private class ColorGridAdapter
    extends BaseAdapter {
        public int getCount() {
            if (ColorChooserDialog.this.isInSub()) {
                return ColorChooserDialog.this.mColorsSub[ColorChooserDialog.this.topIndex()].length;
            }
            return ColorChooserDialog.this.mColorsTop.length;
        }

        public Object getItem(int position) {
            if (ColorChooserDialog.this.isInSub()) {
                return ColorChooserDialog.this.mColorsSub[ColorChooserDialog.this.topIndex()][position];
            }
            return ColorChooserDialog.this.mColorsTop[position];
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = new CircleView(ColorChooserDialog.this.getContext());
                convertView.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(ColorChooserDialog.this.mCircleSize, ColorChooserDialog.this.mCircleSize));
            }
            CircleView child = (CircleView)((Object)convertView);
            int color = ColorChooserDialog.this.isInSub() ? ColorChooserDialog.this.mColorsSub[ColorChooserDialog.this.topIndex()][position] : ColorChooserDialog.this.mColorsTop[position];
            child.setBackgroundColor(color);
            if (ColorChooserDialog.this.isInSub()) {
                child.setSelected(ColorChooserDialog.this.subIndex() == position);
            } else {
                child.setSelected(ColorChooserDialog.this.topIndex() == position);
            }
            child.setTag(String.format("%d:%d", position, color));
            child.setOnClickListener(ColorChooserDialog.this);
            child.setOnLongClickListener(ColorChooserDialog.this);
            return convertView;
        }
    }

    public static interface ColorCallback {
        public void onColorSelection(@NonNull ColorChooserDialog var1, @ColorInt int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ColorChooserTag {
    }
}

