/*
 * Decompiled with CFR 0.152.
 */
package com.aefyr.pseudoapksigner;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipAlignZipOutputStream
extends ZipOutputStream {
    private BytesCounterOutputStream mBytesCounter;
    private int mAlignment;

    public static ZipAlignZipOutputStream create(OutputStream outputStream, int alignment) {
        BytesCounterOutputStream bytesCounterOutputStream = new BytesCounterOutputStream(outputStream);
        ZipAlignZipOutputStream zipAlignZipOutputStream = new ZipAlignZipOutputStream(bytesCounterOutputStream, alignment);
        zipAlignZipOutputStream.mBytesCounter = bytesCounterOutputStream;
        return zipAlignZipOutputStream;
    }

    private ZipAlignZipOutputStream(BytesCounterOutputStream outputStream, int alignment) {
        super(outputStream);
        this.mAlignment = alignment;
    }

    @Override
    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        if (zipEntry.getMethod() == 0) {
            int headerSize = 30;
            int requiredPadding = (int)((long)this.mAlignment - (this.mBytesCounter.getBytesWritten() + (long)(headerSize += zipEntry.getName().getBytes().length)) % (long)this.mAlignment);
            if (requiredPadding != 0) {
                zipEntry.setExtra(new byte[requiredPadding]);
            }
        }
        super.putNextEntry(zipEntry);
    }

    private static class BytesCounterOutputStream
    extends OutputStream {
        private OutputStream mWrappedOutputStream;
        private long mBytesWritten = 0L;

        private BytesCounterOutputStream(OutputStream outputStream) {
            this.mWrappedOutputStream = outputStream;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.mWrappedOutputStream.write(b);
            this.mBytesWritten += (long)b.length;
        }

        @Override
        public void write(int b) throws IOException {
            this.mWrappedOutputStream.write(b);
            ++this.mBytesWritten;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.mWrappedOutputStream.write(b, off, len);
            this.mBytesWritten += (long)len;
        }

        private long getBytesWritten() {
            return this.mBytesWritten;
        }
    }
}

