/*
 * Decompiled with CFR 0.152.
 */
package com.aefyr.pseudoapksigner;

import com.aefyr.pseudoapksigner.ManifestGenerator;
import com.aefyr.pseudoapksigner.SignatureFileGenerator;
import com.aefyr.pseudoapksigner.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class PseudoApkSigner {
    private static final String HASHING_ALGORITHM = "SHA1";
    private RSAPrivateKey mPrivateKey;
    private File mTemplateFile;
    private String mSignatureFileName = "CERT";
    private String mSignatureBlockFileName = "CERT";

    public PseudoApkSigner(File template, File privateKey) throws Exception {
        this.mTemplateFile = template;
        this.mPrivateKey = this.readPrivateKey(privateKey);
    }

    public void sign(File apkFile, File output) throws Exception {
        ManifestGenerator manifest = new ManifestGenerator(apkFile, HASHING_ALGORITHM);
        SignatureFileGenerator signature = new SignatureFileGenerator(manifest);
        ZipFile apkZipFile = new ZipFile(apkFile);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(output));
        Enumeration<? extends ZipEntry> zipEntries = apkZipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            if (zipEntry.getName().toLowerCase().startsWith("meta-inf")) continue;
            InputStream entryInputStream = apkZipFile.getInputStream(zipEntry);
            zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
            Utils.copyStream(entryInputStream, zipOutputStream);
            zipOutputStream.closeEntry();
        }
        zipOutputStream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
        zipOutputStream.write(manifest.generate().getBytes("UTF-8"));
        zipOutputStream.closeEntry();
        zipOutputStream.putNextEntry(new ZipEntry(String.format("META-INF/%s.SF", this.mSignatureFileName)));
        zipOutputStream.write(signature.generate().getBytes("UTF-8"));
        zipOutputStream.closeEntry();
        zipOutputStream.putNextEntry(new ZipEntry(String.format("META-INF/%s.RSA", this.mSignatureBlockFileName)));
        zipOutputStream.write(this.readFile(this.mTemplateFile));
        zipOutputStream.write(this.sign(this.mPrivateKey, signature.generate().getBytes("UTF-8")));
        zipOutputStream.closeEntry();
        apkZipFile.close();
        zipOutputStream.close();
    }

    public void setSignatureFileName(String signatureFileName) {
        this.mSignatureFileName = signatureFileName;
    }

    public void setSignatureBlockFileName(String signatureBlockFileName) {
        this.mSignatureBlockFileName = signatureBlockFileName;
    }

    private byte[] sign(PrivateKey privateKey, byte[] message) throws Exception {
        Signature sign = Signature.getInstance("SHA1withRSA");
        sign.initSign(privateKey);
        sign.update(message);
        return sign.sign();
    }

    private RSAPrivateKey readPrivateKey(File file) throws Exception {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(this.readFile(file));
        return (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(keySpec);
    }

    private byte[] readFile(File file) throws IOException {
        byte[] fileBytes = new byte[(int)file.length()];
        FileInputStream inputStream = new FileInputStream(file);
        inputStream.read(fileBytes);
        inputStream.close();
        return fileBytes;
    }
}

