/*
 * Decompiled with CFR 0.152.
 */
package com.aefyr.pseudoapksigner;

import com.aefyr.pseudoapksigner.Constants;
import com.aefyr.pseudoapksigner.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ManifestGenerator {
    private File mApkFile;
    private String mHashingAlgorithm;
    private ArrayList<ManifestEntry> mEntries;
    private long mVersion = 0L;
    private String mCachedManifest;
    private long mCachedVersion = -1L;

    ManifestGenerator(File apkFile, String hashingAlgorithm) {
        this.mApkFile = apkFile;
        this.mHashingAlgorithm = hashingAlgorithm;
        this.mEntries = new ArrayList();
    }

    String getHashingAlgorithm() {
        return this.mHashingAlgorithm;
    }

    String generate() throws Exception {
        if (this.mVersion == this.mCachedVersion) {
            return this.mCachedManifest;
        }
        this.parseApkAndGenerateEntries();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.generateHeader().toString());
        for (ManifestEntry entry : this.mEntries) {
            stringBuilder.append(entry.toString());
        }
        this.mCachedVersion = this.mVersion;
        this.mCachedManifest = stringBuilder.toString();
        return this.mCachedManifest;
    }

    private ManifestEntry generateHeader() {
        ManifestEntry header = new ManifestEntry();
        header.setAttribute("Manifest-Version", "1.0");
        header.setAttribute("Created-By", Constants.GENERATOR_NAME);
        return header;
    }

    private void addEntry(ManifestEntry entry) {
        this.mEntries.add(entry);
        ++this.mVersion;
    }

    List<ManifestEntry> getEntries() {
        return this.mEntries;
    }

    private void parseApkAndGenerateEntries() throws Exception {
        this.mEntries.clear();
        ZipFile apkZipFile = new ZipFile(this.mApkFile);
        Enumeration<? extends ZipEntry> zipEntries = apkZipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            if (zipEntry.isDirectory() || zipEntry.getName().toLowerCase().startsWith("meta-inf")) continue;
            ManifestEntry manifestEntry = new ManifestEntry();
            manifestEntry.setAttribute("Name", zipEntry.getName());
            manifestEntry.setAttribute(this.mHashingAlgorithm + "-Digest", Utils.base64Encode(Utils.getFileHash(apkZipFile.getInputStream(zipEntry), this.mHashingAlgorithm)));
            this.addEntry(manifestEntry);
        }
        apkZipFile.close();
    }

    static class ManifestEntry {
        private LinkedHashMap<String, String> mAttributes = new LinkedHashMap();

        ManifestEntry() {
        }

        void setAttribute(String attribute, String value) {
            this.mAttributes.put(attribute, value);
        }

        String getAttribute(String attribute) {
            return this.mAttributes.get(attribute);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (String key : this.mAttributes.keySet()) {
                stringBuilder.append(String.format("%s: %s\r\n", key, this.mAttributes.get(key)));
            }
            stringBuilder.append("\r\n");
            return stringBuilder.toString();
        }
    }
}

