/*
 * Decompiled with CFR 0.152.
 */
package com.github.adrienrx.timber.loggly;

import com.github.adrienrx.loggly.ILogglyClient;
import com.github.adrienrx.loggly.LogglyClient;
import com.github.adrienrx.timber.loggly.DummyCallback;
import com.github.adrienrx.timber.loggly.IFormatter;
import com.github.adrienrx.timber.loggly.JsonFormatter;
import timber.log.Timber;

public class LogglyTree
extends Timber.Tree {
    private ILogglyClient loggly;
    private ILogglyClient.Callback handler;
    private IFormatter formatter;

    public LogglyTree(String token) {
        this.loggly = new LogglyClient(token);
        this.handler = new DummyCallback();
        this.formatter = new JsonFormatter();
    }

    LogglyTree(ILogglyClient client, ILogglyClient.Callback handler, IFormatter formatter) {
        this.loggly = client;
        this.handler = handler;
        this.formatter = formatter;
    }

    protected void log(int priority, String tag, String message, Throwable t) {
        this.loggly.log(this.formatter.format(priority, tag, message, t), this.handler);
    }

    public void tag(String tag) {
        this.loggly.setTags(new String[]{tag});
    }
}

