/*
 * Decompiled with CFR 0.152.
 */
package com.github.adrienrx.timber.loggly;

import com.github.adrienrx.timber.loggly.IFormatter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

class JsonFormatter
implements IFormatter {
    private Map<Integer, String> LEVELS = new HashMap<Integer, String>();

    public JsonFormatter() {
        this.LEVELS.put(2, "VERBOSE");
        this.LEVELS.put(3, "DEBUG");
        this.LEVELS.put(4, "INFO");
        this.LEVELS.put(5, "WARN");
        this.LEVELS.put(6, "ERROR");
        this.LEVELS.put(7, "ASSERT");
    }

    @Override
    public String format(int priority, String tag, String message, Throwable t) {
        StringBuilder formatted = new StringBuilder();
        formatted.append("{");
        formatted.append("\"level\": \"").append(this.toLevel(priority)).append("\"");
        this.appendMessage(formatted, message);
        this.appendThrowable(formatted, t);
        formatted.append("}");
        return formatted.toString();
    }

    private void appendThrowable(StringBuilder buffer, Throwable t) {
        if (t != null) {
            StringWriter errors = new StringWriter();
            t.printStackTrace(new PrintWriter(errors));
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("\"exception\": \"").append(JsonFormatter.escape(errors.toString())).append("\"");
        }
    }

    private void appendMessage(StringBuilder buffer, String message) {
        if (message != null && message.length() > 0) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("\"message\": \"").append(JsonFormatter.escape(message)).append("\"");
        }
    }

    private static String escape(String input) {
        return input.replace("\r", "\\\\r").replace("\n", "\\\\n").replace("\t", "\\\\t").replace("\"", "\\\"");
    }

    private String toLevel(int priority) {
        return this.LEVELS.containsKey(priority) ? this.LEVELS.get(priority) : this.LEVELS.get(3);
    }
}

