/*
 * Decompiled with CFR 0.152.
 */
package com.github.adrienrx.loggly;

import com.github.adrienrx.loggly.ILogglyClient;
import com.github.adrienrx.loggly.ILogglyRestService;
import com.github.adrienrx.loggly.LogglyResponse;
import java.util.Arrays;
import java.util.Collection;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class LogglyClient
implements ILogglyClient {
    private static final String API_URL = "https://logs-01.loggly.com/";
    private final ILogglyRestService loggly;
    private final String token;
    private String tags;

    public LogglyClient(String token) {
        if (token == null || token.isEmpty()) {
            throw new IllegalArgumentException("token cannot be empty");
        }
        Retrofit restAdapter = new Retrofit.Builder().baseUrl(API_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        this.token = token;
        this.loggly = (ILogglyRestService)restAdapter.create(ILogglyRestService.class);
    }

    LogglyClient(String token, ILogglyRestService restApi) {
        this.token = token;
        this.loggly = restApi;
    }

    @Override
    public void setTags(String ... tags) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String s : tags) {
            for (String t : s.split(",")) {
                if (!(t = t.trim()).isEmpty()) {
                    if (!first) {
                        builder.append(",");
                    }
                    builder.append(t);
                }
                first = false;
            }
        }
        this.tags = builder.length() > 0 ? builder.toString() : null;
    }

    @Override
    public boolean log(String message) {
        boolean ok;
        if (message == null) {
            return false;
        }
        try {
            ok = this.loggly.log(this.token, this.tags, message).isExecuted();
        }
        catch (Exception e) {
            e.printStackTrace();
            ok = false;
        }
        return ok;
    }

    @Override
    public void log(String message, final ILogglyClient.Callback callback) {
        if (message == null) {
            return;
        }
        this.loggly.log(this.token, this.tags, message).enqueue((Callback)new Callback<LogglyResponse>(){

            public void onResponse(Call<LogglyResponse> call, Response<LogglyResponse> response) {
                callback.success();
            }

            public void onFailure(Call<LogglyResponse> call, Throwable throwable) {
                callback.failure(throwable.getMessage());
            }
        });
    }

    @Override
    public boolean logJson(String message) {
        boolean ok;
        if (message == null) {
            return false;
        }
        try {
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)message);
            if (requestBody == null) {
                return false;
            }
            ok = this.loggly.logJson(this.token, this.tags, requestBody).isExecuted();
        }
        catch (Exception e) {
            e.printStackTrace();
            ok = false;
        }
        return ok;
    }

    @Override
    public void logJson(String message, final ILogglyClient.Callback callback) {
        if (message == null) {
            return;
        }
        RequestBody requestBody = null;
        try {
            requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (requestBody == null) {
            return;
        }
        this.loggly.logJson(this.token, this.tags, requestBody).enqueue((Callback)new Callback<LogglyResponse>(){

            public void onResponse(Call<LogglyResponse> call, Response<LogglyResponse> response) {
                callback.success();
            }

            public void onFailure(Call<LogglyResponse> call, Throwable throwable) {
                callback.failure(throwable.getMessage());
            }
        });
    }

    @Override
    public boolean logBulk(String ... messages) {
        if (messages == null) {
            return false;
        }
        return this.logBulk(Arrays.asList(messages));
    }

    @Override
    public boolean logBulk(Collection<String> messages) {
        boolean ok;
        if (messages == null) {
            return false;
        }
        String parcel = this.joinStrings(messages);
        if (parcel.isEmpty()) {
            return false;
        }
        try {
            ok = this.loggly.logBulk(this.token, this.tags, parcel).isExecuted();
        }
        catch (Exception e) {
            e.printStackTrace();
            ok = false;
        }
        return ok;
    }

    @Override
    public void logBulk(Collection<String> messages, final ILogglyClient.Callback callback) {
        if (messages == null) {
            return;
        }
        String parcel = this.joinStrings(messages);
        if (parcel.isEmpty()) {
            return;
        }
        this.loggly.logBulk(this.token, this.tags, parcel).enqueue((Callback)new Callback<LogglyResponse>(){

            public void onResponse(Call<LogglyResponse> call, Response<LogglyResponse> response) {
                callback.success();
            }

            public void onFailure(Call<LogglyResponse> call, Throwable throwable) {
                callback.failure(throwable.getMessage());
            }
        });
    }

    private String joinStrings(Collection<String> messages) {
        StringBuilder b = new StringBuilder();
        for (String s : messages) {
            if (s == null || s.isEmpty()) continue;
            b.append(s.replaceAll("[\r\n]", "\r")).append('\n');
        }
        return b.toString();
    }
}

