/*
 * Decompiled with CFR 0.152.
 */
package com.addisonelliott.segmentedbutton;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.res.ResourcesCompat;
import com.addisonelliott.segmentedbutton.R;

@SuppressLint(value={"RtlHardcoded"})
public class SegmentedButton
extends View {
    private static final String TAG = "SegmentedButton";
    private RectF rectF;
    private TextPaint textPaint;
    private StaticLayout textStaticLayout;
    private int textMaxWidth;
    private PointF textPosition;
    private PointF drawablePosition;
    private Path backgroundClipPath;
    private int backgroundRadius;
    private boolean isLeftButton;
    private boolean isRightButton;
    private float relativeClipPosition;
    private boolean isClippingLeft;
    private Drawable backgroundDrawable;
    private Drawable selectedBackgroundDrawable;
    private int rippleColor;
    private RippleDrawable rippleDrawableLollipop;
    private codetail.graphics.drawables.RippleDrawable rippleDrawable;
    private PorterDuffColorFilter drawableColorFilter;
    private PorterDuffColorFilter selectedDrawableColorFilter;
    private Drawable drawable;
    private int drawablePadding;
    private boolean hasDrawableTint;
    private boolean hasSelectedDrawableTint;
    private int drawableTint;
    private int selectedDrawableTint;
    private boolean hasDrawableWidth;
    private boolean hasDrawableHeight;
    private int drawableWidth;
    private int drawableHeight;
    private int drawableGravity;
    private boolean hasText;
    private String text;
    private boolean hasSelectedTextColor;
    private int textColor;
    private int selectedTextColor;
    private float textSize;
    private Typeface textTypeface;

    public SegmentedButton(Context context) {
        super(context);
        this.init(context, null);
    }

    public SegmentedButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public SegmentedButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        this.getAttributes(context, attrs);
        this.initText();
        this.initDrawable();
        this.relativeClipPosition = 0.0f;
        this.isClippingLeft = true;
        this.backgroundRadius = 0;
        this.isLeftButton = false;
        this.isRightButton = false;
        this.rectF = new RectF();
        this.setClickable(true);
    }

    private void getAttributes(Context context, @Nullable AttributeSet attrs) {
        int fontFamily;
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.SegmentedButton);
        if (ta.hasValue(R.styleable.SegmentedButton_background)) {
            this.backgroundDrawable = ta.getDrawable(R.styleable.SegmentedButton_background);
        }
        if (ta.hasValue(R.styleable.SegmentedButton_selectedBackground)) {
            this.selectedBackgroundDrawable = ta.getDrawable(R.styleable.SegmentedButton_selectedBackground);
        }
        this.setRipple(ta.getColor(R.styleable.SegmentedButton_rippleColor, -7829368));
        if (ta.hasValue(R.styleable.SegmentedButton_drawable)) {
            this.drawable = ta.getDrawable(R.styleable.SegmentedButton_drawable);
        }
        this.drawablePadding = ta.getDimensionPixelSize(R.styleable.SegmentedButton_drawablePadding, 0);
        this.hasDrawableTint = ta.hasValue(R.styleable.SegmentedButton_drawableTint);
        this.drawableTint = ta.getColor(R.styleable.SegmentedButton_drawableTint, -1);
        this.hasSelectedDrawableTint = ta.hasValue(R.styleable.SegmentedButton_selectedDrawableTint);
        this.selectedDrawableTint = ta.getColor(R.styleable.SegmentedButton_selectedDrawableTint, -1);
        this.hasDrawableWidth = ta.hasValue(R.styleable.SegmentedButton_drawableWidth);
        this.hasDrawableHeight = ta.hasValue(R.styleable.SegmentedButton_drawableHeight);
        this.drawableWidth = ta.getDimensionPixelSize(R.styleable.SegmentedButton_drawableWidth, -1);
        this.drawableHeight = ta.getDimensionPixelSize(R.styleable.SegmentedButton_drawableHeight, -1);
        this.drawableGravity = ta.getInteger(R.styleable.SegmentedButton_drawableGravity, 3);
        this.hasText = ta.hasValue(R.styleable.SegmentedButton_text);
        this.text = ta.getString(R.styleable.SegmentedButton_text);
        this.textColor = ta.getColor(R.styleable.SegmentedButton_textColor, -7829368);
        this.hasSelectedTextColor = ta.hasValue(R.styleable.SegmentedButton_selectedTextColor);
        this.selectedTextColor = ta.getColor(R.styleable.SegmentedButton_selectedTextColor, -1);
        float px14sp = TypedValue.applyDimension((int)2, (float)14.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        this.textSize = ta.getDimension(R.styleable.SegmentedButton_textSize, px14sp);
        boolean hasFontFamily = ta.hasValue(R.styleable.SegmentedButton_android_fontFamily);
        int textStyle = ta.getInt(R.styleable.SegmentedButton_textStyle, 0);
        this.textTypeface = hasFontFamily ? (Build.VERSION.SDK_INT >= 26 ? Typeface.create((Typeface)ta.getFont(R.styleable.SegmentedButton_android_fontFamily), (int)textStyle) : ((fontFamily = ta.getResourceId(R.styleable.SegmentedButton_android_fontFamily, 0)) > 0 ? Typeface.create((Typeface)ResourcesCompat.getFont((Context)context, (int)fontFamily), (int)textStyle) : Typeface.create((String)ta.getString(R.styleable.SegmentedButton_android_fontFamily), (int)textStyle))) : Typeface.create((Typeface)null, (int)textStyle);
        ta.recycle();
    }

    private void initText() {
        this.textPosition = new PointF();
        if (!this.hasText) {
            this.textStaticLayout = null;
            return;
        }
        this.textPaint = new TextPaint();
        this.textPaint.setAntiAlias(true);
        this.textPaint.setTextSize(this.textSize);
        this.textPaint.setColor(this.textColor);
        this.textPaint.setTypeface(this.textTypeface);
        this.textMaxWidth = (int)this.textPaint.measureText(this.text);
        this.textStaticLayout = Build.VERSION.SDK_INT >= 23 ? StaticLayout.Builder.obtain((CharSequence)this.text, (int)0, (int)this.text.length(), (TextPaint)this.textPaint, (int)this.textMaxWidth).build() : new StaticLayout((CharSequence)this.text, this.textPaint, this.textMaxWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
    }

    private void initDrawable() {
        this.drawablePosition = new PointF();
        if (this.drawable == null) {
            return;
        }
        if (this.hasDrawableTint) {
            this.drawableColorFilter = new PorterDuffColorFilter(this.drawableTint, PorterDuff.Mode.SRC_IN);
        }
        if (this.hasSelectedDrawableTint) {
            this.selectedDrawableColorFilter = new PorterDuffColorFilter(this.selectedDrawableTint, PorterDuff.Mode.SRC_IN);
        }
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int drawableWidth = this.drawable != null ? (this.hasDrawableWidth ? this.drawableWidth : this.drawable.getIntrinsicWidth()) : 0;
        int textWidth = this.hasText ? this.textMaxWidth : 0;
        int desiredWidth = this.getPaddingLeft() + this.getPaddingRight();
        desiredWidth = Gravity.isHorizontal((int)this.drawableGravity) ? (desiredWidth += textWidth + this.drawablePadding + drawableWidth) : (desiredWidth += Math.max(textWidth, drawableWidth));
        int width = SegmentedButton.resolveSize((int)desiredWidth, (int)widthMeasureSpec);
        this.measureTextWidth(width, drawableWidth);
        int drawableHeight = this.drawable != null ? (this.hasDrawableHeight ? this.drawableHeight : this.drawable.getIntrinsicHeight()) : 0;
        int textHeight = this.hasText ? this.textStaticLayout.getHeight() : 0;
        int desiredHeight = this.getPaddingTop() + this.getPaddingBottom();
        desiredHeight = Gravity.isHorizontal((int)this.drawableGravity) ? (desiredHeight += Math.max(textHeight, drawableHeight)) : (desiredHeight += textHeight + this.drawablePadding + drawableHeight);
        int height = SegmentedButton.resolveSize((int)desiredHeight, (int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.setupBackgroundClipPath();
        this.updateSize();
    }

    private void measureTextWidth(int width, int drawableWidth) {
        if (!this.hasText) {
            return;
        }
        int newDrawableWidth = Gravity.isHorizontal((int)this.drawableGravity) ? drawableWidth : 0;
        int textWidth = Math.min(width - this.getPaddingLeft() - this.getPaddingRight() - newDrawableWidth, this.textMaxWidth);
        if (textWidth < 0) {
            return;
        }
        this.textStaticLayout = Build.VERSION.SDK_INT >= 23 ? StaticLayout.Builder.obtain((CharSequence)this.text, (int)0, (int)this.text.length(), (TextPaint)this.textPaint, (int)textWidth).build() : new StaticLayout((CharSequence)this.text, this.textPaint, textWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
    }

    private void updateSize() {
        int drawableHeight;
        int drawableWidth;
        int textHeight;
        int width = this.getWidth();
        int height = this.getHeight();
        int textWidth = this.hasText ? this.textStaticLayout.getWidth() : 0;
        int n = textHeight = this.hasText ? this.textStaticLayout.getHeight() : 0;
        int n2 = this.drawable != null ? (this.hasDrawableWidth ? this.drawableWidth : this.drawable.getIntrinsicWidth()) : (drawableWidth = 0);
        int n3 = this.drawable != null ? (this.hasDrawableHeight ? this.drawableHeight : this.drawable.getIntrinsicHeight()) : (drawableHeight = 0);
        if (Gravity.isHorizontal((int)this.drawableGravity)) {
            this.textPosition.y = (float)this.getPaddingTop() + (float)(height - this.getPaddingTop() - this.getPaddingBottom() - textHeight) / 2.0f;
            this.drawablePosition.y = (float)this.getPaddingTop() + (float)(height - this.getPaddingTop() - this.getPaddingBottom() - drawableHeight) / 2.0f;
            float startPosition = (float)(width - textWidth - drawableWidth - this.drawablePadding) / 2.0f;
            if (this.drawableGravity == 3) {
                this.textPosition.x = startPosition + (float)drawableWidth + (float)this.drawablePadding;
                this.drawablePosition.x = startPosition;
            } else if (this.drawableGravity == 5) {
                this.textPosition.x = startPosition;
                this.drawablePosition.x = startPosition + (float)textWidth + (float)this.drawablePadding;
            }
        } else {
            this.textPosition.x = (float)this.getPaddingLeft() + (float)(width - this.getPaddingLeft() - this.getPaddingRight() - textWidth) / 2.0f;
            this.drawablePosition.x = (float)this.getPaddingLeft() + (float)(width - this.getPaddingLeft() - this.getPaddingRight() - drawableWidth) / 2.0f;
            float startPosition = (float)(height - textHeight - drawableHeight - this.drawablePadding) / 2.0f;
            if (this.drawableGravity == 48) {
                this.textPosition.y = startPosition + (float)drawableHeight + (float)this.drawablePadding;
                this.drawablePosition.y = startPosition;
            } else if (this.drawableGravity == 80) {
                this.textPosition.y = startPosition;
                this.drawablePosition.y = startPosition + (float)textHeight + (float)this.drawablePadding;
            }
        }
        if (this.drawable != null) {
            this.drawable.setBounds((int)this.drawablePosition.x, (int)this.drawablePosition.y, (int)this.drawablePosition.x + drawableWidth, (int)this.drawablePosition.y + drawableHeight);
        }
        if (this.backgroundDrawable != null) {
            this.backgroundDrawable.setBounds(0, 0, width, height);
        }
        if (this.selectedBackgroundDrawable != null) {
            this.selectedBackgroundDrawable.setBounds(0, 0, width, height);
        }
        if (this.rippleDrawableLollipop != null) {
            this.rippleDrawableLollipop.setBounds(0, 0, width, height);
        }
        if (this.rippleDrawable != null) {
            this.rippleDrawable.setBounds(0, 0, width, height);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.backgroundClipPath != null) {
            canvas.clipPath(this.backgroundClipPath);
        }
        if (this.backgroundDrawable != null) {
            this.backgroundDrawable.draw(canvas);
        }
        if (this.hasText) {
            canvas.save();
            canvas.translate(this.textPosition.x, this.textPosition.y);
            this.textPaint.setColor(this.textColor);
            this.textStaticLayout.draw(canvas);
            canvas.restore();
        }
        if (this.drawable != null) {
            this.drawable.setColorFilter((ColorFilter)this.drawableColorFilter);
            this.drawable.draw(canvas);
        }
        canvas.save();
        if (this.isClippingLeft) {
            canvas.clipRect(0.0f, 0.0f, this.relativeClipPosition * (float)width, (float)height);
        } else {
            canvas.clipRect(this.relativeClipPosition * (float)width, 0.0f, (float)width, (float)height);
        }
        if (this.selectedBackgroundDrawable != null) {
            this.selectedBackgroundDrawable.draw(canvas);
        }
        if (this.hasText) {
            canvas.save();
            canvas.translate(this.textPosition.x, this.textPosition.y);
            this.textPaint.setColor(this.hasSelectedTextColor ? this.selectedTextColor : this.textColor);
            this.textStaticLayout.draw(canvas);
            canvas.restore();
        }
        if (this.drawable != null) {
            this.drawable.setColorFilter((ColorFilter)(this.hasSelectedDrawableTint ? this.selectedDrawableColorFilter : this.drawableColorFilter));
            this.drawable.draw(canvas);
        }
        canvas.restore();
        if (this.rippleDrawableLollipop != null) {
            this.rippleDrawableLollipop.draw(canvas);
        }
        if (this.rippleDrawable != null) {
            this.rippleDrawable.draw(canvas);
        }
    }

    void clipLeft(@FloatRange(from=0.0, to=1.0) float relativePosition) {
        this.isClippingLeft = true;
        this.relativeClipPosition = relativePosition;
        this.invalidate();
    }

    void clipRight(@FloatRange(from=0.0, to=1.0) float relativePosition) {
        this.isClippingLeft = false;
        this.relativeClipPosition = relativePosition;
        this.invalidate();
    }

    @SuppressLint(value={"NewApi"})
    public void drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.rippleDrawableLollipop != null) {
            this.rippleDrawableLollipop.setHotspot(x, y);
        }
        if (this.rippleDrawable != null) {
            this.rippleDrawable.setHotspot(x, y);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.rippleDrawableLollipop != null) {
            this.rippleDrawableLollipop.setState(this.getDrawableState());
        }
        if (this.rippleDrawable != null) {
            this.rippleDrawable.setState(this.getDrawableState());
        }
    }

    protected boolean verifyDrawable(@NonNull Drawable who) {
        return who == this.rippleDrawableLollipop || who == this.rippleDrawable || super.verifyDrawable(who);
    }

    void setBackgroundRadius(int backgroundRadius) {
        this.backgroundRadius = backgroundRadius;
    }

    void setIsLeftButton(boolean isLeftButton) {
        this.isLeftButton = isLeftButton;
    }

    void setIsRightButton(boolean isRightButton) {
        this.isRightButton = isRightButton;
    }

    void setupBackgroundClipPath() {
        if (this.backgroundRadius == 0) {
            this.backgroundClipPath = null;
            return;
        }
        this.rectF.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        float br = this.backgroundRadius;
        if (this.isLeftButton && this.isRightButton) {
            this.backgroundClipPath = new Path();
            this.backgroundClipPath.addRoundRect(this.rectF, new float[]{br, br, br, br, br, br, br, br}, Path.Direction.CW);
        } else if (this.isLeftButton) {
            this.backgroundClipPath = new Path();
            this.backgroundClipPath.addRoundRect(this.rectF, new float[]{br, br, 0.0f, 0.0f, 0.0f, 0.0f, br, br}, Path.Direction.CW);
        } else if (this.isRightButton) {
            this.backgroundClipPath = new Path();
            this.backgroundClipPath.addRoundRect(this.rectF, new float[]{0.0f, 0.0f, br, br, br, br, 0.0f, 0.0f}, Path.Direction.CW);
        } else {
            this.backgroundClipPath = null;
        }
        if (this.backgroundClipPath != null && Build.VERSION.SDK_INT < 18) {
            this.setLayerType(1, null);
        } else {
            this.setLayerType(2, null);
        }
    }

    void setDefaultBackground(@Nullable Drawable drawable) {
        if (this.backgroundDrawable == null && drawable != null) {
            this.backgroundDrawable = drawable.getConstantState().newDrawable();
        }
    }

    void setDefaultSelectedBackground(@Nullable Drawable drawable) {
        if (this.selectedBackgroundDrawable == null && drawable != null) {
            this.selectedBackgroundDrawable = drawable.getConstantState().newDrawable();
        }
    }

    public Drawable getBackground() {
        return this.backgroundDrawable;
    }

    public void setBackground(Drawable drawable) {
        this.backgroundDrawable = drawable;
        this.backgroundDrawable.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.invalidate();
    }

    public void setBackground(@ColorInt int color) {
        if (this.backgroundDrawable instanceof ColorDrawable) {
            ((ColorDrawable)this.backgroundDrawable.mutate()).setColor(color);
        } else {
            this.backgroundDrawable = new ColorDrawable(color);
            this.backgroundDrawable.setBounds(0, 0, this.getWidth(), this.getHeight());
        }
        this.invalidate();
    }

    public void setBackgroundColor(@ColorInt int color) {
        this.setBackground(color);
    }

    public Drawable getSelectedBackground() {
        return this.selectedBackgroundDrawable;
    }

    public void setSelectedBackground(Drawable drawable) {
        this.selectedBackgroundDrawable = drawable;
        this.selectedBackgroundDrawable.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.invalidate();
    }

    public void setSelectedBackground(@ColorInt int color) {
        if (this.selectedBackgroundDrawable instanceof ColorDrawable) {
            ((ColorDrawable)this.selectedBackgroundDrawable.mutate()).setColor(color);
        } else {
            this.selectedBackgroundDrawable = new ColorDrawable(color);
            this.selectedBackgroundDrawable.setBounds(0, 0, this.getWidth(), this.getHeight());
        }
        this.invalidate();
    }

    public void setSelectedBackgroundColor(@ColorInt int color) {
        this.setSelectedBackground(color);
    }

    public int getRippleColor() {
        return this.rippleColor;
    }

    void setRipple(boolean enabled) {
        if (enabled) {
            this.setRipple(this.rippleColor);
        } else {
            this.rippleDrawableLollipop = null;
            this.rippleDrawable = null;
        }
    }

    public void setRipple(@ColorInt int color) {
        this.rippleColor = color;
        if (Build.VERSION.SDK_INT >= 21) {
            this.rippleDrawableLollipop = new RippleDrawable(ColorStateList.valueOf((int)this.rippleColor), null, null);
            this.rippleDrawableLollipop.setCallback((Drawable.Callback)this);
            this.rippleDrawableLollipop.setBounds(0, 0, this.getWidth(), this.getHeight());
            this.rippleDrawable = null;
        } else {
            this.rippleDrawable = new codetail.graphics.drawables.RippleDrawable(ColorStateList.valueOf((int)this.rippleColor), null, null);
            this.rippleDrawable.setCallback((Drawable.Callback)this);
            this.rippleDrawable.setBounds(0, 0, this.getWidth(), this.getHeight());
            this.rippleDrawableLollipop = null;
        }
        this.invalidate();
    }

    public Drawable getDrawable() {
        return this.drawable;
    }

    public void setDrawable(@Nullable Drawable drawable) {
        this.drawable = drawable;
        this.requestLayout();
        this.updateSize();
    }

    public int getDrawablePadding() {
        return this.drawablePadding;
    }

    public void setDrawablePadding(int padding) {
        this.drawablePadding = padding;
        this.requestLayout();
        this.updateSize();
    }

    public boolean hasDrawableTint() {
        return this.hasDrawableTint;
    }

    public int getDrawableTint() {
        return this.drawableTint;
    }

    public void setDrawableTint(@ColorInt int tint) {
        this.hasDrawableTint = true;
        this.drawableTint = tint;
        this.drawableColorFilter = new PorterDuffColorFilter(tint, PorterDuff.Mode.SRC_IN);
        this.invalidate();
    }

    public void removeDrawableTint() {
        this.hasDrawableTint = false;
        this.drawableColorFilter = null;
        this.invalidate();
    }

    public boolean hasSelectedDrawableTint() {
        return this.hasSelectedDrawableTint;
    }

    public int getSelectedDrawableTint() {
        return this.selectedDrawableTint;
    }

    public void setSelectedDrawableTint(@ColorInt int tint) {
        this.hasSelectedDrawableTint = true;
        this.selectedDrawableTint = tint;
        this.selectedDrawableColorFilter = new PorterDuffColorFilter(tint, PorterDuff.Mode.SRC_IN);
        this.invalidate();
    }

    public void removeSelectedDrawableTint() {
        this.hasSelectedDrawableTint = false;
        this.selectedDrawableColorFilter = null;
        this.invalidate();
    }

    public boolean hasDrawableWidth() {
        return this.hasDrawableWidth;
    }

    public int getDrawableWidth() {
        return this.drawableWidth;
    }

    public void setDrawableWidth(int width) {
        this.hasDrawableWidth = width != -1;
        this.drawableWidth = width;
        this.requestLayout();
        this.updateSize();
    }

    public boolean hasDrawableHeight() {
        return this.hasDrawableHeight;
    }

    public int getDrawableHeight() {
        return this.drawableHeight;
    }

    public void setDrawableHeight(int height) {
        this.hasDrawableHeight = height != -1;
        this.drawableHeight = height;
        this.requestLayout();
        this.updateSize();
    }

    public int getDrawableGravity() {
        return this.drawableGravity;
    }

    public void setDrawableGravity(int gravity) {
        this.drawableGravity = gravity;
        this.requestLayout();
        this.updateSize();
    }

    public String getText() {
        return this.text;
    }

    public void setText(@Nullable String text) {
        this.hasText = text != null && !text.isEmpty();
        this.text = text;
        this.initText();
        this.requestLayout();
        this.updateSize();
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(@ColorInt int color) {
        this.textColor = color;
        this.invalidate();
    }

    public boolean hasSelectedTextColor() {
        return this.hasSelectedTextColor;
    }

    public int getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public void setSelectedTextColor(@ColorInt int color) {
        this.hasSelectedTextColor = true;
        this.selectedTextColor = color;
        this.invalidate();
    }

    public void removeSelectedTextColor() {
        this.hasSelectedTextColor = false;
        this.invalidate();
    }

    public float getTextSize() {
        return this.textSize;
    }

    public void setTextSize(float size) {
        this.textSize = size;
        if (!this.hasText) {
            return;
        }
        this.textPaint.setTextSize(size);
        this.requestLayout();
        this.updateSize();
    }

    public Typeface getTextTypeface() {
        return this.textTypeface;
    }

    public void setTextTypeface(Typeface typeface) {
        this.textTypeface = typeface;
        this.initText();
        this.requestLayout();
        this.updateSize();
    }
}

