/*
 * Decompiled with CFR 0.152.
 */
package codetail.graphics.drawables;

import android.annotation.SuppressLint;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import codetail.graphics.drawables.DrawableReflectiveUtils;
import codetail.graphics.drawables.LayerDrawable;
import codetail.graphics.drawables.Ripple;
import codetail.graphics.drawables.RippleBackground;
import codetail.graphics.drawables.TypedArrayCompat;
import dreamers.graphics.R;
import java.io.IOException;
import java.util.Arrays;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RippleDrawable
extends LayerDrawable {
    private static final int MASK_UNKNOWN = -1;
    private static final int MASK_NONE = 0;
    private static final int MASK_CONTENT = 1;
    private static final int MASK_EXPLICIT = 2;
    public static final int RADIUS_AUTO = -1;
    private static final int MAX_RIPPLES = 10;
    private final Rect mTempRect = new Rect();
    private final Rect mHotspotBounds = new Rect();
    private final Rect mDrawingBounds = new Rect();
    private final Rect mDirtyBounds = new Rect();
    private RippleState mState;
    private Drawable mMask;
    private RippleBackground mBackground;
    private Bitmap mMaskBuffer;
    private BitmapShader mMaskShader;
    private Canvas mMaskCanvas;
    private Matrix mMaskMatrix;
    private PorterDuffColorFilter mMaskColorFilter;
    private boolean mHasValidMask;
    private boolean mBackgroundActive;
    private Ripple mRipple;
    private boolean mRippleActive;
    private float mPendingX;
    private float mPendingY;
    private boolean mHasPending;
    private Ripple[] mExitingRipples;
    private int mExitingRipplesCount = 0;
    private Paint mRipplePaint;
    private float mDensity = 1.0f;
    private boolean mOverrideBounds;

    RippleDrawable() {
        this(new RippleState(null, null, null), null);
    }

    @SuppressLint(value={"InlinedApi"})
    public RippleDrawable(@NonNull ColorStateList color, @Nullable Drawable content, @Nullable Drawable mask) {
        this(new RippleState(null, null, null), null);
        if (content != null) {
            this.addLayer(content, null, 0, 0, 0, 0, 0);
        }
        if (mask != null) {
            this.addLayer(mask, null, 16908334, 0, 0, 0, 0);
        }
        this.setColor(color);
        this.ensurePadding();
        this.initializeFromState();
    }

    public void jumpToCurrentState() {
        super.jumpToCurrentState();
        if (this.mRipple != null) {
            this.mRipple.jump();
        }
        if (this.mBackground != null) {
            this.mBackground.jump();
        }
        this.cancelExitingRipples();
        this.invalidateSelf();
    }

    private boolean cancelExitingRipples() {
        int count = this.mExitingRipplesCount;
        Object[] ripples = this.mExitingRipples;
        for (int i = 0; i < count; ++i) {
            ripples[i].cancel();
        }
        if (ripples != null) {
            Arrays.fill(ripples, 0, count, null);
        }
        this.mExitingRipplesCount = 0;
        return false;
    }

    @Override
    public void setAlpha(int alpha) {
        super.setAlpha(alpha);
    }

    @Override
    public void setColorFilter(ColorFilter cf) {
        super.setColorFilter(cf);
    }

    @Override
    public int getOpacity() {
        return -3;
    }

    @Override
    protected boolean onStateChange(int[] stateSet) {
        boolean changed = super.onStateChange(stateSet);
        boolean enabled = false;
        boolean pressed = false;
        boolean focused = false;
        for (int state : stateSet) {
            if (state == 16842910) {
                enabled = true;
            }
            if (state == 16842908) {
                focused = true;
            }
            if (state != 16842919) continue;
            pressed = true;
        }
        this.setRippleActive(enabled && pressed);
        this.setBackgroundActive(focused || enabled && pressed, focused);
        return changed;
    }

    private void setRippleActive(boolean active) {
        if (this.mRippleActive != active) {
            this.mRippleActive = active;
            if (active) {
                this.tryRippleEnter();
            } else {
                this.tryRippleExit();
            }
        }
    }

    private void setBackgroundActive(boolean active, boolean focused) {
        if (this.mBackgroundActive != active) {
            this.mBackgroundActive = active;
            if (active) {
                this.tryBackgroundEnter(focused);
            } else {
                this.tryBackgroundExit();
            }
        }
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        if (!this.mOverrideBounds) {
            this.mHotspotBounds.set(bounds);
            this.onHotspotBoundsChanged();
        }
        this.invalidateSelf();
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (!visible) {
            this.clearHotspots();
        } else if (changed) {
            if (this.mRippleActive) {
                this.tryRippleEnter();
            }
            if (this.mBackgroundActive) {
                this.tryBackgroundEnter(false);
            }
            this.jumpToCurrentState();
        }
        return changed;
    }

    public boolean isProjected() {
        return this.getNumberOfLayers() == 0;
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    public void setColor(ColorStateList color) {
        this.mState.mColor = color;
        this.invalidateSelf();
    }

    @Override
    public void inflate(@NonNull Resources r, @NonNull XmlPullParser parser, @NonNull AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = RippleDrawable.obtainAttributes(r, theme, attrs, R.styleable.RippleDrawable);
        this.updateStateFromTypedArray(null, a, null);
        a.recycle();
        this.setPaddingMode(1);
        super.inflate(r, parser, attrs, theme);
        this.setTargetDensity(r.getDisplayMetrics());
        this.initializeFromState();
    }

    @Override
    public boolean setDrawableByLayerId(int id2, Drawable drawable) {
        if (super.setDrawableByLayerId(id2, drawable)) {
            if (id2 == 16908334) {
                this.mMask = drawable;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setPaddingMode(int mode) {
        super.setPaddingMode(mode);
    }

    private void updateStateFromTypedArray(Resources.Theme theme, TypedArray a, TypedValue[] values) throws XmlPullParserException {
        RippleState state = this.mState;
        state.mChangingConfigurations |= TypedArrayCompat.getChangingConfigurations(a);
        state.mTouchThemeAttrs = TypedArrayCompat.extractThemeAttrs(a);
        ColorStateList color = TypedArrayCompat.getColorStateList(theme, a, values, R.styleable.RippleDrawable_android_color);
        if (color != null) {
            this.mState.mColor = color;
        }
        this.verifyRequiredAttributes(a);
    }

    private void verifyRequiredAttributes(TypedArray a) throws XmlPullParserException {
        if (this.mState.mColor == null && (this.mState.mTouchThemeAttrs == null || this.mState.mTouchThemeAttrs[R.styleable.RippleDrawable_android_color].data == 0)) {
            throw new XmlPullParserException(a.getPositionDescription() + ": <ripple> requires a valid color attribute");
        }
    }

    private void setTargetDensity(DisplayMetrics metrics) {
        if (this.mDensity != metrics.density) {
            this.mDensity = metrics.density;
            this.invalidateSelf();
        }
    }

    @Override
    public void applyTheme(@NonNull Resources.Theme t) {
        super.applyTheme(t);
        RippleState state = this.mState;
        if (state == null || state.mTouchThemeAttrs == null) {
            return;
        }
        try {
            this.updateStateFromTypedArray(t, null, this.mState.mTouchThemeAttrs);
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
        this.initializeFromState();
    }

    @Override
    public boolean canApplyTheme() {
        return this.mState != null && this.mState.canApplyTheme() || super.canApplyTheme();
    }

    @Override
    public void setHotspot(float x, float y) {
        if (this.mRipple == null || this.mBackground == null) {
            this.mPendingX = x;
            this.mPendingY = y;
            this.mHasPending = true;
        }
        if (this.mRipple != null) {
            this.mRipple.move(x, y);
        }
    }

    private void tryBackgroundEnter(boolean focused) {
        if (this.mBackground == null) {
            this.mBackground = new RippleBackground(this, this.mHotspotBounds);
        }
        this.mBackground.setup(this.mState.mMaxRadius, this.mDensity);
        this.mBackground.enter(focused);
    }

    private void tryBackgroundExit() {
        if (this.mBackground != null) {
            this.mBackground.exit();
        }
    }

    private void tryRippleEnter() {
        if (this.mExitingRipplesCount >= 10) {
            return;
        }
        if (this.mRipple == null) {
            float y;
            float x;
            if (this.mHasPending) {
                this.mHasPending = false;
                x = this.mPendingX;
                y = this.mPendingY;
            } else {
                x = this.mHotspotBounds.exactCenterX();
                y = this.mHotspotBounds.exactCenterY();
            }
            this.mRipple = new Ripple(this, this.mHotspotBounds, x, y);
        }
        this.mRipple.setup(this.mState.mMaxRadius, this.mDensity);
        this.mRipple.enter();
    }

    private void tryRippleExit() {
        if (this.mRipple != null) {
            if (this.mExitingRipples == null) {
                this.mExitingRipples = new Ripple[10];
            }
            this.mExitingRipples[this.mExitingRipplesCount++] = this.mRipple;
            this.mRipple.exit();
            this.mRipple = null;
        }
    }

    private void clearHotspots() {
        if (this.mRipple != null) {
            this.mRipple.cancel();
            this.mRipple = null;
            this.mRippleActive = false;
        }
        if (this.mBackground != null) {
            this.mBackground.cancel();
            this.mBackground = null;
            this.mBackgroundActive = false;
        }
        this.cancelExitingRipples();
        this.invalidateSelf();
    }

    @Override
    public void setHotspotBounds(int left, int top, int right, int bottom) {
        this.mOverrideBounds = true;
        this.mHotspotBounds.set(left, top, right, bottom);
        this.onHotspotBoundsChanged();
    }

    @Override
    public void getHotspotBounds(@NonNull Rect outRect) {
        outRect.set(this.mHotspotBounds);
    }

    private void onHotspotBoundsChanged() {
        int count = this.mExitingRipplesCount;
        Ripple[] ripples = this.mExitingRipples;
        for (int i = 0; i < count; ++i) {
            ripples[i].onHotspotBoundsChanged();
        }
        if (this.mRipple != null) {
            this.mRipple.onHotspotBoundsChanged();
        }
        if (this.mBackground != null) {
            this.mBackground.onHotspotBoundsChanged();
        }
    }

    @Override
    @RequiresApi(api=21)
    public void getOutline(@NonNull Outline outline) {
        LayerDrawable.LayerState state = this.mLayerState;
        LayerDrawable.ChildDrawable[] children = state.mChildren;
        int N = state.mNum;
        for (int i = 0; i < N; ++i) {
            if (children[i].mId == 16908334) continue;
            children[i].mDrawable.getOutline(outline);
            if (outline.isEmpty()) continue;
            return;
        }
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        Rect bounds = this.getDirtyBounds();
        canvas.save();
        canvas.clipRect(bounds);
        this.drawContent(canvas);
        this.drawBackgroundAndRipples(canvas);
        canvas.restore();
    }

    public void invalidateSelf() {
        super.invalidateSelf();
        this.mHasValidMask = false;
    }

    private void updateMaskShaderIfNeeded() {
        if (this.mHasValidMask) {
            return;
        }
        int maskType = this.getMaskType();
        if (maskType == -1) {
            return;
        }
        this.mHasValidMask = true;
        Rect bounds = this.getBounds();
        if (maskType == 0 || bounds.isEmpty()) {
            if (this.mMaskBuffer != null) {
                this.mMaskBuffer.recycle();
                this.mMaskBuffer = null;
                this.mMaskShader = null;
                this.mMaskCanvas = null;
            }
            this.mMaskMatrix = null;
            this.mMaskColorFilter = null;
            return;
        }
        if (this.mMaskBuffer == null || this.mMaskBuffer.getWidth() != bounds.width() || this.mMaskBuffer.getHeight() != bounds.height()) {
            if (this.mMaskBuffer != null) {
                this.mMaskBuffer.recycle();
            }
            this.mMaskBuffer = Bitmap.createBitmap((int)bounds.width(), (int)bounds.height(), (Bitmap.Config)Bitmap.Config.ALPHA_8);
            this.mMaskShader = new BitmapShader(this.mMaskBuffer, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.mMaskCanvas = new Canvas(this.mMaskBuffer);
        } else {
            this.mMaskBuffer.eraseColor(0);
        }
        if (this.mMaskMatrix == null) {
            this.mMaskMatrix = new Matrix();
        } else {
            this.mMaskMatrix.reset();
        }
        if (this.mMaskColorFilter == null) {
            this.mMaskColorFilter = new PorterDuffColorFilter(0, PorterDuff.Mode.SRC_IN);
        }
        if (maskType == 2) {
            this.drawMask(this.mMaskCanvas);
        } else if (maskType == 1) {
            this.drawContent(this.mMaskCanvas);
        }
    }

    private int getMaskType() {
        if (!(this.mRipple != null || this.mExitingRipplesCount > 0 || this.mBackground != null && this.mBackground.shouldDraw())) {
            return -1;
        }
        if (this.mMask != null) {
            if (this.mMask.getOpacity() == -1) {
                return 0;
            }
            return 2;
        }
        LayerDrawable.ChildDrawable[] array = this.mLayerState.mChildren;
        int count = this.mLayerState.mNum;
        for (int i = 0; i < count; ++i) {
            if (array[i].mDrawable.getOpacity() == -1) continue;
            return 1;
        }
        return 0;
    }

    void removeRipple(Ripple ripple) {
        Ripple[] ripples = this.mExitingRipples;
        int count = this.mExitingRipplesCount--;
        int index = this.getRippleIndex(ripple);
        if (index >= 0) {
            System.arraycopy(ripples, index + 1, ripples, index, count - (index + 1));
            ripples[count - 1] = null;
            this.invalidateSelf();
        }
    }

    private int getRippleIndex(Ripple ripple) {
        Ripple[] ripples = this.mExitingRipples;
        int count = this.mExitingRipplesCount;
        for (int i = 0; i < count; ++i) {
            if (ripples[i] != ripple) continue;
            return i;
        }
        return -1;
    }

    private void drawContent(Canvas canvas) {
        LayerDrawable.ChildDrawable[] array = this.mLayerState.mChildren;
        int count = this.mLayerState.mNum;
        for (int i = 0; i < count; ++i) {
            if (array[i].mId == 16908334) continue;
            array[i].mDrawable.draw(canvas);
        }
    }

    private void drawBackgroundAndRipples(Canvas canvas) {
        Ripple active = this.mRipple;
        RippleBackground background = this.mBackground;
        int count = this.mExitingRipplesCount;
        if (!(active != null || count > 0 || background != null && background.shouldDraw())) {
            return;
        }
        float x = this.mHotspotBounds.exactCenterX();
        float y = this.mHotspotBounds.exactCenterY();
        canvas.translate(x, y);
        this.updateMaskShaderIfNeeded();
        if (this.mMaskShader != null) {
            this.mMaskMatrix.setTranslate(-x, -y);
            this.mMaskShader.setLocalMatrix(this.mMaskMatrix);
        }
        int color = this.mState.mColor.getColorForState(this.getState(), -16777216);
        int halfAlpha = Color.alpha((int)color) / 2 << 24;
        Paint p = this.getRipplePaint();
        if (this.mMaskColorFilter != null) {
            int fullAlphaColor = color | 0xFF000000;
            this.mMaskColorFilter = DrawableReflectiveUtils.setColor(this.mMaskColorFilter, fullAlphaColor, PorterDuff.Mode.SRC_IN);
            p.setColor(halfAlpha);
            p.setColorFilter((ColorFilter)this.mMaskColorFilter);
            p.setShader((Shader)this.mMaskShader);
        } else {
            int halfAlphaColor = color & 0xFFFFFF | halfAlpha;
            p.setColor(halfAlphaColor);
            p.setColorFilter(null);
            p.setShader(null);
        }
        if (background != null && background.shouldDraw()) {
            background.draw(canvas, p);
        }
        if (count > 0) {
            Ripple[] ripples = this.mExitingRipples;
            for (int i = 0; i < count; ++i) {
                ripples[i].draw(canvas, p);
            }
        }
        if (active != null) {
            active.draw(canvas, p);
        }
        canvas.translate(-x, -y);
    }

    private void drawMask(Canvas canvas) {
        this.mMask.draw(canvas);
    }

    private Paint getRipplePaint() {
        if (this.mRipplePaint == null) {
            this.mRipplePaint = new Paint();
            this.mRipplePaint.setAntiAlias(true);
            this.mRipplePaint.setStyle(Paint.Style.FILL);
        }
        return this.mRipplePaint;
    }

    @Override
    @NonNull
    public Rect getDirtyBounds() {
        if (this.isProjected()) {
            Rect drawingBounds = this.mDrawingBounds;
            Rect dirtyBounds = this.mDirtyBounds;
            dirtyBounds.set(drawingBounds);
            drawingBounds.setEmpty();
            int cX = (int)this.mHotspotBounds.exactCenterX();
            int cY = (int)this.mHotspotBounds.exactCenterY();
            Rect rippleBounds = this.mTempRect;
            Ripple[] activeRipples = this.mExitingRipples;
            int N = this.mExitingRipplesCount;
            for (int i = 0; i < N; ++i) {
                activeRipples[i].getBounds(rippleBounds);
                rippleBounds.offset(cX, cY);
                drawingBounds.union(rippleBounds);
            }
            RippleBackground background = this.mBackground;
            if (background != null) {
                background.getBounds(rippleBounds);
                rippleBounds.offset(cX, cY);
                drawingBounds.union(rippleBounds);
            }
            dirtyBounds.union(drawingBounds);
            dirtyBounds.union(super.getDirtyBounds());
            return dirtyBounds;
        }
        return this.getBounds();
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return this.mState;
    }

    @Override
    @SuppressLint(value={"InlinedApi"})
    @NonNull
    public Drawable mutate() {
        super.mutate();
        this.mState = (RippleState)this.mLayerState;
        this.mMask = this.findDrawableByLayerId(16908334);
        return this;
    }

    @Override
    RippleState createConstantState(LayerDrawable.LayerState state, Resources res) {
        return new RippleState(state, this, res);
    }

    public void setMaxRadius(int maxRadius) {
        if (maxRadius != -1 && maxRadius < 0) {
            throw new IllegalArgumentException("maxRadius must be RADIUS_AUTO or >= 0");
        }
        this.mState.mMaxRadius = maxRadius;
    }

    public int getMaxRadius() {
        return this.mState.mMaxRadius;
    }

    private RippleDrawable(RippleState state, Resources res) {
        this.mState = new RippleState((LayerDrawable.LayerState)state, this, res);
        this.mLayerState = this.mState;
        if (this.mState.mNum > 0) {
            this.ensurePadding();
        }
        if (res != null) {
            this.mDensity = res.getDisplayMetrics().density;
        }
        this.initializeFromState();
    }

    @SuppressLint(value={"InlinedApi"})
    private void initializeFromState() {
        this.mMask = this.findDrawableByLayerId(16908334);
    }

    static class RippleState
    extends LayerDrawable.LayerState {
        TypedValue[] mTouchThemeAttrs;
        ColorStateList mColor = ColorStateList.valueOf((int)-65281);
        int mMaxRadius = -1;

        public RippleState(LayerDrawable.LayerState orig, RippleDrawable owner, Resources res) {
            super(orig, owner, res);
            if (orig instanceof RippleState) {
                RippleState origs = (RippleState)orig;
                this.mTouchThemeAttrs = origs.mTouchThemeAttrs;
                this.mColor = origs.mColor;
                this.mMaxRadius = origs.mMaxRadius;
            }
        }

        @Override
        public boolean canApplyTheme() {
            return this.mTouchThemeAttrs != null || super.canApplyTheme();
        }

        @Override
        @NonNull
        public Drawable newDrawable() {
            return new RippleDrawable(this, null);
        }

        @Override
        @NonNull
        public Drawable newDrawable(Resources res) {
            return new RippleDrawable(this, res);
        }
    }
}

