/*
 * Decompiled with CFR 0.152.
 */
package codetail.graphics.drawables;

import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.util.Log;
import androidx.collection.LruCache;
import androidx.collection.SimpleArrayMap;
import codetail.graphics.drawables.Android;
import java.lang.reflect.Method;

class DrawableReflectiveUtils {
    private static final String TAG = "DrawableReflectiveUtils";
    private static SimpleArrayMap<String, Method> sCachedMethods = new SimpleArrayMap();
    private static final ColorFilterLruCache COLOR_FILTER_CACHE = new ColorFilterLruCache(6);
    private static final Class[] INT_ARG = new Class[]{Integer.TYPE};

    DrawableReflectiveUtils() {
    }

    private static <T> T tryInvoke(Object target, String methodName, Class<?>[] argTypes, Object ... args) {
        try {
            Method method = (Method)sCachedMethods.get((Object)methodName);
            if (method != null) {
                return (T)method.invoke(target, args);
            }
            method = target.getClass().getDeclaredMethod(methodName, argTypes);
            sCachedMethods.put((Object)methodName, (Object)method);
            return (T)method.invoke(target, args);
        }
        catch (Exception pokemon) {
            Log.e((String)TAG, (String)("Unable to invoke " + methodName + " on " + target), (Throwable)pokemon);
            return null;
        }
    }

    static PorterDuffColorFilter setColor(PorterDuffColorFilter cf, int color, PorterDuff.Mode mode) {
        if (!Android.isLollipop()) {
            PorterDuffColorFilter filter = COLOR_FILTER_CACHE.get(color, mode);
            if (filter == null) {
                filter = new PorterDuffColorFilter(color, mode);
                COLOR_FILTER_CACHE.put(color, mode, filter);
            }
            return filter;
        }
        DrawableReflectiveUtils.tryInvoke(cf, "setColor", INT_ARG, color);
        return cf;
    }

    private static class ColorFilterLruCache
    extends LruCache<Integer, PorterDuffColorFilter> {
        ColorFilterLruCache(int maxSize) {
            super(maxSize);
        }

        PorterDuffColorFilter get(int color, PorterDuff.Mode mode) {
            return (PorterDuffColorFilter)this.get(ColorFilterLruCache.generateCacheKey(color, mode));
        }

        PorterDuffColorFilter put(int color, PorterDuff.Mode mode, PorterDuffColorFilter filter) {
            return (PorterDuffColorFilter)this.put(ColorFilterLruCache.generateCacheKey(color, mode), filter);
        }

        private static int generateCacheKey(int color, PorterDuff.Mode mode) {
            int hashCode = 1;
            hashCode = 31 * hashCode + color;
            hashCode = 31 * hashCode + mode.hashCode();
            return hashCode;
        }
    }
}

