/*
 * Decompiled with CFR 0.152.
 */
package codetail.graphics.drawables;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.animation.LinearInterpolator;
import codetail.graphics.drawables.AnimatorsCompat;
import codetail.graphics.drawables.MathUtils;
import codetail.graphics.drawables.RippleDrawable;

class RippleBackground {
    private static final TimeInterpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    private static final float GLOBAL_SPEED = 1.0f;
    private static final float WAVE_OPACITY_DECAY_VELOCITY = 3.0f;
    private static final float WAVE_OUTER_OPACITY_EXIT_VELOCITY_MAX = 4.5f;
    private static final float WAVE_OUTER_OPACITY_EXIT_VELOCITY_MIN = 1.5f;
    private static final float WAVE_OUTER_SIZE_INFLUENCE_MAX = 200.0f;
    private static final float WAVE_OUTER_SIZE_INFLUENCE_MIN = 40.0f;
    private static final int ENTER_DURATION = 667;
    private static final int ENTER_DURATION_FAST = 100;
    private final RippleDrawable mOwner;
    private final Rect mBounds;
    private int mColor;
    private float mOuterRadius;
    private float mDensity;
    private ObjectAnimator mAnimOuterOpacity;
    private Paint mTempPaint;
    private float mOuterOpacity = 0.0f;
    private float mOuterX;
    private float mOuterY;
    private boolean mHasMaxRadius;

    public RippleBackground(RippleDrawable owner, Rect bounds) {
        this.mOwner = owner;
        this.mBounds = bounds;
    }

    public void setup(int maxRadius, float density) {
        if (maxRadius != -1) {
            this.mHasMaxRadius = true;
            this.mOuterRadius = maxRadius;
        } else {
            float halfWidth = (float)this.mBounds.width() / 2.0f;
            float halfHeight = (float)this.mBounds.height() / 2.0f;
            this.mOuterRadius = (float)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
        }
        this.mOuterX = 0.0f;
        this.mOuterY = 0.0f;
        this.mDensity = density;
    }

    public void onHotspotBoundsChanged() {
        if (!this.mHasMaxRadius) {
            float halfWidth = (float)this.mBounds.width() / 2.0f;
            float halfHeight = (float)this.mBounds.height() / 2.0f;
            this.mOuterRadius = (float)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
        }
    }

    public void setOuterOpacity(float a) {
        this.mOuterOpacity = a;
        this.invalidateSelf();
    }

    public float getOuterOpacity() {
        return this.mOuterOpacity;
    }

    public boolean draw(Canvas c, Paint p) {
        this.mColor = p.getColor();
        return this.drawSoftware(c, p);
    }

    public boolean shouldDraw() {
        return this.mOuterOpacity > 0.0f && this.mOuterRadius > 0.0f;
    }

    private boolean drawSoftware(Canvas c, Paint p) {
        boolean hasContent = false;
        int paintAlpha = p.getAlpha();
        int alpha = (int)((float)paintAlpha * this.mOuterOpacity + 0.5f);
        float radius = this.mOuterRadius;
        if (alpha > 0 && radius > 0.0f) {
            p.setAlpha(alpha);
            c.drawCircle(this.mOuterX, this.mOuterY, radius, p);
            p.setAlpha(paintAlpha);
            hasContent = true;
        }
        return hasContent;
    }

    public void getBounds(Rect bounds) {
        int outerX = (int)this.mOuterX;
        int outerY = (int)this.mOuterY;
        int r = (int)this.mOuterRadius + 1;
        bounds.set(outerX - r, outerY - r, outerX + r, outerY + r);
    }

    public void enter(boolean fast) {
        this.cancel();
        ObjectAnimator opacity = ObjectAnimator.ofFloat((Object)this, (String)"outerOpacity", (float[])new float[]{0.0f, 1.0f});
        opacity.setDuration(fast ? 100L : 667L);
        opacity.setInterpolator(LINEAR_INTERPOLATOR);
        this.mAnimOuterOpacity = opacity;
        AnimatorsCompat.startWithAutoCancel(opacity);
    }

    public void exit() {
        this.cancel();
        int opacityDuration = 333;
        float outerSizeInfluence = MathUtils.constrain((this.mOuterRadius - 40.0f * this.mDensity) / (200.0f * this.mDensity), 0.0f, 1.0f);
        float outerOpacityVelocity = MathUtils.lerp(1.5f, 4.5f, outerSizeInfluence);
        int inflectionDuration = Math.max(0, (int)(1000.0f * (1.0f - this.mOuterOpacity) / (3.0f + outerOpacityVelocity) + 0.5f));
        int inflectionOpacity = (int)((float)Color.alpha((int)this.mColor) * (this.mOuterOpacity + (float)inflectionDuration * outerOpacityVelocity * outerSizeInfluence / 1000.0f) + 0.5f);
        this.exitSoftware(333, inflectionDuration, inflectionOpacity);
    }

    public void jump() {
        this.endSoftwareAnimations();
    }

    private void endSoftwareAnimations() {
        if (this.mAnimOuterOpacity != null) {
            this.mAnimOuterOpacity.end();
            this.mAnimOuterOpacity = null;
        }
    }

    private Paint getTempPaint(Paint original) {
        if (this.mTempPaint == null) {
            this.mTempPaint = new Paint();
        }
        this.mTempPaint.set(original);
        return this.mTempPaint;
    }

    private void exitSoftware(int opacityDuration, int inflectionDuration, int inflectionOpacity) {
        ObjectAnimator outerOpacityAnim;
        if (inflectionDuration > 0) {
            outerOpacityAnim = ObjectAnimator.ofFloat((Object)this, (String)"outerOpacity", (float[])new float[]{(float)inflectionOpacity / 255.0f});
            outerOpacityAnim.setDuration((long)inflectionDuration);
            outerOpacityAnim.setInterpolator(LINEAR_INTERPOLATOR);
            final int outerDuration = opacityDuration - inflectionDuration;
            if (outerDuration > 0) {
                outerOpacityAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        ObjectAnimator outerFadeOutAnim = ObjectAnimator.ofFloat((Object)RippleBackground.this, (String)"outerOpacity", (float[])new float[]{0.0f});
                        outerFadeOutAnim.setDuration((long)outerDuration);
                        outerFadeOutAnim.setInterpolator(LINEAR_INTERPOLATOR);
                        RippleBackground.this.mAnimOuterOpacity = outerFadeOutAnim;
                        AnimatorsCompat.startWithAutoCancel(outerFadeOutAnim);
                    }

                    public void onAnimationCancel(Animator animation) {
                        animation.removeListener((Animator.AnimatorListener)this);
                    }
                });
            }
        } else {
            outerOpacityAnim = ObjectAnimator.ofFloat((Object)this, (String)"outerOpacity", (float[])new float[]{0.0f});
            outerOpacityAnim.setDuration((long)opacityDuration);
        }
        this.mAnimOuterOpacity = outerOpacityAnim;
        AnimatorsCompat.startWithAutoCancel(outerOpacityAnim);
    }

    public void cancel() {
        this.cancelSoftwareAnimations();
    }

    private void cancelSoftwareAnimations() {
        if (this.mAnimOuterOpacity != null) {
            this.mAnimOuterOpacity.cancel();
            this.mAnimOuterOpacity = null;
        }
    }

    private void invalidateSelf() {
        this.mOwner.invalidateSelf();
    }
}

