/*
 * Decompiled with CFR 0.152.
 */
package codetail.graphics.drawables;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import codetail.graphics.drawables.LollipopDrawable;
import java.lang.ref.WeakReference;

public class DrawableHotspotTouch
implements View.OnTouchListener {
    LollipopDrawable mHotspotDrawable;
    PerformClick mPerformClick;
    CheckForTap mPendingCheckForTap;
    CheckForLongPress mPendingCheckForLongPress;
    UnsetPressedState mUnsetPressedState;
    boolean mHasPerformedLongPress;
    int mTouchSlop;
    boolean mPrePressed;
    boolean mInsideScrollContainer;

    public DrawableHotspotTouch() {
        this(null);
    }

    public DrawableHotspotTouch(LollipopDrawable hotspot) {
        this.mHotspotDrawable = hotspot;
        this.mTouchSlop = -1;
    }

    public void setInsideScrollContainer(boolean inside) {
        this.mInsideScrollContainer = inside;
    }

    public boolean onTouch(View v, MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        if (v.isClickable() || v.isLongClickable()) {
            switch (event.getAction()) {
                case 1: {
                    if (!this.mPrePressed && !v.isPressed()) break;
                    boolean focusTaken = false;
                    if (v.isFocusable() && v.isFocusableInTouchMode() && !v.isFocused()) {
                        focusTaken = v.requestFocus();
                    }
                    if (this.mPrePressed) {
                        this.setPressed(v, true, x, y);
                    }
                    if (!this.mHasPerformedLongPress) {
                        this.removeLongPressCallback(v);
                        if (!focusTaken) {
                            if (this.mPerformClick == null) {
                                this.mPerformClick = new PerformClick(v);
                            }
                            if (!v.post((Runnable)this.mPerformClick)) {
                                v.performClick();
                            }
                        }
                    }
                    if (this.mUnsetPressedState == null) {
                        this.mUnsetPressedState = new UnsetPressedState(v);
                    }
                    if (this.mPrePressed) {
                        v.postDelayed((Runnable)this.mUnsetPressedState, (long)ViewConfiguration.getPressedStateDuration());
                    } else if (!v.post((Runnable)this.mUnsetPressedState)) {
                        this.mUnsetPressedState.run();
                    }
                    this.removeTapCallback(v);
                    break;
                }
                case 0: {
                    this.mHasPerformedLongPress = false;
                    if (this.mInsideScrollContainer) {
                        this.mPrePressed = true;
                        if (this.mPendingCheckForTap == null) {
                            this.mPendingCheckForTap = new CheckForTap(v);
                        }
                        this.mPendingCheckForTap.x = event.getX();
                        this.mPendingCheckForTap.y = event.getY();
                        v.postDelayed((Runnable)this.mPendingCheckForTap, (long)ViewConfiguration.getTapTimeout());
                        break;
                    }
                    this.setPressed(v, true, x, y);
                    this.checkForLongClick(v, 0);
                    break;
                }
                case 2: {
                    this.mHotspotDrawable.setHotspot(x, y);
                    if (this.mTouchSlop == -1) {
                        this.mTouchSlop = ViewConfiguration.get((Context)v.getContext()).getScaledTouchSlop();
                    }
                    if (this.pointInView(v, x, y, this.mTouchSlop)) break;
                    this.removeTapCallback(v);
                    if (!v.isPressed()) break;
                    this.removeLongPressCallback(v);
                    v.setPressed(false);
                    break;
                }
                case 3: {
                    v.setPressed(false);
                    this.removeTapCallback(v);
                    this.removeLongPressCallback(v);
                }
            }
            return true;
        }
        return false;
    }

    private void checkForLongClick(View target, int delayOffset) {
        if (target.isLongClickable()) {
            this.mHasPerformedLongPress = false;
            if (this.mPendingCheckForLongPress == null) {
                this.mPendingCheckForLongPress = new CheckForLongPress(target);
            }
            target.postDelayed((Runnable)this.mPendingCheckForLongPress, (long)(ViewConfiguration.getLongPressTimeout() - delayOffset));
        }
    }

    void setPressed(View target, boolean pressed, float x, float y) {
        target.setPressed(pressed);
        this.mHotspotDrawable.setHotspot(x, y);
    }

    public boolean pointInView(View target, float localX, float localY, float slop) {
        return localX >= -slop && localY >= -slop && localX < (float)(target.getRight() - target.getLeft()) + slop && localY < (float)(target.getBottom() - target.getTop()) + slop;
    }

    void removeTapCallback(View target) {
        if (this.mPendingCheckForTap != null) {
            target.removeCallbacks((Runnable)this.mPendingCheckForTap);
        }
    }

    void removeLongPressCallback(View target) {
        if (this.mPendingCheckForLongPress != null) {
            target.removeCallbacks((Runnable)this.mPendingCheckForLongPress);
        }
    }

    private final class UnsetPressedState
    implements Runnable {
        View target;

        private UnsetPressedState(View target) {
            this.target = target;
        }

        @Override
        public void run() {
            this.target.setPressed(false);
        }
    }

    private final class CheckForLongPress
    implements Runnable {
        View target;

        private CheckForLongPress(View target) {
            this.target = target;
        }

        @Override
        public void run() {
            if (this.target.isPressed() && this.target.getParent() != null && this.target.performLongClick()) {
                DrawableHotspotTouch.this.mHasPerformedLongPress = true;
            }
        }
    }

    final class CheckForTap
    implements Runnable {
        View target;
        float x;
        float y;

        CheckForTap(View target) {
            this.target = target;
        }

        @Override
        public void run() {
            DrawableHotspotTouch.this.mPrePressed = true;
            DrawableHotspotTouch.this.setPressed(this.target, true, this.x, this.y);
            DrawableHotspotTouch.this.checkForLongClick(this.target, ViewConfiguration.getTapTimeout());
        }
    }

    private static final class PerformClick
    implements Runnable {
        WeakReference<View> target;

        private PerformClick(View target) {
            this.target = new WeakReference<View>(target);
        }

        @Override
        public void run() {
            if (this.target.get() != null) {
                ((View)this.target.get()).performClick();
            }
        }
    }
}

