/*
 * Decompiled with CFR 0.152.
 */
package codetail.graphics.drawables;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.animation.LinearInterpolator;
import codetail.graphics.drawables.AnimatorsCompat;
import codetail.graphics.drawables.MathUtils;
import codetail.graphics.drawables.RippleDrawable;

class Ripple {
    private static final TimeInterpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    private static final TimeInterpolator DECEL_INTERPOLATOR = new LogInterpolator();
    private static final float GLOBAL_SPEED = 1.0f;
    private static final float WAVE_TOUCH_DOWN_ACCELERATION = 1024.0f;
    private static final float WAVE_TOUCH_UP_ACCELERATION = 3400.0f;
    private static final float WAVE_OPACITY_DECAY_VELOCITY = 3.0f;
    private static final long RIPPLE_ENTER_DELAY = 80L;
    private final RippleDrawable mOwner;
    private final Rect mBounds;
    private float mOuterRadius;
    private float mDensity;
    private float mStartingX;
    private float mStartingY;
    private float mClampedStartingX;
    private float mClampedStartingY;
    private ObjectAnimator mAnimRadius;
    private ObjectAnimator mAnimOpacity;
    private ObjectAnimator mAnimX;
    private ObjectAnimator mAnimY;
    private Paint mTempPaint;
    private float mOpacity = 1.0f;
    private float mOuterX;
    private float mOuterY;
    private float mTweenRadius = 0.0f;
    private float mTweenX = 0.0f;
    private float mTweenY = 0.0f;
    private boolean mHasMaxRadius;
    private boolean mCanceled;
    private final AnimatorListenerAdapter mAnimationListener = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animation) {
            Ripple.this.removeSelf();
        }
    };

    public Ripple(RippleDrawable owner, Rect bounds, float startingX, float startingY) {
        this.mOwner = owner;
        this.mBounds = bounds;
        this.mStartingX = startingX;
        this.mStartingY = startingY;
    }

    public void setup(int maxRadius, float density) {
        if (maxRadius != -1) {
            this.mHasMaxRadius = true;
            this.mOuterRadius = maxRadius;
        } else {
            float halfWidth = (float)this.mBounds.width() / 2.0f;
            float halfHeight = (float)this.mBounds.height() / 2.0f;
            this.mOuterRadius = (float)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
        }
        this.mOuterX = 0.0f;
        this.mOuterY = 0.0f;
        this.mDensity = density;
        this.clampStartingPosition();
    }

    private void clampStartingPosition() {
        float r;
        float cY;
        float dY;
        float cX = this.mBounds.exactCenterX();
        float dX = this.mStartingX - cX;
        if (dX * dX + (dY = this.mStartingY - (cY = this.mBounds.exactCenterY())) * dY > (r = this.mOuterRadius) * r) {
            double angle = Math.atan2(dY, dX);
            this.mClampedStartingX = cX + (float)(Math.cos(angle) * (double)r);
            this.mClampedStartingY = cY + (float)(Math.sin(angle) * (double)r);
        } else {
            this.mClampedStartingX = this.mStartingX;
            this.mClampedStartingY = this.mStartingY;
        }
    }

    public void onHotspotBoundsChanged() {
        if (!this.mHasMaxRadius) {
            float halfWidth = (float)this.mBounds.width() / 2.0f;
            float halfHeight = (float)this.mBounds.height() / 2.0f;
            this.mOuterRadius = (float)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
            this.clampStartingPosition();
        }
    }

    public void setOpacity(float a) {
        this.mOpacity = a;
        this.invalidateSelf();
    }

    public float getOpacity() {
        return this.mOpacity;
    }

    public void setRadiusGravity(float r) {
        this.mTweenRadius = r;
        this.invalidateSelf();
    }

    public float getRadiusGravity() {
        return this.mTweenRadius;
    }

    public void setXGravity(float x) {
        this.mTweenX = x;
        this.invalidateSelf();
    }

    public float getXGravity() {
        return this.mTweenX;
    }

    public void setYGravity(float y) {
        this.mTweenY = y;
        this.invalidateSelf();
    }

    public float getYGravity() {
        return this.mTweenY;
    }

    public boolean draw(Canvas c, Paint p) {
        boolean hasContent = false;
        int paintAlpha = p.getAlpha();
        int alpha = (int)((float)paintAlpha * this.mOpacity + 0.5f);
        float radius = MathUtils.lerp(0.0f, this.mOuterRadius, this.mTweenRadius);
        if (alpha > 0 && radius > 0.0f) {
            float x = MathUtils.lerp(this.mClampedStartingX - this.mBounds.exactCenterX(), this.mOuterX, this.mTweenX);
            float y = MathUtils.lerp(this.mClampedStartingY - this.mBounds.exactCenterY(), this.mOuterY, this.mTweenY);
            p.setAlpha(alpha);
            c.drawCircle(x, y, radius, p);
            p.setAlpha(paintAlpha);
            hasContent = true;
        }
        return hasContent;
    }

    public void getBounds(Rect bounds) {
        int outerX = (int)this.mOuterX;
        int outerY = (int)this.mOuterY;
        int r = (int)this.mOuterRadius + 1;
        bounds.set(outerX - r, outerY - r, outerX + r, outerY + r);
    }

    public void move(float x, float y) {
        this.mStartingX = x;
        this.mStartingY = y;
        this.clampStartingPosition();
    }

    public void enter() {
        this.cancel();
        int radiusDuration = (int)(1000.0 * Math.sqrt(this.mOuterRadius / 1024.0f * this.mDensity) + 0.5);
        ObjectAnimator radius = ObjectAnimator.ofFloat((Object)this, (String)"radiusGravity", (float[])new float[]{1.0f});
        radius.setDuration((long)radiusDuration);
        radius.setInterpolator(LINEAR_INTERPOLATOR);
        radius.setStartDelay(80L);
        ObjectAnimator cX = ObjectAnimator.ofFloat((Object)this, (String)"xGravity", (float[])new float[]{1.0f});
        cX.setDuration((long)radiusDuration);
        cX.setInterpolator(LINEAR_INTERPOLATOR);
        cX.setStartDelay(80L);
        ObjectAnimator cY = ObjectAnimator.ofFloat((Object)this, (String)"yGravity", (float[])new float[]{1.0f});
        cY.setDuration((long)radiusDuration);
        cY.setInterpolator(LINEAR_INTERPOLATOR);
        cY.setStartDelay(80L);
        this.mAnimRadius = radius;
        this.mAnimX = cX;
        this.mAnimY = cY;
        radius.start();
        cX.start();
        cY.start();
        AnimatorsCompat.startWithAutoCancel(radius);
        AnimatorsCompat.startWithAutoCancel(cX);
        AnimatorsCompat.startWithAutoCancel(cY);
    }

    public void exit() {
        float radius = MathUtils.lerp(0.0f, this.mOuterRadius, this.mTweenRadius);
        float remaining = this.mAnimRadius != null && this.mAnimRadius.isRunning() ? this.mOuterRadius - radius : this.mOuterRadius;
        this.cancel();
        int radiusDuration = (int)(1000.0 * Math.sqrt(remaining / 4424.0f * this.mDensity) + 0.5);
        int opacityDuration = (int)(1000.0f * this.mOpacity / 3.0f + 0.5f);
        this.exitSoftware(radiusDuration, opacityDuration);
    }

    public void jump() {
        this.mCanceled = true;
        this.endSoftwareAnimations();
        this.mCanceled = false;
    }

    private void endSoftwareAnimations() {
        if (this.mAnimRadius != null) {
            this.mAnimRadius.end();
            this.mAnimRadius = null;
        }
        if (this.mAnimOpacity != null) {
            this.mAnimOpacity.end();
            this.mAnimOpacity = null;
        }
        if (this.mAnimX != null) {
            this.mAnimX.end();
            this.mAnimX = null;
        }
        if (this.mAnimY != null) {
            this.mAnimY.end();
            this.mAnimY = null;
        }
    }

    private Paint getTempPaint(Paint original) {
        if (this.mTempPaint == null) {
            this.mTempPaint = new Paint();
        }
        this.mTempPaint.set(original);
        return this.mTempPaint;
    }

    private void exitSoftware(int radiusDuration, int opacityDuration) {
        ObjectAnimator radiusAnim = ObjectAnimator.ofFloat((Object)this, (String)"radiusGravity", (float[])new float[]{1.0f});
        radiusAnim.setDuration((long)radiusDuration);
        radiusAnim.setInterpolator(DECEL_INTERPOLATOR);
        ObjectAnimator xAnim = ObjectAnimator.ofFloat((Object)this, (String)"xGravity", (float[])new float[]{1.0f});
        xAnim.setDuration((long)radiusDuration);
        xAnim.setInterpolator(DECEL_INTERPOLATOR);
        ObjectAnimator yAnim = ObjectAnimator.ofFloat((Object)this, (String)"yGravity", (float[])new float[]{1.0f});
        yAnim.setDuration((long)radiusDuration);
        yAnim.setInterpolator(DECEL_INTERPOLATOR);
        ObjectAnimator opacityAnim = ObjectAnimator.ofFloat((Object)this, (String)"opacity", (float[])new float[]{0.0f});
        opacityAnim.setDuration((long)opacityDuration);
        opacityAnim.setInterpolator(LINEAR_INTERPOLATOR);
        opacityAnim.addListener((Animator.AnimatorListener)this.mAnimationListener);
        this.mAnimRadius = radiusAnim;
        this.mAnimOpacity = opacityAnim;
        this.mAnimX = xAnim;
        this.mAnimY = yAnim;
        AnimatorsCompat.startWithAutoCancel(radiusAnim);
        AnimatorsCompat.startWithAutoCancel(opacityAnim);
        AnimatorsCompat.startWithAutoCancel(xAnim);
        AnimatorsCompat.startWithAutoCancel(yAnim);
    }

    public void cancel() {
        this.mCanceled = true;
        this.cancelSoftwareAnimations();
        this.mCanceled = false;
    }

    private void cancelSoftwareAnimations() {
        if (this.mAnimRadius != null) {
            this.mAnimRadius.cancel();
            this.mAnimRadius = null;
        }
        if (this.mAnimOpacity != null) {
            this.mAnimOpacity.cancel();
            this.mAnimOpacity = null;
        }
        if (this.mAnimX != null) {
            this.mAnimX.cancel();
            this.mAnimX = null;
        }
        if (this.mAnimY != null) {
            this.mAnimY.cancel();
            this.mAnimY = null;
        }
    }

    private void removeSelf() {
        if (!this.mCanceled) {
            this.mOwner.removeRipple(this);
        }
    }

    private void invalidateSelf() {
        this.mOwner.invalidateSelf();
    }

    private static final class LogInterpolator
    implements TimeInterpolator {
        private LogInterpolator() {
        }

        public float getInterpolation(float input) {
            return 1.0f - (float)Math.pow(400.0, (double)(-input) * 1.4);
        }
    }
}

