/*
 * Decompiled with CFR 0.152.
 */
package com.acsbendi.requestinspectorwebview;

import android.graphics.Bitmap;
import android.util.Log;
import android.webkit.CookieManager;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.acsbendi.requestinspectorwebview.RequestInspectorJavaScriptInterface;
import com.acsbendi.requestinspectorwebview.RequestInspectorOptions;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\f\u0010\u0014\u001a\u00020\r*\u00020\u0013H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/acsbendi/requestinspectorwebview/RequestInspectorWebViewClient;", "Landroid/webkit/WebViewClient;", "webView", "Landroid/webkit/WebView;", "options", "Lcom/acsbendi/requestinspectorwebview/RequestInspectorOptions;", "(Landroid/webkit/WebView;Lcom/acsbendi/requestinspectorwebview/RequestInspectorOptions;)V", "interceptionJavascriptInterface", "Lcom/acsbendi/requestinspectorwebview/RequestInspectorJavaScriptInterface;", "onPageStarted", "", "view", "url", "", "favicon", "Landroid/graphics/Bitmap;", "shouldInterceptRequest", "Landroid/webkit/WebResourceResponse;", "request", "Landroid/webkit/WebResourceRequest;", "toJsonStringWithCookies", "Companion", "app_release"})
public final class RequestInspectorWebViewClient
extends WebViewClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RequestInspectorOptions options;
    @NotNull
    private final RequestInspectorJavaScriptInterface interceptionJavascriptInterface;
    @NotNull
    private static final String LOG_TAG = "RequestInspectorWebView";

    @JvmOverloads
    public RequestInspectorWebViewClient(@NotNull WebView webView, @NotNull RequestInspectorOptions options) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
        this.interceptionJavascriptInterface = new RequestInspectorJavaScriptInterface();
        webView.addJavascriptInterface((Object)this.interceptionJavascriptInterface, "RequestInspection");
    }

    public /* synthetic */ RequestInspectorWebViewClient(WebView webView, RequestInspectorOptions requestInspectorOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            requestInspectorOptions = new RequestInspectorOptions(null, 1, null);
        }
        this(webView, requestInspectorOptions);
    }

    @Nullable
    public WebResourceResponse shouldInterceptRequest(@NotNull WebView view, @NotNull WebResourceRequest request) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Log.i((String)LOG_TAG, (String)Intrinsics.stringPlus((String)"Received request: ", (Object)this.toJsonStringWithCookies(request)));
        String string = request.getUrl().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.url.toString()");
        RequestInspectorJavaScriptInterface.RecordedRequest recordedRequest = this.interceptionJavascriptInterface.findRecordedRequestForUrl(string);
        Log.i((String)LOG_TAG, (String)Intrinsics.stringPlus((String)"Corresponding recorded request: ", (Object)recordedRequest));
        return null;
    }

    public void onPageStarted(@NotNull WebView view, @NotNull String url, @Nullable Bitmap favicon) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Log.i((String)LOG_TAG, (String)Intrinsics.stringPlus((String)"Page started loading, enabling request inspection. URL: ", (Object)url));
        RequestInspectorJavaScriptInterface.Companion.enableInterception(view, this.options.getExtraJavaScriptToInject());
        super.onPageStarted(view, url, favicon);
    }

    private final String toJsonStringWithCookies(WebResourceRequest $this$toJsonStringWithCookies) {
        String cookies = CookieManager.getInstance().getCookie($this$toJsonStringWithCookies.getUrl().toString());
        HashMap headers = new HashMap($this$toJsonStringWithCookies.getRequestHeaders());
        Object object = headers;
        String string = "Cookie";
        boolean bl = false;
        object.put(string, cookies);
        StringBuilder stringBuilder = new StringBuilder().append("{ \"url\": \"");
        object = $this$toJsonStringWithCookies.getUrl().toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"url.toString()");
        StringBuilder stringBuilder2 = stringBuilder.append(StringsKt.replace$default((String)object, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null)).append("\", \"method\": \"");
        object = $this$toJsonStringWithCookies.getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"method");
        StringBuilder stringBuilder3 = stringBuilder2.append(StringsKt.replace$default((String)object, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null)).append("\", \"isForMainFrame\": ").append($this$toJsonStringWithCookies.isForMainFrame()).append(", \"hasGesture\": ").append($this$toJsonStringWithCookies.hasGesture()).append(", \"headers\": \"");
        object = headers.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"headers.toString()");
        return stringBuilder3.append(StringsKt.replace$default((String)object, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null)).append("\" }").toString();
    }

    @JvmOverloads
    public RequestInspectorWebViewClient(@NotNull WebView webView) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        this(webView, null, 2, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/acsbendi/requestinspectorwebview/RequestInspectorWebViewClient$Companion;", "", "()V", "LOG_TAG", "", "app_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

