/*
 * Decompiled with CFR 0.152.
 */
package io.unico.unicosdkbase.totp;

import io.unico.unicosdkbase.totp.HMACAlgorithm;
import io.unico.unicosdkbase.totp.TOTP;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.codec.binary.Base32;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/unico/unicosdkbase/totp/OTP;", "", "builder", "Lio/unico/unicosdkbase/totp/TOTP$Builder;", "(Lio/unico/unicosdkbase/totp/TOTP$Builder;)V", "algorithm", "Lio/unico/unicosdkbase/totp/HMACAlgorithm;", "passwordLength", "", "secret", "", "decodeBase32", "value", "generate", "", "counter", "", "generateHash", "data", "getCodeFromHash", "hash", "longToBytes", "validatePasswordLength", "", "Builder", "Companion", "totp_release"})
public class OTP {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private int passwordLength;
    @Nullable
    private HMACAlgorithm algorithm;
    @NotNull
    private byte[] secret;
    @Deprecated
    public static final int BYTE = 8;
    @Deprecated
    public static final int TWO = 2;
    @Deprecated
    public static final int THREE = 3;
    @Deprecated
    public static final int FOUR = 4;
    @Deprecated
    public static final int HEXADECIMAL = Integer.MAX_VALUE;
    @Deprecated
    public static final int MIN_PASSWORD_LENGTH = 6;
    @Deprecated
    public static final int MAX_PASSWORD_LENGTH = 8;

    public OTP(@NotNull TOTP.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (!this.validatePasswordLength(builder.getPasswordLength())) {
            boolean $i$a$-require-OTP$32 = false;
            String $i$a$-require-OTP$32 = "Password length must be between 6 and 8 digits";
            throw new IllegalArgumentException($i$a$-require-OTP$32.toString());
        }
        if (!(!(builder.getSecret().length == 0))) {
            boolean bl = false;
            String string = "Secret must not be empty";
            throw new IllegalArgumentException(string.toString());
        }
        this.passwordLength = builder.getPasswordLength();
        this.algorithm = builder.getAlgorithm();
        this.secret = builder.getSecret();
    }

    @NotNull
    public String generate(long counter) throws IllegalStateException {
        if (!(counter >= 0L)) {
            boolean $i$a$-require-OTP$generate$22 = false;
            String $i$a$-require-OTP$generate$22 = "Counter must be greater than or equal to 0";
            throw new IllegalArgumentException($i$a$-require-OTP$generate$22.toString());
        }
        byte[] secretBytes = this.decodeBase32(this.secret);
        byte[] counterBytes = this.longToBytes(counter);
        byte[] hash = this.generateHash(secretBytes, counterBytes);
        return this.getCodeFromHash(hash);
    }

    private final byte[] decodeBase32(byte[] value) {
        Base32 codec = new Base32();
        byte[] byArray = codec.decode(value);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"codec.decode(value)");
        return byArray;
    }

    private final byte[] longToBytes(long value) {
        byte[] byArray = ByteBuffer.allocate(8).putLong(value).array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"allocate(BYTE).putLong(value).array()");
        return byArray;
    }

    private final byte[] generateHash(byte[] secret, byte[] data) throws InvalidKeyException, NoSuchAlgorithmException {
        SecretKeySpec signKey = new SecretKeySpec(secret, "RAW");
        HMACAlgorithm hMACAlgorithm = this.algorithm;
        Intrinsics.checkNotNull((Object)((Object)hMACAlgorithm));
        Mac mac = Mac.getInstance(hMACAlgorithm.getHMACName());
        mac.init(signKey);
        byte[] byArray = mac.doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"mac.doFinal(data)");
        return byArray;
    }

    private final String getCodeFromHash(byte[] hash) {
        int mask = 15;
        byte lastByte = hash[hash.length - 1];
        byte offset = (byte)(lastByte & (byte)mask);
        byte[] byArray = new byte[]{hash[offset], hash[offset + 1], hash[offset + 2], hash[offset + 3]};
        byte[] truncatedHashInBytes = byArray;
        ByteBuffer byteBuffer = ByteBuffer.wrap(truncatedHashInBytes);
        long truncatedHash = byteBuffer.getInt();
        truncatedHash &= Integer.MAX_VALUE;
        String string = "%0" + this.passwordLength + 'd';
        Object[] objectArray = new Object[]{truncatedHash %= (long)Math.pow(10.0, this.passwordLength)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    private final boolean validatePasswordLength(int passwordLength) {
        return 6 <= passwordLength ? passwordLength < 9 : false;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/unico/unicosdkbase/totp/OTP$Companion;", "", "()V", "BYTE", "", "FOUR", "HEXADECIMAL", "MAX_PASSWORD_LENGTH", "MIN_PASSWORD_LENGTH", "THREE", "TWO", "totp_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0011\b&\u0018\u0000 \u001f*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u0002*\u0014\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00002\u00020\u0004:\u0001\u001fB\u000f\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\r\u0010\u0019\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001b\u001a\u00028\u00012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\u00028\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u001eR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00028\u0001X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lio/unico/unicosdkbase/totp/OTP$Builder;", "T", "Lio/unico/unicosdkbase/totp/OTP;", "B", "", "secret", "", "([B)V", "algorithm", "Lio/unico/unicosdkbase/totp/HMACAlgorithm;", "getAlgorithm", "()Lio/unico/unicosdkbase/totp/HMACAlgorithm;", "setAlgorithm", "(Lio/unico/unicosdkbase/totp/HMACAlgorithm;)V", "passwordLength", "", "getPasswordLength", "()I", "setPasswordLength", "(I)V", "getSecret", "()[B", "topBuilder", "getTopBuilder", "()Lio/unico/unicosdkbase/totp/OTP$Builder;", "build", "()Lio/unico/unicosdkbase/totp/OTP;", "withAlgorithm", "(Lio/unico/unicosdkbase/totp/HMACAlgorithm;)Lio/unico/unicosdkbase/totp/OTP$Builder;", "withPasswordLength", "(I)Lio/unico/unicosdkbase/totp/OTP$Builder;", "Companion", "totp_release"})
    public static abstract class Builder<T extends OTP, B extends Builder<T, B>> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private final byte[] secret;
        private int passwordLength;
        @NotNull
        private HMACAlgorithm algorithm;
        @Deprecated
        public static final int DEFAULT_PASSWORD_LENGTH = 6;
        @Deprecated
        @NotNull
        private static final HMACAlgorithm DEFAULT_HMAC_ALGORITHM = HMACAlgorithm.SHA1;

        protected Builder(@NotNull byte[] secret) {
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            this.secret = secret;
            this.passwordLength = 6;
            this.algorithm = DEFAULT_HMAC_ALGORITHM;
        }

        @NotNull
        public final byte[] getSecret() {
            return this.secret;
        }

        @NotNull
        protected abstract B getTopBuilder();

        public abstract T build();

        public final int getPasswordLength() {
            return this.passwordLength;
        }

        public final void setPasswordLength(int n) {
            this.passwordLength = n;
        }

        @NotNull
        public final HMACAlgorithm getAlgorithm() {
            return this.algorithm;
        }

        public final void setAlgorithm(@NotNull HMACAlgorithm hMACAlgorithm) {
            Intrinsics.checkNotNullParameter((Object)((Object)hMACAlgorithm), (String)"<set-?>");
            this.algorithm = hMACAlgorithm;
        }

        @NotNull
        public final B withPasswordLength(int passwordLength) {
            this.passwordLength = passwordLength;
            return this.getTopBuilder();
        }

        @NotNull
        public final B withAlgorithm(@NotNull HMACAlgorithm algorithm) {
            Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
            this.algorithm = algorithm;
            return this.getTopBuilder();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/unico/unicosdkbase/totp/OTP$Builder$Companion;", "", "()V", "DEFAULT_HMAC_ALGORITHM", "Lio/unico/unicosdkbase/totp/HMACAlgorithm;", "getDEFAULT_HMAC_ALGORITHM", "()Lio/unico/unicosdkbase/totp/HMACAlgorithm;", "DEFAULT_PASSWORD_LENGTH", "", "totp_release"})
        private static final class Companion {
            private Companion() {
            }

            @NotNull
            public final HMACAlgorithm getDEFAULT_HMAC_ALGORITHM() {
                return DEFAULT_HMAC_ALGORITHM;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

