/*
 * Decompiled with CFR 0.152.
 */
package com.example.camerabioandroid.camerabiomanager.exif;

import com.example.camerabioandroid.camerabiomanager.exif.ExifInterface;
import com.example.camerabioandroid.camerabiomanager.exif.ExifTag;
import java.util.HashMap;
import java.util.Map;

class IfdData {
    private final int mIfdId;
    private final Map<Short, ExifTag> mExifTags = new HashMap<Short, ExifTag>();
    private int mOffsetToNextIfd = 0;
    private static final int[] sIfds = new int[]{0, 1, 2, 3, 4};

    IfdData(int ifdId) {
        this.mIfdId = ifdId;
    }

    protected static int[] getIfds() {
        return sIfds;
    }

    protected ExifTag[] getAllTags() {
        return this.mExifTags.values().toArray(new ExifTag[this.mExifTags.size()]);
    }

    protected int getId() {
        return this.mIfdId;
    }

    protected ExifTag getTag(short tagId) {
        return this.mExifTags.get(tagId);
    }

    protected ExifTag setTag(ExifTag tag) {
        tag.setIfd(this.mIfdId);
        return this.mExifTags.put(tag.getTagId(), tag);
    }

    protected boolean checkCollision(short tagId) {
        return this.mExifTags.get(tagId) != null;
    }

    protected void removeTag(short tagId) {
        this.mExifTags.remove(tagId);
    }

    protected int getTagCount() {
        return this.mExifTags.size();
    }

    protected void setOffsetToNextIfd(int offset) {
        this.mOffsetToNextIfd = offset;
    }

    protected int getOffsetToNextIfd() {
        return this.mOffsetToNextIfd;
    }

    public boolean equals(Object obj) {
        IfdData data;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof IfdData && (data = (IfdData)obj).getId() == this.mIfdId && data.getTagCount() == this.getTagCount()) {
            ExifTag[] tags;
            for (ExifTag tag : tags = data.getAllTags()) {
                ExifTag tag2;
                if (ExifInterface.isOffsetTag(tag.getTagId()) || tag.equals(tag2 = this.mExifTags.get(tag.getTagId()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

