/*
 * Decompiled with CFR 0.152.
 */
package com.example.camerabioandroid.camerabiomanager.exif;

import com.example.camerabioandroid.camerabiomanager.exif.Rational;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class ExifTag {
    public static final short TYPE_UNSIGNED_BYTE = 1;
    public static final short TYPE_ASCII = 2;
    public static final short TYPE_UNSIGNED_SHORT = 3;
    public static final short TYPE_UNSIGNED_LONG = 4;
    public static final short TYPE_UNSIGNED_RATIONAL = 5;
    public static final short TYPE_UNDEFINED = 7;
    public static final short TYPE_LONG = 9;
    public static final short TYPE_RATIONAL = 10;
    private static Charset US_ASCII = Charset.forName("US-ASCII");
    private static final int[] TYPE_TO_SIZE_MAP = new int[11];
    private static final int UNSIGNED_SHORT_MAX = 65535;
    private static final long UNSIGNED_LONG_MAX = 0xFFFFFFFFL;
    private static final long LONG_MAX = Integer.MAX_VALUE;
    private static final long LONG_MIN = Integer.MIN_VALUE;
    static final int SIZE_UNDEFINED = 0;
    private final short mTagId;
    private final short mDataType;
    private boolean mHasDefinedDefaultComponentCount;
    private int mComponentCountActual;
    private int mIfd;
    private Object mValue;
    private int mOffset;
    private static final SimpleDateFormat TIME_FORMAT;

    public static boolean isValidIfd(int ifdId) {
        return ifdId == 0 || ifdId == 1 || ifdId == 2 || ifdId == 3 || ifdId == 4;
    }

    public static boolean isValidType(short type) {
        return type == 1 || type == 2 || type == 3 || type == 4 || type == 5 || type == 7 || type == 9 || type == 10;
    }

    ExifTag(short tagId, short type, int componentCount, int ifd, boolean hasDefinedComponentCount) {
        this.mTagId = tagId;
        this.mDataType = type;
        this.mComponentCountActual = componentCount;
        this.mHasDefinedDefaultComponentCount = hasDefinedComponentCount;
        this.mIfd = ifd;
        this.mValue = null;
    }

    public static int getElementSize(short type) {
        return TYPE_TO_SIZE_MAP[type];
    }

    public int getIfd() {
        return this.mIfd;
    }

    protected void setIfd(int ifdId) {
        this.mIfd = ifdId;
    }

    public short getTagId() {
        return this.mTagId;
    }

    public short getDataType() {
        return this.mDataType;
    }

    public int getDataSize() {
        return this.getComponentCount() * ExifTag.getElementSize(this.getDataType());
    }

    public int getComponentCount() {
        return this.mComponentCountActual;
    }

    protected void forceSetComponentCount(int count) {
        this.mComponentCountActual = count;
    }

    public boolean hasValue() {
        return this.mValue != null;
    }

    public boolean setValue(int[] value) {
        if (this.checkBadComponentCount(value.length)) {
            return false;
        }
        if (this.mDataType != 3 && this.mDataType != 9 && this.mDataType != 4) {
            return false;
        }
        if (this.mDataType == 3 && this.checkOverflowForUnsignedShort(value)) {
            return false;
        }
        if (this.mDataType == 4 && this.checkOverflowForUnsignedLong(value)) {
            return false;
        }
        long[] data = new long[value.length];
        for (int i = 0; i < value.length; ++i) {
            data[i] = value[i];
        }
        this.mValue = data;
        this.mComponentCountActual = value.length;
        return true;
    }

    public boolean setValue(int value) {
        return this.setValue(new int[]{value});
    }

    public boolean setValue(long[] value) {
        if (this.checkBadComponentCount(value.length) || this.mDataType != 4) {
            return false;
        }
        if (this.checkOverflowForUnsignedLong(value)) {
            return false;
        }
        this.mValue = value;
        this.mComponentCountActual = value.length;
        return true;
    }

    public boolean setValue(long value) {
        return this.setValue(new long[]{value});
    }

    public boolean setValue(String value) {
        byte[] buf;
        if (this.mDataType != 2 && this.mDataType != 7) {
            return false;
        }
        byte[] finalBuf = buf = value.getBytes(US_ASCII);
        if (buf.length > 0) {
            finalBuf = buf[buf.length - 1] == 0 || this.mDataType == 7 ? buf : Arrays.copyOf(buf, buf.length + 1);
        } else if (this.mDataType == 2 && this.mComponentCountActual == 1) {
            finalBuf = new byte[]{0};
        }
        int count = finalBuf.length;
        if (this.checkBadComponentCount(count)) {
            return false;
        }
        this.mComponentCountActual = count;
        this.mValue = finalBuf;
        return true;
    }

    public boolean setValue(Rational[] value) {
        if (this.checkBadComponentCount(value.length)) {
            return false;
        }
        if (this.mDataType != 5 && this.mDataType != 10) {
            return false;
        }
        if (this.mDataType == 5 && this.checkOverflowForUnsignedRational(value)) {
            return false;
        }
        if (this.mDataType == 10 && this.checkOverflowForRational(value)) {
            return false;
        }
        this.mValue = value;
        this.mComponentCountActual = value.length;
        return true;
    }

    public boolean setValue(Rational value) {
        return this.setValue(new Rational[]{value});
    }

    public boolean setValue(byte[] value, int offset, int length) {
        if (this.checkBadComponentCount(length)) {
            return false;
        }
        if (this.mDataType != 1 && this.mDataType != 7) {
            return false;
        }
        this.mValue = new byte[length];
        System.arraycopy(value, offset, this.mValue, 0, length);
        this.mComponentCountActual = length;
        return true;
    }

    public boolean setValue(byte[] value) {
        return this.setValue(value, 0, value.length);
    }

    public boolean setValue(byte value) {
        return this.setValue(new byte[]{value});
    }

    public boolean setValue(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Short) {
            return this.setValue((int)((Short)obj & 0xFFFF));
        }
        if (obj instanceof String) {
            return this.setValue((String)obj);
        }
        if (obj instanceof int[]) {
            return this.setValue((int[])obj);
        }
        if (obj instanceof long[]) {
            return this.setValue((long[])obj);
        }
        if (obj instanceof Rational) {
            return this.setValue((Rational)obj);
        }
        if (obj instanceof Rational[]) {
            return this.setValue((Rational[])obj);
        }
        if (obj instanceof byte[]) {
            return this.setValue((byte[])obj);
        }
        if (obj instanceof Integer) {
            return this.setValue((Integer)obj);
        }
        if (obj instanceof Long) {
            return this.setValue((Long)obj);
        }
        if (obj instanceof Byte) {
            return this.setValue((Byte)obj);
        }
        if (obj instanceof Short[]) {
            Short[] arr = (Short[])obj;
            int[] fin = new int[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                fin[i] = arr[i] == null ? 0 : arr[i] & 0xFFFF;
            }
            return this.setValue(fin);
        }
        if (obj instanceof Integer[]) {
            Integer[] arr = (Integer[])obj;
            int[] fin = new int[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                fin[i] = arr[i] == null ? 0 : arr[i];
            }
            return this.setValue(fin);
        }
        if (obj instanceof Long[]) {
            Long[] arr = (Long[])obj;
            long[] fin = new long[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                fin[i] = arr[i] == null ? 0L : arr[i];
            }
            return this.setValue(fin);
        }
        if (obj instanceof Byte[]) {
            Byte[] arr = (Byte[])obj;
            byte[] fin = new byte[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                fin[i] = arr[i] == null ? (byte)0 : arr[i];
            }
            return this.setValue(fin);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTimeValue(long time) {
        SimpleDateFormat simpleDateFormat = TIME_FORMAT;
        synchronized (simpleDateFormat) {
            return this.setValue(TIME_FORMAT.format(new Date(time)));
        }
    }

    public String getValueAsString() {
        if (this.mValue == null) {
            return null;
        }
        if (this.mValue instanceof String) {
            return (String)this.mValue;
        }
        if (this.mValue instanceof byte[]) {
            return new String((byte[])this.mValue, US_ASCII);
        }
        return null;
    }

    public String getValueAsString(String defaultValue) {
        String s = this.getValueAsString();
        if (s == null) {
            return defaultValue;
        }
        return s;
    }

    public byte[] getValueAsBytes() {
        if (this.mValue instanceof byte[]) {
            return (byte[])this.mValue;
        }
        return null;
    }

    public byte getValueAsByte(byte defaultValue) {
        byte[] b = this.getValueAsBytes();
        if (b == null || b.length < 1) {
            return defaultValue;
        }
        return b[0];
    }

    public Rational[] getValueAsRationals() {
        if (this.mValue instanceof Rational[]) {
            return (Rational[])this.mValue;
        }
        return null;
    }

    public Rational getValueAsRational(Rational defaultValue) {
        Rational[] r = this.getValueAsRationals();
        if (r == null || r.length < 1) {
            return defaultValue;
        }
        return r[0];
    }

    public Rational getValueAsRational(long defaultValue) {
        Rational defaultVal = new Rational(defaultValue, 1L);
        return this.getValueAsRational(defaultVal);
    }

    public int[] getValueAsInts() {
        if (this.mValue == null) {
            return null;
        }
        if (this.mValue instanceof long[]) {
            long[] val = (long[])this.mValue;
            int[] arr = new int[val.length];
            for (int i = 0; i < val.length; ++i) {
                arr[i] = (int)val[i];
            }
            return arr;
        }
        return null;
    }

    public int getValueAsInt(int defaultValue) {
        int[] i = this.getValueAsInts();
        if (i == null || i.length < 1) {
            return defaultValue;
        }
        return i[0];
    }

    public long[] getValueAsLongs() {
        if (this.mValue instanceof long[]) {
            return (long[])this.mValue;
        }
        return null;
    }

    public long getValueAsLong(long defaultValue) {
        long[] l = this.getValueAsLongs();
        if (l == null || l.length < 1) {
            return defaultValue;
        }
        return l[0];
    }

    public Object getValue() {
        return this.mValue;
    }

    public long forceGetValueAsLong(long defaultValue) {
        long[] l = this.getValueAsLongs();
        if (l != null && l.length >= 1) {
            return l[0];
        }
        byte[] b = this.getValueAsBytes();
        if (b != null && b.length >= 1) {
            return b[0];
        }
        Rational[] r = this.getValueAsRationals();
        if (r != null && r.length >= 1 && r[0].getDenominator() != 0L) {
            return (long)r[0].toDouble();
        }
        return defaultValue;
    }

    public String forceGetValueAsString() {
        if (this.mValue == null) {
            return "";
        }
        if (this.mValue instanceof byte[]) {
            if (this.mDataType == 2) {
                return new String((byte[])this.mValue, US_ASCII);
            }
            return Arrays.toString((byte[])this.mValue);
        }
        if (this.mValue instanceof long[]) {
            if (((long[])this.mValue).length == 1) {
                return String.valueOf(((long[])this.mValue)[0]);
            }
            return Arrays.toString((long[])this.mValue);
        }
        if (this.mValue instanceof Object[]) {
            if (((Object[])this.mValue).length == 1) {
                Object val = ((Object[])this.mValue)[0];
                if (val == null) {
                    return "";
                }
                return val.toString();
            }
            return Arrays.toString((Object[])this.mValue);
        }
        return this.mValue.toString();
    }

    protected long getValueAt(int index) {
        if (this.mValue instanceof long[]) {
            return ((long[])this.mValue)[index];
        }
        if (this.mValue instanceof byte[]) {
            return ((byte[])this.mValue)[index];
        }
        throw new IllegalArgumentException("Cannot get integer value from " + ExifTag.convertTypeToString(this.mDataType));
    }

    protected String getString() {
        if (this.mDataType != 2) {
            throw new IllegalArgumentException("Cannot get ASCII value from " + ExifTag.convertTypeToString(this.mDataType));
        }
        return new String((byte[])this.mValue, US_ASCII);
    }

    protected byte[] getStringByte() {
        return (byte[])this.mValue;
    }

    protected Rational getRational(int index) {
        if (this.mDataType != 10 && this.mDataType != 5) {
            throw new IllegalArgumentException("Cannot get RATIONAL value from " + ExifTag.convertTypeToString(this.mDataType));
        }
        return ((Rational[])this.mValue)[index];
    }

    protected void getBytes(byte[] buf) {
        this.getBytes(buf, 0, buf.length);
    }

    protected void getBytes(byte[] buf, int offset, int length) {
        if (this.mDataType != 7 && this.mDataType != 1) {
            throw new IllegalArgumentException("Cannot get BYTE value from " + ExifTag.convertTypeToString(this.mDataType));
        }
        System.arraycopy(this.mValue, 0, buf, offset, length > this.mComponentCountActual ? this.mComponentCountActual : length);
    }

    protected int getOffset() {
        return this.mOffset;
    }

    protected void setOffset(int offset) {
        this.mOffset = offset;
    }

    protected void setHasDefinedCount(boolean d) {
        this.mHasDefinedDefaultComponentCount = d;
    }

    protected boolean hasDefinedCount() {
        return this.mHasDefinedDefaultComponentCount;
    }

    private boolean checkBadComponentCount(int count) {
        return this.mHasDefinedDefaultComponentCount && this.mComponentCountActual != count;
    }

    private static String convertTypeToString(short type) {
        switch (type) {
            case 1: {
                return "UNSIGNED_BYTE";
            }
            case 2: {
                return "ASCII";
            }
            case 3: {
                return "UNSIGNED_SHORT";
            }
            case 4: {
                return "UNSIGNED_LONG";
            }
            case 5: {
                return "UNSIGNED_RATIONAL";
            }
            case 7: {
                return "UNDEFINED";
            }
            case 9: {
                return "LONG";
            }
            case 10: {
                return "RATIONAL";
            }
        }
        return "";
    }

    private boolean checkOverflowForUnsignedShort(int[] value) {
        for (int v : value) {
            if (v <= 65535 && v >= 0) continue;
            return true;
        }
        return false;
    }

    private boolean checkOverflowForUnsignedLong(long[] value) {
        for (long v : value) {
            if (v >= 0L && v <= 0xFFFFFFFFL) continue;
            return true;
        }
        return false;
    }

    private boolean checkOverflowForUnsignedLong(int[] value) {
        for (int v : value) {
            if (v >= 0) continue;
            return true;
        }
        return false;
    }

    private boolean checkOverflowForUnsignedRational(Rational[] value) {
        for (Rational v : value) {
            if (v.getNumerator() >= 0L && v.getDenominator() >= 0L && v.getNumerator() <= 0xFFFFFFFFL && v.getDenominator() <= 0xFFFFFFFFL) continue;
            return true;
        }
        return false;
    }

    private boolean checkOverflowForRational(Rational[] value) {
        for (Rational v : value) {
            if (v.getNumerator() >= Integer.MIN_VALUE && v.getDenominator() >= Integer.MIN_VALUE && v.getNumerator() <= Integer.MAX_VALUE && v.getDenominator() <= Integer.MAX_VALUE) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ExifTag) {
            ExifTag tag = (ExifTag)obj;
            if (tag.mTagId != this.mTagId || tag.mComponentCountActual != this.mComponentCountActual || tag.mDataType != this.mDataType) {
                return false;
            }
            if (this.mValue != null) {
                if (tag.mValue == null) {
                    return false;
                }
                if (this.mValue instanceof long[]) {
                    if (!(tag.mValue instanceof long[])) {
                        return false;
                    }
                    return Arrays.equals((long[])this.mValue, (long[])tag.mValue);
                }
                if (this.mValue instanceof Rational[]) {
                    if (!(tag.mValue instanceof Rational[])) {
                        return false;
                    }
                    return Arrays.equals((Rational[])this.mValue, (Rational[])tag.mValue);
                }
                if (this.mValue instanceof byte[]) {
                    if (!(tag.mValue instanceof byte[])) {
                        return false;
                    }
                    return Arrays.equals((byte[])this.mValue, (byte[])tag.mValue);
                }
                return this.mValue.equals(tag.mValue);
            }
            return tag.mValue == null;
        }
        return false;
    }

    public String toString() {
        return String.format("tag id: %04X\n", this.mTagId) + "ifd id: " + this.mIfd + "\ntype: " + ExifTag.convertTypeToString(this.mDataType) + "\ncount: " + this.mComponentCountActual + "\noffset: " + this.mOffset + "\nvalue: " + this.forceGetValueAsString() + "\n";
    }

    static {
        ExifTag.TYPE_TO_SIZE_MAP[1] = 1;
        ExifTag.TYPE_TO_SIZE_MAP[2] = 1;
        ExifTag.TYPE_TO_SIZE_MAP[3] = 2;
        ExifTag.TYPE_TO_SIZE_MAP[4] = 4;
        ExifTag.TYPE_TO_SIZE_MAP[5] = 8;
        ExifTag.TYPE_TO_SIZE_MAP[7] = 1;
        ExifTag.TYPE_TO_SIZE_MAP[9] = 4;
        ExifTag.TYPE_TO_SIZE_MAP[10] = 8;
        TIME_FORMAT = new SimpleDateFormat("yyyy:MM:dd kk:mm:ss");
    }
}

