/*
 * Decompiled with CFR 0.152.
 */
package com.example.camerabioandroid.camerabiomanager.exif;

import com.example.camerabioandroid.camerabiomanager.exif.ExifData;
import com.example.camerabioandroid.camerabiomanager.exif.ExifInterface;
import com.example.camerabioandroid.camerabiomanager.exif.ExifTag;
import com.example.camerabioandroid.camerabiomanager.exif.IfdData;
import com.example.camerabioandroid.camerabiomanager.exif.JpegHeader;
import com.example.camerabioandroid.camerabiomanager.exif.OrderedDataOutputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

class ExifOutputStream
extends FilterOutputStream {
    private static final String TAG = "ExifOutputStream";
    private static final boolean DEBUG = false;
    private static final int STREAMBUFFER_SIZE = 65536;
    private static final int STATE_SOI = 0;
    private static final int STATE_FRAME_HEADER = 1;
    private static final int STATE_JPEG_DATA = 2;
    private static final int EXIF_HEADER = 1165519206;
    private static final short TIFF_HEADER = 42;
    private static final short TIFF_BIG_ENDIAN = 19789;
    private static final short TIFF_LITTLE_ENDIAN = 18761;
    private static final short TAG_SIZE = 12;
    private static final short TIFF_HEADER_SIZE = 8;
    private static final int MAX_EXIF_SIZE = 65535;
    private ExifData mExifData;
    private int mState = 0;
    private int mByteToSkip;
    private int mByteToCopy;
    private byte[] mSingleByteArray = new byte[1];
    private ByteBuffer mBuffer = ByteBuffer.allocate(4);
    private final ExifInterface mInterface;

    protected ExifOutputStream(OutputStream ou, ExifInterface iRef) {
        super(new BufferedOutputStream(ou, 65536));
        this.mInterface = iRef;
    }

    protected void setExifData(ExifData exifData) {
        this.mExifData = exifData;
    }

    protected ExifData getExifData() {
        return this.mExifData;
    }

    private int requestByteToBuffer(int requestByteCount, byte[] buffer, int offset, int length) {
        int byteNeeded = requestByteCount - this.mBuffer.position();
        int byteToRead = length > byteNeeded ? byteNeeded : length;
        this.mBuffer.put(buffer, offset, byteToRead);
        return byteToRead;
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        while ((this.mByteToSkip > 0 || this.mByteToCopy > 0 || this.mState != 2) && length > 0) {
            int byteToProcess;
            if (this.mByteToSkip > 0) {
                byteToProcess = length > this.mByteToSkip ? this.mByteToSkip : length;
                length -= byteToProcess;
                this.mByteToSkip -= byteToProcess;
                offset += byteToProcess;
            }
            if (this.mByteToCopy > 0) {
                byteToProcess = length > this.mByteToCopy ? this.mByteToCopy : length;
                this.out.write(buffer, offset, byteToProcess);
                length -= byteToProcess;
                this.mByteToCopy -= byteToProcess;
                offset += byteToProcess;
            }
            if (length == 0) {
                return;
            }
            switch (this.mState) {
                case 0: {
                    int byteRead = this.requestByteToBuffer(2, buffer, offset, length);
                    offset += byteRead;
                    length -= byteRead;
                    if (this.mBuffer.position() < 2) {
                        return;
                    }
                    this.mBuffer.rewind();
                    if (this.mBuffer.getShort() != -40) {
                        throw new IOException("Not a valid jpeg image, cannot write exif");
                    }
                    this.out.write(this.mBuffer.array(), 0, 2);
                    this.mState = 1;
                    this.mBuffer.rewind();
                    this.writeExifData();
                    break;
                }
                case 1: {
                    short tag;
                    int byteRead = this.requestByteToBuffer(4, buffer, offset, length);
                    offset += byteRead;
                    length -= byteRead;
                    if (this.mBuffer.position() == 2 && (tag = this.mBuffer.getShort()) == -39) {
                        this.out.write(this.mBuffer.array(), 0, 2);
                        this.mBuffer.rewind();
                    }
                    if (this.mBuffer.position() < 4) {
                        return;
                    }
                    this.mBuffer.rewind();
                    short marker = this.mBuffer.getShort();
                    if (marker == -31) {
                        this.mByteToSkip = (this.mBuffer.getShort() & 0xFFFF) - 2;
                        this.mState = 2;
                    } else if (!JpegHeader.isSofMarker(marker)) {
                        this.out.write(this.mBuffer.array(), 0, 4);
                        this.mByteToCopy = (this.mBuffer.getShort() & 0xFFFF) - 2;
                    } else {
                        this.out.write(this.mBuffer.array(), 0, 4);
                        this.mState = 2;
                    }
                    this.mBuffer.rewind();
                }
            }
        }
        if (length > 0) {
            this.out.write(buffer, offset, length);
        }
    }

    @Override
    public void write(int oneByte) throws IOException {
        this.mSingleByteArray[0] = (byte)(0xFF & oneByte);
        this.write(this.mSingleByteArray);
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    private void writeExifData() throws IOException {
        if (this.mExifData == null) {
            return;
        }
        ArrayList<ExifTag> nullTags = this.stripNullValueTags(this.mExifData);
        this.createRequiredIfdAndTag();
        int exifSize = this.calculateAllOffset();
        if (exifSize + 8 > 65535) {
            throw new IOException("Exif header is too large (>64Kb)");
        }
        OrderedDataOutputStream dataOutputStream = new OrderedDataOutputStream(this.out);
        dataOutputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
        dataOutputStream.writeShort((short)-31);
        dataOutputStream.writeShort((short)(exifSize + 8));
        dataOutputStream.writeInt(1165519206);
        dataOutputStream.writeShort((short)0);
        if (this.mExifData.getByteOrder() == ByteOrder.BIG_ENDIAN) {
            dataOutputStream.writeShort((short)19789);
        } else {
            dataOutputStream.writeShort((short)18761);
        }
        dataOutputStream.setByteOrder(this.mExifData.getByteOrder());
        dataOutputStream.writeShort((short)42);
        dataOutputStream.writeInt(8);
        this.writeAllTags(dataOutputStream);
        this.writeThumbnail(dataOutputStream);
        for (ExifTag t : nullTags) {
            this.mExifData.addTag(t);
        }
    }

    private ArrayList<ExifTag> stripNullValueTags(ExifData data) {
        ArrayList<ExifTag> nullTags = new ArrayList<ExifTag>();
        for (ExifTag t : data.getAllTags()) {
            if (t.getValue() != null || ExifInterface.isOffsetTag(t.getTagId())) continue;
            data.removeTag(t.getTagId(), t.getIfd());
            nullTags.add(t);
        }
        return nullTags;
    }

    private void writeThumbnail(OrderedDataOutputStream dataOutputStream) throws IOException {
        if (this.mExifData.hasCompressedThumbnail()) {
            dataOutputStream.write(this.mExifData.getCompressedThumbnail());
        } else if (this.mExifData.hasUncompressedStrip()) {
            for (int i = 0; i < this.mExifData.getStripCount(); ++i) {
                dataOutputStream.write(this.mExifData.getStrip(i));
            }
        }
    }

    private void writeAllTags(OrderedDataOutputStream dataOutputStream) throws IOException {
        IfdData ifd1;
        IfdData gpsIfd;
        this.writeIfd(this.mExifData.getIfdData(0), dataOutputStream);
        this.writeIfd(this.mExifData.getIfdData(2), dataOutputStream);
        IfdData interoperabilityIfd = this.mExifData.getIfdData(3);
        if (interoperabilityIfd != null) {
            this.writeIfd(interoperabilityIfd, dataOutputStream);
        }
        if ((gpsIfd = this.mExifData.getIfdData(4)) != null) {
            this.writeIfd(gpsIfd, dataOutputStream);
        }
        if ((ifd1 = this.mExifData.getIfdData(1)) != null) {
            this.writeIfd(this.mExifData.getIfdData(1), dataOutputStream);
        }
    }

    private void writeIfd(IfdData ifd, OrderedDataOutputStream dataOutputStream) throws IOException {
        ExifTag[] tags = ifd.getAllTags();
        dataOutputStream.writeShort((short)tags.length);
        for (ExifTag tag : tags) {
            dataOutputStream.writeShort(tag.getTagId());
            dataOutputStream.writeShort(tag.getDataType());
            dataOutputStream.writeInt(tag.getComponentCount());
            if (tag.getDataSize() > 4) {
                dataOutputStream.writeInt(tag.getOffset());
                continue;
            }
            ExifOutputStream.writeTagValue(tag, dataOutputStream);
            int n = 4 - tag.getDataSize();
            for (int i = 0; i < n; ++i) {
                dataOutputStream.write(0);
            }
        }
        dataOutputStream.writeInt(ifd.getOffsetToNextIfd());
        for (ExifTag tag : tags) {
            if (tag.getDataSize() <= 4) continue;
            ExifOutputStream.writeTagValue(tag, dataOutputStream);
        }
    }

    private int calculateOffsetOfIfd(IfdData ifd, int offset) {
        ExifTag[] tags;
        offset += 2 + ifd.getTagCount() * 12 + 4;
        for (ExifTag tag : tags = ifd.getAllTags()) {
            if (tag.getDataSize() <= 4) continue;
            tag.setOffset(offset);
            offset += tag.getDataSize();
        }
        return offset;
    }

    private void createRequiredIfdAndTag() throws IOException {
        IfdData interIfd;
        IfdData gpsIfd;
        ExifTag exifOffsetTag;
        IfdData ifd0 = this.mExifData.getIfdData(0);
        if (ifd0 == null) {
            ifd0 = new IfdData(0);
            this.mExifData.addIfdData(ifd0);
        }
        if ((exifOffsetTag = this.mInterface.buildUninitializedTag(ExifInterface.TAG_EXIF_IFD)) == null) {
            throw new IOException("No definition for crucial exif tag: " + ExifInterface.TAG_EXIF_IFD);
        }
        ifd0.setTag(exifOffsetTag);
        IfdData exifIfd = this.mExifData.getIfdData(2);
        if (exifIfd == null) {
            exifIfd = new IfdData(2);
            this.mExifData.addIfdData(exifIfd);
        }
        if ((gpsIfd = this.mExifData.getIfdData(4)) != null) {
            ExifTag gpsOffsetTag = this.mInterface.buildUninitializedTag(ExifInterface.TAG_GPS_IFD);
            if (gpsOffsetTag == null) {
                throw new IOException("No definition for crucial exif tag: " + ExifInterface.TAG_GPS_IFD);
            }
            ifd0.setTag(gpsOffsetTag);
        }
        if ((interIfd = this.mExifData.getIfdData(3)) != null) {
            ExifTag interOffsetTag = this.mInterface.buildUninitializedTag(ExifInterface.TAG_INTEROPERABILITY_IFD);
            if (interOffsetTag == null) {
                throw new IOException("No definition for crucial exif tag: " + ExifInterface.TAG_INTEROPERABILITY_IFD);
            }
            exifIfd.setTag(interOffsetTag);
        }
        IfdData ifd1 = this.mExifData.getIfdData(1);
        if (this.mExifData.hasCompressedThumbnail()) {
            ExifTag offsetTag;
            if (ifd1 == null) {
                ifd1 = new IfdData(1);
                this.mExifData.addIfdData(ifd1);
            }
            if ((offsetTag = this.mInterface.buildUninitializedTag(ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT)) == null) {
                throw new IOException("No definition for crucial exif tag: " + ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT);
            }
            ifd1.setTag(offsetTag);
            ExifTag lengthTag = this.mInterface.buildUninitializedTag(ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT_LENGTH);
            if (lengthTag == null) {
                throw new IOException("No definition for crucial exif tag: " + ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT_LENGTH);
            }
            lengthTag.setValue(this.mExifData.getCompressedThumbnail().length);
            ifd1.setTag(lengthTag);
            ifd1.removeTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_STRIP_OFFSETS));
            ifd1.removeTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_STRIP_BYTE_COUNTS));
        } else if (this.mExifData.hasUncompressedStrip()) {
            if (ifd1 == null) {
                ifd1 = new IfdData(1);
                this.mExifData.addIfdData(ifd1);
            }
            int stripCount = this.mExifData.getStripCount();
            ExifTag offsetTag = this.mInterface.buildUninitializedTag(ExifInterface.TAG_STRIP_OFFSETS);
            if (offsetTag == null) {
                throw new IOException("No definition for crucial exif tag: " + ExifInterface.TAG_STRIP_OFFSETS);
            }
            ExifTag lengthTag = this.mInterface.buildUninitializedTag(ExifInterface.TAG_STRIP_BYTE_COUNTS);
            if (lengthTag == null) {
                throw new IOException("No definition for crucial exif tag: " + ExifInterface.TAG_STRIP_BYTE_COUNTS);
            }
            long[] lengths = new long[stripCount];
            for (int i = 0; i < this.mExifData.getStripCount(); ++i) {
                lengths[i] = this.mExifData.getStrip(i).length;
            }
            lengthTag.setValue(lengths);
            ifd1.setTag(offsetTag);
            ifd1.setTag(lengthTag);
            ifd1.removeTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT));
            ifd1.removeTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT_LENGTH));
        } else if (ifd1 != null) {
            ifd1.removeTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_STRIP_OFFSETS));
            ifd1.removeTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_STRIP_BYTE_COUNTS));
            ifd1.removeTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT));
            ifd1.removeTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT_LENGTH));
        }
    }

    private int calculateAllOffset() {
        IfdData ifd1;
        IfdData gpsIfd;
        int offset = 8;
        IfdData ifd0 = this.mExifData.getIfdData(0);
        offset = this.calculateOffsetOfIfd(ifd0, offset);
        ifd0.getTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_EXIF_IFD)).setValue(offset);
        IfdData exifIfd = this.mExifData.getIfdData(2);
        offset = this.calculateOffsetOfIfd(exifIfd, offset);
        IfdData interIfd = this.mExifData.getIfdData(3);
        if (interIfd != null) {
            exifIfd.getTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_INTEROPERABILITY_IFD)).setValue(offset);
            offset = this.calculateOffsetOfIfd(interIfd, offset);
        }
        if ((gpsIfd = this.mExifData.getIfdData(4)) != null) {
            ifd0.getTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_GPS_IFD)).setValue(offset);
            offset = this.calculateOffsetOfIfd(gpsIfd, offset);
        }
        if ((ifd1 = this.mExifData.getIfdData(1)) != null) {
            ifd0.setOffsetToNextIfd(offset);
            offset = this.calculateOffsetOfIfd(ifd1, offset);
        }
        if (this.mExifData.hasCompressedThumbnail()) {
            ifd1.getTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT)).setValue(offset);
            offset += this.mExifData.getCompressedThumbnail().length;
        } else if (this.mExifData.hasUncompressedStrip()) {
            int stripCount = this.mExifData.getStripCount();
            long[] offsets = new long[stripCount];
            for (int i = 0; i < this.mExifData.getStripCount(); ++i) {
                offsets[i] = offset;
                offset += this.mExifData.getStrip(i).length;
            }
            ifd1.getTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_STRIP_OFFSETS)).setValue(offsets);
        }
        return offset;
    }

    static void writeTagValue(ExifTag tag, OrderedDataOutputStream dataOutputStream) throws IOException {
        switch (tag.getDataType()) {
            case 2: {
                byte[] buf = tag.getStringByte();
                if (buf.length == tag.getComponentCount()) {
                    buf[buf.length - 1] = 0;
                    dataOutputStream.write(buf);
                    break;
                }
                dataOutputStream.write(buf);
                dataOutputStream.write(0);
                break;
            }
            case 4: 
            case 9: {
                int n = tag.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    dataOutputStream.writeInt((int)tag.getValueAt(i));
                }
                break;
            }
            case 5: 
            case 10: {
                int n = tag.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    dataOutputStream.writeRational(tag.getRational(i));
                }
                break;
            }
            case 1: 
            case 7: {
                byte[] buf = new byte[tag.getComponentCount()];
                tag.getBytes(buf);
                dataOutputStream.write(buf);
                break;
            }
            case 3: {
                int n = tag.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    dataOutputStream.writeShort((short)tag.getValueAt(i));
                }
                break;
            }
        }
    }
}

