/*
 * Decompiled with CFR 0.152.
 */
package com.example.camerabioandroid.camerabiomanager.exif;

import com.example.camerabioandroid.camerabiomanager.exif.ByteBufferInputStream;
import com.example.camerabioandroid.camerabiomanager.exif.ExifData;
import com.example.camerabioandroid.camerabiomanager.exif.ExifInterface;
import com.example.camerabioandroid.camerabiomanager.exif.ExifInvalidFormatException;
import com.example.camerabioandroid.camerabiomanager.exif.ExifParser;
import com.example.camerabioandroid.camerabiomanager.exif.ExifTag;
import com.example.camerabioandroid.camerabiomanager.exif.Rational;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

class ExifModifier {
    public static final String TAG = "ExifModifier";
    public static final boolean DEBUG = false;
    private final ByteBuffer mByteBuffer;
    private final ExifData mTagToModified;
    private final List<TagOffset> mTagOffsets = new ArrayList<TagOffset>();
    private final ExifInterface mInterface;
    private int mOffsetBase;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExifModifier(ByteBuffer byteBuffer, ExifInterface iRef) throws IOException, ExifInvalidFormatException {
        this.mByteBuffer = byteBuffer;
        this.mOffsetBase = byteBuffer.position();
        this.mInterface = iRef;
        ByteBufferInputStream is = null;
        try {
            is = new ByteBufferInputStream(byteBuffer);
            ExifParser parser = ExifParser.parse(is, this.mInterface);
            this.mTagToModified = new ExifData(parser.getByteOrder());
            this.mOffsetBase += parser.getTiffStartPosition();
            this.mByteBuffer.position(0);
        }
        catch (Throwable throwable) {
            ExifInterface.closeSilently(is);
            throw throwable;
        }
        ExifInterface.closeSilently(is);
    }

    protected ByteOrder getByteOrder() {
        return this.mTagToModified.getByteOrder();
    }

    /*
     * Exception decompiling
     */
    protected boolean commit() throws IOException, ExifInvalidFormatException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void modify() {
        this.mByteBuffer.order(this.getByteOrder());
        for (TagOffset tagOffset : this.mTagOffsets) {
            this.writeTagValue(tagOffset.mTag, tagOffset.mOffset);
        }
    }

    private void writeTagValue(ExifTag tag, int offset) {
        this.mByteBuffer.position(offset + this.mOffsetBase);
        switch (tag.getDataType()) {
            case 2: {
                byte[] buf = tag.getStringByte();
                if (buf.length == tag.getComponentCount()) {
                    buf[buf.length - 1] = 0;
                    this.mByteBuffer.put(buf);
                    break;
                }
                this.mByteBuffer.put(buf);
                this.mByteBuffer.put((byte)0);
                break;
            }
            case 4: 
            case 9: {
                int n = tag.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    this.mByteBuffer.putInt((int)tag.getValueAt(i));
                }
                break;
            }
            case 5: 
            case 10: {
                int n = tag.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Rational v = tag.getRational(i);
                    this.mByteBuffer.putInt((int)v.getNumerator());
                    this.mByteBuffer.putInt((int)v.getDenominator());
                }
                break;
            }
            case 1: 
            case 7: {
                byte[] buf = new byte[tag.getComponentCount()];
                tag.getBytes(buf);
                this.mByteBuffer.put(buf);
                break;
            }
            case 3: {
                int n = tag.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    this.mByteBuffer.putShort((short)tag.getValueAt(i));
                }
                break;
            }
        }
    }

    public void modifyTag(ExifTag tag) {
        this.mTagToModified.addTag(tag);
    }

    private static class TagOffset {
        final int mOffset;
        final ExifTag mTag;

        TagOffset(ExifTag tag, int offset) {
            this.mTag = tag;
            this.mOffset = offset;
        }
    }
}

