/*
 * Decompiled with CFR 0.152.
 */
package com.example.camerabioandroid.camerabiomanager.exif;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.SparseIntArray;
import com.example.camerabioandroid.camerabiomanager.exif.ExifData;
import com.example.camerabioandroid.camerabiomanager.exif.ExifInvalidFormatException;
import com.example.camerabioandroid.camerabiomanager.exif.ExifModifier;
import com.example.camerabioandroid.camerabiomanager.exif.ExifOutputStream;
import com.example.camerabioandroid.camerabiomanager.exif.ExifParser;
import com.example.camerabioandroid.camerabiomanager.exif.ExifReader;
import com.example.camerabioandroid.camerabiomanager.exif.ExifTag;
import com.example.camerabioandroid.camerabiomanager.exif.IfdData;
import com.example.camerabioandroid.camerabiomanager.exif.Rational;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

public class ExifInterface {
    public static final int TAG_NULL = -1;
    public static final int IFD_NULL = -1;
    public static final int DEFINITION_NULL = 0;
    public static final String EXIF_VERSION = "0220";
    public static final int TAG_IMAGE_WIDTH = ExifInterface.defineTag(0, (short)256);
    public static final int TAG_IMAGE_LENGTH = ExifInterface.defineTag(0, (short)257);
    public static final int TAG_BITS_PER_SAMPLE = ExifInterface.defineTag(0, (short)258);
    public static final int TAG_COMPRESSION = ExifInterface.defineTag(0, (short)259);
    public static final int TAG_PHOTOMETRIC_INTERPRETATION = ExifInterface.defineTag(0, (short)262);
    public static final int TAG_IMAGE_DESCRIPTION = ExifInterface.defineTag(0, (short)270);
    public static final int TAG_MAKE = ExifInterface.defineTag(0, (short)271);
    public static final int TAG_MODEL = ExifInterface.defineTag(0, (short)272);
    public static final int TAG_STRIP_OFFSETS = ExifInterface.defineTag(0, (short)273);
    public static final int TAG_ORIENTATION = ExifInterface.defineTag(0, (short)274);
    public static final int TAG_SAMPLES_PER_PIXEL = ExifInterface.defineTag(0, (short)277);
    public static final int TAG_ROWS_PER_STRIP = ExifInterface.defineTag(0, (short)278);
    public static final int TAG_STRIP_BYTE_COUNTS = ExifInterface.defineTag(0, (short)279);
    public static final int TAG_X_RESOLUTION = ExifInterface.defineTag(0, (short)282);
    public static final int TAG_Y_RESOLUTION = ExifInterface.defineTag(0, (short)283);
    public static final int TAG_PLANAR_CONFIGURATION = ExifInterface.defineTag(0, (short)284);
    public static final int TAG_RESOLUTION_UNIT = ExifInterface.defineTag(0, (short)296);
    public static final int TAG_TRANSFER_FUNCTION = ExifInterface.defineTag(0, (short)301);
    public static final int TAG_SOFTWARE = ExifInterface.defineTag(0, (short)305);
    public static final int TAG_DATE_TIME = ExifInterface.defineTag(0, (short)306);
    public static final int TAG_ARTIST = ExifInterface.defineTag(0, (short)315);
    public static final int TAG_WHITE_POINT = ExifInterface.defineTag(0, (short)318);
    public static final int TAG_PRIMARY_CHROMATICITIES = ExifInterface.defineTag(0, (short)319);
    public static final int TAG_Y_CB_CR_COEFFICIENTS = ExifInterface.defineTag(0, (short)529);
    public static final int TAG_Y_CB_CR_SUB_SAMPLING = ExifInterface.defineTag(0, (short)530);
    public static final int TAG_Y_CB_CR_POSITIONING = ExifInterface.defineTag(0, (short)531);
    public static final int TAG_REFERENCE_BLACK_WHITE = ExifInterface.defineTag(0, (short)532);
    public static final int TAG_COPYRIGHT = ExifInterface.defineTag(0, (short)-32104);
    public static final int TAG_EXIF_IFD = ExifInterface.defineTag(0, (short)-30871);
    public static final int TAG_GPS_IFD = ExifInterface.defineTag(0, (short)-30683);
    public static final int TAG_JPEG_INTERCHANGE_FORMAT = ExifInterface.defineTag(1, (short)513);
    public static final int TAG_JPEG_INTERCHANGE_FORMAT_LENGTH = ExifInterface.defineTag(1, (short)514);
    public static final int TAG_EXPOSURE_TIME = ExifInterface.defineTag(2, (short)-32102);
    public static final int TAG_F_NUMBER = ExifInterface.defineTag(2, (short)-32099);
    public static final int TAG_EXPOSURE_PROGRAM = ExifInterface.defineTag(2, (short)-30686);
    public static final int TAG_SPECTRAL_SENSITIVITY = ExifInterface.defineTag(2, (short)-30684);
    public static final int TAG_ISO_SPEED_RATINGS = ExifInterface.defineTag(2, (short)-30681);
    public static final int TAG_OECF = ExifInterface.defineTag(2, (short)-30680);
    public static final int TAG_EXIF_VERSION = ExifInterface.defineTag(2, (short)-28672);
    public static final int TAG_DATE_TIME_ORIGINAL = ExifInterface.defineTag(2, (short)-28669);
    public static final int TAG_DATE_TIME_DIGITIZED = ExifInterface.defineTag(2, (short)-28668);
    public static final int TAG_COMPONENTS_CONFIGURATION = ExifInterface.defineTag(2, (short)-28415);
    public static final int TAG_COMPRESSED_BITS_PER_PIXEL = ExifInterface.defineTag(2, (short)-28414);
    public static final int TAG_SHUTTER_SPEED_VALUE = ExifInterface.defineTag(2, (short)-28159);
    public static final int TAG_APERTURE_VALUE = ExifInterface.defineTag(2, (short)-28158);
    public static final int TAG_BRIGHTNESS_VALUE = ExifInterface.defineTag(2, (short)-28157);
    public static final int TAG_EXPOSURE_BIAS_VALUE = ExifInterface.defineTag(2, (short)-28156);
    public static final int TAG_MAX_APERTURE_VALUE = ExifInterface.defineTag(2, (short)-28155);
    public static final int TAG_SUBJECT_DISTANCE = ExifInterface.defineTag(2, (short)-28154);
    public static final int TAG_METERING_MODE = ExifInterface.defineTag(2, (short)-28153);
    public static final int TAG_LIGHT_SOURCE = ExifInterface.defineTag(2, (short)-28152);
    public static final int TAG_FLASH = ExifInterface.defineTag(2, (short)-28151);
    public static final int TAG_FOCAL_LENGTH = ExifInterface.defineTag(2, (short)-28150);
    public static final int TAG_SUBJECT_AREA = ExifInterface.defineTag(2, (short)-28140);
    public static final int TAG_MAKER_NOTE = ExifInterface.defineTag(2, (short)-28036);
    public static final int TAG_USER_COMMENT = ExifInterface.defineTag(2, (short)-28026);
    public static final int TAG_SUB_SEC_TIME = ExifInterface.defineTag(2, (short)-28016);
    public static final int TAG_SUB_SEC_TIME_ORIGINAL = ExifInterface.defineTag(2, (short)-28015);
    public static final int TAG_SUB_SEC_TIME_DIGITIZED = ExifInterface.defineTag(2, (short)-28014);
    public static final int TAG_FLASHPIX_VERSION = ExifInterface.defineTag(2, (short)-24576);
    public static final int TAG_COLOR_SPACE = ExifInterface.defineTag(2, (short)-24575);
    public static final int TAG_PIXEL_X_DIMENSION = ExifInterface.defineTag(2, (short)-24574);
    public static final int TAG_PIXEL_Y_DIMENSION = ExifInterface.defineTag(2, (short)-24573);
    public static final int TAG_RELATED_SOUND_FILE = ExifInterface.defineTag(2, (short)-24572);
    public static final int TAG_INTEROPERABILITY_IFD = ExifInterface.defineTag(2, (short)-24571);
    public static final int TAG_FLASH_ENERGY = ExifInterface.defineTag(2, (short)-24053);
    public static final int TAG_SPATIAL_FREQUENCY_RESPONSE = ExifInterface.defineTag(2, (short)-24052);
    public static final int TAG_FOCAL_PLANE_X_RESOLUTION = ExifInterface.defineTag(2, (short)-24050);
    public static final int TAG_FOCAL_PLANE_Y_RESOLUTION = ExifInterface.defineTag(2, (short)-24049);
    public static final int TAG_FOCAL_PLANE_RESOLUTION_UNIT = ExifInterface.defineTag(2, (short)-24048);
    public static final int TAG_SUBJECT_LOCATION = ExifInterface.defineTag(2, (short)-24044);
    public static final int TAG_EXPOSURE_INDEX = ExifInterface.defineTag(2, (short)-24043);
    public static final int TAG_SENSING_METHOD = ExifInterface.defineTag(2, (short)-24041);
    public static final int TAG_FILE_SOURCE = ExifInterface.defineTag(2, (short)-23808);
    public static final int TAG_SCENE_TYPE = ExifInterface.defineTag(2, (short)-23807);
    public static final int TAG_CFA_PATTERN = ExifInterface.defineTag(2, (short)-23806);
    public static final int TAG_CUSTOM_RENDERED = ExifInterface.defineTag(2, (short)-23551);
    public static final int TAG_EXPOSURE_MODE = ExifInterface.defineTag(2, (short)-23550);
    public static final int TAG_WHITE_BALANCE = ExifInterface.defineTag(2, (short)-23549);
    public static final int TAG_DIGITAL_ZOOM_RATIO = ExifInterface.defineTag(2, (short)-23548);
    public static final int TAG_FOCAL_LENGTH_IN_35_MM_FILE = ExifInterface.defineTag(2, (short)-23547);
    public static final int TAG_SCENE_CAPTURE_TYPE = ExifInterface.defineTag(2, (short)-23546);
    public static final int TAG_GAIN_CONTROL = ExifInterface.defineTag(2, (short)-23545);
    public static final int TAG_CONTRAST = ExifInterface.defineTag(2, (short)-23544);
    public static final int TAG_SATURATION = ExifInterface.defineTag(2, (short)-23543);
    public static final int TAG_SHARPNESS = ExifInterface.defineTag(2, (short)-23542);
    public static final int TAG_DEVICE_SETTING_DESCRIPTION = ExifInterface.defineTag(2, (short)-23541);
    public static final int TAG_SUBJECT_DISTANCE_RANGE = ExifInterface.defineTag(2, (short)-23540);
    public static final int TAG_IMAGE_UNIQUE_ID = ExifInterface.defineTag(2, (short)-23520);
    public static final int TAG_GPS_VERSION_ID = ExifInterface.defineTag(4, (short)0);
    public static final int TAG_GPS_LATITUDE_REF = ExifInterface.defineTag(4, (short)1);
    public static final int TAG_GPS_LATITUDE = ExifInterface.defineTag(4, (short)2);
    public static final int TAG_GPS_LONGITUDE_REF = ExifInterface.defineTag(4, (short)3);
    public static final int TAG_GPS_LONGITUDE = ExifInterface.defineTag(4, (short)4);
    public static final int TAG_GPS_ALTITUDE_REF = ExifInterface.defineTag(4, (short)5);
    public static final int TAG_GPS_ALTITUDE = ExifInterface.defineTag(4, (short)6);
    public static final int TAG_GPS_TIME_STAMP = ExifInterface.defineTag(4, (short)7);
    public static final int TAG_GPS_SATTELLITES = ExifInterface.defineTag(4, (short)8);
    public static final int TAG_GPS_STATUS = ExifInterface.defineTag(4, (short)9);
    public static final int TAG_GPS_MEASURE_MODE = ExifInterface.defineTag(4, (short)10);
    public static final int TAG_GPS_DOP = ExifInterface.defineTag(4, (short)11);
    public static final int TAG_GPS_SPEED_REF = ExifInterface.defineTag(4, (short)12);
    public static final int TAG_GPS_SPEED = ExifInterface.defineTag(4, (short)13);
    public static final int TAG_GPS_TRACK_REF = ExifInterface.defineTag(4, (short)14);
    public static final int TAG_GPS_TRACK = ExifInterface.defineTag(4, (short)15);
    public static final int TAG_GPS_IMG_DIRECTION_REF = ExifInterface.defineTag(4, (short)16);
    public static final int TAG_GPS_IMG_DIRECTION = ExifInterface.defineTag(4, (short)17);
    public static final int TAG_GPS_MAP_DATUM = ExifInterface.defineTag(4, (short)18);
    public static final int TAG_GPS_DEST_LATITUDE_REF = ExifInterface.defineTag(4, (short)19);
    public static final int TAG_GPS_DEST_LATITUDE = ExifInterface.defineTag(4, (short)20);
    public static final int TAG_GPS_DEST_LONGITUDE_REF = ExifInterface.defineTag(4, (short)21);
    public static final int TAG_GPS_DEST_LONGITUDE = ExifInterface.defineTag(4, (short)22);
    public static final int TAG_GPS_DEST_BEARING_REF = ExifInterface.defineTag(4, (short)23);
    public static final int TAG_GPS_DEST_BEARING = ExifInterface.defineTag(4, (short)24);
    public static final int TAG_GPS_DEST_DISTANCE_REF = ExifInterface.defineTag(4, (short)25);
    public static final int TAG_GPS_DEST_DISTANCE = ExifInterface.defineTag(4, (short)26);
    public static final int TAG_GPS_PROCESSING_METHOD = ExifInterface.defineTag(4, (short)27);
    public static final int TAG_GPS_AREA_INFORMATION = ExifInterface.defineTag(4, (short)28);
    public static final int TAG_GPS_DATE_STAMP = ExifInterface.defineTag(4, (short)29);
    public static final int TAG_GPS_DIFFERENTIAL = ExifInterface.defineTag(4, (short)30);
    public static final int TAG_INTEROPERABILITY_INDEX = ExifInterface.defineTag(3, (short)1);
    private static HashSet<Short> sOffsetTags = new HashSet();
    protected static HashSet<Short> sBannedDefines;
    private static final String NULL_ARGUMENT_STRING = "Argument is null";
    private ExifData mData = new ExifData(DEFAULT_BYTE_ORDER);
    public static final ByteOrder DEFAULT_BYTE_ORDER;
    private static final String GPS_DATE_FORMAT_STR = "yyyy:MM:dd";
    private static final String DATETIME_FORMAT_STR = "yyyy:MM:dd kk:mm:ss";
    private final DateFormat mDateTimeStampFormat = new SimpleDateFormat("yyyy:MM:dd kk:mm:ss");
    private final DateFormat mGPSDateStampFormat = new SimpleDateFormat("yyyy:MM:dd");
    private final Calendar mGPSTimeStampCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private SparseIntArray mTagInfo = null;

    public static int defineTag(int ifdId, short tagId) {
        return tagId & 0xFFFF | ifdId << 16;
    }

    public static short getTrueTagKey(int tag) {
        return (short)tag;
    }

    public static int getTrueIfd(int tag) {
        return tag >>> 16;
    }

    public ExifInterface() {
        this.mGPSDateStampFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public void readExif(byte[] jpeg) throws IOException {
        this.readExif(new ByteArrayInputStream(jpeg));
    }

    public void readExif(InputStream inStream) throws IOException {
        if (inStream == null) {
            throw new IllegalArgumentException(NULL_ARGUMENT_STRING);
        }
        ExifData d = null;
        try {
            d = new ExifReader(this).read(inStream);
        }
        catch (ExifInvalidFormatException e) {
            throw new IOException("Invalid exif format : " + e);
        }
        this.mData = d;
    }

    public void readExif(String inFileName) throws FileNotFoundException, IOException {
        if (inFileName == null) {
            throw new IllegalArgumentException(NULL_ARGUMENT_STRING);
        }
        BufferedInputStream is = null;
        is = new BufferedInputStream(new FileInputStream(inFileName));
        this.readExif(is);
        ((InputStream)is).close();
    }

    public void setExif(Collection<ExifTag> tags) {
        this.clearExif();
        this.setTags(tags);
    }

    public void clearExif() {
        this.mData = new ExifData(DEFAULT_BYTE_ORDER);
    }

    public void writeExif(byte[] jpeg, OutputStream exifOutStream) throws IOException {
        if (jpeg == null || exifOutStream == null) {
            throw new IllegalArgumentException(NULL_ARGUMENT_STRING);
        }
        OutputStream s = this.getExifWriterStream(exifOutStream);
        s.write(jpeg, 0, jpeg.length);
        s.flush();
    }

    public void writeExif(Bitmap bmap, OutputStream exifOutStream) throws IOException {
        if (bmap == null || exifOutStream == null) {
            throw new IllegalArgumentException(NULL_ARGUMENT_STRING);
        }
        OutputStream s = this.getExifWriterStream(exifOutStream);
        bmap.compress(Bitmap.CompressFormat.JPEG, 90, s);
        s.flush();
    }

    public void writeExif(InputStream jpegStream, OutputStream exifOutStream) throws IOException {
        if (jpegStream == null || exifOutStream == null) {
            throw new IllegalArgumentException(NULL_ARGUMENT_STRING);
        }
        OutputStream s = this.getExifWriterStream(exifOutStream);
        this.doExifStreamIO(jpegStream, s);
        s.flush();
    }

    public void writeExif(byte[] jpeg, String exifOutFileName) throws FileNotFoundException, IOException {
        if (jpeg == null || exifOutFileName == null) {
            throw new IllegalArgumentException(NULL_ARGUMENT_STRING);
        }
        OutputStream s = null;
        s = this.getExifWriterStream(exifOutFileName);
        s.write(jpeg, 0, jpeg.length);
        s.flush();
        s.close();
    }

    public void writeExif(Bitmap bmap, String exifOutFileName) throws FileNotFoundException, IOException {
        if (bmap == null || exifOutFileName == null) {
            throw new IllegalArgumentException(NULL_ARGUMENT_STRING);
        }
        OutputStream s = null;
        s = this.getExifWriterStream(exifOutFileName);
        bmap.compress(Bitmap.CompressFormat.JPEG, 90, s);
        s.flush();
        s.close();
    }

    public void writeExif(InputStream jpegStream, String exifOutFileName) throws FileNotFoundException, IOException {
        if (jpegStream == null || exifOutFileName == null) {
            throw new IllegalArgumentException(NULL_ARGUMENT_STRING);
        }
        OutputStream s = null;
        s = this.getExifWriterStream(exifOutFileName);
        this.doExifStreamIO(jpegStream, s);
        s.flush();
        s.close();
    }

    public void writeExif(String jpegFileName, String exifOutFileName) throws FileNotFoundException, IOException {
        if (jpegFileName == null || exifOutFileName == null) {
            throw new IllegalArgumentException(NULL_ARGUMENT_STRING);
        }
        FileInputStream is = null;
        is = new FileInputStream(jpegFileName);
        this.writeExif((InputStream)is, exifOutFileName);
        ((InputStream)is).close();
    }

    public OutputStream getExifWriterStream(OutputStream outStream) {
        if (outStream == null) {
            throw new IllegalArgumentException(NULL_ARGUMENT_STRING);
        }
        ExifOutputStream eos = new ExifOutputStream(outStream, this);
        eos.setExifData(this.mData);
        return eos;
    }

    public OutputStream getExifWriterStream(String exifOutFileName) throws FileNotFoundException {
        if (exifOutFileName == null) {
            throw new IllegalArgumentException(NULL_ARGUMENT_STRING);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(exifOutFileName);
        }
        catch (FileNotFoundException e) {
            ExifInterface.closeSilently(out);
            throw e;
        }
        return this.getExifWriterStream(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rewriteExif(String filename, Collection<ExifTag> tags) throws FileNotFoundException, IOException {
        boolean ret;
        RandomAccessFile file = null;
        BufferedInputStream is = null;
        try {
            File temp = new File(filename);
            is = new BufferedInputStream(new FileInputStream(temp));
            ExifParser parser = null;
            try {
                parser = ExifParser.parse(is, this);
            }
            catch (ExifInvalidFormatException e) {
                throw new IOException("Invalid exif format : ", e);
            }
            long exifSize = parser.getOffsetToExifEndFromSOF();
            ((InputStream)is).close();
            is = null;
            file = new RandomAccessFile(temp, "rw");
            long fileLength = file.length();
            if (fileLength < exifSize) {
                throw new IOException("Filesize changed during operation");
            }
            MappedByteBuffer buf = file.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, exifSize);
            ret = this.rewriteExif(buf, tags);
        }
        catch (Throwable throwable) {
            ExifInterface.closeSilently(is);
            throw throwable;
        }
        ExifInterface.closeSilently(is);
        file.close();
        return ret;
    }

    public boolean rewriteExif(ByteBuffer buf, Collection<ExifTag> tags) throws IOException {
        ExifModifier mod = null;
        try {
            mod = new ExifModifier(buf, this);
            for (ExifTag t : tags) {
                mod.modifyTag(t);
            }
            return mod.commit();
        }
        catch (ExifInvalidFormatException e) {
            throw new IOException("Invalid exif format : " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceRewriteExif(String filename, Collection<ExifTag> tags) throws FileNotFoundException, IOException {
        if (!this.rewriteExif(filename, tags)) {
            ExifData tempData = this.mData;
            this.mData = new ExifData(DEFAULT_BYTE_ORDER);
            FileInputStream is = null;
            ByteArrayOutputStream bytes = null;
            try {
                is = new FileInputStream(filename);
                bytes = new ByteArrayOutputStream();
                this.doExifStreamIO(is, bytes);
                byte[] imageBytes = bytes.toByteArray();
                this.readExif(imageBytes);
                this.setTags(tags);
                this.writeExif(imageBytes, filename);
            }
            finally {
                is.close();
                this.mData = tempData;
            }
        }
    }

    public void forceRewriteExif(String filename) throws FileNotFoundException, IOException {
        this.forceRewriteExif(filename, this.getAllTags());
    }

    public List<ExifTag> getAllTags() {
        return this.mData.getAllTags();
    }

    public List<ExifTag> getTagsForTagId(short tagId) {
        return this.mData.getAllTagsForTagId(tagId);
    }

    public List<ExifTag> getTagsForIfdId(int ifdId) {
        return this.mData.getAllTagsForIfd(ifdId);
    }

    public ExifTag getTag(int tagId, int ifdId) {
        if (!ExifTag.isValidIfd(ifdId)) {
            return null;
        }
        return this.mData.getTag(ExifInterface.getTrueTagKey(tagId), ifdId);
    }

    public ExifTag getTag(int tagId) {
        int ifdId = this.getDefinedTagDefaultIfd(tagId);
        return this.getTag(tagId, ifdId);
    }

    public Object getTagValue(int tagId, int ifdId) {
        ExifTag t = this.getTag(tagId, ifdId);
        return t == null ? null : t.getValue();
    }

    public Object getTagValue(int tagId) {
        int ifdId = this.getDefinedTagDefaultIfd(tagId);
        return this.getTagValue(tagId, ifdId);
    }

    public String getTagStringValue(int tagId, int ifdId) {
        ExifTag t = this.getTag(tagId, ifdId);
        if (t == null) {
            return null;
        }
        return t.getValueAsString();
    }

    public String getTagStringValue(int tagId) {
        int ifdId = this.getDefinedTagDefaultIfd(tagId);
        return this.getTagStringValue(tagId, ifdId);
    }

    public Long getTagLongValue(int tagId, int ifdId) {
        long[] l = this.getTagLongValues(tagId, ifdId);
        if (l == null || l.length <= 0) {
            return null;
        }
        return new Long(l[0]);
    }

    public Long getTagLongValue(int tagId) {
        int ifdId = this.getDefinedTagDefaultIfd(tagId);
        return this.getTagLongValue(tagId, ifdId);
    }

    public Integer getTagIntValue(int tagId, int ifdId) {
        int[] l = this.getTagIntValues(tagId, ifdId);
        if (l == null || l.length <= 0) {
            return null;
        }
        return new Integer(l[0]);
    }

    public Integer getTagIntValue(int tagId) {
        int ifdId = this.getDefinedTagDefaultIfd(tagId);
        return this.getTagIntValue(tagId, ifdId);
    }

    public Byte getTagByteValue(int tagId, int ifdId) {
        byte[] l = this.getTagByteValues(tagId, ifdId);
        if (l == null || l.length <= 0) {
            return null;
        }
        return new Byte(l[0]);
    }

    public Byte getTagByteValue(int tagId) {
        int ifdId = this.getDefinedTagDefaultIfd(tagId);
        return this.getTagByteValue(tagId, ifdId);
    }

    public Rational getTagRationalValue(int tagId, int ifdId) {
        Rational[] l = this.getTagRationalValues(tagId, ifdId);
        if (l == null || l.length == 0) {
            return null;
        }
        return new Rational(l[0]);
    }

    public Rational getTagRationalValue(int tagId) {
        int ifdId = this.getDefinedTagDefaultIfd(tagId);
        return this.getTagRationalValue(tagId, ifdId);
    }

    public long[] getTagLongValues(int tagId, int ifdId) {
        ExifTag t = this.getTag(tagId, ifdId);
        if (t == null) {
            return null;
        }
        return t.getValueAsLongs();
    }

    public long[] getTagLongValues(int tagId) {
        int ifdId = this.getDefinedTagDefaultIfd(tagId);
        return this.getTagLongValues(tagId, ifdId);
    }

    public int[] getTagIntValues(int tagId, int ifdId) {
        ExifTag t = this.getTag(tagId, ifdId);
        if (t == null) {
            return null;
        }
        return t.getValueAsInts();
    }

    public int[] getTagIntValues(int tagId) {
        int ifdId = this.getDefinedTagDefaultIfd(tagId);
        return this.getTagIntValues(tagId, ifdId);
    }

    public byte[] getTagByteValues(int tagId, int ifdId) {
        ExifTag t = this.getTag(tagId, ifdId);
        if (t == null) {
            return null;
        }
        return t.getValueAsBytes();
    }

    public byte[] getTagByteValues(int tagId) {
        int ifdId = this.getDefinedTagDefaultIfd(tagId);
        return this.getTagByteValues(tagId, ifdId);
    }

    public Rational[] getTagRationalValues(int tagId, int ifdId) {
        ExifTag t = this.getTag(tagId, ifdId);
        if (t == null) {
            return null;
        }
        return t.getValueAsRationals();
    }

    public Rational[] getTagRationalValues(int tagId) {
        int ifdId = this.getDefinedTagDefaultIfd(tagId);
        return this.getTagRationalValues(tagId, ifdId);
    }

    public boolean isTagCountDefined(int tagId) {
        int info = this.getTagInfo().get(tagId);
        if (info == 0) {
            return false;
        }
        return ExifInterface.getComponentCountFromInfo(info) != 0;
    }

    public int getDefinedTagCount(int tagId) {
        int info = this.getTagInfo().get(tagId);
        if (info == 0) {
            return 0;
        }
        return ExifInterface.getComponentCountFromInfo(info);
    }

    public int getActualTagCount(int tagId, int ifdId) {
        ExifTag t = this.getTag(tagId, ifdId);
        if (t == null) {
            return 0;
        }
        return t.getComponentCount();
    }

    public int getDefinedTagDefaultIfd(int tagId) {
        int info = this.getTagInfo().get(tagId);
        if (info == 0) {
            return -1;
        }
        return ExifInterface.getTrueIfd(tagId);
    }

    public short getDefinedTagType(int tagId) {
        int info = this.getTagInfo().get(tagId);
        if (info == 0) {
            return -1;
        }
        return ExifInterface.getTypeFromInfo(info);
    }

    protected static boolean isOffsetTag(short tag) {
        return sOffsetTags.contains(tag);
    }

    public ExifTag buildTag(int tagId, int ifdId, Object val) {
        boolean hasDefinedCount;
        int info = this.getTagInfo().get(tagId);
        if (info == 0 || val == null) {
            return null;
        }
        short type = ExifInterface.getTypeFromInfo(info);
        int definedCount = ExifInterface.getComponentCountFromInfo(info);
        boolean bl = hasDefinedCount = definedCount != 0;
        if (!ExifInterface.isIfdAllowed(info, ifdId)) {
            return null;
        }
        ExifTag t = new ExifTag(ExifInterface.getTrueTagKey(tagId), type, definedCount, ifdId, hasDefinedCount);
        if (!t.setValue(val)) {
            return null;
        }
        return t;
    }

    public ExifTag buildTag(int tagId, Object val) {
        int ifdId = ExifInterface.getTrueIfd(tagId);
        return this.buildTag(tagId, ifdId, val);
    }

    protected ExifTag buildUninitializedTag(int tagId) {
        int info = this.getTagInfo().get(tagId);
        if (info == 0) {
            return null;
        }
        short type = ExifInterface.getTypeFromInfo(info);
        int definedCount = ExifInterface.getComponentCountFromInfo(info);
        boolean hasDefinedCount = definedCount != 0;
        int ifdId = ExifInterface.getTrueIfd(tagId);
        ExifTag t = new ExifTag(ExifInterface.getTrueTagKey(tagId), type, definedCount, ifdId, hasDefinedCount);
        return t;
    }

    public boolean setTagValue(int tagId, int ifdId, Object val) {
        ExifTag t = this.getTag(tagId, ifdId);
        if (t == null) {
            return false;
        }
        return t.setValue(val);
    }

    public boolean setTagValue(int tagId, Object val) {
        int ifdId = this.getDefinedTagDefaultIfd(tagId);
        return this.setTagValue(tagId, ifdId, val);
    }

    public ExifTag setTag(ExifTag tag) {
        return this.mData.addTag(tag);
    }

    public void setTags(Collection<ExifTag> tags) {
        for (ExifTag t : tags) {
            this.setTag(t);
        }
    }

    public void deleteTag(int tagId, int ifdId) {
        this.mData.removeTag(ExifInterface.getTrueTagKey(tagId), ifdId);
    }

    public void deleteTag(int tagId) {
        int ifdId = this.getDefinedTagDefaultIfd(tagId);
        this.deleteTag(tagId, ifdId);
    }

    public int setTagDefinition(short tagId, int defaultIfd, short tagType, short defaultComponentCount, int[] allowedIfds) {
        if (sBannedDefines.contains(tagId)) {
            return -1;
        }
        if (ExifTag.isValidType(tagType) && ExifTag.isValidIfd(defaultIfd)) {
            int tagDef = ExifInterface.defineTag(defaultIfd, tagId);
            if (tagDef == -1) {
                return -1;
            }
            int[] otherDefs = this.getTagDefinitionsForTagId(tagId);
            SparseIntArray infos = this.getTagInfo();
            boolean defaultCheck = false;
            for (int i : allowedIfds) {
                if (defaultIfd == i) {
                    defaultCheck = true;
                }
                if (ExifTag.isValidIfd(i)) continue;
                return -1;
            }
            if (!defaultCheck) {
                return -1;
            }
            int ifdFlags = ExifInterface.getFlagsFromAllowedIfds(allowedIfds);
            if (otherDefs != null) {
                for (int def : otherDefs) {
                    int tagInfo = infos.get(def);
                    int allowedFlags = ExifInterface.getAllowedIfdFlagsFromInfo(tagInfo);
                    if ((ifdFlags & allowedFlags) == 0) continue;
                    return -1;
                }
            }
            this.getTagInfo().put(tagDef, ifdFlags << 24 | tagType << 16 | defaultComponentCount);
            return tagDef;
        }
        return -1;
    }

    protected int getTagDefinition(short tagId, int defaultIfd) {
        return this.getTagInfo().get(ExifInterface.defineTag(defaultIfd, tagId));
    }

    protected int[] getTagDefinitionsForTagId(short tagId) {
        int[] ifds = IfdData.getIfds();
        int[] defs = new int[ifds.length];
        int counter = 0;
        SparseIntArray infos = this.getTagInfo();
        for (int i : ifds) {
            int def = ExifInterface.defineTag(i, tagId);
            if (infos.get(def) == 0) continue;
            defs[counter++] = def;
        }
        if (counter == 0) {
            return null;
        }
        return Arrays.copyOfRange(defs, 0, counter);
    }

    protected int getTagDefinitionForTag(ExifTag tag) {
        short type = tag.getDataType();
        int count = tag.getComponentCount();
        int ifd = tag.getIfd();
        return this.getTagDefinitionForTag(tag.getTagId(), type, count, ifd);
    }

    protected int getTagDefinitionForTag(short tagId, short type, int count, int ifd) {
        int[] defs = this.getTagDefinitionsForTagId(tagId);
        if (defs == null) {
            return -1;
        }
        SparseIntArray infos = this.getTagInfo();
        int ret = -1;
        for (int i : defs) {
            int info = infos.get(i);
            short def_type = ExifInterface.getTypeFromInfo(info);
            int def_count = ExifInterface.getComponentCountFromInfo(info);
            int[] def_ifds = ExifInterface.getAllowedIfdsFromInfo(info);
            boolean valid_ifd = false;
            for (int j : def_ifds) {
                if (j != ifd) continue;
                valid_ifd = true;
                break;
            }
            if (!valid_ifd || type != def_type || count != def_count && def_count != 0) continue;
            ret = i;
            break;
        }
        return ret;
    }

    public void removeTagDefinition(int tagId) {
        this.getTagInfo().delete(tagId);
    }

    public void resetTagDefinitions() {
        this.mTagInfo = null;
    }

    public Bitmap getThumbnailBitmap() {
        if (this.mData.hasCompressedThumbnail()) {
            byte[] thumb = this.mData.getCompressedThumbnail();
            return BitmapFactory.decodeByteArray((byte[])thumb, (int)0, (int)thumb.length);
        }
        if (this.mData.hasUncompressedStrip()) {
            // empty if block
        }
        return null;
    }

    public byte[] getThumbnailBytes() {
        if (this.mData.hasCompressedThumbnail()) {
            return this.mData.getCompressedThumbnail();
        }
        if (this.mData.hasUncompressedStrip()) {
            // empty if block
        }
        return null;
    }

    public byte[] getThumbnail() {
        return this.mData.getCompressedThumbnail();
    }

    public boolean isThumbnailCompressed() {
        return this.mData.hasCompressedThumbnail();
    }

    public boolean hasThumbnail() {
        return this.mData.hasCompressedThumbnail();
    }

    public boolean setCompressedThumbnail(byte[] thumb) {
        this.mData.clearThumbnailAndStrips();
        this.mData.setCompressedThumbnail(thumb);
        return true;
    }

    public boolean setCompressedThumbnail(Bitmap thumb) {
        ByteArrayOutputStream thumbnail = new ByteArrayOutputStream();
        if (!thumb.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)thumbnail)) {
            return false;
        }
        return this.setCompressedThumbnail(thumbnail.toByteArray());
    }

    public void removeCompressedThumbnail() {
        this.mData.setCompressedThumbnail(null);
    }

    public String getUserComment() {
        return this.mData.getUserComment();
    }

    public static short getOrientationValueForRotation(int degrees) {
        if ((degrees %= 360) < 0) {
            degrees += 360;
        }
        if (degrees < 90) {
            return 1;
        }
        if (degrees < 180) {
            return 6;
        }
        if (degrees < 270) {
            return 3;
        }
        return 8;
    }

    public static int getRotationForOrientationValue(short orientation) {
        switch (orientation) {
            case 1: {
                return 0;
            }
            case 6: {
                return 90;
            }
            case 3: {
                return 180;
            }
            case 8: {
                return 270;
            }
        }
        return 0;
    }

    public static double convertLatOrLongToDouble(Rational[] coordinate, String reference) {
        try {
            double degrees = coordinate[0].toDouble();
            double minutes = coordinate[1].toDouble();
            double seconds = coordinate[2].toDouble();
            double result = degrees + minutes / 60.0 + seconds / 3600.0;
            if (reference.equals("S") || reference.equals("W")) {
                return -result;
            }
            return result;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException();
        }
    }

    public double[] getLatLongAsDoubles() {
        Rational[] latitude = this.getTagRationalValues(TAG_GPS_LATITUDE);
        String latitudeRef = this.getTagStringValue(TAG_GPS_LATITUDE_REF);
        Rational[] longitude = this.getTagRationalValues(TAG_GPS_LONGITUDE);
        String longitudeRef = this.getTagStringValue(TAG_GPS_LONGITUDE_REF);
        if (latitude == null || longitude == null || latitudeRef == null || longitudeRef == null || latitude.length < 3 || longitude.length < 3) {
            return null;
        }
        double[] latLon = new double[]{ExifInterface.convertLatOrLongToDouble(latitude, latitudeRef), ExifInterface.convertLatOrLongToDouble(longitude, longitudeRef)};
        return latLon;
    }

    public boolean addDateTimeStampTag(int tagId, long timestamp, TimeZone timezone) {
        ExifTag t;
        if (tagId == TAG_DATE_TIME || tagId == TAG_DATE_TIME_DIGITIZED || tagId == TAG_DATE_TIME_ORIGINAL) {
            this.mDateTimeStampFormat.setTimeZone(timezone);
            t = this.buildTag(tagId, this.mDateTimeStampFormat.format(timestamp));
            if (t == null) {
                return false;
            }
        } else {
            return false;
        }
        this.setTag(t);
        return true;
    }

    public boolean addGpsTags(double latitude, double longitude) {
        ExifTag latTag = this.buildTag(TAG_GPS_LATITUDE, ExifInterface.toExifLatLong(latitude));
        ExifTag longTag = this.buildTag(TAG_GPS_LONGITUDE, ExifInterface.toExifLatLong(longitude));
        ExifTag latRefTag = this.buildTag(TAG_GPS_LATITUDE_REF, latitude >= 0.0 ? "N" : "S");
        ExifTag longRefTag = this.buildTag(TAG_GPS_LONGITUDE_REF, longitude >= 0.0 ? "E" : "W");
        if (latTag == null || longTag == null || latRefTag == null || longRefTag == null) {
            return false;
        }
        this.setTag(latTag);
        this.setTag(longTag);
        this.setTag(latRefTag);
        this.setTag(longRefTag);
        return true;
    }

    public boolean addGpsDateTimeStampTag(long timestamp) {
        ExifTag t = this.buildTag(TAG_GPS_DATE_STAMP, this.mGPSDateStampFormat.format(timestamp));
        if (t == null) {
            return false;
        }
        this.setTag(t);
        this.mGPSTimeStampCalendar.setTimeInMillis(timestamp);
        t = this.buildTag(TAG_GPS_TIME_STAMP, new Rational[]{new Rational(this.mGPSTimeStampCalendar.get(11), 1L), new Rational(this.mGPSTimeStampCalendar.get(12), 1L), new Rational(this.mGPSTimeStampCalendar.get(13), 1L)});
        if (t == null) {
            return false;
        }
        this.setTag(t);
        return true;
    }

    private static Rational[] toExifLatLong(double value) {
        value = Math.abs(value);
        int degrees = (int)value;
        value = (value - (double)degrees) * 60.0;
        int minutes = (int)value;
        value = (value - (double)minutes) * 6000.0;
        int seconds = (int)value;
        return new Rational[]{new Rational(degrees, 1L), new Rational(minutes, 1L), new Rational(seconds, 100L)};
    }

    private void doExifStreamIO(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[1024];
        int ret = is.read(buf, 0, 1024);
        while (ret != -1) {
            os.write(buf, 0, ret);
            ret = is.read(buf, 0, 1024);
        }
    }

    protected static void closeSilently(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected SparseIntArray getTagInfo() {
        if (this.mTagInfo == null) {
            this.mTagInfo = new SparseIntArray();
            this.initTagInfo();
        }
        return this.mTagInfo;
    }

    private void initTagInfo() {
        int[] ifdAllowedIfds = new int[]{0, 1};
        int ifdFlags = ExifInterface.getFlagsFromAllowedIfds(ifdAllowedIfds) << 24;
        this.mTagInfo.put(TAG_MAKE, ifdFlags | 0x20000 | 0);
        this.mTagInfo.put(TAG_IMAGE_WIDTH, ifdFlags | 0x40000 | 1);
        this.mTagInfo.put(TAG_IMAGE_LENGTH, ifdFlags | 0x40000 | 1);
        this.mTagInfo.put(TAG_BITS_PER_SAMPLE, ifdFlags | 0x30000 | 3);
        this.mTagInfo.put(TAG_COMPRESSION, ifdFlags | 0x30000 | 1);
        this.mTagInfo.put(TAG_PHOTOMETRIC_INTERPRETATION, ifdFlags | 0x30000 | 1);
        this.mTagInfo.put(TAG_ORIENTATION, ifdFlags | 0x30000 | 1);
        this.mTagInfo.put(TAG_SAMPLES_PER_PIXEL, ifdFlags | 0x30000 | 1);
        this.mTagInfo.put(TAG_PLANAR_CONFIGURATION, ifdFlags | 0x30000 | 1);
        this.mTagInfo.put(TAG_Y_CB_CR_SUB_SAMPLING, ifdFlags | 0x30000 | 2);
        this.mTagInfo.put(TAG_Y_CB_CR_POSITIONING, ifdFlags | 0x30000 | 1);
        this.mTagInfo.put(TAG_X_RESOLUTION, ifdFlags | 0x50000 | 1);
        this.mTagInfo.put(TAG_Y_RESOLUTION, ifdFlags | 0x50000 | 1);
        this.mTagInfo.put(TAG_RESOLUTION_UNIT, ifdFlags | 0x30000 | 1);
        this.mTagInfo.put(TAG_STRIP_OFFSETS, ifdFlags | 0x40000 | 0);
        this.mTagInfo.put(TAG_ROWS_PER_STRIP, ifdFlags | 0x40000 | 1);
        this.mTagInfo.put(TAG_STRIP_BYTE_COUNTS, ifdFlags | 0x40000 | 0);
        this.mTagInfo.put(TAG_TRANSFER_FUNCTION, ifdFlags | 0x30000 | 0x300);
        this.mTagInfo.put(TAG_WHITE_POINT, ifdFlags | 0x50000 | 2);
        this.mTagInfo.put(TAG_PRIMARY_CHROMATICITIES, ifdFlags | 0x50000 | 6);
        this.mTagInfo.put(TAG_Y_CB_CR_COEFFICIENTS, ifdFlags | 0x50000 | 3);
        this.mTagInfo.put(TAG_REFERENCE_BLACK_WHITE, ifdFlags | 0x50000 | 6);
        this.mTagInfo.put(TAG_DATE_TIME, ifdFlags | 0x20000 | 0x14);
        this.mTagInfo.put(TAG_IMAGE_DESCRIPTION, ifdFlags | 0x20000 | 0);
        this.mTagInfo.put(TAG_MAKE, ifdFlags | 0x20000 | 0);
        this.mTagInfo.put(TAG_MODEL, ifdFlags | 0x20000 | 0);
        this.mTagInfo.put(TAG_SOFTWARE, ifdFlags | 0x20000 | 0);
        this.mTagInfo.put(TAG_ARTIST, ifdFlags | 0x20000 | 0);
        this.mTagInfo.put(TAG_COPYRIGHT, ifdFlags | 0x20000 | 0);
        this.mTagInfo.put(TAG_EXIF_IFD, ifdFlags | 0x40000 | 1);
        this.mTagInfo.put(TAG_GPS_IFD, ifdFlags | 0x40000 | 1);
        int[] ifd1AllowedIfds = new int[]{1};
        int ifdFlags1 = ExifInterface.getFlagsFromAllowedIfds(ifd1AllowedIfds) << 24;
        this.mTagInfo.put(TAG_JPEG_INTERCHANGE_FORMAT, ifdFlags1 | 0x40000 | 1);
        this.mTagInfo.put(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH, ifdFlags1 | 0x40000 | 1);
        int[] exifAllowedIfds = new int[]{2};
        int exifFlags = ExifInterface.getFlagsFromAllowedIfds(exifAllowedIfds) << 24;
        this.mTagInfo.put(TAG_EXIF_VERSION, exifFlags | 0x70000 | 4);
        this.mTagInfo.put(TAG_FLASHPIX_VERSION, exifFlags | 0x70000 | 4);
        this.mTagInfo.put(TAG_COLOR_SPACE, exifFlags | 0x30000 | 1);
        this.mTagInfo.put(TAG_COMPONENTS_CONFIGURATION, exifFlags | 0x70000 | 4);
        this.mTagInfo.put(TAG_COMPRESSED_BITS_PER_PIXEL, exifFlags | 0x50000 | 1);
        this.mTagInfo.put(TAG_PIXEL_X_DIMENSION, exifFlags | 0x40000 | 1);
        this.mTagInfo.put(TAG_PIXEL_Y_DIMENSION, exifFlags | 0x40000 | 1);
        this.mTagInfo.put(TAG_MAKER_NOTE, exifFlags | 0x70000 | 0);
        this.mTagInfo.put(TAG_USER_COMMENT, exifFlags | 0x70000 | 0);
        this.mTagInfo.put(TAG_RELATED_SOUND_FILE, exifFlags | 0x20000 | 0xD);
        this.mTagInfo.put(TAG_DATE_TIME_ORIGINAL, exifFlags | 0x20000 | 0x14);
        this.mTagInfo.put(TAG_DATE_TIME_DIGITIZED, exifFlags | 0x20000 | 0x14);
        this.mTagInfo.put(TAG_SUB_SEC_TIME, exifFlags | 0x20000 | 0);
        this.mTagInfo.put(TAG_SUB_SEC_TIME_ORIGINAL, exifFlags | 0x20000 | 0);
        this.mTagInfo.put(TAG_SUB_SEC_TIME_DIGITIZED, exifFlags | 0x20000 | 0);
        this.mTagInfo.put(TAG_IMAGE_UNIQUE_ID, exifFlags | 0x20000 | 0x21);
        this.mTagInfo.put(TAG_EXPOSURE_TIME, exifFlags | 0x50000 | 1);
        this.mTagInfo.put(TAG_F_NUMBER, exifFlags | 0x50000 | 1);
        this.mTagInfo.put(TAG_EXPOSURE_PROGRAM, exifFlags | 0x30000 | 1);
        this.mTagInfo.put(TAG_SPECTRAL_SENSITIVITY, exifFlags | 0x20000 | 0);
        this.mTagInfo.put(TAG_ISO_SPEED_RATINGS, exifFlags | 0x30000 | 0);
        this.mTagInfo.put(TAG_OECF, exifFlags | 0x70000 | 0);
        this.mTagInfo.put(TAG_SHUTTER_SPEED_VALUE, exifFlags | 0xA0000 | 1);
        this.mTagInfo.put(TAG_APERTURE_VALUE, exifFlags | 0x50000 | 1);
        this.mTagInfo.put(TAG_BRIGHTNESS_VALUE, exifFlags | 0xA0000 | 1);
        this.mTagInfo.put(TAG_EXPOSURE_BIAS_VALUE, exifFlags | 0xA0000 | 1);
        this.mTagInfo.put(TAG_MAX_APERTURE_VALUE, exifFlags | 0x50000 | 1);
        this.mTagInfo.put(TAG_SUBJECT_DISTANCE, exifFlags | 0x50000 | 1);
        this.mTagInfo.put(TAG_METERING_MODE, exifFlags | 0x30000 | 1);
        this.mTagInfo.put(TAG_LIGHT_SOURCE, exifFlags | 0x30000 | 1);
        this.mTagInfo.put(TAG_FLASH, exifFlags | 0x30000 | 1);
        this.mTagInfo.put(TAG_FOCAL_LENGTH, exifFlags | 0x50000 | 1);
        this.mTagInfo.put(TAG_SUBJECT_AREA, exifFlags | 0x30000 | 0);
        this.mTagInfo.put(TAG_FLASH_ENERGY, exifFlags | 0x50000 | 1);
        this.mTagInfo.put(TAG_SPATIAL_FREQUENCY_RESPONSE, exifFlags | 0x70000 | 0);
        this.mTagInfo.put(TAG_FOCAL_PLANE_X_RESOLUTION, exifFlags | 0x50000 | 1);
        this.mTagInfo.put(TAG_FOCAL_PLANE_Y_RESOLUTION, exifFlags | 0x50000 | 1);
        this.mTagInfo.put(TAG_FOCAL_PLANE_RESOLUTION_UNIT, exifFlags | 0x30000 | 1);
        this.mTagInfo.put(TAG_SUBJECT_LOCATION, exifFlags | 0x30000 | 2);
        this.mTagInfo.put(TAG_EXPOSURE_INDEX, exifFlags | 0x50000 | 1);
        this.mTagInfo.put(TAG_SENSING_METHOD, exifFlags | 0x30000 | 1);
        this.mTagInfo.put(TAG_FILE_SOURCE, exifFlags | 0x70000 | 1);
        this.mTagInfo.put(TAG_SCENE_TYPE, exifFlags | 0x70000 | 1);
        this.mTagInfo.put(TAG_CFA_PATTERN, exifFlags | 0x70000 | 0);
        this.mTagInfo.put(TAG_CUSTOM_RENDERED, exifFlags | 0x30000 | 1);
        this.mTagInfo.put(TAG_EXPOSURE_MODE, exifFlags | 0x30000 | 1);
        this.mTagInfo.put(TAG_WHITE_BALANCE, exifFlags | 0x30000 | 1);
        this.mTagInfo.put(TAG_DIGITAL_ZOOM_RATIO, exifFlags | 0x50000 | 1);
        this.mTagInfo.put(TAG_FOCAL_LENGTH_IN_35_MM_FILE, exifFlags | 0x30000 | 1);
        this.mTagInfo.put(TAG_SCENE_CAPTURE_TYPE, exifFlags | 0x30000 | 1);
        this.mTagInfo.put(TAG_GAIN_CONTROL, exifFlags | 0x50000 | 1);
        this.mTagInfo.put(TAG_CONTRAST, exifFlags | 0x30000 | 1);
        this.mTagInfo.put(TAG_SATURATION, exifFlags | 0x30000 | 1);
        this.mTagInfo.put(TAG_SHARPNESS, exifFlags | 0x30000 | 1);
        this.mTagInfo.put(TAG_DEVICE_SETTING_DESCRIPTION, exifFlags | 0x70000 | 0);
        this.mTagInfo.put(TAG_SUBJECT_DISTANCE_RANGE, exifFlags | 0x30000 | 1);
        this.mTagInfo.put(TAG_INTEROPERABILITY_IFD, exifFlags | 0x40000 | 1);
        int[] gpsAllowedIfds = new int[]{4};
        int gpsFlags = ExifInterface.getFlagsFromAllowedIfds(gpsAllowedIfds) << 24;
        this.mTagInfo.put(TAG_GPS_VERSION_ID, gpsFlags | 0x10000 | 4);
        this.mTagInfo.put(TAG_GPS_LATITUDE_REF, gpsFlags | 0x20000 | 2);
        this.mTagInfo.put(TAG_GPS_LONGITUDE_REF, gpsFlags | 0x20000 | 2);
        this.mTagInfo.put(TAG_GPS_LATITUDE, gpsFlags | 0xA0000 | 3);
        this.mTagInfo.put(TAG_GPS_LONGITUDE, gpsFlags | 0xA0000 | 3);
        this.mTagInfo.put(TAG_GPS_ALTITUDE_REF, gpsFlags | 0x10000 | 1);
        this.mTagInfo.put(TAG_GPS_ALTITUDE, gpsFlags | 0x50000 | 1);
        this.mTagInfo.put(TAG_GPS_TIME_STAMP, gpsFlags | 0x50000 | 3);
        this.mTagInfo.put(TAG_GPS_SATTELLITES, gpsFlags | 0x20000 | 0);
        this.mTagInfo.put(TAG_GPS_STATUS, gpsFlags | 0x20000 | 2);
        this.mTagInfo.put(TAG_GPS_MEASURE_MODE, gpsFlags | 0x20000 | 2);
        this.mTagInfo.put(TAG_GPS_DOP, gpsFlags | 0x50000 | 1);
        this.mTagInfo.put(TAG_GPS_SPEED_REF, gpsFlags | 0x20000 | 2);
        this.mTagInfo.put(TAG_GPS_SPEED, gpsFlags | 0x50000 | 1);
        this.mTagInfo.put(TAG_GPS_TRACK_REF, gpsFlags | 0x20000 | 2);
        this.mTagInfo.put(TAG_GPS_TRACK, gpsFlags | 0x50000 | 1);
        this.mTagInfo.put(TAG_GPS_IMG_DIRECTION_REF, gpsFlags | 0x20000 | 2);
        this.mTagInfo.put(TAG_GPS_IMG_DIRECTION, gpsFlags | 0x50000 | 1);
        this.mTagInfo.put(TAG_GPS_MAP_DATUM, gpsFlags | 0x20000 | 0);
        this.mTagInfo.put(TAG_GPS_DEST_LATITUDE_REF, gpsFlags | 0x20000 | 2);
        this.mTagInfo.put(TAG_GPS_DEST_LATITUDE, gpsFlags | 0x50000 | 1);
        this.mTagInfo.put(TAG_GPS_DEST_BEARING_REF, gpsFlags | 0x20000 | 2);
        this.mTagInfo.put(TAG_GPS_DEST_BEARING, gpsFlags | 0x50000 | 1);
        this.mTagInfo.put(TAG_GPS_DEST_DISTANCE_REF, gpsFlags | 0x20000 | 2);
        this.mTagInfo.put(TAG_GPS_DEST_DISTANCE, gpsFlags | 0x50000 | 1);
        this.mTagInfo.put(TAG_GPS_PROCESSING_METHOD, gpsFlags | 0x70000 | 0);
        this.mTagInfo.put(TAG_GPS_AREA_INFORMATION, gpsFlags | 0x70000 | 0);
        this.mTagInfo.put(TAG_GPS_DATE_STAMP, gpsFlags | 0x20000 | 0xB);
        this.mTagInfo.put(TAG_GPS_DIFFERENTIAL, gpsFlags | 0x30000 | 0xB);
        int[] interopAllowedIfds = new int[]{3};
        int interopFlags = ExifInterface.getFlagsFromAllowedIfds(interopAllowedIfds) << 24;
        this.mTagInfo.put(TAG_INTEROPERABILITY_INDEX, interopFlags | 0x20000 | 0);
    }

    protected static int getAllowedIfdFlagsFromInfo(int info) {
        return info >>> 24;
    }

    protected static int[] getAllowedIfdsFromInfo(int info) {
        int ifdFlags = ExifInterface.getAllowedIfdFlagsFromInfo(info);
        int[] ifds = IfdData.getIfds();
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int i = 0; i < 5; ++i) {
            int flag = ifdFlags >> i & 1;
            if (flag != 1) continue;
            l.add(ifds[i]);
        }
        if (l.size() <= 0) {
            return null;
        }
        int[] ret = new int[l.size()];
        int j = 0;
        Iterator iterator = l.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            ret[j++] = i;
        }
        return ret;
    }

    protected static boolean isIfdAllowed(int info, int ifd) {
        int[] ifds = IfdData.getIfds();
        int ifdFlags = ExifInterface.getAllowedIfdFlagsFromInfo(info);
        for (int i = 0; i < ifds.length; ++i) {
            if (ifd != ifds[i] || (ifdFlags >> i & 1) != 1) continue;
            return true;
        }
        return false;
    }

    protected static int getFlagsFromAllowedIfds(int[] allowedIfds) {
        if (allowedIfds == null || allowedIfds.length == 0) {
            return 0;
        }
        int flags = 0;
        int[] ifds = IfdData.getIfds();
        block0: for (int i = 0; i < 5; ++i) {
            for (int j : allowedIfds) {
                if (ifds[i] != j) continue;
                flags |= 1 << i;
                continue block0;
            }
        }
        return flags;
    }

    protected static short getTypeFromInfo(int info) {
        return (short)(info >> 16 & 0xFF);
    }

    protected static int getComponentCountFromInfo(int info) {
        return info & 0xFFFF;
    }

    static {
        sOffsetTags.add(ExifInterface.getTrueTagKey(TAG_GPS_IFD));
        sOffsetTags.add(ExifInterface.getTrueTagKey(TAG_EXIF_IFD));
        sOffsetTags.add(ExifInterface.getTrueTagKey(TAG_JPEG_INTERCHANGE_FORMAT));
        sOffsetTags.add(ExifInterface.getTrueTagKey(TAG_INTEROPERABILITY_IFD));
        sOffsetTags.add(ExifInterface.getTrueTagKey(TAG_STRIP_OFFSETS));
        sBannedDefines = new HashSet<Short>(sOffsetTags);
        sBannedDefines.add(ExifInterface.getTrueTagKey(-1));
        sBannedDefines.add(ExifInterface.getTrueTagKey(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH));
        sBannedDefines.add(ExifInterface.getTrueTagKey(TAG_STRIP_BYTE_COUNTS));
        DEFAULT_BYTE_ORDER = ByteOrder.BIG_ENDIAN;
    }

    public static interface GpsDifferential {
        public static final short WITHOUT_DIFFERENTIAL_CORRECTION = 0;
        public static final short DIFFERENTIAL_CORRECTION_APPLIED = 1;
    }

    public static interface GpsTrackRef {
        public static final String TRUE_DIRECTION = "T";
        public static final String MAGNETIC_DIRECTION = "M";
    }

    public static interface GpsSpeedRef {
        public static final String KILOMETERS = "K";
        public static final String MILES = "M";
        public static final String KNOTS = "N";
    }

    public static interface GpsMeasureMode {
        public static final String MODE_2_DIMENSIONAL = "2";
        public static final String MODE_3_DIMENSIONAL = "3";
    }

    public static interface GpsStatus {
        public static final String IN_PROGRESS = "A";
        public static final String INTEROPERABILITY = "V";
    }

    public static interface GpsAltitudeRef {
        public static final short SEA_LEVEL = 0;
        public static final short SEA_LEVEL_NEGATIVE = 1;
    }

    public static interface GpsLongitudeRef {
        public static final String EAST = "E";
        public static final String WEST = "W";
    }

    public static interface GpsLatitudeRef {
        public static final String NORTH = "N";
        public static final String SOUTH = "S";
    }

    public static interface SubjectDistance {
        public static final short UNKNOWN = 0;
        public static final short MACRO = 1;
        public static final short CLOSE_VIEW = 2;
        public static final short DISTANT_VIEW = 3;
    }

    public static interface Sharpness {
        public static final short NORMAL = 0;
        public static final short SOFT = 1;
        public static final short HARD = 2;
    }

    public static interface Saturation {
        public static final short NORMAL = 0;
        public static final short LOW = 1;
        public static final short HIGH = 2;
    }

    public static interface Contrast {
        public static final short NORMAL = 0;
        public static final short SOFT = 1;
        public static final short HARD = 2;
    }

    public static interface GainControl {
        public static final short NONE = 0;
        public static final short LOW_UP = 1;
        public static final short HIGH_UP = 2;
        public static final short LOW_DOWN = 3;
        public static final short HIGH_DOWN = 4;
    }

    public static interface SceneType {
        public static final short DIRECT_PHOTOGRAPHED = 1;
    }

    public static interface FileSource {
        public static final short DSC = 3;
    }

    public static interface SensingMethod {
        public static final short NOT_DEFINED = 1;
        public static final short ONE_CHIP_COLOR = 2;
        public static final short TWO_CHIP_COLOR = 3;
        public static final short THREE_CHIP_COLOR = 4;
        public static final short COLOR_SEQUENTIAL_AREA = 5;
        public static final short TRILINEAR = 7;
        public static final short COLOR_SEQUENTIAL_LINEAR = 8;
    }

    public static interface LightSource {
        public static final short UNKNOWN = 0;
        public static final short DAYLIGHT = 1;
        public static final short FLUORESCENT = 2;
        public static final short TUNGSTEN = 3;
        public static final short FLASH = 4;
        public static final short FINE_WEATHER = 9;
        public static final short CLOUDY_WEATHER = 10;
        public static final short SHADE = 11;
        public static final short DAYLIGHT_FLUORESCENT = 12;
        public static final short DAY_WHITE_FLUORESCENT = 13;
        public static final short COOL_WHITE_FLUORESCENT = 14;
        public static final short WHITE_FLUORESCENT = 15;
        public static final short STANDARD_LIGHT_A = 17;
        public static final short STANDARD_LIGHT_B = 18;
        public static final short STANDARD_LIGHT_C = 19;
        public static final short D55 = 20;
        public static final short D65 = 21;
        public static final short D75 = 22;
        public static final short D50 = 23;
        public static final short ISO_STUDIO_TUNGSTEN = 24;
        public static final short OTHER = 255;
    }

    public static interface ComponentsConfiguration {
        public static final short NOT_EXIST = 0;
        public static final short Y = 1;
        public static final short CB = 2;
        public static final short CR = 3;
        public static final short R = 4;
        public static final short G = 5;
        public static final short B = 6;
    }

    public static interface SceneCapture {
        public static final short STANDARD = 0;
        public static final short LANDSCAPE = 1;
        public static final short PROTRAIT = 2;
        public static final short NIGHT_SCENE = 3;
    }

    public static interface WhiteBalance {
        public static final short AUTO = 0;
        public static final short MANUAL = 1;
    }

    public static interface ExposureMode {
        public static final short AUTO_EXPOSURE = 0;
        public static final short MANUAL_EXPOSURE = 1;
        public static final short AUTO_BRACKET = 2;
    }

    public static interface ColorSpace {
        public static final short SRGB = 1;
        public static final short UNCALIBRATED = -1;
    }

    public static interface Flash {
        public static final short DID_NOT_FIRE = 0;
        public static final short FIRED = 1;
        public static final short RETURN_NO_STROBE_RETURN_DETECTION_FUNCTION = 0;
        public static final short RETURN_STROBE_RETURN_LIGHT_NOT_DETECTED = 4;
        public static final short RETURN_STROBE_RETURN_LIGHT_DETECTED = 6;
        public static final short MODE_UNKNOWN = 0;
        public static final short MODE_COMPULSORY_FLASH_FIRING = 8;
        public static final short MODE_COMPULSORY_FLASH_SUPPRESSION = 16;
        public static final short MODE_AUTO_MODE = 24;
        public static final short FUNCTION_PRESENT = 0;
        public static final short FUNCTION_NO_FUNCTION = 32;
        public static final short RED_EYE_REDUCTION_NO_OR_UNKNOWN = 0;
        public static final short RED_EYE_REDUCTION_SUPPORT = 64;
    }

    public static interface MeteringMode {
        public static final short UNKNOWN = 0;
        public static final short AVERAGE = 1;
        public static final short CENTER_WEIGHTED_AVERAGE = 2;
        public static final short SPOT = 3;
        public static final short MULTISPOT = 4;
        public static final short PATTERN = 5;
        public static final short PARTAIL = 6;
        public static final short OTHER = 255;
    }

    public static interface ExposureProgram {
        public static final short NOT_DEFINED = 0;
        public static final short MANUAL = 1;
        public static final short NORMAL_PROGRAM = 2;
        public static final short APERTURE_PRIORITY = 3;
        public static final short SHUTTER_PRIORITY = 4;
        public static final short CREATIVE_PROGRAM = 5;
        public static final short ACTION_PROGRAM = 6;
        public static final short PROTRAIT_MODE = 7;
        public static final short LANDSCAPE_MODE = 8;
    }

    public static interface PlanarConfiguration {
        public static final short CHUNKY = 1;
        public static final short PLANAR = 2;
    }

    public static interface PhotometricInterpretation {
        public static final short RGB = 2;
        public static final short YCBCR = 6;
    }

    public static interface ResolutionUnit {
        public static final short INCHES = 2;
        public static final short CENTIMETERS = 3;
    }

    public static interface Compression {
        public static final short UNCOMPRESSION = 1;
        public static final short JPEG = 6;
    }

    public static interface YCbCrPositioning {
        public static final short CENTERED = 1;
        public static final short CO_SITED = 2;
    }

    public static interface Orientation {
        public static final short TOP_LEFT = 1;
        public static final short TOP_RIGHT = 2;
        public static final short BOTTOM_LEFT = 3;
        public static final short BOTTOM_RIGHT = 4;
        public static final short LEFT_TOP = 5;
        public static final short RIGHT_TOP = 6;
        public static final short LEFT_BOTTOM = 7;
        public static final short RIGHT_BOTTOM = 8;
    }
}

