/*
 * Decompiled with CFR 0.152.
 */
package com.example.camerabioandroid.camerabiomanager.exif;

import android.util.Log;
import com.example.camerabioandroid.camerabiomanager.exif.ExifInterface;
import java.io.IOException;

public class Exif {
    private static final String TAG = "CameraExif";

    public static ExifInterface getExif(byte[] jpegData) {
        ExifInterface exif = new ExifInterface();
        try {
            exif.readExif(jpegData);
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Failed to read EXIF data", (Throwable)e);
        }
        return exif;
    }

    public static int getOrientation(ExifInterface exif) {
        Integer val = exif.getTagIntValue(ExifInterface.TAG_ORIENTATION);
        if (val == null) {
            return 0;
        }
        return ExifInterface.getRotationForOrientationValue(val.shortValue());
    }

    public static int getOrientation(byte[] jpegData) {
        if (jpegData == null) {
            return 0;
        }
        ExifInterface exif = Exif.getExif(jpegData);
        return Exif.getOrientation(exif);
    }
}

