/*
 * Decompiled with CFR 0.152.
 */
package com.example.camerabioandroid.camerabiomanager.camera;

import android.util.Log;
import android.util.Size;
import java.util.ArrayList;
import java.util.List;

public class ImageSize {
    private static boolean DEBUG = false;
    private static final String TAG = "ImageSize";
    public static final int MAX_JPEG_WIDTH = 1280;
    public static final int MAX_JPEG_HEIGHT = 720;

    public static Size chooseOptimalJpegSize(List<Size> sizeJpegList, float width, float height) {
        float ASPECT_TOLERANCE = 0.4f;
        double minDiff = Double.MAX_VALUE;
        if (DEBUG) {
            Log.d((String)TAG, (String)"<< select jpeg >>");
        }
        Size optimalJpegSize = null;
        if (height > width) {
            float temp = width;
            width = height;
            height = temp;
        }
        float aspectRatioScreen = width / height;
        int targetHeight = (int)height;
        for (Size size : sizeJpegList) {
            int diffHeight;
            double ratio;
            if (size.getWidth() > 1280) {
                if (!DEBUG) continue;
                Log.d((String)TAG, (String)("Size excluded: " + size.toString()));
                continue;
            }
            if (DEBUG) {
                Log.d((String)TAG, (String)("Size added: " + size.toString()));
            }
            if (Math.abs((ratio = (double)size.getWidth() / (double)size.getHeight()) - (double)aspectRatioScreen) > (double)0.4f || !((double)(diffHeight = Math.abs(size.getHeight() - targetHeight)) < minDiff)) continue;
            optimalJpegSize = size;
            minDiff = diffHeight;
        }
        if (optimalJpegSize == null) {
            minDiff = Double.MAX_VALUE;
            for (Size size : sizeJpegList) {
                if (!((double)Math.abs(size.getHeight() - targetHeight) < minDiff)) continue;
                optimalJpegSize = size;
                minDiff = Math.abs(size.getHeight() - targetHeight);
            }
        }
        return optimalJpegSize;
    }

    public static Size getOptimalPreviewSize(Size[] sizes, float width, float height, int facing) {
        float ASPECT_TOLERANCE = 0.1f;
        if (height > width) {
            float temp = width;
            width = height;
            height = temp;
        }
        float targetRatio = width / height;
        ArrayList<Size> cameraSizes = new ArrayList<Size>();
        if (facing == 0) {
            for (Size size : sizes) {
                if (size.getWidth() > 1280 && size.getHeight() > 720 || size.getWidth() == size.getHeight()) continue;
                float maxWidthItem = size.getWidth();
                float maxHeightItem = size.getHeight();
                if (!(maxWidthItem <= width) || !(maxHeightItem <= height)) continue;
                cameraSizes.add(size);
            }
        }
        if (cameraSizes.isEmpty()) {
            return null;
        }
        Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        float targetHeight = height;
        while (optimalSize == null) {
            for (Size size : cameraSizes) {
                double ratio = (double)size.getWidth() / (double)size.getHeight();
                if (Math.abs(ratio - (double)targetRatio) > (double)ASPECT_TOLERANCE || !((double)Math.abs((float)size.getHeight() - targetHeight) < minDiff)) continue;
                optimalSize = size;
                minDiff = Math.abs((float)size.getHeight() - targetHeight);
            }
        }
        if (optimalSize.getHeight() > 1024) {
            Size size;
            optimalSize = size = new Size(optimalSize.getWidth() / 2, optimalSize.getWidth() / 2);
        }
        float larg = 1280.0f / targetRatio;
        optimalSize = new Size(1280, (int)larg);
        return optimalSize;
    }
}

