/*
 * Decompiled with CFR 0.152.
 */
package com.example.camerabioandroid.camerabiomanager.bitmap;

import android.graphics.Bitmap;
import android.graphics.ImageFormat;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.media.Image;
import android.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class ImageUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toBase64JPEG(Bitmap bitmap, boolean recycle) {
        try {
            if (bitmap == null) {
                throw new IllegalArgumentException("Bitmap inv\u00e1lido.");
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 92, (OutputStream)stream);
            String string2 = Base64.encodeToString((byte[])stream.toByteArray(), (int)2);
            return string2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (recycle) {
                bitmap.recycle();
                bitmap = null;
                System.gc();
            }
        }
        return null;
    }

    public static Bitmap rotateBitmap(Bitmap bitmap, int degree, boolean recycle) throws Exception {
        Bitmap mtx;
        try {
            int e = bitmap.getWidth();
            int height = bitmap.getHeight();
            if (e >= height) {
                Bitmap bmp;
                Matrix mtx1 = new Matrix();
                mtx1.postRotate((float)degree);
                Bitmap bitmap2 = bmp = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)e, (int)height, (Matrix)mtx1, (boolean)true);
                return bitmap2;
            }
            mtx = bitmap;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            if (recycle) {
                bitmap.recycle();
                bitmap = null;
            }
            System.gc();
        }
        return mtx;
    }

    public static Bitmap flipX(Bitmap bitmap) throws Exception {
        Bitmap bmp;
        try {
            int e = bitmap.getWidth();
            int height = bitmap.getHeight();
            Matrix mtx = new Matrix();
            mtx.postScale(-1.0f, 1.0f, (float)(e / 2), (float)(height / 2));
            bmp = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)e, (int)height, (Matrix)mtx, (boolean)true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            bitmap.recycle();
            bitmap = null;
            System.gc();
        }
        return bmp;
    }

    public static byte[] YUV420ToJPEG(Image image) {
        byte[] data = null;
        if (image.getFormat() == 35) {
            data = ImageUtils.NV21toJPEG(ImageUtils.YUV420toNV21(image), image.getWidth(), image.getHeight(), 100);
        }
        return data;
    }

    public static byte[] NV21toJPEG(byte[] nv21, int width, int height, int quality) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        YuvImage yuv = new YuvImage(nv21, 17, width, height, null);
        yuv.compressToJpeg(new Rect(0, 0, width, height), quality, (OutputStream)out);
        return out.toByteArray();
    }

    public static byte[] YUV420toNV21(Image image) {
        Rect crop = image.getCropRect();
        int format = image.getFormat();
        int width = crop.width();
        int height = crop.height();
        Image.Plane[] planes = image.getPlanes();
        byte[] data = new byte[width * height * ImageFormat.getBitsPerPixel((int)format) / 8];
        byte[] rowData = new byte[planes[0].getRowStride()];
        int channelOffset = 0;
        int outputStride = 1;
        for (int i = 0; i < planes.length; ++i) {
            switch (i) {
                case 0: {
                    channelOffset = 0;
                    outputStride = 1;
                    break;
                }
                case 1: {
                    channelOffset = width * height + 1;
                    outputStride = 2;
                    break;
                }
                case 2: {
                    channelOffset = width * height;
                    outputStride = 2;
                }
            }
            ByteBuffer buffer = planes[i].getBuffer();
            int rowStride = planes[i].getRowStride();
            int pixelStride = planes[i].getPixelStride();
            int shift = i == 0 ? 0 : 1;
            int w = width >> shift;
            int h = height >> shift;
            buffer.position(rowStride * (crop.top >> shift) + pixelStride * (crop.left >> shift));
            for (int row = 0; row < h; ++row) {
                int length;
                if (pixelStride == 1 && outputStride == 1) {
                    length = w;
                    buffer.get(data, channelOffset, length);
                    channelOffset += length;
                } else {
                    length = (w - 1) * pixelStride + 1;
                    buffer.get(rowData, 0, length);
                    for (int col = 0; col < w; ++col) {
                        data[channelOffset] = rowData[col * pixelStride];
                        channelOffset += outputStride;
                    }
                }
                if (row >= h - 1) continue;
                buffer.position(buffer.position() + rowStride - length);
            }
        }
        return data;
    }

    public static byte[] rotateYUV420Degree90(byte[] data, int imageWidth, int imageHeight) {
        int y;
        int x;
        byte[] yuv = new byte[imageWidth * imageHeight * 3 / 2];
        int i = 0;
        for (x = 0; x < imageWidth; ++x) {
            for (y = imageHeight - 1; y >= 0; --y) {
                yuv[i] = data[y * imageWidth + x];
                ++i;
            }
        }
        i = imageWidth * imageHeight * 3 / 2 - 1;
        for (x = imageWidth - 1; x > 0; x -= 2) {
            for (y = 0; y < imageHeight / 2; ++y) {
                yuv[i] = data[imageWidth * imageHeight + y * imageWidth + x];
                yuv[--i] = data[imageWidth * imageHeight + y * imageWidth + (x - 1)];
                --i;
            }
        }
        return yuv;
    }

    public static byte[] rotateYUV420Degree180(byte[] data, int imageWidth, int imageHeight) {
        byte[] yuv = new byte[imageWidth * imageHeight * 3 / 2];
        int i = 0;
        int count = 0;
        for (i = imageWidth * imageHeight - 1; i >= 0; --i) {
            yuv[count] = data[i];
            ++count;
        }
        i = imageWidth * imageHeight * 3 / 2 - 1;
        for (i = imageWidth * imageHeight * 3 / 2 - 1; i >= imageWidth * imageHeight; i -= 2) {
            yuv[count++] = data[i - 1];
            yuv[count++] = data[i];
        }
        return yuv;
    }

    public static byte[] rotateYUV420Degree270(byte[] data, int imageWidth, int imageHeight) {
        int j;
        int nPos;
        int i;
        byte[] yuv = new byte[imageWidth * imageHeight * 3 / 2];
        int nWidth = 0;
        int nHeight = 0;
        int wh = 0;
        int uvHeight = 0;
        if (imageWidth != nWidth || imageHeight != nHeight) {
            nWidth = imageWidth;
            nHeight = imageHeight;
            wh = imageWidth * imageHeight;
            uvHeight = imageHeight >> 1;
        }
        int k = 0;
        for (i = 0; i < imageWidth; ++i) {
            nPos = 0;
            for (j = 0; j < imageHeight; ++j) {
                yuv[k] = data[nPos + i];
                ++k;
                nPos += imageWidth;
            }
        }
        for (i = 0; i < imageWidth; i += 2) {
            nPos = wh;
            for (j = 0; j < uvHeight; ++j) {
                yuv[k] = data[nPos + i];
                yuv[k + 1] = data[nPos + i + 1];
                k += 2;
                nPos += imageWidth;
            }
        }
        return ImageUtils.rotateYUV420Degree180(yuv, imageWidth, imageHeight);
    }
}

