/*
 * Decompiled with CFR 0.152.
 */
package com.example.camerabioandroid.camerabiomanager;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import com.example.camerabioandroid.R;
import com.example.camerabioandroid.camerabiomanager.Camera2Base;
import com.example.camerabioandroid.camerabiomanager.CameraBioManager;
import com.example.camerabioandroid.camerabiomanager.camera.AutoFitTextureView;
import com.example.camerabioandroid.camerabiomanager.camera.CaptureImageProcessor;
import com.example.camerabioandroid.camerabiomanager.camera.ImageProcessor;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.ml.vision.FirebaseVision;
import com.google.firebase.ml.vision.common.FirebaseVisionImage;
import com.google.firebase.ml.vision.common.FirebaseVisionImageMetadata;
import com.google.firebase.ml.vision.common.FirebaseVisionPoint;
import com.google.firebase.ml.vision.face.FirebaseVisionFace;
import com.google.firebase.ml.vision.face.FirebaseVisionFaceDetector;
import com.google.firebase.ml.vision.face.FirebaseVisionFaceDetectorOptions;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SelfieActivity
extends Camera2Base
implements ImageProcessor,
CaptureImageProcessor {
    public static final float COMPENSATION_EYE = 0.05f;
    public static int total = 0;
    private FirebaseVisionFaceDetector firebaseVisionFaceDetector;
    private FirebaseVisionImageMetadata metadata;
    private TextView countdownView;
    private final String[] mensagens = new String[]{"Centraliza o rosto", "Centraliza o rosto", "Centraliza o rosto", "Aproxime o rosto", "Afaste o rosto", "Gire um pouco a esquerda", "Gire um pouco a direita", "Rosto n\u00e3o identificado", "Rosto inclinado"};
    private int erroIndex = -1;
    private boolean faceOK = true;
    private View lineTopView;
    private View lineBottomView;
    private View lineLeftView;
    private View lineRightView;
    private ImageView rectangleImageView;
    private ImageButton takePictureImageButton;
    private Toast toast;
    private float posVerticalLineLeft = 0.0f;
    private float posVerticalLineRight = 0.0f;
    private float posHorizontalLineBottom = 0.0f;
    private float posHorizontalLineTop = 0.0f;
    private int primaryColor = Color.parseColor((String)"#2980ff");
    private boolean showLines = false;
    private FirebaseVisionFace firebaseVisionFace;
    private FirebaseVisionPoint leftEyePosition;
    private FirebaseVisionPoint rightEyePosition;
    private FirebaseVisionPoint nosePosition;
    private FirebaseVisionImage[] visionImage = new FirebaseVisionImage[1];
    private float leftEyePosX = 0.0f;
    private float leftEyePosY = 0.0f;
    private float rightEyePosX = 0.0f;
    private float rightEyePosY = 0.0f;
    private float nosePosY = 0.0f;
    float diffNose = 0.0f;
    float noseRange = 0.0f;
    private float headPosition = 0.0f;
    float aspectRatioRelative = 0.0f;
    final float minDiffEye = 100.0f;
    final float maxDiffEye = 190.0f;
    float densityFactor = 2.0f;
    float densityMultiply = 2.0f;
    float percentHorizontalRange = 25.0f;
    float percentVerticalRange = 30.0f;
    float percentOffsetVerticalRange = 30.0f;
    float screenWidth = 0.0f;
    float screenHeight = 0.0f;
    float aspectRatioBioEye = 1.0f;
    private GradientDrawable rectangleDrawable;
    private String origin = "";
    private boolean initialized = false;
    private CountDownTimer countDownTimer;
    private Boolean[] countDownCancelled = new Boolean[]{Boolean.FALSE};
    private Boolean isRequestImage;
    private Boolean autoCapture;
    private Boolean countRegressive;
    private static CameraBioManager cameraBioManager;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle b = this.getIntent().getExtras();
        if (b != null) {
            this.origin = b.getString("origin");
        }
        if (this.DEBUG.booleanValue()) {
            Log.d((String)"Camera2Base", (String)("from activity: " + this.origin));
        }
        this.isRequestImage = false;
        Camera2Base.activity = this;
        Camera2Base.imageProcessor = this;
        Camera2Base.captureImageProcessor = this;
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.getWindow().addFlags(128);
        this.setContentView(R.layout.activity_selfie);
        this.takePictureImageButton = (ImageButton)this.findViewById(R.id.take_picture);
        this.takePictureImageButton.setOnClickListener((View.OnClickListener)this);
        this.textureView = (AutoFitTextureView)this.findViewById(R.id.texture);
        this.rootView = this.findViewById(R.id.root_view);
        this.autoCapture = true;
        this.countRegressive = true;
        this.setMaxSizes();
        FirebaseVisionFaceDetectorOptions options = new FirebaseVisionFaceDetectorOptions.Builder().setClassificationMode(2).setMinFaceSize(1.0f).enableTracking().setLandmarkMode(2).build();
        this.firebaseVisionFaceDetector = FirebaseVision.getInstance().getVisionFaceDetector(options);
        this.countdownView = (TextView)this.findViewById(R.id.tvCountdown);
        this.countdownView.setVisibility(4);
        this.rectangleImageView = (ImageView)this.findViewById(R.id.rectangle);
        this.rectangleDrawable = (GradientDrawable)this.rectangleImageView.getBackground();
        this.lineTopView = this.findViewById(R.id.lineTop);
        this.lineBottomView = this.findViewById(R.id.lineBottom);
        this.lineLeftView = this.findViewById(R.id.lineLeft);
        this.lineRightView = this.findViewById(R.id.lineRight);
    }

    public void onBackPressed() {
        this.countDownCancelled[0] = Boolean.TRUE;
        this.destroyTimer();
        activity.finish();
    }

    public void setCameraBioManager(CameraBioManager cameraBioManager) {
        SelfieActivity.cameraBioManager = cameraBioManager;
    }

    @Override
    public void process(byte[] image, int w, final int h, int f) {
        if (!this.initialized && this.DEBUG.booleanValue()) {
            Log.d((String)"Camera2Base", (String)("width  buffer: " + w));
            Log.d((String)"Camera2Base", (String)("height buffer: " + h));
        }
        if (this.countDownCancelled[0].booleanValue()) {
            return;
        }
        this.init(w, h);
        if (this.metadata == null) {
            this.metadata = new FirebaseVisionImageMetadata.Builder().setWidth(w).setHeight(h).setFormat(17).setRotation(this.getImageFirebaseVisionRotation()).build();
        }
        this.visionImage[0] = FirebaseVisionImage.fromByteArray((byte[])image, (FirebaseVisionImageMetadata)this.metadata);
        this.firebaseVisionFaceDetector.detectInImage(this.visionImage[0]).addOnSuccessListener((Activity)this, (OnSuccessListener)new OnSuccessListener<List<FirebaseVisionFace>>(){

            public void onSuccess(List<FirebaseVisionFace> firebaseVisionFaces) {
                ((SelfieActivity)SelfieActivity.this).visionImage[0] = null;
                if (firebaseVisionFaces.size() > 0) {
                    SelfieActivity.this.firebaseVisionFace = firebaseVisionFaces.get(0);
                    SelfieActivity.this.leftEyePosition = SelfieActivity.this.firebaseVisionFace.getLandmark(4).getPosition();
                    SelfieActivity.this.rightEyePosition = SelfieActivity.this.firebaseVisionFace.getLandmark(10).getPosition();
                    SelfieActivity.this.nosePosition = SelfieActivity.this.firebaseVisionFace.getLandmark(6).getPosition();
                    if (SelfieActivity.this.leftEyePosition != null && SelfieActivity.this.rightEyePosition != null) {
                        SelfieActivity.this.headPosition = SelfieActivity.this.firebaseVisionFace.getHeadEulerAngleY();
                        SelfieActivity.this.leftEyePosX = (float)h - SelfieActivity.this.rightEyePosition.getX().floatValue();
                        SelfieActivity.this.leftEyePosY = SelfieActivity.this.rightEyePosition.getY().floatValue();
                        SelfieActivity.this.rightEyePosX = (float)h - SelfieActivity.this.leftEyePosition.getX().floatValue();
                        SelfieActivity.this.rightEyePosY = SelfieActivity.this.leftEyePosition.getY().floatValue();
                        SelfieActivity.this.nosePosY = SelfieActivity.this.nosePosition.getY().floatValue();
                        SelfieActivity.this.leftEyePosition = null;
                        SelfieActivity.this.rightEyePosition = null;
                        SelfieActivity.this.firebaseVisionFace = null;
                        SelfieActivity.this.faceOK = true;
                        SelfieActivity.this.erroIndex = -1;
                        float diffEye = Math.abs(SelfieActivity.this.rightEyePosX - SelfieActivity.this.leftEyePosX);
                        SelfieActivity.this.diffNose = SelfieActivity.this.nosePosY - SelfieActivity.this.leftEyePosY;
                        SelfieActivity.this.noseRange = (diffEye *= SelfieActivity.this.aspectRatioBioEye) / 3.0f;
                        float maxDiffNose = SelfieActivity.this.noseRange * 2.2f;
                        if (SelfieActivity.this.DEBUG.booleanValue()) {
                            Log.d((String)"Camera2Base", (String)("Entre olhos: " + diffEye));
                            Log.d((String)"Camera2Base", (String)("Olho esquerdo (X): " + SelfieActivity.this.leftEyePosX));
                            Log.d((String)"Camera2Base", (String)("Olho esquerdo (Y): " + SelfieActivity.this.leftEyePosY));
                            Log.d((String)"Camera2Base", (String)("Olho direito (X): " + SelfieActivity.this.rightEyePosX));
                            Log.d((String)"Camera2Base", (String)("Olho direito (Y): " + SelfieActivity.this.rightEyePosY));
                        }
                        if (SelfieActivity.this.leftEyePosX < SelfieActivity.this.posVerticalLineLeft || SelfieActivity.this.rightEyePosX > SelfieActivity.this.posVerticalLineRight) {
                            SelfieActivity.this.erroIndex = 0;
                            SelfieActivity.this.faceOK = false;
                        } else if (SelfieActivity.this.leftEyePosY < SelfieActivity.this.posHorizontalLineTop || SelfieActivity.this.leftEyePosY > SelfieActivity.this.posHorizontalLineBottom) {
                            if (SelfieActivity.this.leftEyePosY < SelfieActivity.this.posHorizontalLineTop) {
                                SelfieActivity.this.erroIndex = 1;
                            } else {
                                SelfieActivity.this.erroIndex = 2;
                            }
                            SelfieActivity.this.faceOK = false;
                        } else if (diffEye < 100.0f) {
                            SelfieActivity.this.erroIndex = 3;
                            SelfieActivity.this.faceOK = false;
                        } else if (diffEye > 190.0f) {
                            SelfieActivity.this.erroIndex = 4;
                            SelfieActivity.this.faceOK = false;
                        } else if (SelfieActivity.this.headPosition < -16.0f) {
                            SelfieActivity.this.erroIndex = 5;
                            SelfieActivity.this.faceOK = false;
                        } else if (SelfieActivity.this.headPosition > 16.0f) {
                            SelfieActivity.this.erroIndex = 6;
                            SelfieActivity.this.faceOK = false;
                        } else if (Math.abs(SelfieActivity.this.rightEyePosY - SelfieActivity.this.leftEyePosY) > 20.0f || Math.abs(SelfieActivity.this.leftEyePosY - SelfieActivity.this.rightEyePosY) > 20.0f) {
                            SelfieActivity.this.erroIndex = 8;
                            SelfieActivity.this.faceOK = false;
                        } else if (SelfieActivity.this.diffNose < SelfieActivity.this.noseRange || SelfieActivity.this.diffNose > maxDiffNose) {
                            SelfieActivity.this.erroIndex = 0;
                            SelfieActivity.this.faceOK = false;
                        }
                        if (SelfieActivity.this.faceOK) {
                            SelfieActivity.this.markBlue();
                            SelfieActivity.this.takePictureImageButton.setEnabled(true);
                        } else {
                            SelfieActivity.this.markRed();
                            SelfieActivity.this.takePictureImageButton.setEnabled(false);
                        }
                        if (SelfieActivity.this.showLines) {
                            SelfieActivity.this.addHorizontalLineBottom(SelfieActivity.this.posHorizontalLineBottom * SelfieActivity.this.aspectRatioRelative);
                            SelfieActivity.this.addHorizontalLineTop(SelfieActivity.this.posHorizontalLineTop * SelfieActivity.this.aspectRatioRelative);
                            SelfieActivity.this.addVerticalLineLeft(SelfieActivity.this.posVerticalLineLeft * SelfieActivity.this.aspectRatioRelative);
                            SelfieActivity.this.addVerticalLineRight(SelfieActivity.this.posVerticalLineRight * SelfieActivity.this.aspectRatioRelative);
                            SelfieActivity.this.showLines = false;
                        }
                    } else {
                        SelfieActivity.this.erroIndex = 7;
                        SelfieActivity.this.markRed();
                        SelfieActivity.this.takePictureImageButton.setEnabled(false);
                    }
                } else {
                    SelfieActivity.this.erroIndex = 7;
                    SelfieActivity.this.markRed();
                    SelfieActivity.this.takePictureImageButton.setEnabled(false);
                }
                SelfieActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (SelfieActivity.this.erroIndex != -1) {
                            SelfieActivity.this.showFastToast(SelfieActivity.this.mensagens[SelfieActivity.this.erroIndex]);
                        } else if (SelfieActivity.this.toast != null) {
                            SelfieActivity.this.toast.cancel();
                        }
                    }
                });
            }
        }).addOnFailureListener((Activity)this, new OnFailureListener(){

            public void onFailure(@NonNull Exception ex) {
                Log.d((String)"Camera2Base", (String)("Erro: " + ex.toString()));
            }
        });
    }

    private void destroyTimer() {
        if (this.countDownTimer != null) {
            this.countdownView.setVisibility(4);
            this.countDownTimer.cancel();
            this.countDownTimer = null;
            this.countdownView.setText((CharSequence)"3");
        }
    }

    private void createTimer() {
        if (this.countDownTimer == null && !this.isRequestImage.booleanValue()) {
            this.countdownView.setVisibility(0);
            this.countDownTimer = new CountDownTimer(4000L, 1000L){

                public void onTick(long millisUntilFinished) {
                    ((SelfieActivity)SelfieActivity.this).countDownCancelled[0] = Boolean.FALSE;
                    SelfieActivity.this.countdownView.setText((CharSequence)("" + String.format("%d", TimeUnit.MILLISECONDS.toSeconds(millisUntilFinished) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millisUntilFinished)))));
                }

                public void onFinish() {
                    if (!SelfieActivity.this.countDownCancelled[0].booleanValue()) {
                        SelfieActivity.this.isRequestImage = true;
                        SelfieActivity.this.destroyTimer();
                        SelfieActivity.this.takePicture();
                    }
                }
            };
            this.countDownTimer.start();
        }
    }

    private void autoCapture() {
        if (this.countDownTimer == null && !this.isRequestImage.booleanValue()) {
            this.countDownTimer = new CountDownTimer(2000L, 1000L){

                public void onTick(long millisUntilFinished) {
                }

                public void onFinish() {
                    SelfieActivity.this.isRequestImage = true;
                    SelfieActivity.this.destroyTimer();
                    SelfieActivity.this.takePicture();
                }
            }.start();
        }
    }

    public static float convertPixelsToDp(float px, Context context) {
        return px / ((float)context.getResources().getDisplayMetrics().densityDpi / 160.0f);
    }

    public static float convertDpToPixel(float dp, Context context) {
        return dp * ((float)context.getResources().getDisplayMetrics().densityDpi / 160.0f);
    }

    private void markBlue() {
        this.erroIndex = -1;
        if (this.toast != null) {
            this.toast.cancel();
        }
        if (this.autoCapture.booleanValue() && this.countRegressive.booleanValue() && !this.countDownCancelled[0].booleanValue()) {
            this.createTimer();
        } else if (this.autoCapture.booleanValue()) {
            this.autoCapture();
        }
        int size = 18;
        if (this.screenWidth > 1600.0f) {
            size = 34;
        }
        this.rectangleDrawable.setStroke(size, this.primaryColor);
    }

    private void markRed() {
        this.destroyTimer();
        if (!this.countDownCancelled[0].booleanValue()) {
            int size = 18;
            if (this.screenWidth > 1600.0f) {
                size = 34;
            }
            this.rectangleDrawable.setStroke(size, -65536);
        }
    }

    private void init(float widthBuffer, float heightBuffer) {
        if (!this.initialized) {
            this.screenWidth = this.getWidthPixels();
            this.screenHeight = this.getHeightPixels();
            boolean isBufferPortrait = widthBuffer < heightBuffer;
            float aspectRatioBuffer = isBufferPortrait ? widthBuffer / heightBuffer : heightBuffer / widthBuffer;
            float imageHeightScreen = this.screenWidth / aspectRatioBuffer;
            float imageHeightBuffer = 720.0f / aspectRatioBuffer;
            this.aspectRatioRelative = imageHeightScreen / (isBufferPortrait ? heightBuffer : widthBuffer);
            this.aspectRatioBioEye = imageHeightBuffer / (isBufferPortrait ? heightBuffer : widthBuffer);
            float f = this.aspectRatioBioEye = this.aspectRatioBioEye < 1.0f ? 1.0f : this.aspectRatioBioEye;
            if (this.DEBUG.booleanValue()) {
                Log.d((String)"Camera2Base", (String)("Aspect Ratio BIO: " + this.aspectRatioBioEye));
            }
            float refWidth = isBufferPortrait ? widthBuffer : heightBuffer;
            float refHeight = isBufferPortrait ? heightBuffer : widthBuffer;
            float topOffet = refHeight * this.percentOffsetVerticalRange / 100.0f;
            float heightRange = refHeight * this.percentVerticalRange / 100.0f;
            DisplayMetrics metrics = this.getResources().getDisplayMetrics();
            this.densityFactor = metrics.density;
            this.posVerticalLineLeft = refWidth * (this.percentHorizontalRange / 100.0f);
            this.posVerticalLineRight = refWidth * (this.percentHorizontalRange / 100.0f * 3.0f);
            this.posHorizontalLineTop = topOffet;
            this.posHorizontalLineBottom = topOffet + heightRange;
            this.initialized = true;
        }
    }

    private void addHorizontalLineBottom(float bottom) {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams((int)this.screenWidth, 10);
        layoutParams.setMargins(0, (int)bottom, 0, 0);
        this.lineBottomView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void addHorizontalLineTop(float top) {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams((int)this.screenWidth, 10);
        layoutParams.setMargins(0, (int)top, 0, 0);
        this.lineTopView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void addVerticalLineLeft(float left) {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(10, (int)this.screenHeight);
        layoutParams.setMargins((int)left, 0, 0, 0);
        this.lineLeftView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void addVerticalLineRight(float right) {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(10, (int)this.screenHeight);
        layoutParams.setMargins((int)right, 0, 0, 0);
        this.lineRightView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.take_picture) {
            this.destroyTimer();
            this.countDownCancelled[0] = Boolean.TRUE;
            this.isRequestImage = true;
            super.takePicture();
        }
    }

    @Override
    public void capture(String base64) {
        if (base64 != null) {
            cameraBioManager.capture(base64);
            this.finish();
        } else {
            this.showErrorMessage("Erro ao recuperar imagem capturada");
        }
    }

    private void showErrorMessage(String message) {
        this.reopenCamera();
    }

    @Override
    protected void showFastToast(String message) {
        try {
            if (this.toast == null) {
                this.toast = Toast.makeText((Context)this, (CharSequence)message, (int)0);
                this.toast.setGravity(49, 0, 0);
            }
            this.toast.setText((CharSequence)message);
            this.toast.show();
        }
        catch (Exception ex) {
            Log.d((String)"Camera2Base", (String)ex.toString());
        }
    }
}

