/*
 * Decompiled with CFR 0.152.
 */
package com.example.camerabioandroid.camerabiomanager;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.PersistableBundle;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import com.example.camerabioandroid.R;
import com.google.android.material.snackbar.Snackbar;

public class BaseActivity
extends AppCompatActivity {
    public static final String TAG = "BaseActivity";
    protected View rootView;

    public void onCreate(@Nullable Bundle savedInstanceState, @Nullable PersistableBundle persistentState) {
        super.onCreate(savedInstanceState, persistentState);
        this.rootView = this.findViewById(R.id.root_view);
    }

    protected void showSnackbar(String text) {
        if (text == null) {
            Log.e((String)TAG, (String)text);
            return;
        }
        Snackbar snackbar = Snackbar.make((View)this.getRootView(), (CharSequence)text, (int)0);
        View snackbarView = snackbar.getView();
        snackbarView.setBackgroundColor(ContextCompat.getColor((Context)this.getApplicationContext(), (int)R.color.colorRed));
        TextView textView = (TextView)snackbarView.findViewById(R.id.snackbar_text);
        textView.setTextColor(-1);
        snackbar.show();
    }

    protected void showFastToast(String message) {
        try {
            Toast toast = Toast.makeText((Context)this, (CharSequence)message, (int)0);
            toast.setGravity(49, 0, 0);
            toast.show();
        }
        catch (Exception ex) {
            Log.d((String)TAG, (String)ex.toString());
        }
    }

    protected void showToast(String message) {
        try {
            Toast toast = Toast.makeText((Context)this, (CharSequence)message, (int)0);
            toast.setGravity(49, 0, 0);
            toast.show();
        }
        catch (Exception ex) {
            Log.d((String)TAG, (String)ex.toString());
        }
    }

    protected void hideKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.getRootView().getWindowToken(), 0);
    }

    public void showAlert(String message) {
        AlertDialog alertDialog = new AlertDialog.Builder((Context)this).create();
        alertDialog.setTitle((CharSequence)message);
        alertDialog.setButton(-3, (CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        alertDialog.show();
    }

    private View getRootView() {
        if (this.rootView == null) {
            this.rootView = this.findViewById(R.id.root_view);
        }
        return this.rootView;
    }

    protected String getNormalizedUserName(String userName) {
        if (userName == null || userName.trim().length() == 0) {
            return "";
        }
        String[] array = userName.toLowerCase().split(" ");
        String name = "";
        if (array.length > 1) {
            String strName = array[0];
            String strLastname = array[1];
            if (strName.length() > 1) {
                name = strName.substring(0, 1).toUpperCase() + strName.substring(1) + " ";
            }
            if (strLastname.length() > 1) {
                name = name + strLastname.substring(0, 1).toUpperCase() + ".";
            }
        } else {
            String str = array[0];
            if (str != null && str.length() > 1) {
                name = str.substring(0, 1).toUpperCase() + str.substring(1);
            }
        }
        return name;
    }
}

