/*
 * Decompiled with CFR 0.152.
 */
package com.example.camerabioandroid.camerabiomanager.exif;

import android.util.Log;
import com.example.camerabioandroid.camerabiomanager.exif.CountedDataInputStream;
import com.example.camerabioandroid.camerabiomanager.exif.ExifInterface;
import com.example.camerabioandroid.camerabiomanager.exif.ExifInvalidFormatException;
import com.example.camerabioandroid.camerabiomanager.exif.ExifTag;
import com.example.camerabioandroid.camerabiomanager.exif.JpegHeader;
import com.example.camerabioandroid.camerabiomanager.exif.Rational;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.TreeMap;

class ExifParser {
    private static final boolean LOGV = false;
    private static final String TAG = "ExifParser";
    public static final int EVENT_START_OF_IFD = 0;
    public static final int EVENT_NEW_TAG = 1;
    public static final int EVENT_VALUE_OF_REGISTERED_TAG = 2;
    public static final int EVENT_COMPRESSED_IMAGE = 3;
    public static final int EVENT_UNCOMPRESSED_STRIP = 4;
    public static final int EVENT_END = 5;
    public static final int OPTION_IFD_0 = 1;
    public static final int OPTION_IFD_1 = 2;
    public static final int OPTION_IFD_EXIF = 4;
    public static final int OPTION_IFD_GPS = 8;
    public static final int OPTION_IFD_INTEROPERABILITY = 16;
    public static final int OPTION_THUMBNAIL = 32;
    protected static final int EXIF_HEADER = 1165519206;
    protected static final short EXIF_HEADER_TAIL = 0;
    protected static final short LITTLE_ENDIAN_TAG = 18761;
    protected static final short BIG_ENDIAN_TAG = 19789;
    protected static final short TIFF_HEADER_TAIL = 42;
    protected static final int TAG_SIZE = 12;
    protected static final int OFFSET_SIZE = 2;
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    protected static final int DEFAULT_IFD0_OFFSET = 8;
    private final CountedDataInputStream mTiffStream;
    private final int mOptions;
    private int mIfdStartOffset = 0;
    private int mNumOfTagInIfd = 0;
    private int mIfdType;
    private ExifTag mTag;
    private ImageEvent mImageEvent;
    private int mStripCount;
    private ExifTag mStripSizeTag;
    private ExifTag mJpegSizeTag;
    private boolean mNeedToParseOffsetsInCurrentIfd;
    private boolean mContainExifData = false;
    private int mApp1End;
    private int mOffsetToApp1EndFromSOF = 0;
    private byte[] mDataAboveIfd0;
    private int mIfd0Position;
    private int mTiffStartPosition;
    private final ExifInterface mInterface;
    private static final short TAG_EXIF_IFD = ExifInterface.getTrueTagKey(ExifInterface.TAG_EXIF_IFD);
    private static final short TAG_GPS_IFD = ExifInterface.getTrueTagKey(ExifInterface.TAG_GPS_IFD);
    private static final short TAG_INTEROPERABILITY_IFD = ExifInterface.getTrueTagKey(ExifInterface.TAG_INTEROPERABILITY_IFD);
    private static final short TAG_JPEG_INTERCHANGE_FORMAT = ExifInterface.getTrueTagKey(ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT);
    private static final short TAG_JPEG_INTERCHANGE_FORMAT_LENGTH = ExifInterface.getTrueTagKey(ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT_LENGTH);
    private static final short TAG_STRIP_OFFSETS = ExifInterface.getTrueTagKey(ExifInterface.TAG_STRIP_OFFSETS);
    private static final short TAG_STRIP_BYTE_COUNTS = ExifInterface.getTrueTagKey(ExifInterface.TAG_STRIP_BYTE_COUNTS);
    private final TreeMap<Integer, Object> mCorrespondingEvent = new TreeMap();

    private boolean isIfdRequested(int ifdType) {
        switch (ifdType) {
            case 0: {
                return (this.mOptions & 1) != 0;
            }
            case 1: {
                return (this.mOptions & 2) != 0;
            }
            case 2: {
                return (this.mOptions & 4) != 0;
            }
            case 4: {
                return (this.mOptions & 8) != 0;
            }
            case 3: {
                return (this.mOptions & 0x10) != 0;
            }
        }
        return false;
    }

    private boolean isThumbnailRequested() {
        return (this.mOptions & 0x20) != 0;
    }

    private ExifParser(InputStream inputStream, int options, ExifInterface iRef) throws IOException, ExifInvalidFormatException {
        if (inputStream == null) {
            throw new IOException("Null argument inputStream to ExifParser");
        }
        this.mInterface = iRef;
        this.mContainExifData = this.seekTiffData(inputStream);
        this.mTiffStream = new CountedDataInputStream(inputStream);
        this.mOptions = options;
        if (!this.mContainExifData) {
            return;
        }
        this.parseTiffHeader();
        long offset = this.mTiffStream.readUnsignedInt();
        if (offset > Integer.MAX_VALUE) {
            throw new ExifInvalidFormatException("Invalid offset " + offset);
        }
        this.mIfd0Position = (int)offset;
        this.mIfdType = 0;
        if (this.isIfdRequested(0) || this.needToParseOffsetsInCurrentIfd()) {
            this.registerIfd(0, offset);
            if (offset != 8L) {
                this.mDataAboveIfd0 = new byte[(int)offset - 8];
                this.read(this.mDataAboveIfd0);
            }
        }
    }

    protected static ExifParser parse(InputStream inputStream, int options, ExifInterface iRef) throws IOException, ExifInvalidFormatException {
        return new ExifParser(inputStream, options, iRef);
    }

    protected static ExifParser parse(InputStream inputStream, ExifInterface iRef) throws IOException, ExifInvalidFormatException {
        return new ExifParser(inputStream, 63, iRef);
    }

    protected int next() throws IOException, ExifInvalidFormatException {
        int endOfTags;
        if (!this.mContainExifData) {
            return 5;
        }
        int offset = this.mTiffStream.getReadByteCount();
        if (offset < (endOfTags = this.mIfdStartOffset + 2 + 12 * this.mNumOfTagInIfd)) {
            this.mTag = this.readTag();
            if (this.mTag == null) {
                return this.next();
            }
            if (this.mNeedToParseOffsetsInCurrentIfd) {
                this.checkOffsetOrImageTag(this.mTag);
            }
            return 1;
        }
        if (offset == endOfTags) {
            if (this.mIfdType == 0) {
                long ifdOffset = this.readUnsignedLong();
                if ((this.isIfdRequested(1) || this.isThumbnailRequested()) && ifdOffset != 0L) {
                    this.registerIfd(1, ifdOffset);
                }
            } else {
                int offsetSize = 4;
                if (this.mCorrespondingEvent.size() > 0) {
                    offsetSize = this.mCorrespondingEvent.firstEntry().getKey() - this.mTiffStream.getReadByteCount();
                }
                if (offsetSize < 4) {
                    Log.w((String)TAG, (String)("Invalid size of link to next IFD: " + offsetSize));
                } else {
                    long ifdOffset = this.readUnsignedLong();
                    if (ifdOffset != 0L) {
                        Log.w((String)TAG, (String)("Invalid link to next IFD: " + ifdOffset));
                    }
                }
            }
        }
        while (this.mCorrespondingEvent.size() != 0) {
            Map.Entry<Integer, Object> entry = this.mCorrespondingEvent.pollFirstEntry();
            Object event = entry.getValue();
            try {
                this.skipTo(entry.getKey());
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)("Failed to skip to data at: " + entry.getKey() + " for " + event.getClass().getName() + ", the file may be broken."));
                continue;
            }
            if (event instanceof IfdEvent) {
                this.mIfdType = ((IfdEvent)event).ifd;
                this.mNumOfTagInIfd = this.mTiffStream.readUnsignedShort();
                this.mIfdStartOffset = entry.getKey();
                if (this.mNumOfTagInIfd * 12 + this.mIfdStartOffset + 2 > this.mApp1End) {
                    Log.w((String)TAG, (String)("Invalid size of IFD " + this.mIfdType));
                    return 5;
                }
                this.mNeedToParseOffsetsInCurrentIfd = this.needToParseOffsetsInCurrentIfd();
                if (((IfdEvent)event).isRequested) {
                    return 0;
                }
                this.skipRemainingTagsInCurrentIfd();
                continue;
            }
            if (event instanceof ImageEvent) {
                this.mImageEvent = (ImageEvent)event;
                return this.mImageEvent.type;
            }
            ExifTagEvent tagEvent = (ExifTagEvent)event;
            this.mTag = tagEvent.tag;
            if (this.mTag.getDataType() != 7) {
                this.readFullTagValue(this.mTag);
                this.checkOffsetOrImageTag(this.mTag);
            }
            if (!tagEvent.isRequested) continue;
            return 2;
        }
        return 5;
    }

    protected void skipRemainingTagsInCurrentIfd() throws IOException, ExifInvalidFormatException {
        int endOfTags = this.mIfdStartOffset + 2 + 12 * this.mNumOfTagInIfd;
        int offset = this.mTiffStream.getReadByteCount();
        if (offset > endOfTags) {
            return;
        }
        if (this.mNeedToParseOffsetsInCurrentIfd) {
            while (offset < endOfTags) {
                this.mTag = this.readTag();
                offset += 12;
                if (this.mTag == null) continue;
                this.checkOffsetOrImageTag(this.mTag);
            }
        } else {
            this.skipTo(endOfTags);
        }
        long ifdOffset = this.readUnsignedLong();
        if (this.mIfdType == 0 && (this.isIfdRequested(1) || this.isThumbnailRequested()) && ifdOffset > 0L) {
            this.registerIfd(1, ifdOffset);
        }
    }

    private boolean needToParseOffsetsInCurrentIfd() {
        switch (this.mIfdType) {
            case 0: {
                return this.isIfdRequested(2) || this.isIfdRequested(4) || this.isIfdRequested(3) || this.isIfdRequested(1);
            }
            case 1: {
                return this.isThumbnailRequested();
            }
            case 2: {
                return this.isIfdRequested(3);
            }
        }
        return false;
    }

    protected ExifTag getTag() {
        return this.mTag;
    }

    protected int getTagCountInCurrentIfd() {
        return this.mNumOfTagInIfd;
    }

    protected int getCurrentIfd() {
        return this.mIfdType;
    }

    protected int getStripIndex() {
        return this.mImageEvent.stripIndex;
    }

    protected int getStripCount() {
        return this.mStripCount;
    }

    protected int getStripSize() {
        if (this.mStripSizeTag == null) {
            return 0;
        }
        return (int)this.mStripSizeTag.getValueAt(0);
    }

    protected int getCompressedImageSize() {
        if (this.mJpegSizeTag == null) {
            return 0;
        }
        return (int)this.mJpegSizeTag.getValueAt(0);
    }

    private void skipTo(int offset) throws IOException {
        this.mTiffStream.skipTo(offset);
        while (!this.mCorrespondingEvent.isEmpty() && this.mCorrespondingEvent.firstKey() < offset) {
            this.mCorrespondingEvent.pollFirstEntry();
        }
    }

    protected void registerForTagValue(ExifTag tag) {
        if (tag.getOffset() >= this.mTiffStream.getReadByteCount()) {
            this.mCorrespondingEvent.put(tag.getOffset(), new ExifTagEvent(tag, true));
        }
    }

    private void registerIfd(int ifdType, long offset) {
        this.mCorrespondingEvent.put((int)offset, new IfdEvent(ifdType, this.isIfdRequested(ifdType)));
    }

    private void registerCompressedImage(long offset) {
        this.mCorrespondingEvent.put((int)offset, new ImageEvent(3));
    }

    private void registerUncompressedStrip(int stripIndex, long offset) {
        this.mCorrespondingEvent.put((int)offset, new ImageEvent(4, stripIndex));
    }

    private ExifTag readTag() throws IOException, ExifInvalidFormatException {
        short tagId = this.mTiffStream.readShort();
        short dataFormat = this.mTiffStream.readShort();
        long numOfComp = this.mTiffStream.readUnsignedInt();
        if (numOfComp > Integer.MAX_VALUE) {
            throw new ExifInvalidFormatException("Number of component is larger then Integer.MAX_VALUE");
        }
        if (!ExifTag.isValidType(dataFormat)) {
            Log.w((String)TAG, (String)String.format("Tag %04x: Invalid data type %d", tagId, dataFormat));
            this.mTiffStream.skip(4L);
            return null;
        }
        ExifTag tag = new ExifTag(tagId, dataFormat, (int)numOfComp, this.mIfdType, (int)numOfComp != 0);
        int dataSize = tag.getDataSize();
        if (dataSize > 4) {
            long offset = this.mTiffStream.readUnsignedInt();
            if (offset > Integer.MAX_VALUE) {
                throw new ExifInvalidFormatException("offset is larger then Integer.MAX_VALUE");
            }
            if (offset < (long)this.mIfd0Position && dataFormat == 7) {
                byte[] buf = new byte[(int)numOfComp];
                System.arraycopy(this.mDataAboveIfd0, (int)offset - 8, buf, 0, (int)numOfComp);
                tag.setValue(buf);
            } else {
                tag.setOffset((int)offset);
            }
        } else {
            boolean defCount = tag.hasDefinedCount();
            tag.setHasDefinedCount(false);
            this.readFullTagValue(tag);
            tag.setHasDefinedCount(defCount);
            this.mTiffStream.skip(4 - dataSize);
            tag.setOffset(this.mTiffStream.getReadByteCount() - 4);
        }
        return tag;
    }

    private void checkOffsetOrImageTag(ExifTag tag) {
        if (tag.getComponentCount() == 0) {
            return;
        }
        short tid = tag.getTagId();
        int ifd = tag.getIfd();
        if (tid == TAG_EXIF_IFD && this.checkAllowed(ifd, ExifInterface.TAG_EXIF_IFD)) {
            if (this.isIfdRequested(2) || this.isIfdRequested(3)) {
                this.registerIfd(2, tag.getValueAt(0));
            }
        } else if (tid == TAG_GPS_IFD && this.checkAllowed(ifd, ExifInterface.TAG_GPS_IFD)) {
            if (this.isIfdRequested(4)) {
                this.registerIfd(4, tag.getValueAt(0));
            }
        } else if (tid == TAG_INTEROPERABILITY_IFD && this.checkAllowed(ifd, ExifInterface.TAG_INTEROPERABILITY_IFD)) {
            if (this.isIfdRequested(3)) {
                this.registerIfd(3, tag.getValueAt(0));
            }
        } else if (tid == TAG_JPEG_INTERCHANGE_FORMAT && this.checkAllowed(ifd, ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT)) {
            if (this.isThumbnailRequested()) {
                this.registerCompressedImage(tag.getValueAt(0));
            }
        } else if (tid == TAG_JPEG_INTERCHANGE_FORMAT_LENGTH && this.checkAllowed(ifd, ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT_LENGTH)) {
            if (this.isThumbnailRequested()) {
                this.mJpegSizeTag = tag;
            }
        } else if (tid == TAG_STRIP_OFFSETS && this.checkAllowed(ifd, ExifInterface.TAG_STRIP_OFFSETS)) {
            if (this.isThumbnailRequested()) {
                if (tag.hasValue()) {
                    for (int i = 0; i < tag.getComponentCount(); ++i) {
                        if (tag.getDataType() == 3) {
                            this.registerUncompressedStrip(i, tag.getValueAt(i));
                            continue;
                        }
                        this.registerUncompressedStrip(i, tag.getValueAt(i));
                    }
                } else {
                    this.mCorrespondingEvent.put(tag.getOffset(), new ExifTagEvent(tag, false));
                }
            }
        } else if (tid == TAG_STRIP_BYTE_COUNTS && this.checkAllowed(ifd, ExifInterface.TAG_STRIP_BYTE_COUNTS) && this.isThumbnailRequested() && tag.hasValue()) {
            this.mStripSizeTag = tag;
        }
    }

    private boolean checkAllowed(int ifd, int tagId) {
        int info = this.mInterface.getTagInfo().get(tagId);
        if (info == 0) {
            return false;
        }
        return ExifInterface.isIfdAllowed(info, ifd);
    }

    protected void readFullTagValue(ExifTag tag) throws IOException {
        short type = tag.getDataType();
        if (type == 2 || type == 7 || type == 1) {
            int size = tag.getComponentCount();
            if (this.mCorrespondingEvent.size() > 0 && this.mCorrespondingEvent.firstEntry().getKey() < this.mTiffStream.getReadByteCount() + size) {
                Object event = this.mCorrespondingEvent.firstEntry().getValue();
                if (event instanceof ImageEvent) {
                    Log.w((String)TAG, (String)("Thumbnail overlaps value for tag: \n" + tag.toString()));
                    Map.Entry<Integer, Object> entry = this.mCorrespondingEvent.pollFirstEntry();
                    Log.w((String)TAG, (String)("Invalid thumbnail offset: " + entry.getKey()));
                } else {
                    if (event instanceof IfdEvent) {
                        Log.w((String)TAG, (String)("Ifd " + ((IfdEvent)event).ifd + " overlaps value for tag: \n" + tag.toString()));
                    } else if (event instanceof ExifTagEvent) {
                        Log.w((String)TAG, (String)("Tag value for tag: \n" + ((ExifTagEvent)event).tag.toString() + " overlaps value for tag: \n" + tag.toString()));
                    }
                    size = this.mCorrespondingEvent.firstEntry().getKey() - this.mTiffStream.getReadByteCount();
                    Log.w((String)TAG, (String)("Invalid size of tag: \n" + tag.toString() + " setting count to: " + size));
                    tag.forceSetComponentCount(size);
                }
            }
        }
        switch (tag.getDataType()) {
            case 1: 
            case 7: {
                byte[] buf = new byte[tag.getComponentCount()];
                this.read(buf);
                tag.setValue(buf);
                break;
            }
            case 2: {
                tag.setValue(this.readString(tag.getComponentCount()));
                break;
            }
            case 4: {
                long[] value = new long[tag.getComponentCount()];
                int n = value.length;
                for (int i = 0; i < n; ++i) {
                    value[i] = this.readUnsignedLong();
                }
                tag.setValue(value);
                break;
            }
            case 5: {
                Rational[] value = new Rational[tag.getComponentCount()];
                int n = value.length;
                for (int i = 0; i < n; ++i) {
                    value[i] = this.readUnsignedRational();
                }
                tag.setValue(value);
                break;
            }
            case 3: {
                int[] value = new int[tag.getComponentCount()];
                int n = value.length;
                for (int i = 0; i < n; ++i) {
                    value[i] = this.readUnsignedShort();
                }
                tag.setValue(value);
                break;
            }
            case 9: {
                int[] value = new int[tag.getComponentCount()];
                int n = value.length;
                for (int i = 0; i < n; ++i) {
                    value[i] = this.readLong();
                }
                tag.setValue(value);
                break;
            }
            case 10: {
                Rational[] value = new Rational[tag.getComponentCount()];
                int n = value.length;
                for (int i = 0; i < n; ++i) {
                    value[i] = this.readRational();
                }
                tag.setValue(value);
            }
        }
    }

    private void parseTiffHeader() throws IOException, ExifInvalidFormatException {
        short byteOrder = this.mTiffStream.readShort();
        if (18761 == byteOrder) {
            this.mTiffStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        } else if (19789 == byteOrder) {
            this.mTiffStream.setByteOrder(ByteOrder.BIG_ENDIAN);
        } else {
            throw new ExifInvalidFormatException("Invalid TIFF header");
        }
        if (this.mTiffStream.readShort() != 42) {
            throw new ExifInvalidFormatException("Invalid TIFF header");
        }
    }

    private boolean seekTiffData(InputStream inputStream) throws IOException, ExifInvalidFormatException {
        CountedDataInputStream dataStream = new CountedDataInputStream(inputStream);
        if (dataStream.readShort() != -40) {
            throw new ExifInvalidFormatException("Invalid JPEG format");
        }
        short marker = dataStream.readShort();
        while (marker != -39 && !JpegHeader.isSofMarker(marker)) {
            int length = dataStream.readUnsignedShort();
            if (marker == -31) {
                int header = 0;
                short headerTail = 0;
                if (length >= 8) {
                    header = dataStream.readInt();
                    headerTail = dataStream.readShort();
                    length -= 6;
                    if (header == 1165519206 && headerTail == 0) {
                        this.mTiffStartPosition = dataStream.getReadByteCount();
                        this.mApp1End = length;
                        this.mOffsetToApp1EndFromSOF = this.mTiffStartPosition + this.mApp1End;
                        return true;
                    }
                }
            }
            if (length < 2 || (long)(length - 2) != dataStream.skip(length - 2)) {
                Log.w((String)TAG, (String)"Invalid JPEG format.");
                return false;
            }
            marker = dataStream.readShort();
        }
        return false;
    }

    protected int getOffsetToExifEndFromSOF() {
        return this.mOffsetToApp1EndFromSOF;
    }

    protected int getTiffStartPosition() {
        return this.mTiffStartPosition;
    }

    protected int read(byte[] buffer, int offset, int length) throws IOException {
        return this.mTiffStream.read(buffer, offset, length);
    }

    protected int read(byte[] buffer) throws IOException {
        return this.mTiffStream.read(buffer);
    }

    protected String readString(int n) throws IOException {
        return this.readString(n, US_ASCII);
    }

    protected String readString(int n, Charset charset) throws IOException {
        if (n > 0) {
            return this.mTiffStream.readString(n, charset);
        }
        return "";
    }

    protected int readUnsignedShort() throws IOException {
        return this.mTiffStream.readShort() & 0xFFFF;
    }

    protected long readUnsignedLong() throws IOException {
        return (long)this.readLong() & 0xFFFFFFFFL;
    }

    protected Rational readUnsignedRational() throws IOException {
        long nomi = this.readUnsignedLong();
        long denomi = this.readUnsignedLong();
        return new Rational(nomi, denomi);
    }

    protected int readLong() throws IOException {
        return this.mTiffStream.readInt();
    }

    protected Rational readRational() throws IOException {
        int nomi = this.readLong();
        int denomi = this.readLong();
        return new Rational(nomi, denomi);
    }

    protected ByteOrder getByteOrder() {
        return this.mTiffStream.getByteOrder();
    }

    private static class ExifTagEvent {
        ExifTag tag;
        boolean isRequested;

        ExifTagEvent(ExifTag tag, boolean isRequireByUser) {
            this.tag = tag;
            this.isRequested = isRequireByUser;
        }
    }

    private static class IfdEvent {
        int ifd;
        boolean isRequested;

        IfdEvent(int ifd, boolean isInterestedIfd) {
            this.ifd = ifd;
            this.isRequested = isInterestedIfd;
        }
    }

    private static class ImageEvent {
        int stripIndex;
        int type;

        ImageEvent(int type) {
            this.stripIndex = 0;
            this.type = type;
        }

        ImageEvent(int type, int stripIndex) {
            this.type = type;
            this.stripIndex = stripIndex;
        }
    }
}

