/*
 * Decompiled with CFR 0.152.
 */
package com.example.camerabioandroid.camerabiomanager.exif;

import com.example.camerabioandroid.camerabiomanager.exif.ExifInterface;
import com.example.camerabioandroid.camerabiomanager.exif.ExifTag;
import com.example.camerabioandroid.camerabiomanager.exif.IfdData;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ExifData {
    private static final byte[] USER_COMMENT_ASCII = new byte[]{65, 83, 67, 73, 73, 0, 0, 0};
    private static final byte[] USER_COMMENT_JIS = new byte[]{74, 73, 83, 0, 0, 0, 0, 0};
    private static final byte[] USER_COMMENT_UNICODE = new byte[]{85, 78, 73, 67, 79, 68, 69, 0};
    private final IfdData[] mIfdDatas = new IfdData[5];
    private byte[] mThumbnail;
    private ArrayList<byte[]> mStripBytes = new ArrayList();
    private final ByteOrder mByteOrder;

    ExifData(ByteOrder order) {
        this.mByteOrder = order;
    }

    protected byte[] getCompressedThumbnail() {
        return this.mThumbnail;
    }

    protected void setCompressedThumbnail(byte[] thumbnail) {
        this.mThumbnail = thumbnail;
    }

    protected boolean hasCompressedThumbnail() {
        return this.mThumbnail != null;
    }

    protected void setStripBytes(int index, byte[] strip) {
        if (index < this.mStripBytes.size()) {
            this.mStripBytes.set(index, strip);
        } else {
            for (int i = this.mStripBytes.size(); i < index; ++i) {
                this.mStripBytes.add(null);
            }
            this.mStripBytes.add(strip);
        }
    }

    protected int getStripCount() {
        return this.mStripBytes.size();
    }

    protected byte[] getStrip(int index) {
        return this.mStripBytes.get(index);
    }

    protected boolean hasUncompressedStrip() {
        return this.mStripBytes.size() != 0;
    }

    protected ByteOrder getByteOrder() {
        return this.mByteOrder;
    }

    protected IfdData getIfdData(int ifdId) {
        if (ExifTag.isValidIfd(ifdId)) {
            return this.mIfdDatas[ifdId];
        }
        return null;
    }

    protected void addIfdData(IfdData data) {
        this.mIfdDatas[data.getId()] = data;
    }

    protected IfdData getOrCreateIfdData(int ifdId) {
        IfdData ifdData = this.mIfdDatas[ifdId];
        if (ifdData == null) {
            this.mIfdDatas[ifdId] = ifdData = new IfdData(ifdId);
        }
        return ifdData;
    }

    protected ExifTag getTag(short tag, int ifd) {
        IfdData ifdData = this.mIfdDatas[ifd];
        return ifdData == null ? null : ifdData.getTag(tag);
    }

    protected ExifTag addTag(ExifTag tag) {
        if (tag != null) {
            int ifd = tag.getIfd();
            return this.addTag(tag, ifd);
        }
        return null;
    }

    protected ExifTag addTag(ExifTag tag, int ifdId) {
        if (tag != null && ExifTag.isValidIfd(ifdId)) {
            IfdData ifdData = this.getOrCreateIfdData(ifdId);
            return ifdData.setTag(tag);
        }
        return null;
    }

    protected void clearThumbnailAndStrips() {
        this.mThumbnail = null;
        this.mStripBytes.clear();
    }

    protected void removeThumbnailData() {
        this.clearThumbnailAndStrips();
        this.mIfdDatas[1] = null;
    }

    protected void removeTag(short tagId, int ifdId) {
        IfdData ifdData = this.mIfdDatas[ifdId];
        if (ifdData == null) {
            return;
        }
        ifdData.removeTag(tagId);
    }

    protected String getUserComment() {
        IfdData ifdData = this.mIfdDatas[0];
        if (ifdData == null) {
            return null;
        }
        ExifTag tag = ifdData.getTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_USER_COMMENT));
        if (tag == null) {
            return null;
        }
        if (tag.getComponentCount() < 8) {
            return null;
        }
        byte[] buf = new byte[tag.getComponentCount()];
        tag.getBytes(buf);
        byte[] code = new byte[8];
        System.arraycopy(buf, 0, code, 0, 8);
        try {
            if (Arrays.equals(code, USER_COMMENT_ASCII)) {
                return new String(buf, 8, buf.length - 8, "US-ASCII");
            }
            if (Arrays.equals(code, USER_COMMENT_JIS)) {
                return new String(buf, 8, buf.length - 8, "EUC-JP");
            }
            if (Arrays.equals(code, USER_COMMENT_UNICODE)) {
                return new String(buf, 8, buf.length - 8, "UTF-16");
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    protected List<ExifTag> getAllTags() {
        ArrayList<ExifTag> ret = new ArrayList<ExifTag>();
        for (IfdData d : this.mIfdDatas) {
            ExifTag[] tags;
            if (d == null || (tags = d.getAllTags()) == null) continue;
            for (ExifTag t : tags) {
                ret.add(t);
            }
        }
        return ret;
    }

    protected List<ExifTag> getAllTagsForIfd(int ifd) {
        IfdData d = this.mIfdDatas[ifd];
        if (d == null) {
            return null;
        }
        ExifTag[] tags = d.getAllTags();
        if (tags == null) {
            return null;
        }
        ArrayList<ExifTag> ret = new ArrayList<ExifTag>(tags.length);
        for (ExifTag t : tags) {
            ret.add(t);
        }
        if (ret.size() == 0) {
            return null;
        }
        return ret;
    }

    protected List<ExifTag> getAllTagsForTagId(short tag) {
        ArrayList<ExifTag> ret = new ArrayList<ExifTag>();
        for (IfdData d : this.mIfdDatas) {
            ExifTag t;
            if (d == null || (t = d.getTag(tag)) == null) continue;
            ret.add(t);
        }
        if (ret.size() == 0) {
            return null;
        }
        return ret;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ExifData) {
            int i;
            ExifData data = (ExifData)obj;
            if (data.mByteOrder != this.mByteOrder || data.mStripBytes.size() != this.mStripBytes.size() || !Arrays.equals(data.mThumbnail, this.mThumbnail)) {
                return false;
            }
            for (i = 0; i < this.mStripBytes.size(); ++i) {
                if (Arrays.equals(data.mStripBytes.get(i), this.mStripBytes.get(i))) continue;
                return false;
            }
            for (i = 0; i < 5; ++i) {
                IfdData ifd2;
                IfdData ifd1 = data.getIfdData(i);
                if (ifd1 == (ifd2 = this.getIfdData(i)) || ifd1 == null || ifd1.equals(ifd2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

