/*
 * Decompiled with CFR 0.152.
 */
package com.example.camerabioandroid.camerabiomanager.camera;

import android.content.Context;
import android.util.AttributeSet;
import android.view.TextureView;
import android.view.View;

public class AutoFitTextureView
extends TextureView {
    private int mRatioWidth = 0;
    private int mRatioHeight = 0;

    public AutoFitTextureView(Context context) {
        this(context, null);
    }

    public AutoFitTextureView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AutoFitTextureView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setAspectRatio(int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Size cannot be negative.");
        }
        this.mRatioWidth = width;
        this.mRatioHeight = height;
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (0 == this.mRatioWidth || 0 == this.mRatioHeight) {
            this.setMeasuredDimension(width, height);
        } else if (width < height * this.mRatioWidth / this.mRatioHeight) {
            this.setMeasuredDimension(width, width * this.mRatioHeight / this.mRatioWidth);
        } else {
            this.setMeasuredDimension(height * this.mRatioWidth / this.mRatioHeight, height);
        }
    }
}

