/*
 * Decompiled with CFR 0.152.
 */
package com.example.camerabioandroid.camerabiomanager;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.example.camerabioandroid.R;
import com.example.camerabioandroid.camerabiomanager.Camera2DocumentBase;
import com.example.camerabioandroid.camerabiomanager.CameraBioManager;
import com.example.camerabioandroid.camerabiomanager.camera.AutoFitTextureView;
import com.example.camerabioandroid.camerabiomanager.camera.CaptureImageProcessor;
import com.example.camerabioandroid.camerabiomanager.camera.ImageProcessor;

public class DocumentActivity
extends Camera2DocumentBase
implements ImageProcessor,
CaptureImageProcessor {
    public static final float COMPENSATION_EYE = 0.05f;
    public static int total = 0;
    private TextView countdownView;
    private int erroIndex = -1;
    private boolean faceOK = true;
    private View lineTopView;
    private View lineBottomView;
    private View lineLeftView;
    private View lineRightView;
    private ImageView rectangleImageView;
    private ImageButton takePictureImageButton;
    private Toast toast;
    private ImageView ivMask;
    private float posVerticalLineLeft = 0.0f;
    private float posVerticalLineRight = 0.0f;
    private float posHorizontalLineBottom = 0.0f;
    private float posHorizontalLineTop = 0.0f;
    private int primaryColor = Color.parseColor((String)"#2980ff");
    private boolean showLines = false;
    private float leftEyePosX = 0.0f;
    private float leftEyePosY = 0.0f;
    private float rightEyePosX = 0.0f;
    private float rightEyePosY = 0.0f;
    private float nosePosY = 0.0f;
    float diffNose = 0.0f;
    float noseRange = 0.0f;
    private float headPosition = 0.0f;
    float aspectRatioRelative = 0.0f;
    final float minDiffEye = 100.0f;
    final float maxDiffEye = 190.0f;
    float densityFactor = 2.0f;
    float densityMultiply = 2.0f;
    float percentHorizontalRange = 25.0f;
    float percentVerticalRange = 30.0f;
    float percentOffsetVerticalRange = 30.0f;
    float screenWidth = 0.0f;
    float screenHeight = 0.0f;
    float aspectRatioBioEye = 1.0f;
    private GradientDrawable rectangleDrawable;
    private String origin = "";
    private boolean initialized = false;
    private Boolean isRequestImage;
    private static CameraBioManager cameraBioManager;
    private int DOCUMENT_TYPE;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle b = this.getIntent().getExtras();
        this.DOCUMENT_TYPE = b.getInt("DOCUMENT_TYPE");
        if (b != null) {
            this.origin = b.getString("origin");
        }
        if (this.DEBUG.booleanValue()) {
            Log.d((String)"Camera2Base", (String)("from activity: " + this.origin));
        }
        this.isRequestImage = false;
        Camera2DocumentBase.activity = this;
        Camera2DocumentBase.imageProcessor = this;
        Camera2DocumentBase.captureImageProcessor = this;
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.getWindow().addFlags(128);
        this.setContentView(R.layout.activity_selfie);
        this.takePictureImageButton = (ImageButton)this.findViewById(R.id.take_picture);
        this.takePictureImageButton.setOnClickListener((View.OnClickListener)this);
        this.textureView = (AutoFitTextureView)this.findViewById(R.id.texture);
        this.rootView = this.findViewById(R.id.root_view);
        this.ivMask = (ImageView)this.findViewById(R.id.iv_mask);
        if (this.DOCUMENT_TYPE == 501) {
            this.ivMask.setImageResource(R.drawable.frame_rg_frente);
            this.ivMask.setVisibility(0);
        } else if (this.DOCUMENT_TYPE == 502) {
            this.ivMask.setImageResource(R.drawable.frame_rg_verso);
            this.ivMask.setVisibility(0);
        } else if (this.DOCUMENT_TYPE == 4) {
            this.ivMask.setImageResource(R.drawable.frame_cnh);
            this.ivMask.setVisibility(0);
        } else {
            this.ivMask.setVisibility(8);
        }
        this.countdownView = (TextView)this.findViewById(R.id.tvCountdown);
        this.countdownView.setVisibility(8);
        this.setMaxSizes();
        this.rectangleImageView = (ImageView)this.findViewById(R.id.rectangle);
        this.rectangleDrawable = (GradientDrawable)this.rectangleImageView.getBackground();
    }

    public void onBackPressed() {
        activity.finish();
    }

    public void setCameraBioManager(CameraBioManager cameraBioManager) {
        DocumentActivity.cameraBioManager = cameraBioManager;
    }

    @Override
    public void process(byte[] image, int w, int h, int f) {
        if (!this.initialized && this.DEBUG.booleanValue()) {
            Log.d((String)"Camera2Base", (String)("width  buffer: " + w));
            Log.d((String)"Camera2Base", (String)("height buffer: " + h));
        }
        this.init(w, h);
    }

    public static float convertPixelsToDp(float px, Context context) {
        return px / ((float)context.getResources().getDisplayMetrics().densityDpi / 160.0f);
    }

    public static float convertDpToPixel(float dp, Context context) {
        return dp * ((float)context.getResources().getDisplayMetrics().densityDpi / 160.0f);
    }

    private void init(float widthBuffer, float heightBuffer) {
        if (!this.initialized) {
            this.screenWidth = this.getWidthPixels();
            this.screenHeight = this.getHeightPixels();
            boolean isBufferPortrait = widthBuffer < heightBuffer;
            float aspectRatioBuffer = isBufferPortrait ? widthBuffer / heightBuffer : heightBuffer / widthBuffer;
            float imageHeightScreen = this.screenWidth / aspectRatioBuffer;
            float imageHeightBuffer = 720.0f / aspectRatioBuffer;
            this.aspectRatioRelative = imageHeightScreen / (isBufferPortrait ? heightBuffer : widthBuffer);
            this.aspectRatioBioEye = imageHeightBuffer / (isBufferPortrait ? heightBuffer : widthBuffer);
            float f = this.aspectRatioBioEye = this.aspectRatioBioEye < 1.0f ? 1.0f : this.aspectRatioBioEye;
            if (this.DEBUG.booleanValue()) {
                Log.d((String)"Camera2Base", (String)("Aspect Ratio BIO: " + this.aspectRatioBioEye));
            }
            float refWidth = isBufferPortrait ? widthBuffer : heightBuffer;
            float refHeight = isBufferPortrait ? heightBuffer : widthBuffer;
            float topOffet = refHeight * this.percentOffsetVerticalRange / 100.0f;
            float heightRange = refHeight * this.percentVerticalRange / 100.0f;
            DisplayMetrics metrics = this.getResources().getDisplayMetrics();
            this.densityFactor = metrics.density;
            this.posVerticalLineLeft = refWidth * (this.percentHorizontalRange / 100.0f);
            this.posVerticalLineRight = refWidth * (this.percentHorizontalRange / 100.0f * 3.0f);
            this.posHorizontalLineTop = topOffet;
            this.posHorizontalLineBottom = topOffet + heightRange;
            this.initialized = true;
        }
    }

    private void addHorizontalLineBottom(float bottom) {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams((int)this.screenWidth, 10);
        layoutParams.setMargins(0, (int)bottom, 0, 0);
        this.lineBottomView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void addHorizontalLineTop(float top) {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams((int)this.screenWidth, 10);
        layoutParams.setMargins(0, (int)top, 0, 0);
        this.lineTopView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void addVerticalLineLeft(float left) {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(10, (int)this.screenHeight);
        layoutParams.setMargins((int)left, 0, 0, 0);
        this.lineLeftView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void addVerticalLineRight(float right) {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(10, (int)this.screenHeight);
        layoutParams.setMargins((int)right, 0, 0, 0);
        this.lineRightView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.take_picture) {
            this.isRequestImage = true;
            super.takePicture();
        }
    }

    @Override
    public void capture(String base64) {
        if (base64 != null) {
            cameraBioManager.captureDocument(base64);
            this.finish();
        } else {
            this.showErrorMessage("Erro ao recuperar imagem capturada");
        }
    }

    private void showErrorMessage(String message) {
        this.reopenCamera();
    }

    @Override
    protected void showFastToast(String message) {
        try {
            if (this.toast == null) {
                this.toast = Toast.makeText((Context)this, (CharSequence)message, (int)0);
                this.toast.setGravity(49, 0, 0);
            }
            this.toast.setText((CharSequence)message);
            this.toast.show();
        }
        catch (Exception ex) {
            Log.d((String)"Camera2Base", (String)ex.toString());
        }
    }
}

