/*
 * Decompiled with CFR 0.152.
 */
package com.example.camerabioandroid.camerabiomanager;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Size;
import android.util.SparseIntArray;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.example.camerabioandroid.R;
import com.example.camerabioandroid.camerabiomanager.BaseActivity;
import com.example.camerabioandroid.camerabiomanager.bitmap.ImageUtils;
import com.example.camerabioandroid.camerabiomanager.camera.AutoFitTextureView;
import com.example.camerabioandroid.camerabiomanager.camera.CaptureImageProcessor;
import com.example.camerabioandroid.camerabiomanager.camera.ImageProcessor;
import com.example.camerabioandroid.camerabiomanager.camera.ImageSize;
import com.example.camerabioandroid.camerabiomanager.exif.Exif;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Camera2DocumentBase
extends BaseActivity
implements View.OnClickListener {
    protected Boolean DEBUG = Boolean.FALSE;
    protected static Activity activity;
    protected static ImageProcessor imageProcessor;
    protected static CaptureImageProcessor captureImageProcessor;
    protected static final SparseIntArray ORIENTATIONS;
    protected static final String FRAGMENT_DIALOG = "dialog";
    protected Integer facing;
    protected int screenOrientation = 1;
    protected static final int BIOMETRY_IMAGE_WIDTH = 1280;
    protected static final int BIOMETRY_IMAGE_HEIGHT = 720;
    protected static final float PROPORTION_BIOMETRY = 1.7777778f;
    protected static final int BIOMETRY_IMAGE_WIDTH_MIN = 640;
    protected static final int BIOMETRY_IMAGE_HEIGHT_MIN = 360;
    protected Size jpegCaptureSize = new Size(1280, 720);
    protected static final String TAG = "Camera2Base";
    protected static final int STATE_PREVIEW = 0;
    protected static final int STATE_WAITING_LOCK = 1;
    protected static final int STATE_WAITING_PRECAPTURE = 2;
    protected static final int STATE_WAITING_NON_PRECAPTURE = 3;
    protected static final int STATE_PICTURE_TAKEN = 4;
    protected int SCREEN_WIDTH = 0;
    protected int SCREEN_HEIGHT = 0;
    protected float ASPECT_RATIO_ERROR_RANGE = 0.1f;
    protected String cameraId;
    protected AutoFitTextureView textureView;
    protected CameraCaptureSession captureSession;
    protected CameraDevice cameraDevice;
    protected CameraManager cameraManager;
    protected Size previewSize;
    protected Size jpegSize;
    protected HandlerThread backgroundThread;
    protected Handler backgroundHandler;
    protected Handler backgroundHandlerFace;
    protected ImageReader imageReader;
    protected ImageReader imageReaderFace;
    protected CaptureRequest.Builder previewRequestBuilder;
    protected int state = 0;
    protected Semaphore cameraOpenCloseLock = new Semaphore(1);
    protected int sensorOrientation;
    private final Object surfaceTextureLock = new Object();
    private final Object dimensionLock = new Object();
    private SurfaceTexture previewSurfaceTexture;
    protected final TextureView.SurfaceTextureListener surfaceTextureListener = new TextureView.SurfaceTextureListener(){

        public void onSurfaceTextureAvailable(SurfaceTexture texture, int width, int height) {
            Camera2DocumentBase.this.openCamera(width, height);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture texture, int width, int height) {
            if (Camera2DocumentBase.this.DEBUG.booleanValue()) {
                Log.d((String)Camera2DocumentBase.TAG, (String)"Surface size change");
            }
            Camera2DocumentBase.this.configureTransform(width, height);
            Camera2DocumentBase.this.updatePreviewBufferSize();
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture texture) {
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture texture) {
            if (Camera2DocumentBase.this.DEBUG.booleanValue()) {
                Log.d((String)Camera2DocumentBase.TAG, (String)"Surface texture update");
            }
            Camera2DocumentBase.this.updatePreviewBufferSize();
        }
    };
    protected final CameraDevice.StateCallback stateCallback = new CameraDevice.StateCallback(){

        public void onOpened(@NonNull CameraDevice cameraDevice) {
            if (Camera2DocumentBase.this.DEBUG.booleanValue()) {
                Log.d((String)Camera2DocumentBase.TAG, (String)"Camera opened");
            }
            Camera2DocumentBase.this.cameraOpenCloseLock.release();
            Camera2DocumentBase.this.cameraDevice = cameraDevice;
            Camera2DocumentBase.this.createCameraPreviewSession();
        }

        public void onDisconnected(@NonNull CameraDevice cameraDevice) {
            if (Camera2DocumentBase.this.DEBUG.booleanValue()) {
                Log.d((String)Camera2DocumentBase.TAG, (String)"Camera disconnected");
            }
            Camera2DocumentBase.this.cameraOpenCloseLock.release();
            cameraDevice.close();
            Camera2DocumentBase.this.cameraDevice = null;
        }

        public void onError(@NonNull CameraDevice cameraDevice, int error) {
            if (Camera2DocumentBase.this.DEBUG.booleanValue()) {
                Log.d((String)Camera2DocumentBase.TAG, (String)"Camera error");
            }
            Camera2DocumentBase.this.cameraOpenCloseLock.release();
            cameraDevice.close();
            Camera2DocumentBase.this.cameraDevice = null;
            Camera2DocumentBase.this.finish();
        }
    };
    protected final ImageReader.OnImageAvailableListener onImageAvailableListener = new ImageReader.OnImageAvailableListener(){

        public void onImageAvailable(ImageReader reader) {
            Camera2DocumentBase.this.backgroundHandler.post((Runnable)new ImageSaver(reader.acquireNextImage()));
        }
    };
    protected int CURR_IMAGE_COUNT = 0;
    protected static final Object lock;
    private final Lock imageReaderLock = new ReentrantLock(true);
    protected final ImageReader.OnImageAvailableListener onImageFaceAvailableListener = new ImageReader.OnImageAvailableListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onImageAvailable(ImageReader reader) {
            Camera2DocumentBase.this.imageReaderLock.lock();
            try {
                Image image = reader.acquireLatestImage();
                if (image == null) {
                    return;
                }
                ++Camera2DocumentBase.this.CURR_IMAGE_COUNT;
                if (Camera2DocumentBase.this.CURR_IMAGE_COUNT % 3 != 0) {
                    image.close();
                    return;
                }
                ByteBuffer buffer = image.getPlanes()[0].getBuffer();
                final byte[] bytes = new byte[buffer.remaining()];
                buffer.get(bytes);
                if (Camera2DocumentBase.this.DEBUG.booleanValue() && Camera2DocumentBase.this.CURR_IMAGE_COUNT % 20 == 0) {
                    byte[] jpegData = ImageUtils.YUV420ToJPEG(image);
                    Camera2DocumentBase.saveReceivedImage(jpegData, jpegData.length, String.valueOf(Camera2DocumentBase.this.CURR_IMAGE_COUNT));
                }
                final int w = image.getWidth();
                final int h = image.getHeight();
                final int f = image.getFormat();
                image.close();
                buffer = null;
                Camera2DocumentBase.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        imageProcessor.process(bytes, w, h, f);
                    }
                });
            }
            catch (Exception ex) {
                Log.d((String)Camera2DocumentBase.TAG, (String)ex.getMessage());
            }
            finally {
                Camera2DocumentBase.this.imageReaderLock.unlock();
            }
        }
    };
    protected CameraCaptureSession.CaptureCallback captureCallback = new CameraCaptureSession.CaptureCallback(){

        protected void process(CaptureResult result) {
            switch (Camera2DocumentBase.this.state) {
                case 0: {
                    break;
                }
                case 1: {
                    Integer afState = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
                    if (afState == null) {
                        Camera2DocumentBase.this.captureStillPicture();
                        break;
                    }
                    if (4 != afState && 5 != afState) break;
                    Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (aeState == null || aeState == 2) {
                        Camera2DocumentBase.this.state = 4;
                        Camera2DocumentBase.this.captureStillPicture();
                        break;
                    }
                    Camera2DocumentBase.this.takePicture();
                    break;
                }
                case 2: {
                    Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (aeState != null && aeState != 5 && aeState != 4) break;
                    Camera2DocumentBase.this.state = 3;
                    break;
                }
                case 3: {
                    Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (aeState != null && aeState == 5) break;
                    Camera2DocumentBase.this.state = 4;
                    Camera2DocumentBase.this.captureStillPicture();
                    break;
                }
            }
        }

        public void onCaptureProgressed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureResult partialResult) {
            this.process(partialResult);
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            this.process((CaptureResult)result);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePreviewBufferSize() {
        if (this.DEBUG.booleanValue()) {
            Log.d((String)TAG, (String)"Update preview buffer size");
        }
        Object object = this.surfaceTextureLock;
        synchronized (object) {
            if (this.previewSurfaceTexture != null) {
                this.previewSurfaceTexture.setDefaultBufferSize(this.previewSize.getWidth(), this.previewSize.getHeight());
            }
        }
    }

    private static void saveReceivedImage(Bitmap bitmap, String imageName) throws Exception {
        File path = new File(activity.getExternalFilesDir(null), "frame");
        if (!path.exists()) {
            path.mkdirs();
        }
        File outFile = new File(path, imageName + ".jpeg");
        String absPath = outFile.getAbsolutePath();
        Log.d((String)TAG, (String)("Path image: " + absPath));
        FileOutputStream outputStream = new FileOutputStream(outFile);
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)outputStream);
        outputStream.close();
    }

    private static void saveReceivedImage(byte[] imageByteArray, int numberOfBytes, String imageName) {
        try {
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])imageByteArray, (int)0, (int)numberOfBytes);
            Camera2DocumentBase.saveReceivedImage(bitmap, imageName);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Saving received message failed with", (Throwable)e);
        }
    }

    public void onResume() {
        if (this.DEBUG.booleanValue()) {
            Log.d((String)TAG, (String)"OnResume");
        }
        super.onResume();
        this.startBackgroundThread();
        if (this.textureView.isAvailable()) {
            this.openCamera(this.textureView.getWidth(), this.textureView.getHeight());
        } else {
            this.textureView.setSurfaceTextureListener(this.surfaceTextureListener);
        }
    }

    public void onPause() {
        if (this.DEBUG.booleanValue()) {
            Log.d((String)TAG, (String)"OnPause");
        }
        this.closeCamera();
        this.stopBackgroundThread();
        super.onPause();
    }

    protected void setupCameraOutputs(int width, int height) {
        if (this.DEBUG.booleanValue()) {
            Log.d((String)TAG, (String)"Setup camera");
        }
        CameraManager manager = (CameraManager)activity.getSystemService("camera");
        try {
            for (String cameraId : manager.getCameraIdList()) {
                StreamConfigurationMap map;
                CameraCharacteristics characteristics = manager.getCameraCharacteristics(cameraId);
                this.facing = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
                if (this.facing != null && this.facing == 0 || (map = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)) == null) continue;
                if (this.DEBUG.booleanValue()) {
                    Log.d((String)TAG, (String)("screen width: " + width));
                    Log.d((String)TAG, (String)("screen height: " + height));
                }
                this.loadImageSizes(map, width, height);
                if (this.DEBUG.booleanValue()) {
                    Log.d((String)TAG, (String)("jpeg width: " + this.jpegSize.getWidth()));
                    Log.d((String)TAG, (String)("jpeg height: " + this.jpegSize.getHeight()));
                }
                this.createImageReader();
                if (this.DEBUG.booleanValue()) {
                    Log.d((String)TAG, (String)("preview width: " + this.previewSize.getWidth()));
                    Log.d((String)TAG, (String)("preview height: " + this.previewSize.getHeight()));
                }
                this.loadOrientations(characteristics);
                this.updateTextureView();
                this.cameraId = cameraId;
                return;
            }
        }
        catch (CameraAccessException ex) {
            Log.d((String)TAG, (String)ex.toString());
        }
        catch (NullPointerException ex) {
            this.showAlert(this.getString(R.string.camera_error));
        }
        catch (Exception ex) {
            Log.d((String)TAG, (String)ex.toString());
        }
    }

    private void updateTextureView() {
        int orientation = this.getResources().getConfiguration().orientation;
        if (orientation == 2) {
            this.textureView.setAspectRatio(this.previewSize.getWidth(), this.previewSize.getHeight());
        } else {
            this.textureView.setAspectRatio(this.previewSize.getHeight(), this.previewSize.getWidth());
        }
    }

    private void loadImageSizes(StreamConfigurationMap map, int width, int height) {
        boolean portrait = this.isPortrait(this.getScreenOrientation());
        this.jpegSize = ImageSize.chooseOptimalJpegSize(Arrays.asList(map.getOutputSizes(256)), 1280.0f, 720.0f);
        this.previewSize = ImageSize.getOptimalPreviewSize(map.getOutputSizes(SurfaceTexture.class), width, height, this.facing);
        this.previewSize = new Size(1280, 720);
    }

    private void loadOrientations(CameraCharacteristics characteristics) {
        this.screenOrientation = this.getScreenOrientation();
        this.sensorOrientation = (Integer)characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
    }

    private void createImageReader() {
        if (this.imageReader != null && this.imageReaderFace != null || this.jpegSize == null || this.previewSize == null) {
            return;
        }
        this.imageReader = ImageReader.newInstance((int)this.jpegSize.getWidth(), (int)this.jpegSize.getHeight(), (int)256, (int)2);
        this.imageReaderFace = ImageReader.newInstance((int)this.previewSize.getWidth(), (int)this.previewSize.getHeight(), (int)35, (int)3);
        this.imageReader.setOnImageAvailableListener(this.onImageAvailableListener, this.backgroundHandler);
        this.imageReaderFace.setOnImageAvailableListener(this.onImageFaceAvailableListener, this.backgroundHandlerFace);
    }

    protected int getScreenOrientation() {
        int orientation;
        int rotation = this.getWindowManager().getDefaultDisplay().getRotation();
        DisplayMetrics dm = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(dm);
        int width = dm.widthPixels;
        int height = dm.heightPixels;
        if ((rotation == 0 || rotation == 2) && height > width || (rotation == 1 || rotation == 3) && width > height) {
            switch (rotation) {
                case 0: {
                    orientation = 1;
                    break;
                }
                case 1: {
                    orientation = 0;
                    break;
                }
                case 2: {
                    orientation = 9;
                    break;
                }
                case 3: {
                    orientation = 8;
                    break;
                }
                default: {
                    Log.e((String)TAG, (String)"Unknown screen orientation. Defaulting to portrait.");
                    orientation = 1;
                    break;
                }
            }
        } else {
            switch (rotation) {
                case 0: {
                    orientation = 0;
                    break;
                }
                case 1: {
                    orientation = 1;
                    break;
                }
                case 2: {
                    orientation = 8;
                    break;
                }
                case 3: {
                    orientation = 9;
                    break;
                }
                default: {
                    Log.e((String)TAG, (String)"Unknown screen orientation. Defaulting to landscape.");
                    orientation = 0;
                }
            }
        }
        return orientation;
    }

    protected boolean isPortrait(int orientation) {
        boolean portrait = false;
        switch (orientation) {
            case 1: 
            case 9: {
                portrait = true;
            }
        }
        return portrait;
    }

    protected void openCamera(int width, int height) {
        if (this.DEBUG.booleanValue()) {
            Log.d((String)TAG, (String)"Open camera");
        }
        this.setupCameraOutputs(width, height);
        this.configureTransform(width, height);
        this.cameraManager = (CameraManager)activity.getSystemService("camera");
        try {
            if (!this.cameraOpenCloseLock.tryAcquire(2500L, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Time out waiting to lock camera opening.");
            }
            if (this.DEBUG.booleanValue()) {
                Log.d((String)TAG, (String)"Manager Open camera");
            }
            this.cameraManager.openCamera(this.cameraId, this.stateCallback, this.backgroundHandler);
        }
        catch (CameraAccessException e) {
            Log.d((String)TAG, (String)e.getMessage());
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to lock camera opening.", e);
        }
    }

    protected void reopenCamera() {
        if (this.DEBUG.booleanValue()) {
            Log.d((String)TAG, (String)"Reopen camera");
        }
        AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Camera2DocumentBase.this.closeCamera();
                    Camera2DocumentBase.this.createImageReader();
                    Camera2DocumentBase.this.cameraManager.openCamera(Camera2DocumentBase.this.cameraId, Camera2DocumentBase.this.stateCallback, Camera2DocumentBase.this.backgroundHandler);
                }
                catch (CameraAccessException e) {
                    Log.d((String)"Erro de acesso a camera: Camera2Base", (String)e.toString());
                }
            }
        });
    }

    protected void closeCamera() {
        if (this.DEBUG.booleanValue()) {
            Log.d((String)TAG, (String)"Close camera");
        }
        try {
            this.cameraOpenCloseLock.acquire();
            if (null != this.captureSession) {
                this.captureSession.close();
                this.captureSession = null;
            }
            if (null != this.cameraDevice) {
                this.cameraDevice.close();
                this.cameraDevice = null;
            }
            if (null != this.imageReader) {
                this.imageReader.close();
                this.imageReader = null;
            }
            if (null != this.imageReaderFace) {
                this.imageReaderFace.close();
                this.imageReaderFace = null;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to lock camera closing.", e);
        }
        finally {
            this.cameraOpenCloseLock.release();
        }
    }

    protected void startBackgroundThread() {
        this.backgroundThread = new HandlerThread("CameraBackground");
        this.backgroundThread.start();
        this.backgroundHandler = new Handler(this.backgroundThread.getLooper());
        this.backgroundHandlerFace = new Handler(this.backgroundThread.getLooper());
    }

    protected void stopBackgroundThread() {
        this.backgroundThread.quitSafely();
        try {
            this.backgroundThread.join();
            this.backgroundThread = null;
            this.backgroundHandler = null;
            this.backgroundHandlerFace = null;
        }
        catch (InterruptedException ex) {
            Log.d((String)TAG, (String)ex.getMessage());
        }
    }

    protected void createCameraPreviewSession() {
        if (this.DEBUG.booleanValue()) {
            Log.d((String)TAG, (String)"Create preview session");
        }
        try {
            if (this.previewSize == null || this.textureView == null || this.cameraDevice == null || this.imageReader == null || this.imageReaderFace == null || this.cameraDevice == null) {
                return;
            }
            this.previewSurfaceTexture = this.textureView.getSurfaceTexture();
            assert (this.previewSurfaceTexture != null);
            if (this.DEBUG.booleanValue()) {
                Log.d((String)TAG, (String)("preview width: " + this.previewSize.getWidth()));
                Log.d((String)TAG, (String)("preview height: " + this.previewSize.getHeight()));
            }
            this.updatePreviewBufferSize();
            Surface surface = new Surface(this.previewSurfaceTexture);
            this.previewRequestBuilder = this.cameraDevice.createCaptureRequest(1);
            this.previewRequestBuilder.addTarget(surface);
            this.previewRequestBuilder.addTarget(this.imageReaderFace.getSurface());
            List<Surface> surfaceList = Arrays.asList(surface, this.imageReader.getSurface(), this.imageReaderFace.getSurface());
            this.cameraDevice.createCaptureSession(surfaceList, new CameraCaptureSession.StateCallback(){

                public void onConfigured(@NonNull CameraCaptureSession cameraCaptureSession) {
                    if (null == Camera2DocumentBase.this.cameraDevice) {
                        return;
                    }
                    Camera2DocumentBase.this.captureSession = cameraCaptureSession;
                    try {
                        Camera2DocumentBase.this.previewRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
                        Camera2DocumentBase.this.captureSession.setRepeatingRequest(Camera2DocumentBase.this.previewRequestBuilder.build(), Camera2DocumentBase.this.captureCallback, Camera2DocumentBase.this.backgroundHandler);
                    }
                    catch (CameraAccessException e) {
                        Log.d((String)Camera2DocumentBase.TAG, (String)e.getMessage());
                    }
                }

                public void onConfigureFailed(@NonNull CameraCaptureSession cameraCaptureSession) {
                    Camera2DocumentBase.this.showToast("Failed");
                }
            }, null);
        }
        catch (CameraAccessException ex) {
            Log.d((String)TAG, (String)ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureTransform(int viewWidth, int viewHeight) {
        if (this.DEBUG.booleanValue()) {
            Log.d((String)TAG, (String)"Configure transform");
        }
        Object object = this.dimensionLock;
        synchronized (object) {
            if (null == this.textureView || null == this.previewSize || null == activity) {
                return;
            }
            int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
            Matrix matrix = new Matrix();
            RectF viewRect = new RectF(0.0f, 0.0f, (float)viewWidth, (float)viewHeight);
            RectF bufferRect = new RectF(0.0f, 0.0f, (float)this.previewSize.getHeight(), (float)this.previewSize.getWidth());
            float centerX = viewRect.centerX();
            float centerY = viewRect.centerY();
            if (1 == rotation || 3 == rotation) {
                bufferRect.offset(centerX - bufferRect.centerX(), centerY - bufferRect.centerY());
                matrix.setRectToRect(viewRect, bufferRect, Matrix.ScaleToFit.FILL);
                float scale = Math.max((float)viewHeight / (float)this.previewSize.getHeight(), (float)viewWidth / (float)this.previewSize.getWidth());
                matrix.postScale(scale, scale, centerX, centerY);
                matrix.postRotate((float)(90 * (rotation - 2)), centerX, centerY);
            } else if (2 == rotation) {
                matrix.postRotate(180.0f, centerX, centerY);
            }
            this.textureView.setTransform(matrix);
        }
    }

    protected void takePicture() {
        if (this.DEBUG.booleanValue()) {
            Log.d((String)TAG, (String)"Take picture");
        }
        if (this.previewRequestBuilder == null || this.captureSession == null) {
            return;
        }
        try {
            this.previewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
            this.state = 2;
            this.captureSession.capture(this.previewRequestBuilder.build(), this.captureCallback, this.backgroundHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    protected void captureStillPicture() {
        if (this.DEBUG.booleanValue()) {
            Log.d((String)TAG, (String)"Capture still picture");
        }
        try {
            if (null == activity || null == this.cameraDevice) {
                return;
            }
            CaptureRequest.Builder captureBuilder = this.cameraDevice.createCaptureRequest(2);
            captureBuilder.addTarget(this.imageReader.getSurface());
            captureBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
            captureBuilder.set(CaptureRequest.JPEG_ORIENTATION, (Object)this.getOrientation(this.getScreenOrientation()));
            this.captureSession.stopRepeating();
            this.captureSession.abortCaptures();
            this.captureSession.capture(captureBuilder.build(), null, null);
        }
        catch (CameraAccessException ex) {
            Log.d((String)TAG, (String)ex.toString());
        }
    }

    protected int getOrientation(int rotation) {
        return (ORIENTATIONS.get(rotation) + this.sensorOrientation + 270) % 360;
    }

    public void onClick(View view) {
        this.takePicture();
    }

    protected void setMaxSizes() {
        Point displaySize = new Point();
        activity.getWindowManager().getDefaultDisplay().getSize(displaySize);
        this.SCREEN_HEIGHT = displaySize.x;
        this.SCREEN_WIDTH = displaySize.y;
    }

    public int getHeightPixels() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.heightPixels;
    }

    public int getWidthPixels() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.widthPixels;
    }

    protected int getImageFirebaseVisionRotation() {
        try {
            return this.getRotationCompensation(this.cameraId, activity, this.getApplicationContext());
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @RequiresApi(api=21)
    protected int getRotationCompensation(String cameraId, Activity activity, Context context) throws CameraAccessException {
        int result;
        int deviceRotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        int rotationCompensation = ORIENTATIONS.get(deviceRotation);
        CameraManager cameraManager = (CameraManager)context.getSystemService("camera");
        int sensorOrientation = (Integer)cameraManager.getCameraCharacteristics(cameraId).get(CameraCharacteristics.SENSOR_ORIENTATION);
        rotationCompensation = (rotationCompensation + sensorOrientation + 270) % 360;
        switch (rotationCompensation) {
            case 0: {
                result = 0;
                break;
            }
            case 90: {
                result = 1;
                break;
            }
            case 180: {
                result = 2;
                break;
            }
            case 270: {
                result = 3;
                break;
            }
            default: {
                result = 0;
                Log.e((String)TAG, (String)("Bad rotation value: " + rotationCompensation));
            }
        }
        return result;
    }

    static {
        ORIENTATIONS = new SparseIntArray();
        ORIENTATIONS.append(0, 90);
        ORIENTATIONS.append(1, 0);
        ORIENTATIONS.append(2, 270);
        ORIENTATIONS.append(3, 180);
        lock = new Object();
    }

    static class CompareSizesByArea
    implements Comparator<Size> {
        CompareSizesByArea() {
        }

        @Override
        public int compare(Size lhs, Size rhs) {
            return Long.signum((long)lhs.getWidth() * (long)lhs.getHeight() - (long)rhs.getWidth() * (long)rhs.getHeight());
        }
    }

    protected static class ImageSaver
    implements Runnable {
        protected final Image image;

        ImageSaver(Image image) {
            this.image = image;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ByteBuffer buffer = this.image.getPlanes()[0].getBuffer();
                byte[] bytes = new byte[buffer.remaining()];
                buffer.get(bytes);
                int jpegOrientation = Exif.getOrientation(bytes);
                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
                bytes = null;
                buffer = null;
                switch (jpegOrientation) {
                    case 0: {
                        bitmap = ImageUtils.rotateBitmap(bitmap, 90, false);
                        break;
                    }
                    case 180: {
                        bitmap = ImageUtils.rotateBitmap(bitmap, -90, false);
                        break;
                    }
                    case 270: {
                        bitmap = ImageUtils.rotateBitmap(bitmap, -180, false);
                        break;
                    }
                }
                String base64 = ImageUtils.toBase64JPEG(bitmap, false);
                bitmap = null;
                captureImageProcessor.capture(base64);
                base64 = null;
            }
            catch (Exception ex) {
                Log.d((String)Camera2DocumentBase.TAG, (String)ex.getMessage());
            }
            finally {
                this.image.close();
            }
        }
    }
}

