/*
 * Decompiled with CFR 0.152.
 */
package com.abdeveloper.library;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;

public class RecyclerViewEmptySupport
extends RecyclerView {
    private View emptyView;
    private final RecyclerView.AdapterDataObserver observer = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            RecyclerViewEmptySupport.this.checkIfEmpty();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            RecyclerViewEmptySupport.this.checkIfEmpty();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            RecyclerViewEmptySupport.this.checkIfEmpty();
        }
    };

    public RecyclerViewEmptySupport(Context context) {
        super(context);
    }

    public RecyclerViewEmptySupport(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RecyclerViewEmptySupport(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    void checkIfEmpty() {
        if (this.emptyView != null && this.getAdapter() != null) {
            boolean emptyViewVisible = this.getAdapter().getItemCount() == 0;
            this.emptyView.setVisibility(emptyViewVisible ? 0 : 8);
            this.setVisibility(emptyViewVisible ? 8 : 0);
        }
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        RecyclerView.Adapter oldAdapter = this.getAdapter();
        if (oldAdapter != null) {
            oldAdapter.unregisterAdapterDataObserver(this.observer);
        }
        super.setAdapter(adapter);
        if (adapter != null) {
            adapter.registerAdapterDataObserver(this.observer);
        }
        this.checkIfEmpty();
    }

    public void setEmptyView(View emptyView) {
        this.emptyView = emptyView;
        this.checkIfEmpty();
    }
}

