/*
 * Decompiled with CFR 0.152.
 */
package abhishekti7.unicorn.filepicker.adapters;

import abhishekti7.unicorn.filepicker.R;
import abhishekti7.unicorn.filepicker.models.Config;
import abhishekti7.unicorn.filepicker.models.DirectoryModel;
import abhishekti7.unicorn.filepicker.utils.Utils;
import android.content.Context;
import android.content.res.Resources;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;

public class DirectoryAdapter
extends RecyclerView.Adapter<ViewHolder>
implements Filterable {
    private Context context;
    private ArrayList<DirectoryModel> filesList;
    private ArrayList<DirectoryModel> filesListFiltered;
    private onFilesClickListener onFilesClickListener;
    private ArrayList<String> selected;
    private Config config;
    private TypedValue typedValue;
    @ColorInt
    private int selectionTint;
    @ColorInt
    private int backgroundTint;
    private Filter tempFilter = new Filter(){

        protected Filter.FilterResults performFiltering(CharSequence constraint) {
            ArrayList filteredList = new ArrayList();
            if (constraint == null || constraint.length() == 0) {
                filteredList = DirectoryAdapter.this.filesList;
            } else {
                String filteredPattern = constraint.toString().toLowerCase().trim();
                for (DirectoryModel model : DirectoryAdapter.this.filesList) {
                    if (!model.getName().toLowerCase().contains(filteredPattern)) continue;
                    filteredList.add(model);
                }
            }
            Filter.FilterResults results = new Filter.FilterResults();
            results.values = filteredList;
            return results;
        }

        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            DirectoryAdapter.this.filesListFiltered = (ArrayList)results.values;
            DirectoryAdapter.this.notifyDataSetChanged();
        }
    };

    public Filter getFilter() {
        return this.tempFilter;
    }

    public DirectoryAdapter(Context context, ArrayList<DirectoryModel> list, boolean selectMultiple, onFilesClickListener onFilesClickListener2) {
        this.context = context;
        this.filesList = list;
        this.filesListFiltered = list;
        this.onFilesClickListener = onFilesClickListener2;
        this.selected = new ArrayList();
        this.config = Config.getInstance();
        this.typedValue = new TypedValue();
        Resources.Theme theme = context.getTheme();
        theme.resolveAttribute(R.attr.unicorn_file_selectionTint, this.typedValue, true);
        this.selectionTint = this.typedValue.data;
        theme.resolveAttribute(R.attr.unicorn_background, this.typedValue, true);
        this.backgroundTint = this.typedValue.data;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = viewType == 1 ? LayoutInflater.from((Context)this.context).inflate(R.layout.unicorn_item_layout_directory, parent, false) : LayoutInflater.from((Context)this.context).inflate(R.layout.unicorn_item_layout_files, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        if (this.filesListFiltered.get(position).isDirectory()) {
            holder.tv_folder_name.setText((CharSequence)this.filesListFiltered.get(position).getName());
            holder.tv_num_files.setText((CharSequence)(this.filesListFiltered.get(position).getNum_files() + " files"));
        } else {
            holder.tv_file_name.setText((CharSequence)this.filesListFiltered.get(position).getName());
        }
        if (!this.filesListFiltered.get(position).isDirectory()) {
            this.changeFileIcon(holder, this.filesListFiltered.get(position).getName());
            if (this.selected.contains(String.valueOf(position))) {
                holder.rl_file_root.setBackgroundColor(this.selectionTint);
                holder.rg_selected.setVisibility(0);
            } else {
                holder.rl_file_root.setBackgroundColor(this.backgroundTint);
                holder.rg_selected.setVisibility(8);
            }
        }
        holder.tv_date.setText((CharSequence)Utils.longToReadableDate(this.filesListFiltered.get(position).getLast_modif_time()));
        holder.itemView.setOnClickListener(v -> {
            if (this.filesListFiltered.get(position).isDirectory()) {
                this.onFilesClickListener.onClicked(this.filesListFiltered.get(position));
            } else {
                if (this.config.isSelectMultiple()) {
                    if (this.selected.contains(String.valueOf(position))) {
                        this.selected.remove(String.valueOf(position));
                        holder.rg_selected.setVisibility(8);
                        holder.rl_file_root.setBackgroundColor(this.backgroundTint);
                    } else {
                        this.selected.add(String.valueOf(position));
                        holder.rg_selected.setVisibility(0);
                        holder.rl_file_root.setBackgroundColor(this.selectionTint);
                    }
                } else if (this.selected.size() == 0) {
                    this.selected.add(0, String.valueOf(position));
                } else if (this.selected.get(0).equals(String.valueOf(position))) {
                    this.selected.remove(0);
                } else {
                    this.selected.remove(0);
                    this.selected.add(0, String.valueOf(position));
                }
                this.notifyDataSetChanged();
                this.onFilesClickListener.onFileSelected(this.filesListFiltered.get(position));
            }
        });
    }

    private void changeFileIcon(ViewHolder holder, String fileName) {
        try {
            String extension = fileName.substring(fileName.lastIndexOf("."));
            if (extension.toLowerCase().contains("pdf")) {
                holder.item_icon.setImageResource(R.drawable.unicorn_ic_pdf);
            } else if (extension.toLowerCase().contains("png") || extension.toLowerCase().contains("jpg") || extension.toLowerCase().contains("jpeg")) {
                holder.item_icon.setImageResource(R.drawable.unicorn_ic_images);
            }
        }
        catch (Exception e) {
            holder.item_icon.setImageResource(R.drawable.unicorn_ic_file);
        }
    }

    public void resetSelection() {
        this.selected = new ArrayList();
    }

    public int getItemViewType(int position) {
        if (this.filesListFiltered.get(position).isDirectory()) {
            return 1;
        }
        return 2;
    }

    public int getItemCount() {
        return this.filesListFiltered.size();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tv_folder_name;
        private TextView tv_file_name;
        private TextView tv_date;
        private TextView tv_num_files;
        private RadioButton rg_selected;
        private RelativeLayout rl_file_root;
        private ImageView item_icon;

        public ViewHolder(View itemView) {
            super(itemView);
            this.tv_file_name = (TextView)itemView.findViewById(R.id.tv_file_name);
            this.tv_folder_name = (TextView)itemView.findViewById(R.id.tv_folder_name);
            this.tv_date = (TextView)itemView.findViewById(R.id.tv_date);
            this.tv_num_files = (TextView)itemView.findViewById(R.id.tv_num_files);
            this.rg_selected = (RadioButton)itemView.findViewById(R.id.rg_selected);
            this.rl_file_root = (RelativeLayout)itemView.findViewById(R.id.rl_file_root);
            this.item_icon = (ImageView)itemView.findViewById(R.id.item_icon);
        }
    }

    public static interface onFilesClickListener {
        public void onClicked(DirectoryModel var1);

        public void onFileSelected(DirectoryModel var1);
    }
}

