/*
 * Decompiled with CFR 0.152.
 */
package com.xtivia.sgdxp.liferay;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.util.PortalUtil;
import com.xtivia.sgdxp.core.ResourceContext;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ResourceInfo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DxpResourceContext
extends ResourceContext {
    private static Logger _logger = LoggerFactory.getLogger(DxpResourceContext.class);

    public DxpResourceContext(HttpServletRequest request, Map pathParameters, ResourceInfo resourceInfo) {
        super(request, pathParameters, resourceInfo);
        try {
            Long companyId;
            User user = this.getUser(request);
            if (user != null) {
                super.put("_LIFERAY_USER", user);
            }
            if ((companyId = Long.valueOf(this.getCompanyId(request))) != 0L) {
                super.put("_LIFERAY_COMPANY_ID", companyId);
            }
        }
        catch (Exception e) {
            _logger.error("Error accessing DXP user", (Throwable)e);
        }
    }

    @Override
    public <T> T find(String key) {
        Object val = super.find(key);
        if (val == null && key.equals("_LIFERAY_PERMISSION_CHECKER")) {
            HttpServletRequest request = (HttpServletRequest)super.find("_request_");
            if (request == null) {
                return null;
            }
            User user = null;
            try {
                user = this.getUser(request);
            }
            catch (PortalException | SystemException e) {
                _logger.error("Error accessing DXP user", e);
            }
            if (user != null && !user.isDefaultUser()) {
                try {
                    PermissionChecker permissionChecker = this.getPermissionChecker(user);
                    super.put("_LIFERAY_PERMISSION_CHECKER", permissionChecker);
                    return (T)permissionChecker;
                }
                catch (Exception e) {
                    _logger.error("Error accessing DXP permission checker", (Throwable)e);
                }
            }
        }
        return val;
    }

    private User getUser(HttpServletRequest request) throws SystemException, PortalException {
        return PortalUtil.getUser((HttpServletRequest)request);
    }

    private long getCompanyId(HttpServletRequest request) {
        return PortalUtil.getCompanyId((HttpServletRequest)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionChecker getPermissionChecker(User user) {
        BundleContext bc = FrameworkUtil.getBundle(DxpResourceContext.class).getBundleContext();
        ServiceReference serviceReference = null;
        PermissionChecker pc = null;
        try {
            serviceReference = bc.getServiceReference(PermissionCheckerFactory.class);
            PermissionCheckerFactory pcFactory = (PermissionCheckerFactory)bc.getService(serviceReference);
            pc = pcFactory.create(user);
        }
        catch (Exception e) {
            _logger.error("Error accessing DXP permission checker", (Throwable)e);
        }
        finally {
            if (serviceReference != null) {
                bc.ungetService(serviceReference);
            }
        }
        return pc;
    }
}

